/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.util.secondarycapture.CaptureImageWriter;
import com.mimvista.dicom.util.secondarycapture.DefaultCaptureImageWriter;
import com.mimvista.dicom.util.secondarycapture.SecondaryCaptureImageHandler;
import com.mimvista.dicom.util.secondarycapture.SlabSecondaryCaptureFactory;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.ImageCapturer;
import com.mimvista.file.MIMFile;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ak;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ag;
import com.mimvista.util.ay;
import com.mimvista.util.b.g;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;

public class DcmSecondaryCaptureWriter
extends DcmWriter {
    private List<BufferedImage> images;
    private CaptureType type;
    private ViewPort viewPort;
    private boolean includeInfo = true;
    private int monitorIndex = -1;
    private SeriesInfo infoToUse;

    public DcmSecondaryCaptureWriter(ViewPort viewPort, int n2, ViewController viewController, CaptureType captureType, SendToDestination sendToDestination, PresentationType presentationType, SeriesInfo seriesInfo) {
        super.setViewController(viewController);
        this.infoToUse = seriesInfo;
        this.viewPort = viewPort;
        this.type = captureType;
        this.setDestination(sendToDestination);
        this.plane = presentationType;
        this.monitorIndex = n2;
        this.includeInfo = DcmSecondaryCapturePrefs.volumeCaptureUseDemographics.getValue();
        this.images = Lists.newArrayList();
    }

    public DcmSecondaryCaptureWriter(Collection<BufferedImage> collection, ViewController viewController, SendToDestination sendToDestination, SeriesInfo seriesInfo, boolean bl2) {
        super.setViewController(viewController);
        this.infoToUse = seriesInfo;
        this.setDestination(sendToDestination);
        this.images = new ArrayList<BufferedImage>(collection);
        this.includeInfo = bl2;
        this.plane = null;
    }

    public DcmSecondaryCaptureWriter(Collection<BufferedImage> collection, ViewController viewController, SendToDestination sendToDestination, boolean bl2) {
        this(collection, viewController, sendToDestination, viewController.getUncopiedMutableInfo(), bl2);
    }

    public DcmSecondaryCaptureWriter(ViewPort viewPort, CaptureType captureType, SendToDestination sendToDestination, SeriesInfo seriesInfo) {
        this(viewPort, -1, viewPort.M(), captureType, sendToDestination, null, seriesInfo);
    }

    public DcmSecondaryCaptureWriter(ViewController viewController, int n2, CaptureType captureType, SendToDestination sendToDestination) {
        this(null, n2, viewController, captureType, sendToDestination, null, viewController.getUncopiedMutableInfo());
    }

    public DcmSecondaryCaptureWriter(ViewController viewController, int n2, CaptureType captureType, SendToDestination sendToDestination, SeriesInfo seriesInfo) {
        this(null, n2, viewController, captureType, sendToDestination, null, seriesInfo);
    }

    @Override
    public String getModality() {
        return Modality.OT.get();
    }

    @Override
    public String getSopClass() {
        return "1.2.840.10008.5.1.4.1.1.7";
    }

    public List<BufferedImage> getJustRenderedImages() {
        return this.images;
    }

    @Override
    public boolean shouldWriteDeactualizedPixelValues() {
        return false;
    }

    @Override
    public void writeFiles() {
        if (this.saveDest == null || this.saveDest.length() == 0) {
            throw new IllegalStateException("Haven't set save dest, so I can't save.");
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block28: {
                    boolean bl2;
                    File file;
                    Messages messages;
                    block26: {
                        SecondaryCaptureImageHandler secondaryCaptureImageHandler;
                        messages = Messages.a("Dicom");
                        file = null;
                        bl2 = false;
                        if (!DcmSecondaryCaptureWriter.this.saveDest.endsWith(File.separator)) {
                            DcmSecondaryCaptureWriter.this.saveDest = DcmSecondaryCaptureWriter.this.saveDest + File.separator;
                        }
                        ay.b((Object)("Saving captures to directory: " + DcmSecondaryCaptureWriter.this.saveDest), this);
                        file = new File(DcmSecondaryCaptureWriter.this.saveDest);
                        if (!file.exists()) {
                            file.mkdirs();
                        }
                        float f2 = 1.0f;
                        if (DcmSecondaryCaptureWriter.this.saveOptions != null) {
                            f2 = DcmSecondaryCaptureWriter.this.saveOptions.sliceSampleFreq;
                        }
                        ViewStateNew viewStateNew = DcmSecondaryCaptureWriter.this.vs.ap();
                        if (DcmSecondaryCaptureWriter.this.plane != null && viewStateNew instanceof ViewStateNew.ViewStateNew3D && ((ViewStateNew.ViewStateNew3D)viewStateNew).b((PresentationType)DcmSecondaryCaptureWriter.this.plane).slabbingEnabled && DcmSecondaryCaptureWriter.this.images.size() == 0 && DcmSecondaryCaptureWriter.this.type == CaptureType.VIEWPORT) {
                            DcmSecondaryCaptureWriter.this.images = SlabSecondaryCaptureFactory.getSlabImages(DcmSecondaryCaptureWriter.this.vs, DcmSecondaryCaptureWriter.this.plane, DcmSecondaryCaptureWriter.this.progress);
                        }
                        if (DcmSecondaryCaptureWriter.this.images.size() == 0) {
                            DcmSecondaryCaptureWriter.this.images = ImageCapturer.getImages(DcmSecondaryCaptureWriter.this.type, DcmSecondaryCaptureWriter.this.vs, DcmSecondaryCaptureWriter.this.viewPort, DcmSecondaryCaptureWriter.this.plane, DcmSecondaryCaptureWriter.this.includeInfo, DcmSecondaryCaptureWriter.this.extent, f2, DcmSecondaryCaptureWriter.this.progress, DcmSecondaryCaptureWriter.this.monitorIndex);
                        }
                        if (DcmSecondaryCaptureWriter.this.plane != null) {
                            DcmSecondaryCaptureWriter.this.progress.a(MIMFormat.a(messages.getProperty("DCM_CAP_TITLE"), DcmSecondaryCaptureWriter.this.plane.name()));
                        }
                        if (bl2 = (secondaryCaptureImageHandler = new SecondaryCaptureImageHandler(DcmSecondaryCaptureWriter.this.makeImageWriter(), DcmSecondaryCaptureWriter.this.progress)).write(new g(file))) break block26;
                        try {
                            if (file != null) {
                                new MIMFile(file).delete();
                            }
                        }
                        catch (Throwable throwable) {
                            ay.d((Object)"Error cleaning up after failed DICOM capture save", throwable, DcmSecondaryCaptureWriter.class);
                        }
                    }
                    try {
                        DcmSecondaryCaptureWriter.this.runCallbacks(bl2);
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error running callbacks after DICOM capture save", throwable, DcmSecondaryCaptureWriter.class);
                    }
                    break block28;
                    catch (Throwable throwable) {
                        block27: {
                            try {
                                ay.d((Object)"Error during DICOM capture save", throwable, DcmSecondaryCaptureWriter.class);
                                JOptionPane.showMessageDialog(ak.b().O(), messages.getProperty("DCM_CAP_W_FAIL"), messages.getProperty("DCM_CAP_W_ERROR"), 0);
                                if (bl2) break block27;
                            }
                            catch (Throwable throwable2) {
                                if (!bl2) {
                                    try {
                                        if (file != null) {
                                            new MIMFile(file).delete();
                                        }
                                    }
                                    catch (Throwable throwable3) {
                                        ay.d((Object)"Error cleaning up after failed DICOM capture save", throwable3, DcmSecondaryCaptureWriter.class);
                                    }
                                }
                                try {
                                    DcmSecondaryCaptureWriter.this.runCallbacks(bl2);
                                }
                                catch (Throwable throwable4) {
                                    ay.d((Object)"Error running callbacks after DICOM capture save", throwable4, DcmSecondaryCaptureWriter.class);
                                }
                                throw throwable2;
                            }
                            try {
                                if (file != null) {
                                    new MIMFile(file).delete();
                                }
                            }
                            catch (Throwable throwable5) {
                                ay.d((Object)"Error cleaning up after failed DICOM capture save", throwable5, DcmSecondaryCaptureWriter.class);
                            }
                        }
                        try {
                            DcmSecondaryCaptureWriter.this.runCallbacks(bl2);
                        }
                        catch (Throwable throwable6) {
                            ay.d((Object)"Error running callbacks after DICOM capture save", throwable6, DcmSecondaryCaptureWriter.class);
                        }
                    }
                }
            }
        };
        if (this.blocking) {
            runnable.run();
        } else {
            m.e.submit(runnable);
        }
    }

    private CaptureImageWriter makeImageWriter() {
        DefaultCaptureImageWriter defaultCaptureImageWriter = new DefaultCaptureImageWriter(this.infoToUse, this.images);
        if (this.plane != null) {
            defaultCaptureImageWriter.setSeriesDescPrefix(this.plane.a(this.infoToUse).toUpperCase() + " ");
        }
        if (this.saveOptions != null) {
            defaultCaptureImageWriter.setSaveOptions(this.saveOptions);
            defaultCaptureImageWriter.setModality(this.saveOptions.modality);
            defaultCaptureImageWriter.setMonochromeMode(this.saveOptions.saveRgbImagesAsMonochrome);
        } else {
            defaultCaptureImageWriter.setStudyDescription(this.infoToUse.studyDesc);
            defaultCaptureImageWriter.setSeriesDescription(this.infoToUse.seriesDesc);
            String string = DcmSecondaryCapturePrefs.secondaryDicomModality.getValue();
            if (string.equalsIgnoreCase("ORIGINAL")) {
                string = this.infoToUse.modality;
            }
            defaultCaptureImageWriter.setModality(string);
        }
        defaultCaptureImageWriter.setAnnotated(this.includeInfo);
        return defaultCaptureImageWriter;
    }

    @Override
    Matrix4f getSaveMatrix() {
        return DcmSecondaryCaptureWriter.getSaveMatrix(this.vs.ap(), this.saveOptions.applyGantryTilt, this.saveOptions.applyViewingRotation);
    }

    @Override
    public String getImageType() {
        return "DERIVED\\PRIMARY\\" + this.plane.toString().toUpperCase();
    }

    public static enum CaptureType implements ag
    {
        PAGE,
        PAGE_WITH_SIDE,
        SERIES,
        VIEWPORT;


        @Override
        public String getExternalizedString() {
            return WorkflowCommand.m.getProperty("CAPTYPE_" + this.toString());
        }
    }
}

