/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.file.Path;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ReadOnlyContrast;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.ay;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import com.mimvista.viewer.algo.BestContrastor;
import java.io.File;
import java.util.List;
import javax.vecmath.Matrix4f;

public abstract class DcmWriter {
    ViewController vs;
    String saveDest = null;
    g progress = new o();
    List<FuncUtils.m<Boolean>> callbacks = Lists.newArrayList();
    int[] extent = new int[6];
    boolean blocking = false;
    PresentationType plane = PresentationType.a;
    protected DcmSaveOptions saveOptions = null;
    protected boolean saveDynamic = false;
    protected int frmIdx = -1;

    public static boolean shouldDefaultToSaveAsSUV(SeriesInfo seriesInfo) {
        if ("PT".equalsIgnoreCase(seriesInfo.modality) && seriesInfo.philipsSuvScalingTag != 0.0f) {
            UnitHelper.AppliedImageUnit appliedImageUnit = seriesInfo.u().a();
            return appliedImageUnit != null && appliedImageUnit.unit != null && appliedImageUnit.unit.canonBaseUnit != null && !DataUnitUtils.BQML_CANON_.matchesUnit(appliedImageUnit.unit.canonBaseUnit) && !appliedImageUnit.unit.canonBaseUnit.toLowerCase().startsWith("suv");
        }
        return false;
    }

    protected static Matrix4f getSaveMatrix(ViewStateNew viewStateNew, boolean bl2, boolean bl3) {
        Matrix4f matrix4f;
        if (bl3) {
            matrix4f = (Matrix4f)viewStateNew.rotationMatrix.clone();
        } else if (bl2) {
            matrix4f = viewStateNew.i().M();
        } else {
            matrix4f = new Matrix4f();
            matrix4f.setIdentity();
        }
        return matrix4f;
    }

    public DcmWriter() {
        this.addCallback(bl2 -> {
            if (!bl2.booleanValue()) {
                return;
            }
            if (this.vs == null) {
                return;
            }
            SeriesInfo seriesInfo = this.vs.getUncopiedMutableInfo();
            if (seriesInfo == null) {
                return;
            }
            if (this.saveOptions.savingToPublicZone) {
                this.vs.getUncopiedMutableInfo().volumeHasBeenSaved = true;
                seriesInfo.lastSaveHadAppliedViewingRot = this.saveOptions.applyViewingRotation && MatrixMultiplier.b(this.vs.bq());
            } else {
                this.vs.getUncopiedMutableInfo().volumeHasBeenSaved = false;
                this.vs.getUncopiedMutableInfo().forceNewSeriesUidOnNextSave = true;
            }
        });
    }

    public void setViewController(ViewController viewController) {
        this.vs = viewController;
        int[] nArray = viewController.ay();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.extent[i2 * 2] = 0;
            this.extent[i2 * 2 + 1] = nArray[i2] - 1;
        }
    }

    public ViewController getViewController() {
        return this.vs;
    }

    public void setProgressUI(g g2) {
        this.progress = g2;
    }

    public void setBlocking(boolean bl2) {
        this.blocking = bl2;
    }

    public void addCallback(FuncUtils.m<Boolean> m2) {
        if (!this.callbacks.contains(m2) && m2 != null) {
            this.callbacks.add(m2);
        }
    }

    public void setPlane(PresentationType presentationType) {
        if (presentationType == PresentationType.a || presentationType == PresentationType.c || presentationType == PresentationType.b) {
            this.plane = presentationType;
        } else {
            System.err.println("Plane for DICOM saving can only be axial, coronal or sagittal.");
        }
    }

    public void setSavingExtent(int[] nArray) {
        try {
            if (nArray.length >= 6) {
                int n2;
                SimpleImageVolume simpleImageVolume = (SimpleImageVolume)((Object)this.vs.aw());
                int[] nArray2 = simpleImageVolume.a();
                this.extent[0] = nArray[0] < 0 ? 0 : (nArray[0] >= nArray2[0] ? nArray2[0] - 1 : nArray[0]);
                this.extent[1] = nArray[1] < 0 ? 0 : (nArray[1] >= nArray2[0] ? nArray2[0] - 1 : nArray[1]);
                if (this.extent[0] > this.extent[1]) {
                    n2 = this.extent[1];
                    this.extent[1] = this.extent[0];
                    this.extent[0] = n2;
                }
                this.extent[2] = nArray[2] < 0 ? 0 : (nArray[2] >= nArray2[1] ? nArray2[1] - 1 : nArray[2]);
                this.extent[3] = nArray[3] < 0 ? 0 : (nArray[3] >= nArray2[1] ? nArray2[1] - 1 : nArray[3]);
                if (this.extent[2] > this.extent[3]) {
                    n2 = this.extent[3];
                    this.extent[3] = this.extent[2];
                    this.extent[2] = n2;
                }
                this.extent[4] = nArray[4] < 0 ? 0 : (nArray[4] >= nArray2[2] ? nArray2[2] - 1 : nArray[4]);
                this.extent[5] = nArray[5] < 0 ? 0 : (nArray[5] >= nArray2[2] ? nArray2[2] - 1 : nArray[5]);
                if (this.extent[4] > this.extent[5]) {
                    n2 = this.extent[5];
                    this.extent[5] = this.extent[4];
                    this.extent[4] = n2;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setSliceSampleFrequency(float f2) {
        this.saveOptions.sliceSampleFreq = f2 < 0.0f ? 0.0f : f2;
    }

    protected ImageVolumeShort getVolume() {
        ImageFrame imageFrame = this.vs.aw();
        if (this.frmIdx != -1) {
            imageFrame = this.vs.au().b(this.frmIdx);
        }
        if (imageFrame instanceof ImageVolumeShort) {
            return (ImageVolumeShort)imageFrame;
        }
        return null;
    }

    protected ReadOnlyContrast getContrast() {
        ReadOnlyContrast readOnlyContrast = this.getSaveDynamic() && this.getFrmIdx() >= 0 ? this.vs.g(new EditTargetInfo(this.getFrmIdx(), true)) : this.vs.s();
        return readOnlyContrast;
    }

    protected void runCallbacks(boolean bl2) {
        for (FuncUtils.m<Boolean> m2 : this.callbacks) {
            try {
                m2.doIt(bl2);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error running DICOM save callback", throwable, this);
            }
        }
    }

    public void setDest(String string) {
        this.saveDest = string;
    }

    public String getDest() {
        return this.saveDest;
    }

    public void setDestination(final SendToDestination sendToDestination) {
        String string;
        if (sendToDestination == null) {
            return;
        }
        if (this.saveDest == null) {
            string = Path.getImporterTempPath();
            int n2 = 0;
            while (new File(string, String.valueOf(n2)).exists()) {
                ++n2;
            }
            File file = new File(string, "" + n2);
            file.mkdirs();
            this.saveDest = file.getAbsolutePath();
        }
        string = this.saveDest;
        this.callbacks.add(new FuncUtils.m<Boolean>(){

            @Override
            public void doIt(Boolean bl2) {
                if (bl2.booleanValue()) {
                    FolderSearchSource.a(DcmWriter.this.vs.bG(), sendToDestination, string, true, DcmWriter.this.blocking);
                }
            }
        });
    }

    public String getDerivationText() {
        return "";
    }

    public String getExtraDerivationText() {
        return "";
    }

    public void setSaveOptions(DcmSaveOptions dcmSaveOptions) {
        this.saveOptions = dcmSaveOptions;
    }

    int[] getOutputVolumeDims() {
        return null;
    }

    float[] getOutputVoxel() {
        return null;
    }

    public void setFrmIdx(int n2) {
        this.frmIdx = n2;
    }

    public int getFrmIdx() {
        return this.frmIdx;
    }

    public void setSaveDynamic(boolean bl2) {
        this.saveDynamic = bl2;
    }

    public boolean getSaveDynamic() {
        return this.saveDynamic;
    }

    public abstract String getModality();

    public abstract String getSopClass();

    public abstract String getImageType();

    abstract Matrix4f getSaveMatrix();

    public abstract void writeFiles();

    public abstract boolean shouldWriteDeactualizedPixelValues();

    public boolean needsUnsignedActualizedSave() {
        boolean bl2 = false;
        if (!this.shouldWriteDeactualizedPixelValues()) {
            ImageFrame imageFrame = this.frmIdx != -1 ? this.vs.au().b(this.frmIdx) : this.vs.aw();
            RescaleConverter rescaleConverter = imageFrame.getUncopiedMutableInfo().rescale;
            BestContrastor bestContrastor = imageFrame.k();
            float f2 = rescaleConverter.apply(bestContrastor.i());
            float f3 = rescaleConverter.apply(bestContrastor.h());
            if (f3 > 32767.0f) {
                if (f2 >= 0.0f) {
                    bl2 = true;
                } else {
                    ay.c((Object)"Attempting to DICOM save data without rescale support that doesn't fit in 16-bit range. Truncating values.", this);
                }
            }
        }
        return bl2;
    }

    public RescaleConverter getRescaleConverterForSave() {
        return null;
    }

    public boolean needsUnsignedDeactualizedSave() {
        return false;
    }

    public static class DcmSaveOptions
    implements Cloneable {
        public String modality;
        public String dicomName;
        public String patientID;
        public String studyID;
        public String accession;
        public String referringLast;
        public String referringFirst;
        public String studyDescription;
        public String seriesDescription;
        public String savedAssociatedUID;
        public boolean keepAssociation;
        public boolean saveSUV;
        public boolean applyGantryTilt;
        public boolean squareVoxels;
        public boolean applyViewingRotation;
        public boolean saveAsOrthogonal;
        public float sliceSampleFreq = 0.0f;
        public String sopInstanceUID = null;
        public boolean saveRgbImagesAsMonochrome = false;
        public boolean savingToPublicZone = true;

        public static DcmSaveOptions fillDefaultsFromSeriesInfo(SeriesInfo seriesInfo) {
            DcmSaveOptions dcmSaveOptions = new DcmSaveOptions();
            dcmSaveOptions.accession = seriesInfo.accession;
            dcmSaveOptions.applyGantryTilt = false;
            dcmSaveOptions.applyViewingRotation = false;
            dcmSaveOptions.dicomName = seriesInfo.patientNameRaw;
            dcmSaveOptions.keepAssociation = true;
            dcmSaveOptions.modality = seriesInfo.modality;
            dcmSaveOptions.patientID = seriesInfo.patientId;
            dcmSaveOptions.referringLast = seriesInfo.referringPhysRaw;
            dcmSaveOptions.saveAsOrthogonal = false;
            dcmSaveOptions.saveSUV = DcmWriter.shouldDefaultToSaveAsSUV(seriesInfo);
            dcmSaveOptions.seriesDescription = seriesInfo.seriesDesc;
            dcmSaveOptions.squareVoxels = false;
            dcmSaveOptions.studyDescription = seriesInfo.studyDesc;
            dcmSaveOptions.studyID = seriesInfo.studyID;
            return dcmSaveOptions;
        }

        public DcmSaveOptions clone() {
            try {
                return (DcmSaveOptions)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                ay.d((Object)"Error.", (Throwable)cloneNotSupportedException, DcmSaveOptions.class);
                return null;
            }
        }
    }
}

