/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.dicom.write.DcmCTWriter;
import com.mimvista.dicom.write.DcmMRWriter;
import com.mimvista.dicom.write.DcmNMWriter;
import com.mimvista.dicom.write.DcmPTWriter;
import com.mimvista.dicom.write.DcmRTDOSEWriter;
import com.mimvista.dicom.write.DcmRTImageWriter;
import com.mimvista.dicom.write.DcmSecondaryCaptureWriter;
import com.mimvista.dicom.write.DcmUSWriter;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.mui.PresentationType;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.util.ArrayList;

public class DcmWriterFactory {
    public static final String SECONDARY_CAPTURE_SINGLE_PLANE;
    public static final String SCREEN_CAPTURE_OT;

    private DcmWriterFactory() {
    }

    public static DcmWriter getDefaultDicomVolumeWriter(ViewController viewController) {
        try {
            if (viewController instanceof ViewController3D) {
                if ("1.2.840.10008.5.1.4.1.1.2".equals(viewController.aw().getUncopiedMutableInfo().sopClassUID)) {
                    return new DcmCTWriter(viewController);
                }
                if ("1.2.840.10008.5.1.4.1.1.128".equals(viewController.aw().getUncopiedMutableInfo().sopClassUID)) {
                    return new DcmPTWriter(viewController);
                }
                if ("1.2.840.10008.5.1.4.1.1.4".equals(viewController.aw().getUncopiedMutableInfo().sopClassUID)) {
                    return new DcmMRWriter(viewController);
                }
                if ("1.2.840.10008.5.1.4.1.1.20".equals(viewController.aw().getUncopiedMutableInfo().sopClassUID)) {
                    return new DcmNMWriter(viewController);
                }
                if ("1.2.840.10008.5.1.4.1.1.481.2".equals(viewController.aw().getUncopiedMutableInfo().sopClassUID)) {
                    return new DcmRTDOSEWriter(viewController);
                }
                return null;
            }
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static boolean isMultiframeModality(String string) {
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"US", "NM", "RTDOSE"});
        return string != null && arrayList.contains(string.toUpperCase());
    }

    public static DcmWriter getWriterForModality(ViewController viewController, String string, @d PresentationType presentationType) {
        if (string == null) {
            return null;
        }
        if (!(viewController instanceof ViewController3D)) {
            return null;
        }
        try {
            if ("CT".equals(string.toUpperCase())) {
                return new DcmCTWriter(viewController);
            }
            if ("PT".equals(string.toUpperCase())) {
                return new DcmPTWriter(viewController);
            }
            if ("MR".equals(string.toUpperCase())) {
                return new DcmMRWriter(viewController);
            }
            if ("NM".equals(string.toUpperCase())) {
                return new DcmNMWriter(viewController);
            }
            if ("RTIMAGE".equals(string.toUpperCase())) {
                return new DcmRTImageWriter(viewController);
            }
            if ("US".equals(string.toUpperCase())) {
                return new DcmUSWriter(viewController);
            }
            if ("RTDOSE".equals(string.toUpperCase())) {
                return new DcmRTDOSEWriter(viewController);
            }
            if (SCREEN_CAPTURE_OT.equals(string)) {
                DcmSecondaryCaptureWriter dcmSecondaryCaptureWriter = new DcmSecondaryCaptureWriter(viewController, -1, DcmSecondaryCaptureWriter.CaptureType.SERIES, null);
                dcmSecondaryCaptureWriter.setPlane(presentationType);
                return dcmSecondaryCaptureWriter;
            }
            if (string.contains(SECONDARY_CAPTURE_SINGLE_PLANE)) {
                DcmSecondaryCaptureWriter dcmSecondaryCaptureWriter = new DcmSecondaryCaptureWriter(viewController, -1, DcmSecondaryCaptureWriter.CaptureType.VIEWPORT, null);
                dcmSecondaryCaptureWriter.setPlane(presentationType);
                return dcmSecondaryCaptureWriter;
            }
            return null;
        }
        catch (Exception exception) {
            ay.d((Object)("Trying to get DICOM writer for " + string), (Throwable)exception, DcmWriterFactory.class);
            return null;
        }
    }

    public static String formatNameForDICOM(String string, String string2, String string3) {
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{string3, string, string2});
        return Joiner.on((String)"^").join(Iterables.filter((Iterable)arrayList, (Predicate)new Predicate<String>(){

            public boolean apply(String string) {
                return string != null && !string.trim().isEmpty();
            }
        }));
    }

    public static String getPNString(String string) {
        String string2;
        String string3;
        String string4 = string.trim();
        if (cn.g(string4)) {
            return "";
        }
        String string5 = "";
        if (string4.contains(",")) {
            String[] stringArray = string4.split(",");
            string3 = stringArray[0];
            ArrayList arrayList = Lists.newArrayList();
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                arrayList.add(stringArray[i2].trim());
            }
            string2 = Joiner.on((String)" ").join(Iterables.filter((Iterable)arrayList, (Predicate)new Predicate<String>(){

                public boolean apply(String string) {
                    return string != null && !string.trim().isEmpty();
                }
            }));
        } else {
            String[] stringArray = string4.split(" ");
            string2 = stringArray[0];
            ArrayList arrayList = Lists.newArrayList();
            for (int i3 = 1; i3 < stringArray.length; ++i3) {
                arrayList.add(stringArray[i3].trim());
            }
            string3 = Joiner.on((String)" ").join(Iterables.filter((Iterable)arrayList, (Predicate)new Predicate<String>(){

                public boolean apply(String string) {
                    return string != null && !string.trim().isEmpty();
                }
            }));
        }
        return DcmWriterFactory.formatNameForDICOM(string2, string5, string3);
    }

    static {
        Messages messages = Messages.a("Dicom");
        SECONDARY_CAPTURE_SINGLE_PLANE = messages.getProperty("DICOM_SAVE_FUSION_SECONDARY_CAPTURE") + " (" + messages.getProperty("DCM_WRITER_FACT_SINGLE_PLANE") + ")";
        SCREEN_CAPTURE_OT = messages.getProperty("DCM_WRITER_FACT_CAPTURE") + " OT";
    }
}

