/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.biopsy.prostatescoring.model.PiradsScoringModel;
import com.mimvista.biopsy.prostatescoring.model.a;
import com.mimvista.brachytherapy.BrachyReportPlanState;
import com.mimvista.brachytherapy.alg.DoseAccumulator;
import com.mimvista.brachytherapy.alg.DoseKernel;
import com.mimvista.brachytherapy.mui.overlays.RandomBrachyNeedle;
import com.mimvista.brachytherapy.mui.overlays.RandomSeedLocation;
import com.mimvista.brachytherapy.mui.overlays.RandomSeedsOverlay;
import com.mimvista.brachytherapy.mui.overlays.TemplateGridOverlay;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.brachytherapy.seeds.ManufacturedSeed;
import com.mimvista.brachytherapy.seeds.PrescribedSeed;
import com.mimvista.commands.keyboard.SaveRTDOSECommand;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.gui.DicomRtStructSaveInputFactory;
import com.mimvista.dicom.gui.DicomSaveInputFactory;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.dicom.write.DicomBrachyRtPlanSaveParams;
import com.mimvista.dicom.write.DicomRtPlanWriter;
import com.mimvista.dicom.write.rtst.DicomRtStructCreator;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.gui.util.m;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.mouse.mode.k;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.numerics.helpers.b;
import com.mimvista.preferencesNew.BrachytherapyPrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.jdesktop.swingx.JXDatePicker;

public class DicomBrachyRtPlanWriter
extends DicomRtPlanWriter {
    private ViewController3D brachyVC;
    private SendToDestination sendDest;
    private String operatorName = "";
    private RandomSeedsOverlay overlay;
    private ImageVolumeShort doseField;
    private String[] reslicedRtstSOP = new String[]{""};
    private String[] origRtstSOP = new String[]{""};
    private String planName = "";
    private Date procedureDate;
    private BrachyReportPlanState state;
    private boolean planHasTemplate = true;
    private ViewController3D srcVC;

    public DicomBrachyRtPlanWriter(BrachyReportPlanState brachyReportPlanState, SendToDestination sendToDestination) {
        this.brachyVC = brachyReportPlanState.g();
        this.srcVC = brachyReportPlanState.a();
        this.sendDest = sendToDestination;
        this.info = this.brachyVC.getUncopiedMutableInfo();
        this.doseField = brachyReportPlanState.x() != null ? brachyReportPlanState.x().C() : null;
        this.state = brachyReportPlanState;
        this.procedureDate = brachyReportPlanState.procedureDate;
        this.overlay = this.state.p();
        if (this.overlay == null) {
            OverlayCollection overlayCollection = this.brachyVC.ba();
            this.overlay = overlayCollection.O();
            this.planHasTemplate = false;
        }
    }

    public DicomBrachyRtPlanWriter(DicomBrachyRtPlanSaveParams dicomBrachyRtPlanSaveParams) {
        this(dicomBrachyRtPlanSaveParams.planState, dicomBrachyRtPlanSaveParams.sendDest);
        this.operatorName = dicomBrachyRtPlanSaveParams.operatorName;
        this.reslicedRtstSOP = dicomBrachyRtPlanSaveParams.reslicedRtstSOP;
        this.origRtstSOP = dicomBrachyRtPlanSaveParams.origRtstSOP;
        this.planName = dicomBrachyRtPlanSaveParams.planName;
    }

    @Override
    public UIDContainer getSopClassUID() {
        boolean bl2 = this.state.F().a();
        if (bl2) {
            return new UIDContainer.SOPClassUID("1.2.840.10008.5.1.4.1.1.66");
        }
        return super.getSopClassUID();
    }

    @Override
    public Modality getModality() {
        boolean bl2 = this.state.F().a();
        if (bl2) {
            return Modality.RAW;
        }
        return super.getModality();
    }

    @Override
    public String getOperatorName() {
        return this.operatorName;
    }

    @Override
    public String getSeriesDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (DicomPrefs.seriesDescPrependTimestamp.getValue().booleanValue()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String string = simpleDateFormat.format(Calendar.getInstance().getTime());
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        if (DicomPrefs.seriesDescPrependOperator.getValue().booleanValue()) {
            stringBuilder.append(this.operatorName);
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.planName);
        return stringBuilder.toString();
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        this.buildBasicHeader(dicomObject);
        this.buildFractionGroupSequence(dicomObject);
        this.buildTreatmentMachineSequence(dicomObject);
        this.buildSourceSequence(dicomObject);
        this.buildApplicationSetupSequence(dicomObject);
        this.buildReferencedStructureSetSequence(dicomObject);
        this.buildMIMBrachySequence(dicomObject);
    }

    protected void buildBasicHeader(DicomObject dicomObject) {
        dicomObject.putString(805962240, VR.CS, "PERMANENT");
        dicomObject.putString(805962242, VR.CS, "MANUAL");
        dicomObject.putString(805961732, VR.ST, this.planName);
        if (this.planName.length() > 16) {
            dicomObject.putString(805961730, VR.SH, this.planName.substring(0, 16));
        } else {
            dicomObject.putString(805961730, VR.SH, this.planName);
        }
        dicomObject.putDate(805961734, VR.DA, this.procedureDate);
        dicomObject.putString(805961740, VR.SH, "PATIENT");
    }

    protected void buildFractionGroupSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(805961840);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putInt(805961841, VR.IS, 1);
        basicDicomObject.putInt(805961848, VR.IS, 1);
        basicDicomObject.putInt(805961856, VR.IS, 0);
        basicDicomObject.putInt(0x300A00A0, VR.IS, this.overlay.z());
        DicomElement dicomElement2 = basicDicomObject.putSequence(806092810);
        for (int i2 = 1; i2 <= this.overlay.z(); ++i2) {
            BasicDicomObject basicDicomObject2 = new BasicDicomObject();
            basicDicomObject2.putInt(0x300C000C, VR.IS, i2);
            dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
        }
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
    }

    protected void buildTreatmentMachineSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(805962246);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(805961906, VR.SH, "Manual Loading");
    }

    protected void buildSourceSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(805962256);
        PrescribedSeed prescribedSeed = this.state.seed;
        ManufacturedSeed manufacturedSeed = prescribedSeed.d();
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putInt(805962258, VR.IS, 1);
        basicDicomObject.putString(805962260, VR.CS, this.state.doseModel.getExternalizedString());
        basicDicomObject.putString(805962278, VR.LO, manufacturedSeed.h().replaceAll("_", "-"));
        basicDicomObject.putFloat(805962280, VR.DS, prescribedSeed.i());
        basicDicomObject.putFloat(805962282, VR.DS, prescribedSeed.c());
        basicDicomObject.putString(805962284, VR.DA, "");
        basicDicomObject.putString(805962286, VR.TM, "");
        basicDicomObject.putString(928055298, VR.CS, manufacturedSeed.g());
        basicDicomObject.putString(928055300, VR.CS, manufacturedSeed.f());
    }

    protected void buildApplicationSetupSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(805962288);
        int n2 = 1;
        if (this.planHasTemplate) {
            TemplateGridOverlay templateGridOverlay = (TemplateGridOverlay)this.overlay;
            for (RandomBrachyNeedle randomBrachyNeedle : templateGridOverlay.N()) {
                for (RandomSeedLocation randomSeedLocation : randomBrachyNeedle.h()) {
                    DicomPoint3f dicomPoint3f = randomSeedLocation.c().d().d();
                    if (this.doseField != null) {
                        DoseAccumulator.a(templateGridOverlay, randomSeedLocation.c(), this.doseField).d().d();
                    }
                    n2 = this.buildApplicationSetupSequenceEntry(dicomElement, n2, randomSeedLocation, dicomPoint3f);
                }
            }
        } else {
            RandomSeedsOverlay randomSeedsOverlay = this.overlay;
            for (RandomSeedLocation randomSeedLocation : randomSeedsOverlay.w()) {
                DicomPoint3f dicomPoint3f = randomSeedLocation.c().d().d();
                n2 = this.buildApplicationSetupSequenceEntry(dicomElement, n2, randomSeedLocation, dicomPoint3f);
            }
        }
    }

    private int buildApplicationSetupSequenceEntry(DicomElement dicomElement, int n2, RandomSeedLocation randomSeedLocation, DicomPoint3f dicomPoint3f) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(805962290, VR.CS, "");
        basicDicomObject.putInt(805962292, VR.IS, n2++);
        this.addChannelSequence(basicDicomObject, randomSeedLocation, dicomPoint3f);
        return n2;
    }

    private void addChannelSequence(BasicDicomObject basicDicomObject, RandomSeedLocation randomSeedLocation, DicomPoint3f dicomPoint3f) {
        DicomElement dicomElement = basicDicomObject.putSequence(805962368);
        PrescribedSeed prescribedSeed = this.state.seed;
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject2);
        basicDicomObject2.putInt(805962000, VR.IS, 2);
        basicDicomObject2.putInt(805962370, VR.IS, 1);
        basicDicomObject2.putFloat(805962372, VR.DS, 0.0f);
        float f2 = 86400.0f * DoseKernel.a(prescribedSeed);
        basicDicomObject2.putFloat(805962374, VR.DS, f2);
        basicDicomObject2.putString(805962376, VR.CS, "FIXED");
        basicDicomObject2.putFloat(805962440, VR.DS, 100.0f);
        DicomElement dicomElement2 = basicDicomObject2.putSequence(805962448);
        BasicDicomObject basicDicomObject3 = new BasicDicomObject();
        basicDicomObject3.putInt(805962002, VR.IS, 0);
        basicDicomObject3.putFloat(805962450, VR.DS, 0.0f);
        basicDicomObject3.putFloats(805962452, VR.DS, new float[]{dicomPoint3f.x, dicomPoint3f.y, dicomPoint3f.z});
        basicDicomObject3.putFloats(805962770, VR.FL, this.convertOrientationToDicom(randomSeedLocation));
        basicDicomObject3.putFloat(805962454, VR.DS, 0.0f);
        dicomElement2.addDicomObject((DicomObject)basicDicomObject3);
        BasicDicomObject basicDicomObject4 = new BasicDicomObject();
        basicDicomObject4.putInt(805962002, VR.IS, 0);
        basicDicomObject4.putFloat(805962450, VR.DS, 0.0f);
        basicDicomObject4.putFloats(805962452, VR.DS, new float[]{dicomPoint3f.x, dicomPoint3f.y, dicomPoint3f.z});
        basicDicomObject4.putFloats(805962770, VR.FL, this.convertOrientationToDicom(randomSeedLocation));
        basicDicomObject4.putFloat(805962454, VR.DS, 100.0f);
        dicomElement2.addDicomObject((DicomObject)basicDicomObject4);
        basicDicomObject2.putInt(806092814, VR.IS, 1);
    }

    private float[] convertOrientationToDicom(RandomSeedLocation randomSeedLocation) {
        MetricPoint3f metricPoint3f = new MetricPoint3f(randomSeedLocation.c().i());
        MetricPoint3f metricPoint3f2 = metricPoint3f.a();
        metricPoint3f2.add((Tuple3f)randomSeedLocation.b());
        Vector3f vector3f = new Vector3f((Tuple3f)metricPoint3f2.d());
        vector3f.sub((Tuple3f)metricPoint3f.d());
        vector3f.scale(-1.0f);
        return new float[]{vector3f.x, vector3f.y, vector3f.z};
    }

    private void buildReferencedStructureSetSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(806092896);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.3");
        basicDicomObject.putString(528725, VR.UI, this.reslicedRtstSOP[0]);
    }

    private void buildMIMBrachySequence(DicomObject dicomObject) {
        Object object;
        Float f2;
        Serializable serializable;
        Object object2;
        TemplateGridOverlay templateGridOverlay;
        DicomElement dicomElement = dicomObject.putSequence(930283796);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        if (this.state.F().a()) {
            dicomObject.putString(930291986, VR.SH, "Y");
        }
        basicDicomObject.putString(928055350, VR.CS, this.state.E().name());
        if (this.planHasTemplate) {
            templateGridOverlay = (TemplateGridOverlay)this.overlay;
            object2 = templateGridOverlay.v_().d();
            basicDicomObject.putString(928055304, VR.CS, templateGridOverlay.O().g());
            basicDicomObject.putString(928055312, VR.CS, templateGridOverlay.O().h());
            basicDicomObject.putFloats(928055314, VR.DS, new float[]{((DicomPoint3f)((Object)object2)).x, ((DicomPoint3f)((Object)object2)).y, ((DicomPoint3f)((Object)object2)).z});
        }
        templateGridOverlay = this.state.needleVector;
        object2 = this.state.resliceAngleDisplay;
        if (object2 != null) {
            object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
        }
        if (templateGridOverlay != null) {
            basicDicomObject.putFloats(928055316, VR.DS, new float[]{((Vector3f)templateGridOverlay).x, ((Vector3f)templateGridOverlay).y, ((Vector3f)templateGridOverlay).z});
        }
        if (object2 != null) {
            try {
                if (BrachytherapyPrefs.limitBreastResliceDisplayAngleToAbsolute.getValue().booleanValue() && this.state.E() == BrachyReportPlanState.BrachyContext.a) {
                    serializable = k.q();
                    f2 = (Float)((JFormattedTextField.AbstractFormatter)serializable).stringToValue((String)object2);
                    basicDicomObject.putFloat(928055320, VR.DS, f2.floatValue());
                } else {
                    basicDicomObject.putFloat(928055320, VR.DS, DecimalFormat.getNumberInstance().parse((String)object2).floatValue());
                }
            }
            catch (ParseException parseException) {
                ay.d((Object)parseException.getMessage(), (Throwable)parseException, this.getClass());
            }
        }
        basicDicomObject.putFloat(928055328, VR.DS, this.state.w().getValueInGy());
        serializable = this.state.p();
        if (serializable != null && ((TemplateGridOverlay)serializable).u_()) {
            basicDicomObject.putString(928055330, VR.CS, "1");
        } else {
            basicDicomObject.putString(928055330, VR.CS, "0");
        }
        if (object2 != null) {
            f2 = basicDicomObject.putSequence(806092896);
            object = new BasicDicomObject();
            object.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.3");
            object.putString(528725, VR.UI, this.origRtstSOP[0]);
            f2.addDicomObject((DicomObject)object);
        }
        if (this.state.b()) {
            f2 = basicDicomObject.putSequence(930291968);
            object = new BasicDicomObject();
            object.putString(0x20000E, VR.UI, this.state.baselineDoseUID);
            f2.addDicomObject((DicomObject)object);
        }
        if (this.state.e()) {
            basicDicomObject.putFloat(928055376, VR.DS, (float)(this.state.f() + 1));
        }
        if (serializable != null) {
            f2 = ((TemplateGridOverlay)serializable).l().templateToApexPlaneDistMM;
            if (f2 != null) {
                basicDicomObject.putFloat(928055346, VR.DS, f2.floatValue());
            }
            if ((object = ((TemplateGridOverlay)serializable).l().apexToRefPlaneDistMM) != null) {
                basicDicomObject.putFloat(928055362, VR.DS, ((Float)object).floatValue());
            }
            float f3 = ((TemplateGridOverlay)serializable).l().apexPlaneVoxelIndexAtIntraopStart * ((TemplateGridOverlay)serializable).f().ao_()[2] / 5.0f;
            basicDicomObject.putFloat(928055360, VR.DS, f3);
            DicomElement dicomElement2 = basicDicomObject.putSequence(930283798);
            for (RandomBrachyNeedle randomBrachyNeedle : ((TemplateGridOverlay)serializable).N()) {
                BasicDicomObject basicDicomObject2 = new BasicDicomObject();
                basicDicomObject2.putFloats(928055334, VR.DS, MatrixMultiplier.l(randomBrachyNeedle.c()));
                basicDicomObject2.putFloats(928055336, VR.DS, MatrixMultiplier.l(randomBrachyNeedle.b()));
                basicDicomObject2.putFloats(928055348, VR.DS, randomBrachyNeedle.j());
                if (((TemplateGridOverlay)serializable).K()) {
                    float f4 = randomBrachyNeedle.q();
                    float f5 = f4 * randomBrachyNeedle.d().i().voxel[2] / 5.0f;
                    basicDicomObject2.putFloat(928055352, VR.DS, f5);
                }
                float[] fArray = new float[randomBrachyNeedle.h().size() * 3];
                int[] nArray = new int[randomBrachyNeedle.h().size() * 4];
                byte[] byArray = new byte[randomBrachyNeedle.h().size()];
                String[] stringArray = new String[byArray.length];
                int n2 = 0;
                int n3 = 0;
                for (RandomSeedLocation randomSeedLocation : randomBrachyNeedle.h()) {
                    byArray[n2 / 3] = (byte)(randomSeedLocation.d() ? 1 : 0);
                    stringArray[n2 / 3] = randomSeedLocation.f() != null ? randomSeedLocation.f() : "";
                    fArray[n2++] = randomSeedLocation.c().x;
                    fArray[n2++] = randomSeedLocation.c().y;
                    fArray[n2++] = randomSeedLocation.c().z;
                    nArray[n3++] = randomSeedLocation.e().getRed();
                    nArray[n3++] = randomSeedLocation.e().getGreen();
                    nArray[n3++] = randomSeedLocation.e().getBlue();
                    nArray[n3++] = randomSeedLocation.e().getAlpha();
                }
                basicDicomObject2.putFloats(928055344, VR.DS, fArray);
                basicDicomObject2.putInts(930291987, VR.IS, nArray);
                basicDicomObject2.putBytes(928055349, VR.OB, byArray);
                basicDicomObject2.putStrings(930291991, VR.LO, stringArray);
                basicDicomObject2.putInt(0x300C000C, VR.IS, n2);
                dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
            }
        }
        f2 = null;
        object = this.brachyVC.g().b(PiradsScoringModel.class);
        if (object != null) {
            f2 = object;
        }
        if (f2 != null) {
            a.a((DicomObject)basicDicomObject, (PiradsScoringModel)((Object)f2));
        }
    }

    public InputNotification showDialog() {
        InputNotification inputNotification = this.showDialog(new Notification.a(this.brachyVC));
        inputNotification.addToGrandNotifier();
        final ActionListener actionListener = inputNotification.getDismissActionListener();
        inputNotification.setDismissActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionListener != null) {
                    actionListener.actionPerformed(actionEvent);
                }
                DicomBrachyRtPlanWriter.this.srcVC.k(false);
            }
        });
        this.srcVC.k(true);
        return inputNotification;
    }

    public InputNotification showDialog(Notification.a a2) {
        l<String> l2;
        l<String> l3;
        l<String> l4;
        l<String> l5;
        l<String> l6;
        l<String> l7;
        l<String> l8;
        Object object;
        l<SendToDestination> l9;
        boolean bl2 = DicomBrachyRtPlanWriter.needsSave(this.srcVC);
        Messages messages = Messages.a("Dicom");
        Messages messages2 = Messages.a("Brachytherapy");
        String string = Messages.a("Dicom", "DCM_RT_PLAN_CREATOR_SAVE");
        if (this.overlay.q().a()) {
            string = Messages.a("Biopsy", "SAVE_BXPLAN");
        }
        String string2 = Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_RTPLAN_DESC");
        if (this.srcVC.ba().P() != null && this.srcVC.ba().P().q().a()) {
            string = Messages.a("Biopsy", "SAVE_BXPLAN_TITLE");
            string2 = Messages.a("Biopsy", "BXPLAN_DESCRIPTION");
        }
        final InputNotification inputNotification = new InputNotification(a2, string, "save");
        inputNotification.setScrollBarType(AbstractInputContainer.ScrollBarType.b);
        inputNotification.addTitle(string);
        m m2 = inputNotification.addCollection(messages.getProperty("DCM_RT_STRUCT_CREATOR_PATIENT"), null, 0);
        m2.b(this.info.patientName);
        m m3 = inputNotification.addCollection(messages.getProperty("DCM_RT_STRUCT_CREATOR_MODALITY"), null, 0);
        m3.b(this.info.modality);
        m m4 = inputNotification.addCollection(messages.getProperty("DCM_RT_STRUCT_CREATOR_DATE"), null, 0);
        m4.b(this.info.d());
        if (!MIMContext.k()) {
            l9 = inputNotification.addSendToCombo(messages.getProperty("DCM_RT_STRUCT_CREATOR_DEST"));
            object = this.sendDest != null ? this.sendDest : ag.a(this.state.a().bG());
            if (ag.d() != null) {
                object = ag.d();
            }
            l9.a((SendToDestination)object);
        } else {
            l9 = null;
        }
        object = inputNotification.addTextField(string2);
        ((l)object).a((String)this.state.rtPlanDescription);
        l<Date> l10 = inputNotification.addDateField(messages.getProperty("DCM_RT_STRUCT_CREATOR_RTPLAN_DATE"));
        final JXDatePicker jXDatePicker = (JXDatePicker)l10.g();
        jXDatePicker.setFormats(new String[]{"yyyy-MM-dd"});
        l10.a(this.state.procedureDate);
        jXDatePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (jXDatePicker.getDate() != null) {
                    inputNotification.setErrorText(null);
                }
            }
        });
        inputNotification.addSeparator();
        String string3 = this.state.needleVector != null ? messages.b("DCM_RT_PLAN_WRITER_RESLICED_SERIES_TITLE") : messages.b("DCM_RT_PLAN_WRITER_BRACHY_SERIES_TITLE");
        inputNotification.addLabel("<html><strong>" + string3 + "</strong></html>");
        boolean bl3 = DicomBrachyRtPlanWriter.needsSave(this.brachyVC);
        if (bl3) {
            l8 = inputNotification.addTextField(messages.getProperty("DCM_RT_STRUCT_CREATOR_DESCRIPTION"));
            l8.a(this.info.seriesDesc);
            l7 = inputNotification.addTextField(messages.getProperty("DCM_RT_PLAN_WRITER_STUDY_DESC"));
            l7.a(this.info.studyDesc);
        } else {
            l8 = null;
            l7 = null;
            this.addAlreadySavedBlock(inputNotification, this.brachyVC.getUncopiedMutableInfo());
        }
        String string4 = this.state.needleVector != null ? messages2.b("VOL_SAVE_RT_RESLICED") : "";
        l<String> l11 = inputNotification.addTextField(messages.getProperty("DCM_RT_PLAN_WRITER_RTST_DESC"));
        l11.a(string4);
        if (this.state.needleVector != null) {
            inputNotification.addSeparator();
            inputNotification.addLabel("<html><strong>" + messages.b("DCM_RT_PLAN_WRITER_ORIG_TITLE") + "</strong></html>");
            if (bl2) {
                l6 = inputNotification.addTextField(messages.getProperty("DCM_RT_STRUCT_CREATOR_DESCRIPTION"));
                l6.a(this.srcVC.getUncopiedMutableInfo().seriesDesc);
                l5 = inputNotification.addTextField(messages.getProperty("DCM_RT_PLAN_WRITER_STUDY_DESC"));
                l5.a(this.srcVC.getUncopiedMutableInfo().studyDesc);
            } else {
                l6 = null;
                l5 = null;
                this.addAlreadySavedBlock(inputNotification, this.srcVC.getUncopiedMutableInfo());
            }
            l4 = inputNotification.addTextField(messages.getProperty("DCM_RT_PLAN_WRITER_RTST_DESC"));
            l4.a(messages2.b("VOL_SAVE_RT_ORIG"));
        } else {
            l6 = null;
            l4 = null;
            l5 = null;
        }
        inputNotification.addSeparator();
        inputNotification.addLabel("<html><strong>" + messages.b("DCM_RT_PLAN_WRITER_RTST_OPTIONS") + "</strong></html>");
        l<String> l12 = inputNotification.addTextField(messages.getProperty("DCM_RT_STRUCT_CREATOR_OPERATOR"));
        l12.a(DicomRtStructCreator.getLastOperatorName());
        l<Boolean> l13 = inputNotification.addCheckBox(messages.getProperty("DCM_RT_STRUCT_CREATOR_SIMPLIFY"));
        l13.a(Boolean.FALSE);
        IsodoseOverlay isodoseOverlay = DicomBrachyRtPlanWriter.findBaselineDose(this.state);
        if (isodoseOverlay != null) {
            inputNotification.addSeparator();
            inputNotification.addLabel("<html><strong>" + messages.b("DCM_RT_PLAN_WRITER_BASELINE_TITLE") + "</strong></html>");
            if (DicomBrachyRtPlanWriter.needsSave(isodoseOverlay.C())) {
                l3 = inputNotification.addTextField(messages.getProperty("DCM_RT_STRUCT_CREATOR_DESCRIPTION"));
                l3.a(isodoseOverlay.C().getUncopiedMutableInfo().seriesDesc);
                l2 = inputNotification.addTextField(messages.getProperty("DCM_RT_PLAN_WRITER_STUDY_DESC"));
                l2.a(isodoseOverlay.C().getUncopiedMutableInfo().studyDesc);
            } else {
                l3 = null;
                l2 = null;
                this.addAlreadySavedBlock(inputNotification, isodoseOverlay.C().getUncopiedMutableInfo());
            }
        } else {
            l3 = null;
            l2 = null;
        }
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(l8);
        arrayList.add(l11);
        arrayList.add(l4);
        arrayList.add(l3);
        this.copyDescriptionString((l<String>)object, arrayList);
        inputNotification.setOkActionListener(new ActionListener((l)object, l10, l12, l4, l8, l7, l11, l5, l6, l13, l3, l2){
            final /* synthetic */ l val$planDescIv;
            final /* synthetic */ l val$procDateIv;
            final /* synthetic */ l val$opNameIv;
            final /* synthetic */ l val$originalRtStSeriesDesc;
            final /* synthetic */ l val$brachyVCSeriesDesc;
            final /* synthetic */ l val$brachyVCStudyDesc;
            final /* synthetic */ l val$brachyRtStSeriesDesc;
            final /* synthetic */ l val$originalVCStudyDesc;
            final /* synthetic */ l val$originalVCSeriesDesc;
            final /* synthetic */ l val$simplifyIv;
            final /* synthetic */ l val$baselineSeriesDesc;
            final /* synthetic */ l val$baselineStudyDesc;
            {
                this.val$planDescIv = l3;
                this.val$procDateIv = l4;
                this.val$opNameIv = l5;
                this.val$originalRtStSeriesDesc = l6;
                this.val$brachyVCSeriesDesc = l7;
                this.val$brachyVCStudyDesc = l8;
                this.val$brachyRtStSeriesDesc = l92;
                this.val$originalVCStudyDesc = l10;
                this.val$originalVCSeriesDesc = l11;
                this.val$simplifyIv = l12;
                this.val$baselineSeriesDesc = l13;
                this.val$baselineStudyDesc = l14;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                inputNotification.setOkButtonEnabled(false);
                if (l9 != null) {
                    DicomBrachyRtPlanWriter.this.sendDest = (SendToDestination)l9.b();
                }
                DicomBrachyRtPlanWriter.this.planName = (String)this.val$planDescIv.b();
                DicomBrachyRtPlanWriter.this.procedureDate = (Date)this.val$procDateIv.b();
                if (DicomBrachyRtPlanWriter.this.procedureDate == null && DicomBrachyRtPlanWriter.this.state.F() == BrachyReportPlanState.SymphonyContext.a) {
                    inputNotification.setErrorText(Messages.a("BrachytherapyReports", "GENERATION_PROMPT_NO_DATE"));
                    return;
                }
                BrachySidePanel.b(DicomBrachyRtPlanWriter.this.brachyVC.g(), DicomBrachyRtPlanWriter.this.planName);
                BrachySidePanel.a(DicomBrachyRtPlanWriter.this.brachyVC.g(), DicomBrachyRtPlanWriter.this.procedureDate);
                ProgressQueueNotification.a(new ProgressQueueNotification.b(){

                    @Override
                    public void run(g g2) {
                        String string;
                        g2.a(DicomBrachyRtPlanWriter.this.getProgressTitle());
                        g2.a(6);
                        DicomBrachyRtPlanSaveParams dicomBrachyRtPlanSaveParams = new DicomBrachyRtPlanSaveParams();
                        dicomBrachyRtPlanSaveParams.planState = DicomBrachyRtPlanWriter.this.state;
                        dicomBrachyRtPlanSaveParams.progress = g2;
                        dicomBrachyRtPlanSaveParams.sendDest = DicomBrachyRtPlanWriter.this.sendDest;
                        ((DicomBrachyRtPlanWriter)DicomBrachyRtPlanWriter.this).reslicedRtstSOP[0] = string = UIDGenerator.generateUID();
                        dicomBrachyRtPlanSaveParams.operatorName = (String)val$opNameIv.b();
                        if (DicomBrachyRtPlanWriter.needsSave(DicomBrachyRtPlanWriter.this.brachyVC) && ((DicomBrachyRtPlanWriter)DicomBrachyRtPlanWriter.this).brachyVC.getUncopiedMutableInfo().needsNewSeriesUID) {
                            DicomBrachyRtPlanWriter.this.brachyVC.getUncopiedMutableInfo().j(UIDGenerator.generateUID());
                        }
                        DicomBrachyRtPlanWriter.this.operatorName = DcmWriterFactory.getPNString(dicomBrachyRtPlanSaveParams.operatorName);
                        if (val$originalRtStSeriesDesc != null) {
                            ((DicomBrachyRtPlanWriter)DicomBrachyRtPlanWriter.this).origRtstSOP[0] = UIDGenerator.generateUID();
                        }
                        if (val$brachyVCSeriesDesc != null && val$brachyVCStudyDesc != null) {
                            dicomBrachyRtPlanSaveParams.brachSeriesDesc = (String)val$brachyVCSeriesDesc.b();
                            dicomBrachyRtPlanSaveParams.brachStudyDesc = (String)val$brachyVCStudyDesc.b();
                        }
                        dicomBrachyRtPlanSaveParams.brachRtstSeriesDesc = (String)val$brachyRtStSeriesDesc.b();
                        if (val$originalVCStudyDesc != null && val$originalVCSeriesDesc != null) {
                            dicomBrachyRtPlanSaveParams.origStudyDesc = (String)val$originalVCStudyDesc.b();
                            dicomBrachyRtPlanSaveParams.origSeriesDesc = (String)val$originalVCSeriesDesc.b();
                        }
                        if (val$originalRtStSeriesDesc != null) {
                            dicomBrachyRtPlanSaveParams.origRtstSeriesDesc = (String)val$originalRtStSeriesDesc.b();
                        }
                        dicomBrachyRtPlanSaveParams.shouldSimplify = (Boolean)val$simplifyIv.b();
                        if (val$baselineSeriesDesc != null && val$baselineStudyDesc != null) {
                            dicomBrachyRtPlanSaveParams.baselineDoseSeriesDesc = (String)val$baselineSeriesDesc.b();
                            dicomBrachyRtPlanSaveParams.baselineDoseStudyDesc = (String)val$baselineStudyDesc.b();
                        }
                        dicomBrachyRtPlanSaveParams.origRtstSOP = DicomBrachyRtPlanWriter.this.origRtstSOP;
                        dicomBrachyRtPlanSaveParams.reslicedRtstSOP = DicomBrachyRtPlanWriter.this.reslicedRtstSOP;
                        boolean bl2 = DicomBrachyRtPlanWriter.saveReferencedObjects(dicomBrachyRtPlanSaveParams);
                        if (bl2) {
                            dicomBrachyRtPlanSaveParams.progress.b_(Messages.a("Dicom", "DCM_SERIES_SAVE_PLAN"));
                            bl2 &= DicomBrachyRtPlanWriter.this.writeTo(dicomBrachyRtPlanSaveParams.sendDest, (Progress)new o());
                            dicomBrachyRtPlanSaveParams.progress.N_();
                        }
                        if (!bl2) {
                            g2.k();
                            inputNotification.setErrorText(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_FAIL"));
                            inputNotification.setEnabled(true);
                        } else {
                            ((DicomBrachyRtPlanWriter)DicomBrachyRtPlanWriter.this).state.hasBrachySaved = true;
                            g2.b();
                            u.b().d(inputNotification);
                        }
                    }
                });
            }
        });
        return inputNotification;
    }

    private void addAlreadySavedBlock(InputNotification inputNotification, SeriesInfo seriesInfo) {
        Messages messages = Messages.a("Dicom");
        JLabel jLabel = inputNotification.addLabel(cn.a() + messages.getProperty("DCM_RT_PLAN_WRITER_SERIES_ALREADY_SAVED"));
        jLabel.setFont(jLabel.getFont().deriveFont(2));
        m m2 = inputNotification.addCollection(messages.getProperty("DCM_RT_STRUCT_CREATOR_DESCRIPTION"), null, 0);
        JLabel jLabel2 = m2.b(seriesInfo.seriesDesc);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        m m3 = inputNotification.addCollection(messages.getProperty("DCM_RT_PLAN_WRITER_STUDY_DESC"), null, 0);
        JLabel jLabel3 = m3.b(seriesInfo.studyDesc);
        jLabel3.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
    }

    private void copyDescriptionString(final l<String> l2, final List<l<String>> list) {
        Object object = l2.g();
        if (object instanceof JTextComponent) {
            ((JTextComponent)object).getDocument().addDocumentListener(new DocumentListener(){
                String planIVstring = "";
                String oldPlanIVstring = "";

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.pullTextLater();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.pullTextLater();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                private void pullTextLater() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.pullText();
                        }
                    });
                }

                private void pullText() {
                    this.planIVstring = (String)l2.b() + (((String)l2.b()).length() > 0 ? " " : "");
                    if (!this.planIVstring.equals(this.oldPlanIVstring)) {
                        for (l l22 : list) {
                            if (l22 == null) continue;
                            String string = (String)l22.b();
                            string = this.planIVstring + this.chopFront(string);
                            l22.b(string);
                        }
                        this.oldPlanIVstring = this.planIVstring;
                    }
                }

                private String chopFront(String string) {
                    if (this.oldPlanIVstring.length() < 0 || this.oldPlanIVstring.length() > string.length()) {
                        return string;
                    }
                    return string.substring(this.oldPlanIVstring.length(), string.length());
                }
            });
        }
    }

    private static boolean saveBrachyVC(DicomBrachyRtPlanSaveParams dicomBrachyRtPlanSaveParams) {
        try {
            boolean bl2 = true;
            if (bl2) {
                if (DicomBrachyRtPlanWriter.needsSave(dicomBrachyRtPlanSaveParams.planState.g())) {
                    dicomBrachyRtPlanSaveParams.progress.b_(Messages.a("Dicom", "DCM_SERIES_SAVE_VOL"));
                    bl2 &= DicomBrachyRtPlanWriter.doVolSave(dicomBrachyRtPlanSaveParams.planState.g(), dicomBrachyRtPlanSaveParams.sendDest, dicomBrachyRtPlanSaveParams.brachStudyDesc, dicomBrachyRtPlanSaveParams.brachSeriesDesc, dicomBrachyRtPlanSaveParams.isSavingToTempDest);
                }
                dicomBrachyRtPlanSaveParams.progress.N_();
            }
            if (bl2) {
                dicomBrachyRtPlanSaveParams.progress.b_(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE"));
                bl2 &= DicomBrachyRtPlanWriter.doRTstSave(dicomBrachyRtPlanSaveParams.planState.g(), dicomBrachyRtPlanSaveParams.sendDest, dicomBrachyRtPlanSaveParams.reslicedRtstSOP[0], dicomBrachyRtPlanSaveParams.brachRtstSeriesDesc, dicomBrachyRtPlanSaveParams.planName, dicomBrachyRtPlanSaveParams.operatorName, dicomBrachyRtPlanSaveParams.shouldSimplify);
                dicomBrachyRtPlanSaveParams.progress.N_();
            }
            return bl2;
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error while trying to save brachy VC.", throwable, DicomBrachyRtPlanWriter.class);
            return false;
        }
    }

    private static boolean doRTstSave(ViewController3D viewController3D, SendToDestination sendToDestination, String string, String string2, String string3, String string4, boolean bl2) {
        boolean bl3 = true;
        DicomRtStructCreator dicomRtStructCreator = DicomRtStructSaveInputFactory.get(viewController3D, string, string2, string3, string4, true);
        bl3 &= dicomRtStructCreator.writeTo(sendToDestination, (Progress)new o());
        if (bl2) {
            dicomRtStructCreator = DicomRtStructSaveInputFactory.get(viewController3D, string, string2, string3, string4, true);
            dicomRtStructCreator.setSimplifyContours(true);
            bl3 &= dicomRtStructCreator.writeTo(sendToDestination, (Progress)new o());
        }
        return bl3;
    }

    private static boolean doVolSave(ViewController3D viewController3D, SendToDestination sendToDestination, String string, String string2, boolean bl2) {
        final b b2 = new b();
        DicomSaveInputFactory.DicomSaveCallback dicomSaveCallback = DicomSaveInputFactory.getDefaultSaveCallback(viewController3D, new FuncUtils.m<Boolean>(){

            @Override
            public void doIt(Boolean bl2) {
                b2.a(bl2);
            }
        });
        dicomSaveCallback.destination = sendToDestination;
        dicomSaveCallback.extent = null;
        dicomSaveCallback.modality = viewController3D.getUncopiedMutableInfo().modality;
        dicomSaveCallback.saveAxial = true;
        dicomSaveCallback.saveSagittal = false;
        dicomSaveCallback.saveCoronal = false;
        dicomSaveCallback.saveType = DicomSaveInputFactory.DicomSaveType.NORMAL;
        dicomSaveCallback.options = DcmWriter.DcmSaveOptions.fillDefaultsFromSeriesInfo(viewController3D.getUncopiedMutableInfo());
        dicomSaveCallback.options.seriesDescription = string2;
        dicomSaveCallback.options.studyDescription = string;
        dicomSaveCallback.options.savingToPublicZone = !bl2;
        try {
            dicomSaveCallback.run();
            return (Boolean)b2.get();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Failed to save derived volume for RTplan", throwable, DicomBrachyRtPlanWriter.class);
            return false;
        }
    }

    public static boolean needsSave(ViewController3D viewController3D) {
        return DicomBrachyRtPlanWriter.needsSave(viewController3D.cw());
    }

    private static boolean needsSave(ImageVolumeShort imageVolumeShort) {
        return imageVolumeShort.getUncopiedMutableInfo().mimDerivedVolume && !imageVolumeShort.getUncopiedMutableInfo().volumeHasBeenSaved;
    }

    public static boolean saveReferencedObjects(DicomBrachyRtPlanSaveParams dicomBrachyRtPlanSaveParams) {
        IsodoseOverlay isodoseOverlay;
        boolean bl2 = DicomBrachyRtPlanWriter.saveBrachyVC(dicomBrachyRtPlanSaveParams);
        if (dicomBrachyRtPlanSaveParams.planState.a() != dicomBrachyRtPlanSaveParams.planState.g()) {
            if (bl2 && DicomBrachyRtPlanWriter.needsSave(dicomBrachyRtPlanSaveParams.planState.a()) && dicomBrachyRtPlanSaveParams.planState.a() != dicomBrachyRtPlanSaveParams.planState.g()) {
                dicomBrachyRtPlanSaveParams.progress.b_(Messages.a("Dicom", "DCM_SERIES_SAVE_VOL"));
                bl2 &= DicomBrachyRtPlanWriter.doVolSave(dicomBrachyRtPlanSaveParams.planState.a(), dicomBrachyRtPlanSaveParams.sendDest, dicomBrachyRtPlanSaveParams.origStudyDesc, dicomBrachyRtPlanSaveParams.origSeriesDesc, dicomBrachyRtPlanSaveParams.isSavingToTempDest);
                dicomBrachyRtPlanSaveParams.progress.N_();
            }
            if (bl2) {
                dicomBrachyRtPlanSaveParams.progress.b_(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE"));
                bl2 &= DicomBrachyRtPlanWriter.doRTstSave(dicomBrachyRtPlanSaveParams.planState.a(), dicomBrachyRtPlanSaveParams.sendDest, dicomBrachyRtPlanSaveParams.origRtstSOP[0], dicomBrachyRtPlanSaveParams.origRtstSeriesDesc, dicomBrachyRtPlanSaveParams.planName, dicomBrachyRtPlanSaveParams.operatorName, dicomBrachyRtPlanSaveParams.shouldSimplify);
                dicomBrachyRtPlanSaveParams.progress.N_();
            }
        }
        if ((isodoseOverlay = DicomBrachyRtPlanWriter.findBaselineDose(dicomBrachyRtPlanSaveParams.planState)) != null && DicomBrachyRtPlanWriter.needsSave(isodoseOverlay.C())) {
            ViewController3D viewController3D = SaveRTDOSECommand.a(isodoseOverlay.C());
            viewController3D.a(isodoseOverlay.t().bG());
            ((RTDoseSeriesInfo)isodoseOverlay.C().getUncopiedMutableInfo().modInfo).a = new WeakReference<ViewController3D>(isodoseOverlay.t());
            dicomBrachyRtPlanSaveParams.progress.b_(Messages.a("Dicom", "DCM_SERIES_SAVE_VOL"));
            bl2 &= DicomBrachyRtPlanWriter.doVolSave(viewController3D, dicomBrachyRtPlanSaveParams.sendDest, dicomBrachyRtPlanSaveParams.baselineDoseStudyDesc, dicomBrachyRtPlanSaveParams.baselineDoseSeriesDesc, dicomBrachyRtPlanSaveParams.isSavingToTempDest);
            dicomBrachyRtPlanSaveParams.progress.N_();
        }
        return bl2;
    }

    private static IsodoseOverlay findBaselineDose(BrachyReportPlanState brachyReportPlanState) {
        IsodoseOverlay isodoseOverlay = null;
        if (brachyReportPlanState.b()) {
            String string = brachyReportPlanState.baselineDoseUID;
            for (IsodoseOverlay isodoseOverlay2 : brachyReportPlanState.g().ba().a(IsodoseOverlay.class, false, false)) {
                if (!cn.a(string, isodoseOverlay2.C().getUncopiedMutableInfo().ag(), true)) continue;
                isodoseOverlay = isodoseOverlay2;
                break;
            }
        }
        return isodoseOverlay;
    }
}

