/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.e;
import com.mimvista.commands.keyboard.bx;
import com.mimvista.dicom.gui.DicomIsocenterRtPlanSaveNotification;
import com.mimvista.dicom.gui.DicomRtStructSaveInputFactory;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.DicomIsocenterRtPlanTags;
import com.mimvista.dicom.write.DicomRtPlanWriter;
import com.mimvista.dicom.write.rtst.DicomRtStructCreator;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomIsocenterRtPlanWriter
extends DicomRtPlanWriter {
    private DicomIsocenterRtPlanTags tags;
    private ViewController srcVC;

    public DicomIsocenterRtPlanWriter(ViewController viewController) {
        this.srcVC = viewController;
        this.info = viewController.getUncopiedMutableInfo();
    }

    @Override
    public String getSeriesDescription() {
        return this.tags.rtPlanDescription;
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        this.buildBasicHeader(dicomObject);
        this.buildBeamSeq(dicomObject);
        this.buildPatientSetupSeq(dicomObject);
        this.buildReferencedStructureSetSeq(dicomObject);
        this.buildFractionGroupSeq(dicomObject);
    }

    private void buildBasicHeader(DicomObject dicomObject) {
        dicomObject.putString(805961734, VR.DA, DateUtils.e());
        dicomObject.putString(805961735, VR.DA, DateUtils.f());
        dicomObject.putString(805961730, VR.SH, this.tags.rtPlanLabel);
        dicomObject.putString(0x300A0003, VR.LO, this.tags.rtPlanName);
        dicomObject.putString(0x200052, VR.UI, this.srcVC.aP().frameOfRefUID);
    }

    private void buildBeamSeq(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(805961904);
        int n2 = 1;
        for (Overlayish overlayish : this.srcVC.ba().a(OverlayishBase.InterpretedType.w, false, false)) {
            if (!(overlayish instanceof PointContourOverlay)) continue;
            for (DicomPoint3f dicomPoint3f : ((PointContourOverlay)overlayish).a()) {
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject);
                basicDicomObject.putInt(805961920, VR.IS, n2++);
                basicDicomObject.putString(805961922, VR.LO, overlayish.getName());
                basicDicomObject.putInt(806092906, VR.IS, this.tags.patientSetupNumber);
                DicomElement dicomElement2 = basicDicomObject.putSequence(805962001);
                BasicDicomObject basicDicomObject2 = new BasicDicomObject();
                dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
                basicDicomObject2.putTruncatedFloatsToDS(805962028, dicomPoint3f.f(), 3);
                basicDicomObject2.putString(805962194, VR.DS, "");
                basicDicomObject2.putString(805962196, VR.DS, "");
                basicDicomObject2.putString(805962198, VR.DS, "");
            }
        }
    }

    private void buildPatientSetupSeq(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(805962112);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(1593600, VR.CS, this.info.origPatientPosition == null ? "" : this.info.origPatientPosition.toString());
        basicDicomObject.putInt(805962114, VR.IS, this.tags.patientSetupNumber);
    }

    private void buildReferencedStructureSetSeq(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(806092896);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.3");
        basicDicomObject.putString(528725, VR.UI, this.tags.referencedSOPInstanceUID);
    }

    private void buildFractionGroupSeq(DicomObject dicomObject) {
        int n2 = this.srcVC.ba().a(OverlayishBase.InterpretedType.w, false, false).size();
        DicomElement dicomElement = dicomObject.putSequence(805961840);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putInt(805961841, VR.IS, 0);
        basicDicomObject.putInt(805961848, VR.IS, 0);
        basicDicomObject.putInt(805961856, VR.IS, n2);
        basicDicomObject.putInt(0x300A00A0, VR.IS, 0);
    }

    public boolean writeIsocenterRtPlan(SendToDestination sendToDestination, DicomIsocenterRtPlanTags dicomIsocenterRtPlanTags) {
        String string;
        this.tags = dicomIsocenterRtPlanTags;
        dicomIsocenterRtPlanTags.referencedSOPInstanceUID = string = UIDGenerator.generateUID();
        dicomIsocenterRtPlanTags.patientSetupNumber = 1;
        DicomRtStructCreator dicomRtStructCreator = DicomRtStructSaveInputFactory.get((ViewController3D)this.srcVC, string, dicomIsocenterRtPlanTags.rtPlanDescription, dicomIsocenterRtPlanTags.rtPlanDescription, "", true);
        boolean bl2 = dicomRtStructCreator.writeTo(sendToDestination, (Progress)new o());
        boolean bl3 = this.writeTo(sendToDestination, (Progress)new o());
        return !bl2 || !bl3;
    }

    @e(e="save_lap_laser_rt_plan", f="save_lap_laser_rt_plan", b="command_save_lap_laser_rt_plan", a="General", h="save_rt_plan", k=MIMFeatureCategory.CONTOURING, j={LicenseOption.CONTOURING_ADVANCED})
    public static class SaveIsocentersAsRtPlanCommand
    extends bx.a {
        @Override
        public void execute(final ViewController viewController) {
            if (viewController.ba().e()) {
                DicomIsocenterRtPlanSaveNotification dicomIsocenterRtPlanSaveNotification = new DicomIsocenterRtPlanSaveNotification(viewController);
                u.b().c(dicomIsocenterRtPlanSaveNotification);
                viewController.k(true);
                final ActionListener actionListener = dicomIsocenterRtPlanSaveNotification.getDismissActionListener();
                ActionListener actionListener2 = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionListener != null) {
                            actionListener.actionPerformed(actionEvent);
                        }
                        viewController.k(false);
                    }
                };
                dicomIsocenterRtPlanSaveNotification.setDismissActionListener(actionListener2);
            } else {
                String string = Messages.a("Dicom", "DCM_LAP_RT_PLAN_WRITE_NO_ISOCENTERS");
                BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, string, new Notification.a(viewController), Notification.NotificationTimeoutType.b, 5000L);
                u.b().c(basicNotification);
            }
        }
    }
}

