/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesParameters;
import com.mimvista.dicom.write.DicomReferencingRtPlanTags;
import com.mimvista.dicom.write.DicomRtPlanWriter;
import com.mimvista.internals.ViewController;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.util.List;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomReferencingRtPlanWriter
extends DicomRtPlanWriter {
    private DicomReferencingRtPlanTags tags;
    private ViewController srcVC;
    private ViewController doseVC;

    public DicomReferencingRtPlanWriter(ViewController viewController, ViewController viewController2, DicomReferencingRtPlanTags dicomReferencingRtPlanTags) {
        this.tags = dicomReferencingRtPlanTags;
        this.srcVC = viewController2;
        this.doseVC = viewController;
        this.info = viewController2.getUncopiedMutableInfo();
        this.sopInstanceUID = dicomReferencingRtPlanTags.planSOPInstanceUID;
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        this.buildBasicHeader(dicomObject);
        if (DicomPrefs.includeRTplanDummySeqs.getValue().booleanValue()) {
            this.buildDummyBeamSeq(dicomObject);
            this.buildDummyPatientSetupSeq(dicomObject);
        }
        this.buildReferencedStructureSetSeq(dicomObject);
        this.buildReferencedDoseSeq(dicomObject);
    }

    private void buildBasicHeader(DicomObject dicomObject) {
        dicomObject.putString(805961734, VR.DA, DateUtils.e());
        dicomObject.putString(805961735, VR.DA, DateUtils.f());
        dicomObject.putString(805961730, VR.SH, this.tags.rtPlanLabel);
        dicomObject.putString(0x300A0003, VR.LO, this.tags.rtPlanName);
        dicomObject.putString(805961740, VR.CS, "PATIENT");
        dicomObject.putString(528496, VR.PN, this.tags.operatorName);
    }

    private void buildDummyBeamSeq(DicomObject dicomObject) {
        DicomElement dicomElement = this.getOriginalPlanSeq(805961904);
        if (dicomElement == null) {
            dicomElement = dicomObject.putSequence(805961904);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(805961906, VR.SH, "");
            basicDicomObject.putInt(805961920, VR.IS, 1);
            basicDicomObject.putString(805961922, VR.LO, "");
            basicDicomObject.putString(805961924, VR.CS, "STATIC");
            basicDicomObject.putString(805961926, VR.CS, "PHOTON");
            basicDicomObject.putString(805961907, VR.CS, "MU");
            basicDicomObject.putString(805961934, VR.CS, "TREATMENT");
            basicDicomObject.putInt(805961936, VR.IS, 0);
            basicDicomObject.putInt(805961952, VR.IS, 0);
            basicDicomObject.putInt(805961965, VR.IS, 0);
            basicDicomObject.putInt(805961968, VR.IS, 0);
            basicDicomObject.putInt(806092906, VR.IS, this.tags.patientSetupNumber);
            basicDicomObject.putInt(805699654, VR.IS, 1);
            DicomElement dicomElement2 = basicDicomObject.putSequence(805961910);
            BasicDicomObject basicDicomObject2 = new BasicDicomObject();
            dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
            basicDicomObject2.putString(805961912, VR.CS, "X");
            basicDicomObject2.putInt(805961916, VR.IS, 1);
            DicomElement dicomElement3 = basicDicomObject.putSequence(805962001);
            BasicDicomObject basicDicomObject3 = new BasicDicomObject();
            dicomElement3.addDicomObject((DicomObject)basicDicomObject3);
            basicDicomObject3.putInt(805962002, VR.IS, 0);
            basicDicomObject3.putFloat(805962004, VR.DS, 0.0f);
            basicDicomObject3.putTruncatedFloatsToDS(805962028, new float[]{0.0f, 0.0f, 0.0f}, 3);
            basicDicomObject3.putString(805962194, VR.DS, "");
            basicDicomObject3.putString(805962196, VR.DS, "");
            basicDicomObject3.putString(805962198, VR.DS, "");
        } else {
            dicomObject.add(dicomElement);
        }
    }

    private void buildDummyPatientSetupSeq(DicomObject dicomObject) {
        DicomElement dicomElement = this.getOriginalPlanSeq(805962112);
        if (dicomElement == null) {
            dicomElement = dicomObject.putSequence(805962112);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(1593600, VR.CS, this.info.origPatientPosition == null ? "" : this.info.origPatientPosition.toString());
            basicDicomObject.putInt(805962114, VR.IS, this.tags.patientSetupNumber);
        } else {
            dicomObject.add(dicomElement);
        }
    }

    private DicomElement getOriginalPlanSeq(int n2) {
        List<String> list;
        if (this.doseVC.getUncopiedMutableInfo().modInfo instanceof RTDoseSeriesInfo && (list = ((RTDoseSeriesInfo)this.doseVC.getUncopiedMutableInfo().modInfo).referencedRtPlanUIDs) != null && !list.isEmpty()) {
            for (String string : list) {
                SeriesParameters seriesParameters = new SeriesParameters();
                seriesParameters.name = this.srcVC.getPatientName();
                seriesParameters.searchType = 0;
                seriesParameters.uidList = Lists.newArrayList((Object[])new String[]{string});
                List<DcmSeries> list2 = this.srcVC.bJ().a(seriesParameters);
                if (list2 == null || list2.isEmpty()) continue;
                for (DcmSeries dcmSeries : list2) {
                    DicomObject dicomObject;
                    DicomElement dicomElement;
                    if (!Modality.RTPLAN.isSameModality(dcmSeries.getModality()) || (dicomElement = (dicomObject = dcmSeries.getDataProvider().getFirstDicomObj()).get(n2)) == null) continue;
                    return dicomElement;
                }
            }
        }
        return null;
    }

    private void buildReferencedStructureSetSeq(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(806092896);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.3");
        basicDicomObject.putString(528725, VR.UI, this.tags.referencedSOPInstanceUID);
    }

    private void buildReferencedDoseSeq(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(806092928);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.2");
        basicDicomObject.putString(528725, VR.UI, this.tags.doseSOPInstanceUID);
    }
}

