/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.dicom.DicomColorUtilities;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.PositionTransform;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mesh.MeshOverlay;
import com.mimvista.mesh.MetricMesh;
import com.mimvista.mesh.a;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.RemoteVolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.algo.b;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomSurfSegCreator
extends b {
    public Messages props = Messages.a("Dicom");
    private ImageVolumeShort volume;
    private LinkedListMultimap<VolumetricContourOverlayish, Integer> segmentList = LinkedListMultimap.create();
    private List<MeshOverlay> surfaces = Lists.newArrayList();
    private List<Pair<MeshOverlay, String>> writeableOverlays;
    private boolean generateFromContours;
    Set<ImageFrame> remoteVolumes = Sets.newHashSet();

    public DicomSurfSegCreator(ViewController3D viewController3D, ImageVolumeShort imageVolumeShort, String string, boolean bl2) {
        this.viewState = viewController3D;
        this.volume = imageVolumeShort;
        this.info = imageVolumeShort.getUncopiedMutableInfo();
        this.sopInstanceUID = string;
        this.generateFromContours = bl2;
    }

    @Override
    public String getProgressTitle() {
        return this.props.getProperty("DCM_SURFACE_SEG_CREATOR_SAVE");
    }

    @Override
    public Modality getModality() {
        return Modality.SEG;
    }

    @Override
    public UIDContainer getSopClassUID() {
        return new UIDContainer.SOPClassUID("1.2.840.10008.5.1.4.1.1.66.5");
    }

    @Override
    public String getSeriesDate() {
        return DateUtils.e();
    }

    @Override
    public String getSeriesTime() {
        return DateUtils.f();
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        this.getOverlays();
        this.buildReferencedSeriesSequence(dicomObject);
        this.buildSegmentSequence(dicomObject);
        this.buildSurfaceSequence(dicomObject);
        this.buildMIMPrivateInfoSequence(dicomObject);
    }

    private void buildMIMPrivateInfoSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(930299904);
        this.remoteVolumes.forEach(imageFrame -> {
            SeriesInfo seriesInfo = imageFrame.getUncopiedMutableInfo();
            DicomObject dicomObject = dicomElement.addDicomObject((DicomObject)new BasicDicomObject());
            if (seriesInfo.hasStudyDate) {
                dicomObject.putString(930299905, VR.DA, seriesInfo.N());
            } else {
                dicomObject.putString(930299905, VR.DA, "");
            }
            dicomObject.putString(930299906, VR.TM, DateUtils.e(seriesInfo.studyTime));
            dicomObject.putString(930299907, VR.LO, seriesInfo.institutionName);
            dicomObject.putString(930299908, VR.PN, seriesInfo.referringPhysRaw);
            dicomObject.putString(930299909, VR.PN, seriesInfo.patientNameRaw);
            dicomObject.putString(930299910, VR.LO, seriesInfo.patientId);
            dicomObject.putString(930299911, VR.DA, seriesInfo.birthDate);
            dicomObject.putString(930299912, VR.CS, seriesInfo.sex);
        });
    }

    private void getOverlays() {
        block7: {
            if (this.writeableOverlays != null) break block7;
            int n2 = 0;
            if (this.generateFromContours) {
                a a2 = new a();
                for (Overlayish overlayish : this.volume.n().R()) {
                    MeshOverlay meshOverlay;
                    List<Contour> list;
                    ArrayList arrayList;
                    Overlay overlay;
                    if (overlayish instanceof VolumetricContourOverlay) {
                        overlay = (VolumetricContourOverlay)overlayish;
                        arrayList = Lists.newArrayList();
                        list = ((VolumetricContourOverlay)overlay).aq().d();
                        for (Contour contour : list) {
                            meshOverlay = new MeshOverlay(this.viewState, a2.a(contour), MeshOverlay.MeshRenderChoice.a);
                            arrayList.add(++n2);
                            this.surfaces.add(meshOverlay);
                        }
                        this.segmentList.putAll((Object)overlay, (Iterable)arrayList);
                    }
                    if (!(overlayish instanceof RemoteVolumetricContourOverlay)) continue;
                    overlay = (RemoteVolumetricContourOverlay)overlayish;
                    this.remoteVolumes.add(((RemoteVolumetricContourOverlay)overlay).U().au().aw());
                    arrayList = Lists.newArrayList();
                    list = ((RemoteVolumetricContourOverlay)overlay).aq().d();
                    for (Contour contour : list) {
                        meshOverlay = new MeshOverlay(((RemoteVolumetricContourOverlay)overlay).U().au(), a2.a(contour), MeshOverlay.MeshRenderChoice.a);
                        arrayList.add(++n2);
                        this.surfaces.add(meshOverlay);
                    }
                    this.segmentList.putAll((Object)overlay, (Iterable)arrayList);
                }
            } else {
                for (Overlayish overlayish : this.volume.n().h()) {
                    if (!(overlayish instanceof MeshOverlay)) continue;
                }
            }
        }
    }

    protected void buildReferencedSeriesSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(528661);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        DicomElement dicomElement2 = basicDicomObject.putSequence(528714);
        for (SliceInfo sliceInfo : this.volume.ab()) {
            BasicDicomObject basicDicomObject2 = new BasicDicomObject();
            dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
            basicDicomObject2.putString(528720, VR.UI, this.volume.I().sopClassUID);
            basicDicomObject2.putString(528725, VR.UI, sliceInfo.sopInstanceUID);
        }
        basicDicomObject.add(dicomElement2);
        basicDicomObject.putString(0x20000D, VR.UI, this.volume.I().studyUID);
        basicDicomObject.putString(0x20000E, VR.UI, this.volume.I().ag());
    }

    protected void buildSegmentSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(0x620002);
        int n2 = 1;
        for (VolumetricContourOverlayish volumetricContourOverlayish : this.segmentList.keySet()) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            List list = this.segmentList.get((Object)volumetricContourOverlayish);
            basicDicomObject.putInt(6422532, VR.US, n2);
            basicDicomObject.putString(6422533, VR.LO, volumetricContourOverlayish.getName());
            basicDicomObject.putString(6422536, VR.CS, "MANUAL");
            basicDicomObject.putInt(6684714, VR.UL, list.size());
            Color color = volumetricContourOverlayish.bn_();
            int[] nArray = new int[]{color.getRed(), color.getGreen(), color.getBlue()};
            int[] nArray2 = DicomColorUtilities.getIntegerScaledCIELabPCSFromSRGB(nArray);
            basicDicomObject.putInts(6422541, VR.US, nArray2);
            this.buildReferencedSurfaceSequence((DicomObject)basicDicomObject, list);
            ++n2;
        }
        dicomObject.add(dicomElement);
    }

    public void buildReferencedSurfaceSequence(DicomObject dicomObject, List<Integer> list) {
        DicomElement dicomElement = dicomObject.putSequence(6684715);
        for (int n2 : list) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putInt(6684716, VR.UL, n2);
        }
    }

    protected void buildSurfaceSequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(0x660002);
        for (int i2 = 0; i2 < this.surfaces.size(); ++i2) {
            int n2 = i2 + 1;
            MeshOverlay meshOverlay = this.surfaces.get(i2);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putInt(0x660003, VR.UL, n2);
            basicDicomObject.putString(0x66000D, VR.CS, "WIREFRAME");
            basicDicomObject.putString(0x66000E, VR.CS, "YES");
            this.buildSurfacePointsSequence((DicomObject)basicDicomObject, meshOverlay);
            this.buildSurfaceMeshPrimitivesSequence((DicomObject)basicDicomObject, meshOverlay.b());
        }
    }

    protected void buildSurfacePointsSequence(DicomObject dicomObject, MeshOverlay meshOverlay) {
        MetricPoint3f metricPoint3f2;
        Object object;
        MetricMesh metricMesh = meshOverlay.b();
        List list = metricMesh.g();
        ArrayList arrayList = Lists.newArrayList();
        if (this.generateFromContours) {
            if (meshOverlay.ao() == this.volume) {
                for (Object object2 : list) {
                    arrayList.add(((MetricPoint3f)((Object)object2)).d());
                }
            } else {
                object = this.viewState.aG().d(meshOverlay.ao(), this.viewState.aw());
                for (MetricPoint3f metricPoint3f2 : list) {
                    MetricPoint3f metricPoint3f3 = ((PositionTransform)object).a(metricPoint3f2);
                    arrayList.add(metricPoint3f3.d());
                }
            }
        } else {
            for (Object object2 : list) {
                arrayList.add(((MetricPoint3f)((Object)object2)).d());
            }
        }
        object = new float[arrayList.size() * 3];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            object[3 * i2] = ((DicomPoint3f)((Object)arrayList.get((int)i2))).x;
            object[3 * i2 + 1] = ((DicomPoint3f)((Object)arrayList.get((int)i2))).y;
            object[3 * i2 + 2] = ((DicomPoint3f)((Object)arrayList.get((int)i2))).z;
        }
        DicomElement dicomElement = dicomObject.putSequence(0x660011);
        metricPoint3f2 = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)metricPoint3f2);
        metricPoint3f2.putInt(6684693, VR.UL, arrayList.size());
        metricPoint3f2.putFloats(0x660016, VR.OF, (float[])object);
    }

    protected void buildSurfaceMeshPrimitivesSequence(DicomObject dicomObject, MetricMesh metricMesh) {
        List<int[]> list = metricMesh.h();
        int[] nArray = new int[list.size() * 3];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[3 * i2] = list.get(i2)[0] + 1;
            nArray[3 * i2 + 1] = list.get(i2)[1] + 1;
            nArray[3 * i2 + 2] = list.get(i2)[2] + 1;
        }
        DicomElement dicomElement = dicomObject.putSequence(6684691);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putInts(6684737, VR.UL, nArray);
    }
}

