/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mimvista.commands.workflow.Create4DCTMIPCommand;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.ak;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.state.VolumeSourceInfo;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.work.m;
import com.mimvista.viewer.CTSeriesInfo;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JOptionPane;

public class Dynamic4DCTVolumeDeriver {
    private DynamicDerivationOptions options;
    private Progress progress;
    private ImageVolumeShort newVolume;
    private static Messages props = Messages.a("Dicom");

    public Dynamic4DCTVolumeDeriver(o o2, Create4DCTMIPCommand.MIPType mIPType) {
        this(new DynamicDerivationOptions(o2, mIPType));
    }

    public Dynamic4DCTVolumeDeriver(DynamicDerivationOptions dynamicDerivationOptions) {
        this.options = dynamicDerivationOptions;
    }

    public ImageVolumeShort getOutputVolume() {
        if (this.newVolume == null) {
            this.generateOutputVolume();
        }
        return this.newVolume;
    }

    private List<ImageVolumeShort> getSourceVols() {
        ArrayList arrayList = Lists.newArrayList();
        o o2 = this.getSourceSeries();
        for (int i2 = 0; i2 < o2.n(); ++i2) {
            if (!this.options.frameFilter.apply((Object)i2)) continue;
            arrayList.add(o2.c(i2));
        }
        return arrayList;
    }

    private void calculateRescaleInfo() {
        Object object2;
        DeriverFunctor deriverFunctor = this.getPass1Functor(this.getSourceVols(), m.c.getCorePoolSize());
        int n2 = this.newVolume.a()[2] * this.newVolume.a()[1];
        FuncUtils.a((ThreadPoolExecutor)m.c, n2, deriverFunctor, "4D Vol Deriver");
        if (this.progress.n() == Progress.Status.e) {
            this.newVolume = null;
            return;
        }
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        List list = deriverFunctor.getStates();
        for (Object object2 : list) {
            Pass1State pass1State = (Pass1State)object2;
            if (pass1State.maxAcVal > f3) {
                f3 = pass1State.maxAcVal;
            }
            if (!(pass1State.minAcVal < f2)) continue;
            f2 = pass1State.minAcVal;
        }
        float f4 = f3 - f2;
        object2 = null;
        boolean bl2 = true;
        for (ImageVolumeShort imageVolumeShort : this.getSourceVols()) {
            RescaleConverter rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale;
            float f5 = rescaleConverter.slope * rescaleConverter.unitScale;
            if (object2 == null) {
                object2 = Float.valueOf(f5);
                continue;
            }
            if (f5 == ((Float)object2).floatValue()) continue;
            bl2 = false;
            break;
        }
        if (object2 == null) {
            ay.d((Object)"No frames? Bad state...", this);
            return;
        }
        SeriesInfo seriesInfo = this.newVolume.getUncopiedMutableInfo();
        seriesInfo.rescale.intercept = f2;
        boolean bl3 = this.getType() == Create4DCTMIPCommand.MIPType.b ? true : (this.getType() == Create4DCTMIPCommand.MIPType.e ? (bl2 ? !(f4 / ((Float)object2).floatValue() < 65534.0f) : true) : !bl2);
        seriesInfo.rescale.slope = bl3 ? f4 / 32767.0f * 2.0f : ((Float)object2).floatValue();
        seriesInfo.rescale.unitScale = 1.0f;
        seriesInfo.u().a(seriesInfo.u().m());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateOutputVolume() {
        try {
            int n2;
            List<ImageVolumeShort> list;
            if (this.progress == null) {
                this.progress = new ProgressPanel();
                this.progress.c(true);
                this.progress.b_(props.getProperty("DYNAMIC_4DCT_VOLUME_PROGRESS_MESSAGE"));
                ProgressQueueNotification.a((ProgressPanel)this.progress);
            }
            if ((list = this.getSourceVols()).isEmpty()) {
                throw new RuntimeException("No input vols to derive from.");
            }
            this.copySeriesInfo();
            this.progress.a(this.newVolume.a()[2] * this.newVolume.a()[1] * 2);
            this.progress.a();
            if (this.getType() == Create4DCTMIPCommand.MIPType.c) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    ImageVolumeShort imageVolumeShort = list.get(n2);
                    int n3 = imageVolumeShort.getUncopiedMutableInfo().b(imageVolumeShort);
                    if (n3 > 0) continue;
                    u.b().c(new BasicNotification(BasicNotification.NotificationType.a, props.getProperty("DYNAMIC_TIME_FAIL"), new Notification.a(this.getSourceSeries().g())));
                    this.progress.k();
                    this.newVolume = null;
                    return;
                }
            }
            for (n2 = 0; n2 < this.newVolume.a()[2]; ++n2) {
                ((ImageCube.ImageCubeShort)this.newVolume.ad()).a(new short[this.newVolume.a()[0] * this.newVolume.a()[1]]);
            }
            if (this.progress.n() == Progress.Status.e) {
                this.newVolume = null;
                return;
            }
            this.calculateRescaleInfo();
            this.newVolume.c(true);
            this.newVolume.k();
            DeriverFunctor deriverFunctor = this.getPass2Functor(list);
            int n4 = this.newVolume.a()[2] * this.newVolume.a()[1];
            FuncUtils.a((ThreadPoolExecutor)m.c, n4, deriverFunctor, "4D Vol Deriver2");
            if (this.progress.n() == Progress.Status.e) {
                this.newVolume = null;
                return;
            }
            if (this.getType() == Create4DCTMIPCommand.MIPType.e) {
                RescaleConverter rescaleConverter = this.newVolume.getUncopiedMutableInfo().rescale;
                rescaleConverter.intercept *= (float)list.size();
                rescaleConverter.slope *= (float)list.size();
            }
            this.newVolume.aj();
            this.newVolume.i();
            String string = this.newVolume.getUncopiedMutableInfo().seriesType;
            if (!cn.h(string)) {
                String[] stringArray = string.split("\\\\");
                ArrayList arrayList = Lists.newArrayList();
                Object object = stringArray;
                int n5 = ((String[])object).length;
                for (int i2 = 0; i2 < n5; ++i2) {
                    String string2 = object[i2];
                    if (string2.contains("GATED") || string2.contains("DYNAMIC")) continue;
                    arrayList.add(string2);
                }
                if (!arrayList.contains("STATIC")) {
                    arrayList.add(0, "STATIC");
                }
                this.newVolume.getUncopiedMutableInfo().seriesType = object = cn.a(arrayList, "\\");
            }
            if (this.newVolume.getUncopiedMutableInfo().modInfo instanceof PTSeriesInfo) {
                ((PTSeriesInfo)this.newVolume.getUncopiedMutableInfo().modInfo).origUnits = this.newVolume.getUncopiedMutableInfo().u().z();
            } else if (this.newVolume.getUncopiedMutableInfo().modInfo instanceof CTSeriesInfo) {
                ((CTSeriesInfo)this.newVolume.getUncopiedMutableInfo().modInfo).scanOptions = "";
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception.getMessage(), (Throwable)exception, this);
            JOptionPane.showMessageDialog(ak.b().O(), props.getProperty("DYNAMIC_4DCT_VOLUME_DERIVE_FAIL"), props.getProperty("DYNAMIC_4DCT_VOLUME_ERROR"), 0);
        }
        finally {
            this.progress.b();
        }
    }

    private DeriverFunctor getPass1Functor(List<ImageVolumeShort> list, final int n2) {
        return new DeriverFunctor(list){
            {
                super(list);
                List list2 = this.getStates();
                for (int i2 = 0; i2 < n2; ++i2) {
                    list2.add(new Pass1State());
                }
            }

            @Override
            public Pass1State getState(int n22) {
                return (Pass1State)super.getState(n22);
            }

            @Override
            protected void handleVoxel(float f2, int n22, int n3, int n4) {
                Pass1State pass1State = this.getState(n4);
                if (f2 > pass1State.maxAcVal) {
                    pass1State.maxAcVal = f2;
                }
                if (f2 < pass1State.minAcVal) {
                    pass1State.minAcVal = f2;
                }
            }
        };
    }

    private DeriverFunctor getPass2Functor(List<ImageVolumeShort> list) {
        return new DeriverFunctor((List)list){

            @Override
            protected void handleVoxel(float f2, int n2, int n3, int n4) {
                ((short[])((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)((Dynamic4DCTVolumeDeriver)Dynamic4DCTVolumeDeriver.this).newVolume.ad()).f((int)n2)).data)[n3] = (short)((Dynamic4DCTVolumeDeriver)Dynamic4DCTVolumeDeriver.this).newVolume.getUncopiedMutableInfo().rescale.removeWithBounds(f2);
            }
        };
    }

    private void copySeriesInfo() {
        this.newVolume = new ImageVolumeShort();
        ImageVolumeShort imageVolumeShort = this.getSourceSeries().e();
        this.newVolume.b(imageVolumeShort.Z());
        this.newVolume.a(imageVolumeShort.a());
        this.newVolume.a(imageVolumeShort.b());
        this.newVolume.b(imageVolumeShort.G());
        this.newVolume.a(imageVolumeShort.N());
        SeriesInfo seriesInfo = SeriesInfo.a(imageVolumeShort.getUncopiedMutableInfo());
        seriesInfo.j(UIDGenerator.generateUID());
        seriesInfo.seriesDesc = this.getType().getExternalizedString() + ": " + seriesInfo.seriesDesc;
        seriesInfo.ak();
        this.newVolume.b(seriesInfo);
        VolumeSourceInfo volumeSourceInfo = this.newVolume.D();
        volumeSourceInfo.c(true);
        volumeSourceInfo.b(imageVolumeShort.D().b());
        this.newVolume.a((SimpleImageFrame)imageVolumeShort, true);
        List<SliceInfo> list = imageVolumeShort.ab();
        if (list != null) {
            ((SimpleImageVolume)this.newVolume).a(SliceInfo.a(list));
            this.newVolume.aa().forEach(sliceInfo -> {
                sliceInfo.binNumber = -1;
            });
        }
    }

    public o getSourceSeries() {
        return this.options.sourceSeries;
    }

    public Create4DCTMIPCommand.MIPType getType() {
        return this.options.type;
    }

    public static class DynamicDerivationOptions {
        public o sourceSeries;
        public Create4DCTMIPCommand.MIPType type;
        public Predicate<Integer> frameFilter = Predicates.alwaysTrue();

        public DynamicDerivationOptions(o o2, Create4DCTMIPCommand.MIPType mIPType) {
            this.sourceSeries = o2;
            this.type = mIPType;
        }
    }

    private static class Pass1State
    extends FuncUtils.ab {
        float minAcVal = Float.MAX_VALUE;
        float maxAcVal = -3.4028235E38f;

        private Pass1State() {
        }
    }

    private abstract class DeriverFunctor
    extends FuncUtils.e {
        List<ImageVolumeShort> vols;

        public DeriverFunctor(List<ImageVolumeShort> list) {
            this.vols = list;
        }

        @Override
        public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
            int n5;
            ImageVolumeShort imageVolumeShort = this.vols.get(0);
            int n6 = this.vols.size();
            float f2 = Dynamic4DCTVolumeDeriver.this.getType().b();
            int n7 = imageVolumeShort.a()[0];
            int n8 = imageVolumeShort.a()[1];
            float[] fArray = new float[n6];
            for (n5 = 0; n5 < n6; ++n5) {
                ImageVolumeShort imageVolumeShort2 = this.vols.get(n5);
                fArray[n5] = imageVolumeShort2.getUncopiedMutableInfo().b(imageVolumeShort2);
            }
            for (n5 = n2; n5 < n3; ++n5) {
                if (Dynamic4DCTVolumeDeriver.this.progress.n() == Progress.Status.e) {
                    return;
                }
                int n9 = n5 % n8;
                int n10 = n5 / n8;
                for (int i2 = 0; i2 < n7; ++i2) {
                    int n11 = n9 * n7 + i2;
                    float f3 = f2;
                    int n12 = 0;
                    block9: for (int i3 = 0; i3 < n6; ++i3) {
                        ImageVolumeShort imageVolumeShort3 = this.vols.get(i3);
                        ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)imageVolumeShort3.ad()).f(n10);
                        short s2 = ((short[])imageSliceShort.data)[n11];
                        float f4 = imageVolumeShort3.getUncopiedMutableInfo().rescale.apply(s2);
                        float f5 = fArray[i3];
                        n12 = (int)((float)n12 + f5);
                        switch (Dynamic4DCTVolumeDeriver.this.getType()) {
                            case a: {
                                if (!(f4 > f3)) continue block9;
                                f3 = f4;
                                continue block9;
                            }
                            case d: {
                                if (!(f4 < f3)) continue block9;
                                f3 = f4;
                                continue block9;
                            }
                            case b: 
                            case e: {
                                f3 += f4;
                                continue block9;
                            }
                            case c: {
                                f3 += f4 * f5;
                            }
                        }
                    }
                    if (Dynamic4DCTVolumeDeriver.this.getType() == Create4DCTMIPCommand.MIPType.b || Dynamic4DCTVolumeDeriver.this.getType() == Create4DCTMIPCommand.MIPType.e) {
                        f3 /= (float)n6;
                    } else if (Dynamic4DCTVolumeDeriver.this.getType() == Create4DCTMIPCommand.MIPType.c) {
                        f3 /= (float)n12;
                    }
                    this.handleVoxel(f3, n10, n11, n4);
                }
                Dynamic4DCTVolumeDeriver.this.progress.N_();
            }
        }

        protected abstract void handleVoxel(float var1, int var2, int var3, int var4);
    }
}

