/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.atlas.management.AtlasDBManager;
import com.mimvista.dicom.gui.DicomSaveInputFactory;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ContrastState;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.ab;
import com.mimvista.internals.fusionmode.FusionMode;
import com.mimvista.internals.fusionmode.FusionModeNormalized;
import com.mimvista.internals.fusionmode.FusionModeSubAdd;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ak;
import com.mimvista.mui.az;
import com.mimvista.mui.bc;
import com.mimvista.mui.be;
import com.mimvista.mui.layout.g;
import com.mimvista.mui.y;
import com.mimvista.mui.z;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.numerics.VoxelIndexViewingPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.VoxelViewingPoint3f;
import com.mimvista.numerics.bk;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.preferencesNew.DicomsavePrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.viewer.Interpolator;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import javax.swing.JOptionPane;

public class FusionVolumeDeriver {
    public static Messages props = Messages.a("Dicom");
    protected s fusVS;
    protected DicomSaveInputFactory.FusionSaveType saveOption = DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY;
    private DicomSaveInputFactory.AlignedSecondaryResolutionOption rez = DicomSaveInputFactory.AlignedSecondaryResolutionOption.SECONDARY_RESOLUTION;
    private Progress progress = null;
    private ImageVolumeShort newVolume;
    private Interpolator.InterpolationType forcedInterpolation = null;
    private boolean cancellable = false;
    private ViewLoadState.a volumeFactory = new ViewLoadState.DefaultVolumeFactory();
    private int priFrmIndex = -1;
    private int secFrmIndex = -1;
    private boolean changeMetadata = true;

    public FusionVolumeDeriver(s s2) {
        this.fusVS = s2;
    }

    public void setVolumeFactory(ViewLoadState.a a2) {
        this.volumeFactory = a2;
    }

    public void setFusionSaveType(DicomSaveInputFactory.FusionSaveType fusionSaveType) {
        this.saveOption = fusionSaveType;
    }

    public void setPriFrmIndex(int n2) {
        this.priFrmIndex = n2;
    }

    public void setSecFrmIndex(int n2) {
        this.secFrmIndex = n2;
    }

    public void setCancellable(boolean bl2) {
        this.cancellable = bl2;
    }

    public void setForcedInterpolation(Interpolator.InterpolationType interpolationType) {
        this.forcedInterpolation = interpolationType;
    }

    public void setChangeMetadata(boolean bl2) {
        this.changeMetadata = bl2;
    }

    public void setAlignedSecondaryResolution(DicomSaveInputFactory.AlignedSecondaryResolutionOption alignedSecondaryResolutionOption) {
        this.rez = alignedSecondaryResolutionOption;
    }

    public ImageVolumeShort getOutputVolume() {
        this.output();
        return this.newVolume;
    }

    protected ImageVolumeShort getPriVol() {
        if (this.priFrmIndex == -1) {
            return this.fusVS.cw();
        }
        return (ImageVolumeShort)this.fusVS.cE().c(this.priFrmIndex);
    }

    protected ImageVolumeShort getSecVol() {
        if (this.secFrmIndex == -1) {
            return this.fusVS.W().cw();
        }
        return (ImageVolumeShort)this.fusVS.n().c(this.secFrmIndex);
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    protected void output() {
        try {
            if (this.saveOption == DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY && this.rez == null) {
                FuncUtils.f f2 = this.askUserForAlignedSecondaryResolution(this.fusVS);
                f2.a();
            }
            if (this.progress == null) {
                this.progress = new ProgressPanel();
                this.progress.c(this.cancellable);
                ProgressQueueNotification.a((ProgressPanel)this.progress);
            }
            this.writeMultiFileDICOM();
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
        }
        finally {
            if (this.progress != null) {
                this.progress.b();
            }
        }
    }

    private FuncUtils.f askUserForAlignedSecondaryResolution(s s2) {
        Object object;
        InputNotification inputNotification = new InputNotification(new Notification.a(this.fusVS), props.getProperty("DICOM_SAVE_FUSION_ALIGNED_SECONDARY"), "scale");
        final String[] stringArray = new String[DicomSaveInputFactory.AlignedSecondaryResolutionOption.values().length];
        String string = null;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2;
            stringArray[i2] = DicomSaveInputFactory.AlignedSecondaryResolutionOption.values()[i2].getExternalizedString();
            if (DicomSaveInputFactory.AlignedSecondaryResolutionOption.values()[i2] == DicomSaveInputFactory.AlignedSecondaryResolutionOption.PRIMARY_RESOLUTION) {
                object = s2.cw().a();
                string2 = "(" + object[PresentationType.a.a()[0]] + "x" + object[PresentationType.a.a()[1]] + ")";
                int n2 = i2;
                stringArray[n2] = stringArray[n2] + " " + string2;
                continue;
            }
            if (DicomSaveInputFactory.AlignedSecondaryResolutionOption.values()[i2] != DicomSaveInputFactory.AlignedSecondaryResolutionOption.SECONDARY_RESOLUTION) continue;
            object = s2.C().a();
            string2 = "(" + object[PresentationType.a.a()[0]] + "x" + object[PresentationType.a.a()[1]] + ")";
            int n3 = i2;
            stringArray[n3] = stringArray[n3] + " " + string2;
            string = stringArray[i2];
        }
        final l<String> l2 = inputNotification.addComboBox(props.getProperty("DICOM_SAVE_FUSION_ALIGNED_SECONDARY") + " " + props.getProperty("DICOM_SAVE_FUSION_ALIGNED_SECONDARY_RESOLUTION"), stringArray);
        if (string != null) {
            l2.a(string);
        }
        object = new FuncUtils.f();
        inputNotification.addOkListener(new ActionListener((FuncUtils.f)object){
            final /* synthetic */ FuncUtils.f val$eft;
            {
                this.val$eft = f2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (l2 != null) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (!stringArray[i2].equals(l2.b())) continue;
                        FusionVolumeDeriver.this.rez = DicomSaveInputFactory.AlignedSecondaryResolutionOption.values()[i2];
                        break;
                    }
                }
                this.val$eft.b();
            }
        });
        inputNotification.addCancelListener(new ActionListener((FuncUtils.f)object){
            final /* synthetic */ FuncUtils.f val$eft;
            {
                this.val$eft = f2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$eft.b();
            }
        });
        inputNotification.setDismissActionListener(new ActionListener((FuncUtils.f)object){
            final /* synthetic */ FuncUtils.f val$eft;
            {
                this.val$eft = f2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$eft.b();
            }
        });
        u.b().c(inputNotification);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMultiFileDICOM() {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            int[] nArray;
            Serializable serializable;
            Serializable serializable2;
            if (AtlasDBManager.d(this.fusVS)) {
                ay.b((Object)"Declined to derive from atlas subject.", this);
                return;
            }
            ImageVolumeShort imageVolumeShort = this.getPriVol();
            if (this.saveOption == DicomSaveInputFactory.FusionSaveType.COMPOSITE && !this.fusVS.b().mode.b()) {
                throw new RuntimeException("Cannot create composite unless fusion mode is addition or subtraction.");
            }
            if (this.saveOption == DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY) {
                int n2;
                serializable2 = this.getPriVol();
                serializable = this.getSecVol();
                nArray = ((SimpleImageVolume)serializable).a();
                object8 = ((SimpleImageVolume)serializable).b();
                object7 = ((SimpleImageVolume)serializable2).a();
                object6 = ((SimpleImageVolume)serializable2).b();
                object5 = new int[nArray.length];
                object4 = object8;
                if (this.rez == DicomSaveInputFactory.AlignedSecondaryResolutionOption.PRIMARY_RESOLUTION) {
                    object5 = ((SimpleImageVolume)serializable2).a();
                    object4 = object6;
                } else if (this.rez == DicomSaveInputFactory.AlignedSecondaryResolutionOption.SECONDARY_RESOLUTION) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        object5[n2] = nArray[n2];
                        object4[n2] = object6[n2] * ((float)object7[n2] / (float)nArray[n2]);
                    }
                    object5[2] = object7[2];
                    object4[2] = object6[2];
                } else {
                    switch (this.rez) {
                        case AT_512x512: {
                            object5[0] = 512;
                            object5[1] = 512;
                            break;
                        }
                        case AT_256x256: {
                            object5[0] = 256;
                            object5[1] = 256;
                            break;
                        }
                        case AT_128x128: {
                            object5[0] = 128;
                            object5[1] = 128;
                        }
                    }
                    for (n2 = 0; n2 < 2; ++n2) {
                        object4[n2] = object6[n2] * ((float)object7[n2] / (float)object5[n2]);
                    }
                    object5[2] = object7[2];
                    object4[2] = object6[2];
                }
                object3 = new DicomPoint3f(((SimpleImageVolume)serializable).G(), (SimpleImageFrame)serializable);
                object2 = this.fusVS.aG().b((ImageFrame)serializable2, (ImageFrame)serializable, true).a(((DicomPoint3f)((Object)object3)).c()).b((SimpleImageFrame)serializable);
                object = this.volumeFactory.a();
                object.a((int[])object5);
                object.a((float[])object4);
                object.b(((SimpleImageVolume)serializable).getUncopiedMutableInfo());
                object.b(object2.f());
                imageVolumeShort = object;
            }
            if (this.changeMetadata) {
                serializable2 = SeriesInfo.a(imageVolumeShort.getUncopiedMutableInfo());
                ((SeriesInfo)serializable2).frameOfRefUID = this.fusVS.getUncopiedMutableInfo().frameOfRefUID;
            } else {
                serializable2 = imageVolumeShort.getUncopiedMutableInfo().m();
            }
            serializable = this.fusVS.b();
            nArray = this.fusVS.ay();
            object8 = (Object)new VoxelIndexPoint3i(nArray[0], nArray[1], nArray[2], new Point3f.PointVolumeInfo(this.fusVS.cw()));
            ((ViewStateNew.FusionViewStateNew)serializable).visibleExtent = (VoxelIndexPoint3i)((Object)object8);
            object7 = (Object)new VoxelIndexPoint3f(0.0f, 0.0f, 0.0f, new Point3f.PointVolumeInfo(this.fusVS.cw()));
            ((ViewStateNew.FusionViewStateNew)serializable).visibleOffset = (VoxelIndexPoint3f)((Object)object7);
            if (this.priFrmIndex != -1) {
                ((ViewStateNew.FusionViewStateNew)serializable).currentFrame = this.priFrmIndex;
            }
            if (this.secFrmIndex != -1) {
                ((ViewStateNew.FusionViewStateNew)serializable).secFrame = this.secFrmIndex;
            }
            ((ViewStateNew.FusionViewStateNew)serializable).zoomEqualized = false;
            object6 = ((ViewStateNew.FusionViewStateNew)serializable).frameStates.iterator();
            while (object6.hasNext()) {
                object5 = (ViewStateNew.FrameState)object6.next();
                object4 = PresentationType.o().iterator();
                while (object4.hasNext()) {
                    object3 = (PresentationType)object4.next();
                    ((ViewStateNew.FrameState)object5).zoomLevels.put((PresentationType)object3, Float.valueOf(1.0f));
                }
            }
            ((ViewStateNew.FusionViewStateNew)serializable).rotationMatrix = MatrixMultiplier.b();
            object6 = PresentationType.o().iterator();
            while (object6.hasNext()) {
                object5 = (PresentationType)object6.next();
                ((ViewStateNew)serializable).a((float[])null, new EditTargetInfo(((ViewStateNew.FusionViewStateNew)serializable).currentFrame, (PresentationType)object5, true));
            }
            ((SeriesInfo)serializable2).imageOrientation = ab.e((ViewStateNew)serializable);
            ((SeriesInfo)serializable2).origImageOrientation = this.fusVS.cw().getUncopiedMutableInfo().origImageOrientation;
            if (this.changeMetadata && (this.saveOption != DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY || !DicomsavePrefs.alignedSecondaryKeepsStudyUid.getValue().booleanValue())) {
                ((SeriesInfo)serializable2).studyUID = this.fusVS.cw().getUncopiedMutableInfo().studyUID;
            }
            object6 = this.fusVS.ae();
            if (this.saveOption == DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY) {
                if (this.changeMetadata) {
                    object5 = this.fusVS.cw().getUncopiedMutableInfo();
                    object4 = this.fusVS.C().getUncopiedMutableInfo();
                    ((SeriesInfo)serializable2).seriesDesc = FusionVolumeDeriver.makeAlignedSecondarySeriesDescription((SeriesInfo)object5, (SeriesInfo)object4);
                    ((SeriesInfo)serializable2).origPatientPosition = DcmSecondaryCapturePrefs.usePrimaryPatientPosition.getValue().booleanValue() ? ((SeriesInfo)object5).origPatientPosition : ((SeriesInfo)object4).origPatientPosition;
                }
            } else {
                if (this.changeMetadata) {
                    ((SeriesInfo)serializable2).seriesDesc = ((FusionMode)object6).getExternalizedString() + ": " + ((SeriesInfo)serializable2).seriesDesc;
                }
                object5 = this.fusVS.v();
                ((SeriesInfo)serializable2).rescale.slope = ((ContrastState)object5).z();
                ((SeriesInfo)serializable2).rescale.intercept = ((ContrastState)object5).y();
                ((SeriesInfo)serializable2).rescale.unitScale = ((ContrastState)object5).C();
                object4 = ((SeriesInfo)serializable2).u();
                if (object6 instanceof FusionModeSubAdd) {
                    object3 = (FusionModeSubAdd)object6;
                    if (!((FusionModeSubAdd)object3).l() && ((FusionModeSubAdd)object3).m()) {
                        ((SeriesInfo)serializable2).modality = "PT";
                        ((SeriesInfo)serializable2).rescale.slope = 0.1f;
                        ((UnitHelper)object4).a("PCNT");
                        if (((SeriesInfo)serializable2).modInfo == null) {
                            ((SeriesInfo)serializable2).modInfo = new PTSeriesInfo();
                        }
                        if (((SeriesInfo)serializable2).modInfo instanceof PTSeriesInfo) {
                            ((PTSeriesInfo)((SeriesInfo)serializable2).modInfo).origUnits = "PCNT";
                        }
                        ((UnitHelper)object4).a("PCNT");
                    } else {
                        object2 = ((UnitHelper)object4).z();
                        if (((SeriesInfo)serializable2).modInfo instanceof PTSeriesInfo) {
                            ((PTSeriesInfo)((SeriesInfo)serializable2).modInfo).origUnits = object2;
                        }
                        ((UnitHelper)object4).a((String)object2);
                    }
                }
                if (object6 instanceof FusionModeNormalized) {
                    ((SeriesInfo)serializable2).modality = "PT";
                    ((UnitHelper)object4).a("PCNT");
                    if (((SeriesInfo)serializable2).modInfo == null) {
                        ((SeriesInfo)serializable2).modInfo = new PTSeriesInfo();
                    }
                    if (((SeriesInfo)serializable2).modInfo instanceof PTSeriesInfo) {
                        ((PTSeriesInfo)((SeriesInfo)serializable2).modInfo).origUnits = "PCNT";
                    }
                }
            }
            ((SeriesInfo)serializable2).scalingFactorFromOriginal = Math.round(1.0f / ((SeriesInfo)serializable2).rescale.slope);
            this.newVolume = this.volumeFactory.a();
            this.newVolume.b(imageVolumeShort.Z());
            this.newVolume.a(imageVolumeShort.a());
            this.newVolume.a(imageVolumeShort.b());
            this.newVolume.b(this.fusVS.cw().G());
            this.newVolume.a(MatrixMultiplier.b());
            this.newVolume.b((SeriesInfo)serializable2);
            ((SimpleImageVolume)this.newVolume).a(SliceInfo.a(this.fusVS.cw().ab()));
            if (this.saveOption == DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY) {
                this.newVolume.a(this.getSecVol(), this.getPriVol(), true);
            } else {
                this.newVolume.a((SimpleImageFrame)null, true);
            }
            object5 = new Rectangle(0, 0, imageVolumeShort.a()[0], imageVolumeShort.a()[1]);
            object4 = (y)az.a(new g((Rectangle)object5, PresentationType.a, this.fusVS));
            int n3 = imageVolumeShort.a()[2];
            this.progress.a(n3);
            this.progress.a();
            for (int i2 = 0; i2 < n3; ++i2) {
                Object object9;
                bc bc2;
                Object object10;
                if (this.progress.n() == Progress.Status.e) {
                    this.newVolume = null;
                    return;
                }
                object = new VoxelIndexViewingPoint3f(0.0f, 0.0f, (float)i2, this.getPriVol()).a(((ViewStateNew.FusionViewStateNew)serializable).rotationMatrix);
                short[] sArray = null;
                ((ViewStateNew.FusionViewStateNew)serializable).metricCoords = object;
                if (this.saveOption == DicomSaveInputFactory.FusionSaveType.ALIGNED_SECONDARY) {
                    object10 = ((y)object4).a((ViewStateNew.FusionViewStateNew)serializable);
                    bc2 = object10.get(1);
                    bc2.a(true);
                    this.fixCorners(bc2.g, (ViewStateNew.FusionViewStateNew)serializable, imageVolumeShort.a(), this.getPriVol().a());
                    object9 = ((y)object4).a(Lists.newArrayList((Object[])new bc[]{bc2})).get(0);
                    sArray = (short[])((ImageSlice.ImageSliceShort)((az.b)object9).a).data;
                } else if (this.saveOption == DicomSaveInputFactory.FusionSaveType.COMPOSITE) {
                    object10 = ((y)object4).b((ViewStateNew)serializable);
                    bc2 = ((y)object4).a((z)object10, (ViewStateNew.FusionViewStateNew)serializable);
                    if (this.forcedInterpolation != null) {
                        ((bc)object10).a(this.forcedInterpolation);
                        bc2.a(this.forcedInterpolation);
                    }
                    this.fixVpCorners(((z)object10).g, this.getPriVol().a());
                    this.fixCorners(((z)bc2).g, (ViewStateNew.FusionViewStateNew)serializable, this.getPriVol().a(), this.getPriVol().a());
                    object9 = ((y)object4).a((ViewStateNew.FusionViewStateNew)serializable, (z)object10, (z)bc2);
                    ImageSlice.ImageSliceShort imageSliceShort = (ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)this.getPriVol().ad()).f(i2);
                    ImageSlice.ImageSliceShort imageSliceShort2 = new be.l().a((ImageSlice.ImageSliceShort)null, bc2);
                    if (((FusionMode)object6).j()) {
                        FusionMode.a(FusionMode.a((z)object10), ((bc)object10).u().e(), imageSliceShort, bc2.u().e(), imageSliceShort2, (ImageSlice.ImageSliceShort)object9);
                    }
                    sArray = (short[])((ImageSlice.ImageSliceShort)object9).data;
                }
                this.progress.b_("Deriving slice " + String.valueOf(i2 + 1));
                this.progress.N_();
                ((ImageCube.ImageCubeShort)this.newVolume.ad()).a(sArray);
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
            JOptionPane.showMessageDialog(ak.b().O(), props.getProperty("FUSION_VOLUME_SAVE_FAIL"), props.getProperty("FUSION_VOLUME_ERROR"), 0);
        }
        finally {
            this.progress.b();
        }
    }

    public static String makeAlignedSecondarySeriesDescription(SeriesInfo seriesInfo, SeriesInfo seriesInfo2) {
        String string = "";
        if (seriesInfo.studyTime != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
            string = simpleDateFormat.format(seriesInfo.studyTime);
        }
        return "Aligned " + seriesInfo.modality + " " + seriesInfo.N() + " " + string + ", " + seriesInfo2.seriesDesc;
    }

    private void fixCorners(bk bk2, ViewStateNew.FusionViewStateNew fusionViewStateNew, int[] nArray, int[] nArray2) {
        if (bk2 == null) {
            return;
        }
        this.fixVpCorners(bk2, nArray);
        MetricPoint3f metricPoint3f = new VoxelViewingPoint3f(0.0f, 0.0f, 0.0f, fusionViewStateNew.w()).a(fusionViewStateNew.rotationMatrix);
        VoxelPoint3f voxelPoint3f = metricPoint3f.a(fusionViewStateNew.q().C());
        MetricPoint3f metricPoint3f2 = new VoxelViewingPoint3f((float)nArray2[0], (float)nArray2[1], 0.0f, fusionViewStateNew.w()).a(fusionViewStateNew.rotationMatrix);
        VoxelPoint3f voxelPoint3f2 = metricPoint3f2.a(fusionViewStateNew.q().C());
        bk2.a().a.x = voxelPoint3f.x;
        bk2.a().a.y = voxelPoint3f.y;
        bk2.b().a.x = voxelPoint3f.x;
        bk2.b().a.y = voxelPoint3f2.y;
        bk2.c().a.x = voxelPoint3f2.x;
        bk2.c().a.y = voxelPoint3f.y;
        bk2.d().a.x = voxelPoint3f2.x;
        bk2.d().a.y = voxelPoint3f2.y;
    }

    private void fixVpCorners(bk bk2, int[] nArray) {
        if (bk2 == null) {
            return;
        }
        bk2.a().b.x = 0;
        bk2.a().b.y = 0;
        bk2.b().b.x = 0;
        bk2.b().b.y = nArray[1];
        bk2.c().b.x = nArray[0];
        bk2.c().b.y = 0;
        bk2.d().b.x = nArray[0];
        bk2.d().b.y = nArray[1];
    }
}

