/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.d;
import com.mimvista.dicom.write.DcmSecondaryCaptureWriter;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.VolumetricRendering;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.GridPresentation;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.az;
import com.mimvista.mui.bm;
import com.mimvista.mui.bw;
import com.mimvista.mui.captures.Capture;
import com.mimvista.mui.captures.StudyDemographicsPrepender;
import com.mimvista.mui.findings.OverlayFindingElement;
import com.mimvista.mui.layout.HangingInfo;
import com.mimvista.mui.layout.HangingProtocol;
import com.mimvista.mui.layout.f;
import com.mimvista.mui.mouse.mode.an;
import com.mimvista.mui.mouse.mode.suv.b;
import com.mimvista.mui.overlays.LabelDrawer;
import com.mimvista.mui.overlays.findings.FindingsOverlay;
import com.mimvista.mui.presenters.ProtocolPage;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.mui.presenters.ViewPortUtilities;
import com.mimvista.mui.presenters.display.p;
import com.mimvista.mui.presenters.protocol.UberProtocolEdit;
import com.mimvista.mui.presenters.protocol.a;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.preferencesNew.CapturePrefs;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.progress.g;
import com.mimvista.util.state.StateManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.JComponent;
import javax.swing.event.UndoableEditEvent;
import javax.vecmath.Tuple3f;

public class ImageCapturer {
    public static int getPreferredCaptureSize() {
        return DcmSecondaryCapturePrefs.volumeCaptureSize.getValue();
    }

    public static String getSliceOfCapture(SimpleImageVolume<?> simpleImageVolume, MetricPoint3f metricPoint3f, az az2) {
        String string = "";
        if (metricPoint3f != null) {
            Pair<SliceInfo, Float> pair = SimpleImageVolume.a(simpleImageVolume, metricPoint3f.d());
            if (az2.U() == PresentationType.a && pair != null) {
                SliceInfo sliceInfo = (SliceInfo)pair.x;
                if (sliceInfo != null) {
                    string = Messages.a("Modes", "SLICE") + " " + sliceInfo.sliceNumber;
                }
            } else {
                LabelDrawer labelDrawer = new LabelDrawer(az2);
                string = LabelDrawer.b(labelDrawer.s(), labelDrawer.t());
            }
        }
        return string;
    }

    public static Capture captureViewPortsWith(FindingsOverlay<?, ?> findingsOverlay, @d ViewController viewController) {
        ViewStateNew viewStateNew;
        OverlayFindingElement overlayFindingElement;
        if (viewController == null) {
            viewController = findingsOverlay.au();
        }
        BufferedImage bufferedImage = null;
        String string = findingsOverlay.bI_();
        boolean bl2 = DcmSecondaryCapturePrefs.volumeCaptureUseDemographics.getValue();
        List<PresentationType> list = findingsOverlay.S();
        while (list.remove(PresentationType.d)) {
        }
        if (bl2) {
            list.add(PresentationType.d);
        }
        ArrayList arrayList = Lists.newArrayList((Object[])new ViewPortUtilities.CapturePrevent[]{ViewPortUtilities.CapturePrevent.a, ViewPortUtilities.CapturePrevent.g});
        Dimension dimension = ImageCapturer.computeDimsForFindingsCapture(list, viewController);
        if (dimension == null || dimension.height == 0 || dimension.width == 0) {
            return null;
        }
        ViewController viewController2 = viewController;
        if (findingsOverlay.aU() != null && (overlayFindingElement = findingsOverlay.aU().c(findingsOverlay)) != null && (viewStateNew = overlayFindingElement.g()) != null) {
            viewController2 = viewController.aQ();
            ViewStateNew viewStateNew2 = viewController2.ap();
            MetricPoint3f metricPoint3f = viewStateNew2.metricCoords;
            viewStateNew2.b(viewStateNew);
            viewController2.a(viewStateNew2);
            Rectangle rectangle = new Rectangle(dimension);
            for (PresentationType presentationType : list) {
                if (viewStateNew2.metricCoords.equals((Tuple3f)metricPoint3f) || viewController2.c(new EditTargetInfo(viewController.cl(), presentationType, true)) == 1.0f) continue;
                bw.a(viewController2, viewStateNew2.metricCoords, presentationType, rectangle, false);
            }
        }
        bufferedImage = ViewPortUtilities.a(viewController2, list, dimension, (List<ViewPortUtilities.CapturePrevent>)arrayList, true, false);
        if (viewController2 != viewController) {
            viewController2.ac();
        }
        return new Capture(bufferedImage, string, bl2, Lists.newArrayList((Object[])new ViewController[]{viewController}));
    }

    private static Dimension computeDimsForFindingsCapture(List<PresentationType> list, ViewController viewController) {
        HashSet hashSet;
        Dimension dimension;
        HashSet hashSet2 = null;
        a a2 = viewController.g().ac();
        if (a2 != null) {
            hashSet2 = Sets.newHashSet(a2.e());
        }
        if (ImageCapturer.areDimsOK(dimension = ImageCapturer.getCapturesDims(list, hashSet2, hashSet = Sets.newHashSet(p.f(viewController))))) {
            return dimension;
        }
        HashSet hashSet3 = Sets.newHashSet(p.j(viewController));
        dimension = ImageCapturer.getCapturesDims(list, hashSet2, hashSet3);
        if (ImageCapturer.areDimsOK(dimension)) {
            return dimension;
        }
        HashSet hashSet4 = Sets.newHashSet(p.k(viewController));
        dimension = ImageCapturer.getCapturesDims(list, hashSet2, hashSet4);
        if (ImageCapturer.areDimsOK(dimension)) {
            return dimension;
        }
        int n2 = ImageCapturer.getPreferredCaptureSize();
        return new Dimension(n2, n2);
    }

    private static Dimension getCapturesDims(List<PresentationType> list, @d Set<ViewController> set, Set<? extends ViewController> set2) {
        Dimension dimension;
        Sets.SetView setView;
        if (set != null && !(setView = Sets.intersection(set, set2)).isEmpty() && ImageCapturer.areDimsOK(dimension = ImageCapturer.getMaxDim(list, (Iterable<? extends ViewController>)setView))) {
            return dimension;
        }
        return ImageCapturer.getMaxDim(list, set2);
    }

    private static boolean areDimsOK(Dimension dimension) {
        return dimension != null && dimension.width > 0 && dimension.height > 0;
    }

    private static Dimension getMaxDim(List<PresentationType> list, Iterable<? extends ViewController> iterable) {
        int n2 = 0;
        int n3 = 0;
        for (ViewController viewController : iterable) {
            Dimension dimension = ImageCapturer.computeDims(list, viewController);
            if (dimension == null) continue;
            n2 = Math.max(n2, dimension.width);
            n3 = Math.max(n3, dimension.height);
        }
        return new Dimension(n2, n3);
    }

    private static Dimension computeDims(List<PresentationType> list, ViewController viewController) {
        int n2 = 0;
        int n3 = 0;
        Map<PresentationType, List<ViewPort>> map = viewController.a(Lists.newArrayList((Object[])new a[]{viewController.bW()}));
        for (PresentationType presentationType : list) {
            List<ViewPort> list2 = map.get(presentationType);
            if (list2.size() == 0) continue;
            ViewPort viewPort = list2.get(0);
            if (viewPort.getBounds().width > n2) {
                n2 = viewPort.getBounds().width;
            }
            if (viewPort.getBounds().height <= n3) continue;
            n3 = viewPort.getBounds().height;
        }
        return new Dimension(n2, n3);
    }

    public static Capture capturePageWith(FindingsOverlay findingsOverlay) {
        Object object;
        a a2 = findingsOverlay.aD().ac();
        HashSet hashSet = Sets.newHashSet(p.f(findingsOverlay.au()));
        if (a2 != null && !Sets.intersection((Set)hashSet, (Set)(object = Sets.newHashSet(a2.e()))).isEmpty()) {
            return ImageCapturer.captureGivenPage(a2);
        }
        for (a a3 : findingsOverlay.aD().s()) {
            HashSet hashSet2 = Sets.newHashSet(a3.e());
            if (Sets.intersection((Set)hashSet, (Set)hashSet2).isEmpty()) continue;
            return ImageCapturer.captureGivenPage(a3);
        }
        return null;
    }

    public static List<BufferedImage> getImages(DcmSecondaryCaptureWriter.CaptureType captureType, @d ViewController viewController, @d ViewPort viewPort, @d PresentationType presentationType, boolean bl2, @d int[] nArray, @d g g2) {
        return ImageCapturer.getImages(captureType, viewController, viewPort, presentationType, bl2, nArray, -1.0f, g2, -1);
    }

    public static List<BufferedImage> getImages(DcmSecondaryCaptureWriter.CaptureType captureType, @d ViewController viewController, @d ViewPort viewPort, @d PresentationType presentationType, boolean bl2, @d int[] nArray, float f2, @d g g2, int n2) {
        ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
        boolean bl3 = DcmSecondaryCapturePrefs.captureInvertColors.getValue();
        if (captureType == DcmSecondaryCaptureWriter.CaptureType.PAGE || captureType == DcmSecondaryCaptureWriter.CaptureType.PAGE_WITH_SIDE) {
            a a2 = bm.b().ac();
            boolean bl4 = captureType == DcmSecondaryCaptureWriter.CaptureType.PAGE_WITH_SIDE;
            BufferedImage bufferedImage = null;
            if (n2 > -1) {
                bufferedImage = ImageCapturer.captureGivenPage(a2, n2, bl4, bl2).e();
            } else if (viewController != null) {
                bufferedImage = ImageCapturer.capturePageOfViewController(viewController, bl4).e();
            } else if (viewPort != null) {
                bufferedImage = ImageCapturer.capturePageOfViewController(viewPort.M(), bl4).e();
            } else {
                ay.d((Object)"Not enough information to make capture", ImageCapturer.class);
            }
            if (bufferedImage != null) {
                arrayList.add(bufferedImage);
            }
        } else if (captureType == DcmSecondaryCaptureWriter.CaptureType.VIEWPORT && viewPort != null) {
            arrayList.add(ImageCapturer.captureViewPort(viewPort).e());
        } else if (captureType == DcmSecondaryCaptureWriter.CaptureType.VIEWPORT && viewPort == null && viewController != null) {
            int n3 = ImageCapturer.getPreferredCaptureSize();
            int n4 = DcmSecondaryCapturePrefs.volumeCaptureThumbSize.getValue();
            ArrayList<ViewPortUtilities.CapturePrevent> arrayList2 = new ArrayList<ViewPortUtilities.CapturePrevent>();
            arrayList2.add(ViewPortUtilities.CapturePrevent.a);
            arrayList2.add(ViewPortUtilities.CapturePrevent.g);
            if (Float.compare(f2, 0.0f) <= 0) {
                f2 = viewController.ao_()[presentationType.a()[2]];
            }
            ArrayList<BufferedImage> arrayList3 = ViewPortUtilities.a(viewController, presentationType, bl2, n3, n4, arrayList2, nArray, f2, g2);
            arrayList.addAll(arrayList3);
        } else if (captureType == DcmSecondaryCaptureWriter.CaptureType.SERIES && viewPort != null) {
            Rectangle rectangle = viewPort.getBounds();
            ViewController viewController2 = viewPort.M();
            ArrayList<PresentationType> arrayList4 = new ArrayList<PresentationType>();
            if (!viewController2.is2D()) {
                arrayList4.add(PresentationType.a);
                arrayList4.add(PresentationType.b);
                arrayList4.add(PresentationType.c);
                for (ViewPort viewPort2 : viewController2.aZ()) {
                    if (viewPort2.N() != PresentationType.f) continue;
                    arrayList4.add(PresentationType.f);
                    break;
                }
            } else {
                arrayList4.add(PresentationType.g);
            }
            if (!arrayList4.contains(PresentationType.d) && bl2) {
                arrayList4.add(PresentationType.d);
            }
            BufferedImage bufferedImage = ViewPortUtilities.a(viewController2, arrayList4, rectangle.getSize(), null, bl3, false);
            arrayList.add(bufferedImage);
        }
        return arrayList;
    }

    public static Capture captureSeries(ViewController viewController) {
        int n2 = ImageCapturer.getPreferredCaptureSize();
        Dimension dimension = new Dimension(n2, n2);
        ArrayList arrayList = Lists.newArrayList((Object[])new PresentationType[]{PresentationType.a, PresentationType.b, PresentationType.c});
        a a2 = viewController.bW();
        if (a2 != null && a2.b(viewController) || viewController instanceof ViewController3D && ((ViewController3D)viewController).b(VolumetricRendering.RenderingType.a)) {
            arrayList.add(PresentationType.f);
        }
        if (DcmSecondaryCapturePrefs.volumeCaptureUseDemographics.getValue().booleanValue()) {
            arrayList.add(PresentationType.d);
        }
        BufferedImage bufferedImage = ViewPortUtilities.a(viewController, (List<PresentationType>)arrayList, dimension, new ArrayList<ViewPortUtilities.CapturePrevent>(), true, false);
        String string = com.mimvista.mui.info.d.a(viewController);
        String string2 = MIMFormat.a(Messages.a("Commands", "SERIES_CAP_DEFAULT"), string);
        return new Capture(bufferedImage, string2, true, Lists.newArrayList((Object[])new ViewController[]{viewController}));
    }

    public static Capture captureViewPorts(ViewController viewController, List<PresentationType> list, boolean bl2, boolean bl3) {
        ArrayList arrayList = Lists.newArrayList();
        for (PresentationType presentationType : list) {
            arrayList.add(viewController);
        }
        return ImageCapturer.captureViewPorts((List<ViewController>)arrayList, list, bl2, bl3);
    }

    public static Capture captureViewPorts(ViewController viewController, List<PresentationType> list, boolean bl2, List<ViewPortUtilities.CapturePrevent> list2) {
        ArrayList arrayList = Lists.newArrayList();
        for (PresentationType presentationType : list) {
            arrayList.add(viewController);
        }
        return ImageCapturer.captureViewPorts((List<ViewController>)arrayList, list, bl2, list2);
    }

    public static Capture captureViewPorts(List<ViewController> list, List<PresentationType> list2, boolean bl2, List<ViewPortUtilities.CapturePrevent> list3) {
        int n2 = ImageCapturer.getPreferredCaptureSize();
        Dimension dimension = new Dimension(n2, n2);
        Rectangle rectangle = new Rectangle(dimension);
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            az az2 = az.a(new com.mimvista.mui.layout.g(rectangle, list2.get(i2), list.get(i2)));
            if (bl2) {
                an.a(az2, false);
            }
            arrayList.add(az2);
        }
        return ImageCapturer.makeViewPortCapture((List<az>)arrayList, dimension, list3);
    }

    public static Capture captureViewPorts(List<ViewController> list, List<PresentationType> list2, boolean bl2, boolean bl3) {
        int n2 = ImageCapturer.getPreferredCaptureSize();
        Dimension dimension = new Dimension(n2, n2);
        Rectangle rectangle = new Rectangle(dimension);
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            az az2 = az.a(new com.mimvista.mui.layout.g(rectangle, list2.get(i2), list.get(i2)));
            if (bl2) {
                an.a(az2, false);
            }
            arrayList.add(az2);
        }
        return ImageCapturer.makeViewPortCapture((List<az>)arrayList, dimension, bl3);
    }

    public static Capture captureViewable(f f2) {
        if (f2 instanceof ViewPort) {
            ViewPort viewPort = (ViewPort)f2;
            return ImageCapturer.captureViewPort(viewPort.M(), viewPort.N(), false);
        }
        return ImageCapturer.captureNonViewportPageViewable(f2);
    }

    public static Capture captureViewPort(ViewController viewController, PresentationType presentationType, boolean bl2) {
        int n2 = ImageCapturer.getPreferredCaptureSize();
        Dimension dimension = new Dimension(n2, n2);
        if (viewController.bg()) {
            dimension = new Dimension(viewController.ay()[0], viewController.ay()[1]);
        }
        Rectangle rectangle = new Rectangle(dimension);
        az az2 = az.a(new com.mimvista.mui.layout.g(rectangle, presentationType, viewController));
        if (bl2) {
            an.a(az2, false);
        }
        return ImageCapturer.makeViewPortCapture(null, az2, dimension, new ArrayList<ViewPortUtilities.CapturePrevent>());
    }

    private static Capture captureNonViewportPageViewable(final f f2) {
        FutureTask<BufferedImage> futureTask = new FutureTask<BufferedImage>(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                BufferedImage bufferedImage = new BufferedImage(ImageCapturer.getPreferredCaptureSize(), ImageCapturer.getPreferredCaptureSize(), 6);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                Component component = f2.l();
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty("CurrentlyCapturing", "true");
                }
                Rectangle rectangle = component.getBounds();
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.setSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
                component.setBounds(rectangle2);
                component.invalidate();
                component.validate();
                f2.a(graphics2D);
                component.setBounds(rectangle);
                component.invalidate();
                component.validate();
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty("CurrentlyCapturing", null);
                }
                graphics2D.dispose();
                return bufferedImage;
            }
        });
        MIMSwingUtils.c(futureTask);
        try {
            return new Capture(futureTask.get(), f2.p(), false, f2.n());
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, ImageCapturer.class);
            return null;
        }
    }

    public static Capture captureViewPort(ViewPort viewPort) {
        return ImageCapturer.captureViewPort(viewPort, false);
    }

    public static Capture captureViewPort(ViewPort viewPort, boolean bl2) {
        return ImageCapturer.captureViewPort(viewPort, bl2, false);
    }

    private static Capture captureViewPort(ViewPort viewPort, boolean bl2, boolean bl3) {
        ArrayList arrayList = Lists.newArrayList();
        if (bl2) {
            arrayList.add(ViewPortUtilities.CapturePrevent.i);
        }
        return ImageCapturer.captureViewPort(viewPort, arrayList, bl3);
    }

    private static Capture captureViewPort(ViewPort viewPort, List<ViewPortUtilities.CapturePrevent> list, boolean bl2) {
        Rectangle rectangle = viewPort.getBounds();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        if (bl2) {
            return ImageCapturer.makeViewPortCapture(viewPort, viewPort.L(), dimension, list, false);
        }
        return ImageCapturer.makeViewPortCapture(viewPort, viewPort.L(), dimension, list);
    }

    private static Capture makeViewPortCapture(@d ViewPort viewPort, az az2, Dimension dimension, List<ViewPortUtilities.CapturePrevent> list) {
        return ImageCapturer.makeViewPortCapture(viewPort, az2, dimension, list, DcmSecondaryCapturePrefs.volumeCaptureUseDemographics.getValue());
    }

    private static Capture makeViewPortCapture(@d ViewPort viewPort, az az2, Dimension dimension, List<ViewPortUtilities.CapturePrevent> list, boolean bl2) {
        String string;
        PresentationType presentationType = az2.U();
        ViewController viewController = az2.n();
        ArrayList arrayList = Lists.newArrayList((Object[])new PresentationType[]{presentationType});
        if (bl2) {
            arrayList.add(PresentationType.d);
        }
        ArrayList arrayList2 = Lists.newArrayList((Object[])new ViewPortUtilities.CapturePrevent[]{ViewPortUtilities.CapturePrevent.a, ViewPortUtilities.CapturePrevent.g, ViewPortUtilities.CapturePrevent.h});
        arrayList2.addAll(list);
        HashMap hashMap = null;
        if (viewPort != null) {
            hashMap = Maps.newHashMap();
            hashMap.put(presentationType, viewPort);
        }
        BufferedImage bufferedImage = ViewPortUtilities.a(viewController, arrayList, dimension, arrayList2, true, false, hashMap);
        String string2 = presentationType.a(viewController.aP()) + " " + viewController.getModality();
        ImageFrame imageFrame = viewController.aw();
        if (imageFrame instanceof SimpleImageVolume && !(az2 instanceof GridPresentation) && (string = ImageCapturer.getSliceOfCapture((SimpleImageVolume)((Object)imageFrame), viewController.bc(), az2)) != null) {
            string2 = string2 + " " + string;
        }
        return new Capture(bufferedImage, string2, bl2, Lists.newArrayList((Object[])new ViewController[]{viewController}));
    }

    private static Capture makeViewPortCapture(List<az> list, Dimension dimension, List<ViewPortUtilities.CapturePrevent> list2) {
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        for (az object2 : list) {
            arrayList.add(object2.U());
            arrayList2.add(object2.n());
        }
        boolean bl2 = DcmSecondaryCapturePrefs.volumeCaptureUseDemographics.getValue();
        if (bl2) {
            arrayList.add(PresentationType.d);
            arrayList2.add(arrayList2.get(0));
        }
        BufferedImage bufferedImage = ViewPortUtilities.a(arrayList2, (List<PresentationType>)arrayList, dimension, list2, true, false);
        String string = (arrayList.size() == 2 ? arrayList.get(0) + " " : "") + ((ViewController)arrayList2.get(0)).getModality() + " ";
        return new Capture(bufferedImage, string, bl2, arrayList2);
    }

    private static Capture makeViewPortCapture(List<az> list, Dimension dimension, boolean bl2) {
        ArrayList arrayList = Lists.newArrayList((Object[])new ViewPortUtilities.CapturePrevent[]{ViewPortUtilities.CapturePrevent.a, ViewPortUtilities.CapturePrevent.g, ViewPortUtilities.CapturePrevent.h});
        if (bl2) {
            arrayList.add(ViewPortUtilities.CapturePrevent.i);
        }
        return ImageCapturer.makeViewPortCapture(list, dimension, arrayList);
    }

    public static Capture captureCurrentPage() {
        return ImageCapturer.captureCurrentPage(-1, DcmSecondaryCapturePrefs.sidePanel.getValue());
    }

    public static Capture captureCurrentPage(int n2, boolean bl2) {
        return ImageCapturer.captureGivenPage(bm.b().ac(), n2, bl2, true);
    }

    public static Capture captureGivenPage(a a2) {
        return ImageCapturer.captureGivenPage(a2, -1, DcmSecondaryCapturePrefs.sidePanel.getValue(), true);
    }

    public static Capture captureGivenPage(ProtocolPage protocolPage) {
        return ImageCapturer.captureGivenPage(protocolPage.k(), protocolPage.f(), DcmSecondaryCapturePrefs.sidePanel.getValue(), true);
    }

    public static Capture captureGivenPage(a a2, int n2, boolean bl2, boolean bl3) {
        Object object;
        boolean bl4 = b.i();
        InterfacePrefs.showSuvTip.setValue(false);
        UberProtocolEdit uberProtocolEdit = null;
        if (!bl3) {
            object = a2.d();
            ImageCapturer.removeAllInfoPorts((HangingProtocol)object, n2);
            uberProtocolEdit = new UberProtocolEdit(a2, (HangingProtocol)object);
            bm.b().r().undoableEditHappened(new UndoableEditEvent(a2, uberProtocolEdit));
        }
        a2.r();
        object = null;
        if (n2 == -1) {
            for (Integer object2 : bm.b().ac().m()) {
                object = bm.b().ac().a(object2);
            }
        } else {
            object = a2.a(n2);
        }
        if (object == null) {
            return null;
        }
        Capture capture = ImageCapturer.getImageOfPage((ProtocolPage)object, bl2);
        InterfacePrefs.showSuvTip.setValue(bl4);
        if (uberProtocolEdit != null) {
            uberProtocolEdit.undo();
            StateManager.c c2 = new StateManager.c();
            c2.a((ProtocolPage)object);
        }
        return capture;
    }

    private static void removeAllInfoPorts(HangingProtocol hangingProtocol, int n2) {
        for (HangingInfo hangingInfo : hangingProtocol.d(n2)) {
            if (PresentationType.d != hangingInfo.type) continue;
            hangingInfo.seriesInfo.viewPortInfo.remove(hangingInfo);
        }
    }

    public static Capture capturePageOfViewController(ViewController viewController, boolean bl2) {
        for (ProtocolPage protocolPage : bm.b().ac().n()) {
            if (!protocolPage.i().contains(viewController)) continue;
            return ImageCapturer.getImageOfPage(protocolPage, bl2);
        }
        return null;
    }

    private static Capture getImageOfPage(ProtocolPage protocolPage, boolean bl2) {
        BufferedImage bufferedImage = protocolPage.a(bl2, true, false, true);
        if (CapturePrefs.includeStudyInfoInPageCaptures.getValue().booleanValue()) {
            bufferedImage = StudyDemographicsPrepender.a(bufferedImage, protocolPage.b());
        }
        String string = Messages.a("mui", "SCREEN_CAPTURE") + " " + protocolPage.k().b();
        return new Capture(bufferedImage, string, true, protocolPage.i());
    }
}

