/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.atlas.management.AtlasDBManager;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.AbstractVolumetricDcmWriter;
import com.mimvista.file.MIMFile;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ak;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public abstract class MultiFileDcmWriter
extends AbstractVolumetricDcmWriter {
    public MultiFileDcmWriter(ViewController viewController) {
        super(viewController);
    }

    @Override
    public void writeFiles() {
        if (this.saveDest == null) {
            throw new IllegalStateException("Haven't set the save dest, so I can't save.");
        }
        if (AtlasDBManager.d(this.vs3D)) {
            ay.c((Object)"Declined to DICOM save atlas subject.", this);
            return;
        }
        final int[] nArray = this.plane == PresentationType.c ? new int[]{this.extent[0], this.extent[1], this.extent[4], this.extent[5], this.extent[2], this.extent[3]} : (this.plane == PresentationType.b ? new int[]{this.extent[2], this.extent[3], this.extent[4], this.extent[5], this.extent[0], this.extent[1]} : this.extent);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (MultiFileDcmWriter.this.progress == null) {
                    MultiFileDcmWriter.this.progress = o.o();
                }
                long l2 = System.currentTimeMillis();
                boolean bl2 = false;
                try {
                    File file;
                    MultiFileDcmWriter.this.progress.a(true);
                    if (!MultiFileDcmWriter.this.saveDest.endsWith(File.separator)) {
                        MultiFileDcmWriter.this.saveDest = MultiFileDcmWriter.this.saveDest + File.separator;
                    }
                    if (!(file = new File(MultiFileDcmWriter.this.saveDest)).exists()) {
                        file.mkdirs();
                    }
                    ay.b((Object)("Save directory: " + MultiFileDcmWriter.this.saveDest), MultiFileDcmWriter.this);
                    int n2 = nArray[5] - nArray[4] + 1;
                    MultiFileDcmWriter.this.progress.a(false);
                    MultiFileDcmWriter.this.progress.b(0);
                    MultiFileDcmWriter.this.progress.a(n2);
                    MultiFileDcmWriter.this.progress.a();
                    VolumetricDcmFunctor volumetricDcmFunctor = new VolumetricDcmFunctor(nArray);
                    if (MultiFileDcmWriter.this.saveDynamic) {
                        List<ImageVolumeShort> list = MultiFileDcmWriter.this.vs3D.cE().l();
                        boolean bl3 = true;
                        for (int i2 = 0; i2 < list.size(); ++i2) {
                            ImageVolumeShort imageVolumeShort = list.get(i2);
                            MultiFileDcmWriter.this.setFrmIdx(MultiFileDcmWriter.this.vs3D.at().b((SimpleImageFrame)imageVolumeShort));
                            volumetricDcmFunctor.updateTags();
                            FuncUtils.a((ThreadPoolExecutor)m.c, n2, volumetricDcmFunctor);
                            bl3 &= !volumetricDcmFunctor.canceled;
                        }
                        bl2 = bl3;
                    } else {
                        FuncUtils.a((ThreadPoolExecutor)m.c, n2, volumetricDcmFunctor);
                        bl2 = !volumetricDcmFunctor.canceled;
                    }
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error during multi-file DICOM save.", throwable, MultiFileDcmWriter.this);
                    Messages messages = Messages.a("Dicom");
                    JOptionPane.showMessageDialog(ak.b().O(), messages.getProperty("ABSTRACTVOL_SAVE_FAIL"), messages.getProperty("ABSTRACTVOL_ERROR"), 0);
                }
                finally {
                    MultiFileDcmWriter.this.progress.b();
                    if (bl2) {
                        ay.e("Finished multi-file DICOM save in " + (System.currentTimeMillis() - l2) + "ms");
                    }
                    try {
                        MultiFileDcmWriter.this.runCallbacks(bl2);
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error running callbacks after multi-file DICOM save", throwable, MultiFileDcmWriter.this);
                    }
                }
            }
        };
        if (this.blocking) {
            runnable.run();
        } else {
            m.b.submit(runnable);
        }
    }

    protected void addPositionalTags(DicomObject dicomObject, int[] nArray, int n2, ImageVolumeShort imageVolumeShort, Matrix4f matrix4f) {
        DicomPoint3f dicomPoint3f = this.addImagePositionTag(dicomObject, nArray, n2, imageVolumeShort, matrix4f);
        dicomObject.putFloat(2101313, VR.DS, dicomPoint3f.b(this.plane.a()[2]));
        dicomObject.putString(0x200012, VR.IS, "1");
    }

    protected boolean output(DicomObject dicomObject, byte[] byArray, String string) {
        return this.output(dicomObject, new ByteArrayPixDataWriter(byArray), string);
    }

    private class VolumetricDcmFunctor
    extends FuncUtils.aa {
        boolean canceled = false;
        final int sliceCount;
        int progCount = 1;
        final DicomObject resultDicomObj;
        final Matrix4f matrix;
        final int[] swizzledExtent;

        public VolumetricDcmFunctor(int[] nArray) {
            this.swizzledExtent = nArray;
            this.resultDicomObj = new BasicDicomObject();
            for (AbstractDcmModule abstractDcmModule : MultiFileDcmWriter.this.modules) {
                abstractDcmModule.fillTags(this.resultDicomObj);
                abstractDcmModule.fillOrientationTags(this.resultDicomObj);
            }
            this.sliceCount = nArray[5] - nArray[4] + 1;
            this.matrix = MultiFileDcmWriter.this.getSaveMatrix();
        }

        public void updateTags() {
            for (AbstractDcmModule abstractDcmModule : MultiFileDcmWriter.this.modules) {
                abstractDcmModule.updateTags(this.resultDicomObj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void f(int n2, int n3) {
            n2 += this.swizzledExtent[4];
            String string = "";
            if (MultiFileDcmWriter.this.saveDynamic && MultiFileDcmWriter.this.getFrmIdx() != -1) {
                string = MultiFileDcmWriter.this.getFrmIdx() + "_";
            }
            final String string2 = MultiFileDcmWriter.this.saveDest + string + String.valueOf(n2 + 1) + ".dcm";
            MultiFileDcmWriter multiFileDcmWriter = MultiFileDcmWriter.this;
            synchronized (multiFileDcmWriter) {
                if (!this.canceled && MultiFileDcmWriter.this.progress.n() == Progress.Status.e) {
                    this.canceled = true;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            finally {
                                new MIMFile(MultiFileDcmWriter.this.saveDest).delete();
                                new MIMFile(string2).delete();
                            }
                        }
                    }).start();
                }
            }
            multiFileDcmWriter = new BasicDicomObject();
            this.resultDicomObj.copyTo((DicomObject)multiFileDcmWriter, false);
            int[] nArray = MultiFileDcmWriter.this.getOutputVolumeDims();
            int n4 = nArray[0] * nArray[1];
            ByteBuffer byteBuffer = ByteBuffer.allocate(n4 * 2);
            ByteOrder byteOrder = multiFileDcmWriter.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            byteBuffer.order(byteOrder);
            ImageVolumeShort imageVolumeShort = MultiFileDcmWriter.this.getVolume();
            MultiFileDcmWriter.this.addPositionalTags((DicomObject)multiFileDcmWriter, this.swizzledExtent, n2, imageVolumeShort, this.matrix);
            MultiFileDcmWriter.this.createDataForSlice(this.swizzledExtent, n2, imageVolumeShort, this.matrix, byteBuffer, false);
            multiFileDcmWriter.putInt(2097171, VR.IS, n2 + 1);
            if (imageVolumeShort.I().triggerTime >= 0.0f) {
                multiFileDcmWriter.putFloat(1577056, VR.DS, imageVolumeShort.I().triggerTime);
            }
            if (imageVolumeShort.I().frameTime >= 0.0f) {
                multiFileDcmWriter.putFloat(1577059, VR.DS, imageVolumeShort.I().frameTime);
            }
            String string3 = !imageVolumeShort.getUncopiedMutableInfo().binnedInMIM && !imageVolumeShort.getUncopiedMutableInfo().volumeHasBeenSaved && imageVolumeShort.c((int)n2).sopInstanceUID != null && !imageVolumeShort.ar() && MultiFileDcmWriter.this.plane == PresentationType.a ? imageVolumeShort.c((int)n2).sopInstanceUID : UIDGenerator.generateUID();
            multiFileDcmWriter.putString(524312, VR.UI, string3);
            multiFileDcmWriter.putString(131075, VR.UI, string3);
            if (!this.canceled) {
                Messages messages = Messages.a("Dicom");
                MultiFileDcmWriter.this.progress.a(messages.getProperty("ABSTRACTVOL_SAVE_TITLE"));
                MultiFileDcmWriter.this.progress.b_(MIMFormat.a(messages.getProperty("ABSTRACTVOL_SAVE"), String.valueOf(this.progCount), String.valueOf(this.sliceCount)));
                ++this.progCount;
                MultiFileDcmWriter.this.progress.N_();
                MultiFileDcmWriter.this.output((DicomObject)multiFileDcmWriter, byteBuffer.array(), string2);
            }
        }
    }

    protected static class ByteArrayPixDataWriter
    implements FuncUtils.n<DicomOutputStream, IOException> {
        private byte[] pixelData;

        public ByteArrayPixDataWriter(byte[] byArray) {
            this.pixelData = byArray;
        }

        @Override
        public void doIt(DicomOutputStream dicomOutputStream) throws IOException {
            dicomOutputStream.writeHeader(2145386512, VR.OW, this.pixelData.length);
            dicomOutputStream.write(this.pixelData);
        }
    }
}

