/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.mui.PresentationType;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class NMPetPatientOrientationWriter {
    public static void fillOrientationTags(DcmWriter dcmWriter, DicomObject dicomObject) {
        int[] nArray = dcmWriter.extent;
        if (dcmWriter.plane == PresentationType.c) {
            dicomObject.putInt(5505153, VR.US, nArray[3] - nArray[2] + 1);
        } else if (dcmWriter.plane == PresentationType.b) {
            dicomObject.putInt(5505153, VR.US, nArray[1] - nArray[0] + 1);
        } else {
            dicomObject.putInt(5505153, VR.US, nArray[5] - nArray[4] + 1);
        }
        RawDicomUtils.writeCodeSequence(dicomObject, new int[]{5506064}, new String[]{"99SDM", "F-10450", "recumbent"});
        SimpleOrientationHelper.PatientPosition patientPosition = dcmWriter.vs.getUncopiedMutableInfo().origPatientPosition;
        int[] nArray2 = new int[]{5506064, 0, 5506066};
        String[] stringArray = new String[]{"99SDM", null, null};
        int[] nArray3 = new int[]{5506068};
        String[] stringArray2 = new String[]{"99SDM", null, null};
        if (patientPosition != null) {
            switch (patientPosition) {
                case b: 
                case c: {
                    stringArray[1] = "F-10310";
                    stringArray[2] = "prone";
                    break;
                }
                case a: 
                case d: {
                    stringArray[1] = "F-10340";
                    stringArray[2] = "supine";
                    break;
                }
                case e: 
                case g: {
                    stringArray[1] = "F-10319";
                    stringArray[2] = "left lateral decubitus";
                    break;
                }
                case f: 
                case h: {
                    stringArray[1] = "F-10317";
                    stringArray[2] = "right lateral decubitus";
                }
            }
            switch (patientPosition) {
                case b: 
                case a: 
                case e: 
                case f: {
                    stringArray2[1] = "G-5190";
                    stringArray2[2] = "headfirst";
                    break;
                }
                case c: 
                case d: 
                case g: 
                case h: {
                    stringArray2[1] = "G-5191";
                    stringArray2[2] = "feet-first";
                }
            }
        } else {
            stringArray[1] = "";
            stringArray[2] = "";
            stringArray2[1] = "";
            stringArray2[2] = "";
        }
        RawDicomUtils.writeCodeSequence(dicomObject, nArray2, stringArray);
        RawDicomUtils.writeCodeSequence(dicomObject, nArray3, stringArray2);
    }
}

