/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.AbstractVolumetricDcmWriter;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ak;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.work.m;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public abstract class SingleFileDcmWriter
extends AbstractVolumetricDcmWriter {
    public SingleFileDcmWriter(ViewController viewController) {
        super(viewController);
    }

    protected abstract boolean shouldWrite32Bit();

    protected int[] getSwizzledExtent() {
        if (this.plane == PresentationType.c) {
            return new int[]{this.extent[0], this.extent[1], this.extent[4], this.extent[5], this.extent[2], this.extent[3]};
        }
        if (this.plane == PresentationType.b) {
            return new int[]{this.extent[2], this.extent[3], this.extent[4], this.extent[5], this.extent[0], this.extent[1]};
        }
        return this.extent;
    }

    private DicomObject buildBaseDicomObject() {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        ImageVolumeShort imageVolumeShort = this.getVolume();
        int[] nArray = this.getSwizzledExtent();
        Matrix4f matrix4f = this.getSaveMatrix();
        for (AbstractDcmModule abstractDcmModule : this.modules) {
            abstractDcmModule.fillTags((DicomObject)basicDicomObject);
            abstractDcmModule.fillOrientationTags((DicomObject)basicDicomObject);
        }
        if (this.plane == PresentationType.c) {
            this.addImagePositionTag((DicomObject)basicDicomObject, nArray, nArray[4], imageVolumeShort, matrix4f);
        } else {
            this.addImagePositionTag((DicomObject)basicDicomObject, nArray, nArray[5], imageVolumeShort, matrix4f);
        }
        this.postProcess((DicomObject)basicDicomObject);
        return basicDicomObject;
    }

    public void postProcess(DicomObject dicomObject) {
    }

    @Override
    public void writeFiles() {
        if (this.saveDest == null || this.saveDest.length() == 0) {
            throw new IllegalStateException("Please call setSaveDestination.");
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (SingleFileDcmWriter.this.progress == null) {
                    SingleFileDcmWriter.this.progress = new ProgressPanel();
                    ProgressQueueNotification.a(SingleFileDcmWriter.this.progress);
                }
                boolean bl2 = false;
                File file = null;
                try {
                    if (!SingleFileDcmWriter.this.saveDest.endsWith(File.separator)) {
                        SingleFileDcmWriter.this.saveDest = SingleFileDcmWriter.this.saveDest + File.separator;
                    }
                    if (!(file = new File(SingleFileDcmWriter.this.saveDest)).exists()) {
                        file.mkdirs();
                    }
                    ay.b((Object)("DICOM Save Dir: " + SingleFileDcmWriter.this.saveDest), SingleFileDcmWriter.class);
                    DicomObject dicomObject = SingleFileDcmWriter.this.buildBaseDicomObject();
                    ByteOrder byteOrder = dicomObject.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                    int n2 = dicomObject.getInt(2621699, 0);
                    boolean bl3 = SingleFileDcmWriter.this.shouldWrite32Bit();
                    ImageVolumeShort imageVolumeShort = SingleFileDcmWriter.this.getVolume();
                    Float f2 = null;
                    if ("1.2.840.10008.5.1.4.1.1.481.2".equals(SingleFileDcmWriter.this.getSopClass())) {
                        f2 = Float.valueOf(dicomObject.getFloat(805568526, imageVolumeShort.getUncopiedMutableInfo().rescale.slope));
                    }
                    if (f2 != null && !SingleFileDcmWriter.this.shouldWriteDeactualizedPixelValues()) {
                        throw new IllegalStateException("DICOM save has conflicting rescale parameters.");
                    }
                    MemorySavingPixDataWriter memorySavingPixDataWriter = new MemorySavingPixDataWriter(byteOrder, n2, bl3, f2);
                    String string = SingleFileDcmWriter.this.saveDest + PathUtils.safeFilename(imageVolumeShort.getUncopiedMutableInfo().p());
                    string = string.length() > 251 ? string.substring(0, 251) + ".dcm" : string + ".dcm";
                    bl2 = SingleFileDcmWriter.this.output(dicomObject, memorySavingPixDataWriter, string);
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error during single-file DICOM save.", throwable, SingleFileDcmWriter.this);
                    Messages messages = Messages.a("Dicom");
                    JOptionPane.showMessageDialog(ak.b().O(), messages.getProperty("DCMNM_W_SAVE_FAIL"), messages.getProperty("DCMNM_W_ERROR"), 0);
                }
                finally {
                    SingleFileDcmWriter.this.progress.b();
                    if (!bl2) {
                        try {
                            if (file != null) {
                                new MIMFile(file).delete();
                            }
                        }
                        catch (Throwable throwable) {
                            ay.d((Object)"Error cleaning up after failed single-file DICOM save", throwable, SingleFileDcmWriter.this);
                        }
                    }
                    try {
                        SingleFileDcmWriter.this.runCallbacks(bl2);
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)"Error running callbacks after single-file DICOM save", throwable, SingleFileDcmWriter.this);
                    }
                }
            }
        };
        if (this.blocking) {
            runnable.run();
        } else {
            m.c.submit(runnable);
        }
    }

    private class MemorySavingPixDataWriter
    implements FuncUtils.n<DicomOutputStream, IOException> {
        private ByteOrder bo;
        private int pixRep;
        private boolean write32bit;
        private Float outputSlope;

        public MemorySavingPixDataWriter(ByteOrder byteOrder, int n2, boolean bl2, Float f2) {
            this.bo = byteOrder;
            this.pixRep = n2;
            this.write32bit = bl2;
            this.outputSlope = f2;
        }

        @Override
        public void doIt(DicomOutputStream dicomOutputStream) throws IOException {
            ImageVolumeShort imageVolumeShort = SingleFileDcmWriter.this.getVolume();
            int[] nArray = SingleFileDcmWriter.this.getSwizzledExtent();
            int[] nArray2 = new int[]{nArray[1] - nArray[0] + 1, nArray[3] - nArray[2] + 1, nArray[5] - nArray[4] + 1};
            Matrix4f matrix4f = SingleFileDcmWriter.this.getSaveMatrix();
            int n2 = nArray2[0] * nArray2[1];
            ByteBuffer byteBuffer = ByteBuffer.allocate(n2 * 2);
            byteBuffer.order(this.bo);
            ByteBuffer byteBuffer2 = null;
            RescaleConverter rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale;
            RescaleConverter rescaleConverter2 = null;
            if (this.write32bit) {
                byteBuffer2 = ByteBuffer.allocate(n2 * 4);
                byteBuffer2.order(this.bo);
            }
            if (this.outputSlope != null) {
                rescaleConverter2 = rescaleConverter.clone();
                rescaleConverter2.slope = this.outputSlope.floatValue();
                rescaleConverter2.intercept = 0.0f;
            }
            ArrayList arrayList = Lists.newArrayList();
            if (SingleFileDcmWriter.this.saveDynamic) {
                arrayList.addAll(SingleFileDcmWriter.this.vs3D.cE().l());
            } else {
                arrayList.add(imageVolumeShort);
            }
            int n3 = nArray2[2] * arrayList.size();
            int n4 = n3 * n2;
            n4 = byteBuffer2 != null ? (n4 *= 4) : (n4 *= 2);
            dicomOutputStream.writeHeader(2145386512, VR.OW, n4);
            SingleFileDcmWriter.this.progress.a(n3);
            Messages messages = Messages.a("Dicom");
            for (ImageVolumeShort imageVolumeShort2 : arrayList) {
                for (int i2 = nArray[5]; i2 >= nArray[4]; --i2) {
                    int n5;
                    SingleFileDcmWriter.this.progress.b_(messages.getProperty("DCMNM_W_SAVE") + String.valueOf(i2));
                    byteBuffer.rewind();
                    if (SingleFileDcmWriter.this.plane == PresentationType.c) {
                        n5 = nArray[4] + (nArray[5] - i2);
                        SingleFileDcmWriter.this.createDataForSlice(nArray, n5, imageVolumeShort2, matrix4f, byteBuffer, true);
                    } else {
                        SingleFileDcmWriter.this.createDataForSlice(nArray, i2, imageVolumeShort2, matrix4f, byteBuffer, true);
                    }
                    if (SingleFileDcmWriter.this.progress.n() == Progress.Status.e) {
                        return;
                    }
                    if (rescaleConverter2 != null) {
                        byteBuffer.rewind();
                        if (byteBuffer2 != null) {
                            byteBuffer2.rewind();
                        }
                        for (n5 = 0; n5 < n2; ++n5) {
                            float f2 = rescaleConverter.apply(byteBuffer.getShort(n5 * 2));
                            float f3 = rescaleConverter2.removeRaw(f2);
                            if (byteBuffer2 != null) {
                                if (this.pixRep == 0) {
                                    long l2 = Math.round((double)f3);
                                    if (l2 < 0L) {
                                        l2 = 0L;
                                    } else if (l2 >= 0xFFFFFFFFL) {
                                        l2 = 0xFFFFFFFFL;
                                    }
                                    byteBuffer2.putInt(n5 * 4, (int)l2);
                                    continue;
                                }
                                byteBuffer2.putInt(n5 * 4, Math.round(f3));
                                continue;
                            }
                            if (this.pixRep == 0) {
                                byteBuffer.putChar(n5 * 2, MathUtils.g(f3));
                                continue;
                            }
                            byteBuffer.putShort(n5 * 2, MathUtils.f(f3));
                        }
                    }
                    if (byteBuffer2 != null) {
                        byteBuffer2.rewind();
                        dicomOutputStream.write(byteBuffer2.array());
                    } else {
                        byteBuffer.rewind();
                        dicomOutputStream.write(byteBuffer.array());
                    }
                    SingleFileDcmWriter.this.progress.N_();
                }
            }
        }
    }
}

