/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.LocalLicense.LicenseOption;
import com.mimvista.archive.gui.SelectedFolderDestination;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.commands.MIMFeatureCategory;
import com.mimvista.commands.e;
import com.mimvista.commands.keyboard.bx;
import com.mimvista.dicom.util.DicomRegUtils;
import com.mimvista.file.PathUtils;
import com.mimvista.ftp.FtpDestination;
import com.mimvista.gui.a.a;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.gui.util.m;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ak;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3i;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;

public class TextIsomarkFileWriter {
    private static final String VERSION = "2.0";
    ViewController vc;
    List<PointContourOverlay> isocentersToSave = Lists.newArrayList();
    private Map<String, String> tags = new HashMap<String, String>();

    public TextIsomarkFileWriter(ViewController viewController, List<Overlayish> list) {
        this.vc = viewController;
        for (Overlayish overlayish : list) {
            if (!(overlayish instanceof PointContourOverlay)) continue;
            this.isocentersToSave.add((PointContourOverlay)overlayish);
        }
        this.initializeTags();
    }

    public void saveLapIsoMarkFile() {
        InputNotification inputNotification = this.showDialog(new Notification.a(this.vc));
        inputNotification.addToGrandNotifier();
    }

    private InputNotification showDialog(Notification.a a2) {
        InputNotification inputNotification = new InputNotification(a2, Messages.a("Util", "ISOMARK_TXT_CREATOR"), "save");
        inputNotification.setScrollBarType(AbstractInputContainer.ScrollBarType.b);
        inputNotification.setShowReset(false);
        inputNotification.addTitle("<html><strong>" + Messages.a("Util", "ISOMARK_TXT_CREATOR") + "</strong></html>");
        inputNotification.addLabel(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_ASSOC"));
        m m2 = inputNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_PATIENT"), null, 0);
        m2.b(this.vc.getUncopiedMutableInfo().patientName);
        m m3 = inputNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_MODALITY"), null, 0);
        m3.b(this.vc.getUncopiedMutableInfo().modality);
        m m4 = inputNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DATE"), null, 0);
        m4.b(this.vc.getUncopiedMutableInfo().d());
        m m5 = inputNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DESC"), null, 0);
        m5.b(this.vc.getUncopiedMutableInfo().seriesDesc);
        inputNotification.addSeparator();
        final l<SendToDestination> l2 = inputNotification.addSendToCombo(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DEST"), sendToDestination -> sendToDestination instanceof FtpDestination || sendToDestination instanceof SelectedFolderDestination);
        final l<String> l3 = inputNotification.addTextField(Messages.a("Util", "ISOMARK_TXT_NAME"));
        String string = ContourPrefs.textIsomarkLastFileName.getValue();
        if (cn.h(string)) {
            string = this.vc.aw().getUncopiedMutableInfo().patientName + "_" + this.vc.aw().getUncopiedMutableInfo().patientId + ".dat";
        }
        string = PathUtils.safeFilename(string);
        l3.a(string);
        final l<String> l4 = inputNotification.addTextField(Messages.a("Util", "ISOMARK_TXT_DESCRIPTION"));
        inputNotification.addSeparator();
        final com.mimvista.gui.util.u<Integer> u2 = inputNotification.addIntegerField(Messages.a("Util", "ISOMARK_TXT_Y_OFFSET"));
        u2.g(true);
        int n2 = ContourPrefs.textIsomarkLastYOffset.getValue();
        if (n2 != 0) {
            u2.c(n2);
        }
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SendToDestination sendToDestination = (SendToDestination)l2.b();
                String string = (String)l3.b();
                TextIsomarkFileWriter.this.tags.put("Comment2", l4.b());
                TextIsomarkFileWriter.this.tags.put("yOffset", u2.b() == null ? "0" : ((Integer)u2.b()).toString());
                if (sendToDestination instanceof FtpDestination) {
                    File file = null;
                    file = new File(System.getProperty("java.io.tmpdir") + File.separator + string);
                    file.deleteOnExit();
                    TextIsomarkFileWriter.this.writeLapIsoMarkTextFile(file);
                    a a2 = new a(file.getAbsolutePath());
                    a2.a(file.getName());
                    a2.push(sendToDestination, false);
                } else if (sendToDestination instanceof SelectedFolderDestination) {
                    MIMFileDialog mIMFileDialog = MIMFileDialog.a(ak.b().O(), Messages.a("Util", "ISOMARK_TXT_CREATOR"), MIMFileDialog.FileDialogType.b, true);
                    String string2 = ContourPrefs.textIsomarkLastSaveDir.getValue();
                    if (cn.h(string2)) {
                        string2 = PathUtils.getMIMDataPath();
                    }
                    mIMFileDialog.b(string2);
                    mIMFileDialog.a(string2 + File.separator + string);
                    mIMFileDialog.a(true);
                    if (mIMFileDialog.a() == null) {
                        return;
                    }
                    File file = new File(mIMFileDialog.a());
                    ContourPrefs.textIsomarkLastSaveDir.setValue(mIMFileDialog.b());
                    ContourPrefs.textIsomarkLastFileName.setValue(mIMFileDialog.c());
                    TextIsomarkFileWriter.this.writeLapIsoMarkTextFile(file);
                }
            }
        });
        return inputNotification;
    }

    private void initializeTags() {
        this.tags.put("ID", this.vc.getUncopiedMutableInfo().patientId);
        this.tags.put("Name", this.vc.getUncopiedMutableInfo().patientName);
        Date date = DateUtils.h(this.vc.getUncopiedMutableInfo().birthDate);
        this.tags.put("Birthdate", date == null ? "" : DateUtils.a(date, "MM/dd/yy"));
        this.tags.put("Plandate", DateUtils.a(new Date(), "MM/dd/yy HH:mm:ss"));
        this.tags.put("Comment1", this.vc.getUncopiedMutableInfo().p());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLapIsoMarkTextFile(File file) {
        int n2 = Integer.parseInt(this.tags.get("yOffset"));
        ContourPrefs.textIsomarkLastYOffset.setValue(n2);
        FileWriter fileWriter = null;
        ArrayList<PointContourOverlay> arrayList = new ArrayList<PointContourOverlay>();
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(String.format("[General]\n", new Object[0]));
            fileWriter.write(String.format("Version = %S\n", VERSION));
            fileWriter.write(String.format("\n", new Object[0]));
            fileWriter.write(String.format("[PatientData]\n", new Object[0]));
            fileWriter.write(String.format("ID = %S\n", this.tags.get("ID")));
            fileWriter.write(String.format("Name = %S\n", this.tags.get("Name")));
            fileWriter.write(String.format("Birthdate = %S\n", this.tags.get("Birthdate")));
            fileWriter.write(String.format("Plandate = %S\n", this.tags.get("Plandate")));
            fileWriter.write(String.format("Comment1 = %S\n", this.tags.get("Comment1")));
            fileWriter.write(String.format("Comment2 = %S\n", this.tags.get("Comment2")));
            fileWriter.write(String.format("\n", new Object[0]));
            int n3 = 1;
            for (PointContourOverlay object : this.isocentersToSave) {
                fileWriter.write(String.format("[Field%S]\n", n3));
                fileWriter.write(String.format("ID = %S\n", n3));
                for (DicomPoint3f dicomPoint3f : object.a()) {
                    Point3i point3i = TextIsomarkFileWriter.getMMFromLapZero(this.vc.aw(), n2, dicomPoint3f);
                    fileWriter.write(String.format("Isocenter = %+04d, %+04d, %+04d, \"%S\"\n", point3i.x, point3i.y, point3i.z, object.getName()));
                }
                fileWriter.write(String.format("\n", new Object[0]));
                ++n3;
                arrayList.add(object);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)"Could not write out LAP IsoMark file", (Throwable)iOException, this);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.flush();
                    fileWriter.close();
                }
                catch (Exception exception) {
                    ay.d((Object)"Error closing LAP IsoMark file", (Throwable)exception, this);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        for (Object object : arrayList) {
            ((PointContourOverlay)object).b(l2);
        }
    }

    public static Point3i getMMFromLapZero(ImageFrame imageFrame, float f2, DicomPoint3f dicomPoint3f) {
        Point3i point3i = new Point3i();
        DicomPoint3f dicomPoint3f2 = new MetricPoint3f(0.0f, 0.0f, 0.0f, imageFrame).d();
        DicomPoint3f dicomPoint3f3 = new DicomPoint3f(0.0f, 0.0f, 0.0f, imageFrame);
        DicomPoint3f dicomPoint3f4 = dicomPoint3f.a();
        SimpleOrientationHelper.PatientPosition patientPosition = imageFrame.getUncopiedMutableInfo().origPatientPosition;
        float[] fArray = patientPosition.a();
        Matrix4f matrix4f = SimpleOrientationHelper.a(fArray, imageFrame.getUncopiedMutableInfo().gantryDetectorTilt, Float.valueOf(0.0f));
        Matrix4f matrix4f2 = DicomRegUtils.generate_METRIC_M_DICOM(imageFrame, fArray).b();
        Matrix4f matrix4f3 = DicomRegUtils.generate_DICOM_M_METRIC(imageFrame, fArray).b();
        matrix4f.mul(matrix4f, matrix4f2);
        matrix4f.mul(matrix4f3, matrix4f);
        dicomPoint3f2.b(matrix4f);
        dicomPoint3f4.b(matrix4f);
        dicomPoint3f3.b(matrix4f);
        DicomPoint3f dicomPoint3f5 = new DicomPoint3f(0.0f, 0.0f, 0.0f, imageFrame);
        dicomPoint3f5.add((Tuple3f)dicomPoint3f4);
        dicomPoint3f5.sub((Tuple3f)dicomPoint3f2);
        DicomPoint3f dicomPoint3f6 = new DicomPoint3f(0.0f, 0.0f, 0.0f, imageFrame);
        dicomPoint3f6.add((Tuple3f)dicomPoint3f4);
        dicomPoint3f6.sub((Tuple3f)dicomPoint3f3);
        point3i.x = Math.round(dicomPoint3f5.x);
        point3i.y = Math.round(dicomPoint3f6.z - f2);
        point3i.z = Math.round(-dicomPoint3f5.y);
        return point3i;
    }

    @e(e="save_lap_isomark_file", f="save_lap_isomark_file", b="command_save_lap_isomark_file", a="General", h="save", k=MIMFeatureCategory.CONTOURING, j={LicenseOption.CONTOURING_ADVANCED})
    public static class SaveTextIsomarkFileCommand
    extends bx.a {
        @Override
        public void execute(ViewController viewController) {
            List<Overlayish> list = viewController.ba().a(OverlayishBase.InterpretedType.w, false, false);
            if (list.size() != 0) {
                TextIsomarkFileWriter textIsomarkFileWriter = new TextIsomarkFileWriter(viewController, list);
                textIsomarkFileWriter.saveLapIsoMarkFile();
            } else {
                String string = Messages.a("Util", "ISOMARK_TXT_NO_ISOCENTERS");
                BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.b, string, new Notification.a(viewController), Notification.NotificationTimeoutType.b, 5000L);
                u.b().c(basicNotification);
            }
        }
    }
}

