/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write.deformable;

import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.write.deformable.AlignedFusionSaveInfo;
import com.mimvista.dicom.write.deformable.DcmDeformableRegWriter;
import com.mimvista.intensitybasedwarp.qa.DeformationRating;
import com.mimvista.intensitybasedwarp.qa.ReviewStatus;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.volumes.ImageVolumeByte;
import com.mimvista.mui.findings.FindingElement;
import com.mimvista.mui.findings.OverlayFindingElement;
import com.mimvista.mui.mouse.mode.box.MetricBox;
import com.mimvista.mui.overlays.AbstractSpyglassOverlay;
import com.mimvista.mui.overlays.DeformableSpyglassOverlay;
import com.mimvista.mui.overlays.FusionAlignOverlay;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.util.ay;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DcmDeformableRegQAHelper {
    private final DcmDeformableRegWriter defRegWriter;

    public DcmDeformableRegQAHelper(DcmDeformableRegWriter dcmDeformableRegWriter) {
        this.defRegWriter = dcmDeformableRegWriter;
    }

    boolean shouldAddQaSequence() {
        return this.warpTransform().c() != null && this.warpTransform().c().c() != ReviewStatus.a;
    }

    public static boolean shouldAddLockedAlignmentsSequence(ImageFrame imageFrame, ImageFrame imageFrame2) {
        List<FusionAlignOverlay> list = FusionAlignOverlay.a(imageFrame, imageFrame2, true);
        return list.size() != 0;
    }

    public void addQASequence(DicomObject dicomObject) {
        DicomElement dicomElement = dicomObject.putSequence(930283825);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        this.addRatingMap((DicomObject)basicDicomObject);
        this.createReviewOverlaysSequence((DicomObject)basicDicomObject);
    }

    private void addRatingMap(DicomObject dicomObject) {
        ImageVolumeByte imageVolumeByte = this.warpTransform().c().g();
        if (imageVolumeByte != null) {
            this.addRatingMapInfo(dicomObject.putSequence(930283826));
        }
    }

    private DicomObject addRatingMapInfo(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        ImageVolumeByte imageVolumeByte = this.warpTransform().c().g();
        ImageCube.ImageCubeByte imageCubeByte = (ImageCube.ImageCubeByte)imageVolumeByte.ad();
        ByteBuffer byteBuffer = ByteBuffer.allocate((int)MathUtils.d(imageCubeByte.d()));
        for (byte[] byArray : imageCubeByte.b()) {
            byteBuffer.put(byArray);
        }
        basicDicomObject.putInt(2621457, VR.US, imageCubeByte.d()[0]);
        basicDicomObject.putInt(2621456, VR.US, imageCubeByte.d()[1]);
        basicDicomObject.putInt(5505153, VR.US, imageCubeByte.d()[2]);
        basicDicomObject.putInt(2621696, VR.US, 8);
        basicDicomObject.putInt(2621697, VR.US, 8);
        basicDicomObject.putInt(2621698, VR.US, 7);
        basicDicomObject.putInt(0x280002, VR.US, 1);
        basicDicomObject.putFloats(2621488, VR.DS, new float[]{imageVolumeByte.b()[1], imageVolumeByte.b()[0]});
        basicDicomObject.putFloat(1572944, VR.DS, imageVolumeByte.b()[2]);
        basicDicomObject.putInt(2621699, VR.US, 0);
        basicDicomObject.putBytes(2145386512, VR.OB, byteBuffer.array());
        return basicDicomObject;
    }

    private void createReviewOverlaysSequence(DicomObject dicomObject) {
        if (this.warpTransform().c() != null && this.warpTransform().c().e() != null && !this.warpTransform().c().e().isEmpty()) {
            DicomElement dicomElement = dicomObject.putSequence(805699616);
            for (FindingElement findingElement : this.warpTransform().c().e()) {
                try {
                    if (findingElement instanceof OverlayFindingElement && ((OverlayFindingElement)findingElement).f() instanceof DeformableSpyglassOverlay) {
                        DeformableSpyglassOverlay deformableSpyglassOverlay = (DeformableSpyglassOverlay)((OverlayFindingElement)findingElement).f();
                        this.addOverlaySequenceItem(dicomElement, deformableSpyglassOverlay);
                        continue;
                    }
                    ay.c((Object)"Unrecognized overlay in deformation QA", this);
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error adding QA object", throwable, this);
                }
            }
        }
    }

    private void addOverlaySequenceItem(DicomElement dicomElement, DeformableSpyglassOverlay deformableSpyglassOverlay) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        DcmDeformableRegQAHelper.addInfoToSequence(deformableSpyglassOverlay, (DicomObject)basicDicomObject);
        DeformationRating deformationRating = deformableSpyglassOverlay.C();
        this.createRatingSequence((DicomObject)basicDicomObject, deformationRating, deformableSpyglassOverlay.h());
        DcmDeformableRegQAHelper.addFusionModeInformation((DicomObject)basicDicomObject, deformableSpyglassOverlay);
    }

    private void createRatingSequence(DicomObject dicomObject, DeformationRating deformationRating, Date date) {
        if (deformationRating == null) {
            deformationRating = DeformationRating.b;
        }
        if (date == null) {
            date = new Date();
        }
        dicomObject.putString(806223874, VR.CS, deformationRating.name());
        if (deformationRating != DeformationRating.b) {
            dicomObject.putDate(806223876, VR.DA, date);
            dicomObject.putDate(806223877, VR.TM, date);
            dicomObject.putString(806223880, null, this.defRegWriter.contentCreator);
        }
    }

    public static void createRRSequence(DicomObject dicomObject, ImageFrame imageFrame, ImageFrame imageFrame2) {
        DicomElement dicomElement = dicomObject.putSequence(930283827);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        List<FusionAlignOverlay> list = FusionAlignOverlay.a(imageFrame, imageFrame2, true);
        DicomElement dicomElement2 = basicDicomObject.putSequence(805699616);
        try {
            for (FusionAlignOverlay fusionAlignOverlay : list) {
                DcmDeformableRegQAHelper.addOverlaySequenceItem(dicomElement2, fusionAlignOverlay);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error adding pinned alignments", throwable, DcmDeformableRegQAHelper.class);
        }
    }

    private static void addOverlaySequenceItem(DicomElement dicomElement, FusionAlignOverlay fusionAlignOverlay) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        DcmDeformableRegQAHelper.addInfoToSequence(fusionAlignOverlay, (DicomObject)basicDicomObject);
        DcmDeformableRegQAHelper.addFusionModeInformation((DicomObject)basicDicomObject, fusionAlignOverlay);
    }

    private static void addInfoToSequence(AbstractSpyglassOverlay abstractSpyglassOverlay, DicomObject dicomObject) {
        dicomObject.putString(805699622, VR.LO, abstractSpyglassOverlay.getName());
        dicomObject.putString(805699624, VR.ST, abstractSpyglassOverlay.B_());
        RawDicomUtils.addRoiDisplayColor(dicomObject, abstractSpyglassOverlay.bn_());
        dicomObject.putInt(805699654, VR.IS, 2);
        dicomObject.putFloats(805699664, VR.DS, DcmDeformableRegQAHelper.getBoxPoints(abstractSpyglassOverlay));
    }

    private static void addFusionModeInformation(DicomObject dicomObject, AbstractSpyglassOverlay abstractSpyglassOverlay) {
        try {
            AlignedFusionSaveInfo alignedFusionSaveInfo = abstractSpyglassOverlay.b();
            dicomObject.putDouble(2626566, VR.FD, (double)alignedFusionSaveInfo.blend);
            dicomObject.putString(928055553, VR.ST, alignedFusionSaveInfo.modeType.name());
            if (alignedFusionSaveInfo.checkerSize > 0.0f) {
                dicomObject.putString(928055554, VR.LT, Float.toString(alignedFusionSaveInfo.checkerSize));
            }
            try {
                dicomObject.putFloats(805699782, VR.DS, MatrixMultiplier.l(alignedFusionSaveInfo.transform));
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error adding local rigid registration to QA overlay", throwable, DcmDeformableRegQAHelper.class);
            }
            try {
                DcmDeformableRegQAHelper.createTableAndContrastSequenceItem(dicomObject.putSequence(928055556), alignedFusionSaveInfo.secondaryColortableName, alignedFusionSaveInfo.secondaryWindow, alignedFusionSaveInfo.secondaryLevel);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error adding secondary contrast information to QA overlay", throwable, DcmDeformableRegQAHelper.class);
            }
            try {
                DcmDeformableRegQAHelper.createTableAndContrastSequenceItem(dicomObject.putSequence(928055557), alignedFusionSaveInfo.fusionColortableName, alignedFusionSaveInfo.fusionWindow, alignedFusionSaveInfo.fusionLevel);
            }
            catch (Throwable throwable) {
                ay.d((Object)"Error adding fusion contrast information to QA overlay", throwable, DcmDeformableRegQAHelper.class);
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error adding fusion information for QA overlay", throwable, DcmDeformableRegQAHelper.class);
        }
    }

    private static float[] getBoxPoints(AbstractSpyglassOverlay abstractSpyglassOverlay) {
        MetricBox metricBox = abstractSpyglassOverlay.c();
        DicomPoint3f dicomPoint3f = metricBox.b(metricBox.c()).a(metricBox.c().bq()).d();
        DicomPoint3f dicomPoint3f2 = metricBox.d().d();
        float[] fArray = new float[6];
        System.arraycopy(dicomPoint3f.f(), 0, fArray, 0, 3);
        System.arraycopy(dicomPoint3f2.f(), 0, fArray, 3, 3);
        return fArray;
    }

    private static void createTableAndContrastSequenceItem(DicomElement dicomElement, String string, float f2, float f3) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(7340161, VR.LO, string);
        basicDicomObject.putFloat(2625617, VR.DS, f2);
        basicDicomObject.putFloat(2625616, VR.DS, f3);
    }

    private WarpTransform warpTransform() {
        return this.defRegWriter.warpTransform;
    }
}

