/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write.deformable;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.d;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.write.DcmRegWriter;
import com.mimvista.dicom.write.deformable.DcmDeformableRegQAHelper;
import com.mimvista.dicom.write.deformable.DcmSaveListener;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.af;
import com.mimvista.gui.util.l;
import com.mimvista.intensitybasedwarp.s;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ab;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3d;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.algo.b;
import com.mimvista.viewer.f;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.nio.FloatBuffer;
import java.util.List;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DcmDeformableRegWriter
extends b {
    public static Messages props = Messages.a("Dicom");
    WarpTransform warpTransform;
    String contentCreator;
    SendToDestination dest;
    ImageVolumeShort srcVol;

    public DcmDeformableRegWriter(ImageVolumeShort imageVolumeShort, WarpTransform warpTransform, String string, String string2) {
        this.info = imageVolumeShort.getUncopiedMutableInfo();
        this.srcVol = imageVolumeShort;
        this.warpTransform = warpTransform;
        this.contentCreator = string;
        this.seriesDescription = string2;
    }

    public DcmDeformableRegWriter(ViewController3D viewController3D, WarpTransform warpTransform) {
        this.viewState = viewController3D;
        this.info = this.viewState.getUncopiedMutableInfo();
        this.srcVol = viewController3D.cw();
        this.warpTransform = warpTransform;
    }

    @Override
    public String getProgressTitle() {
        return Messages.a("Dicom", "DCM_SERIES_SAVE_DEF_REG");
    }

    @Override
    public Modality getModality() {
        return Modality.REG;
    }

    @Override
    public UIDContainer getSopClassUID() {
        return new UIDContainer.SOPClassUID("1.2.840.10008.5.1.4.1.1.66.3");
    }

    @Override
    public String getSeriesDate() {
        return DateUtils.e();
    }

    @Override
    public String getSeriesTime() {
        return DateUtils.f();
    }

    public SendToDestination getDest() {
        return this.dest;
    }

    public void setDest(SendToDestination sendToDestination) {
        this.dest = sendToDestination;
    }

    public InputNotification createNotification(Component component) {
        return this.createNotification(component, null);
    }

    public InputNotification createNotification(Component component, final @d DcmSaveListener dcmSaveListener) {
        InputNotification inputNotification = new InputNotification(new Notification.a(this.viewState), props.getProperty("DCM_DEF_REG_W_SAVE"), "save");
        inputNotification.addTitle(props.getProperty("DCM_DEF_REG_W_SAVE"));
        final af af2 = inputNotification.addStringField(props.getProperty("DCM_REG_W_SERIES")).g(false).d("DEFORMABLE REG");
        final af af3 = inputNotification.addStringField(props.getProperty("DCM_REG_W_CREATOR")).g(true);
        SearchSource searchSource = this.viewState.bK();
        SendToDestination sendToDestination = ag.a(searchSource);
        if (ag.d() != null) {
            sendToDestination = ag.d();
        }
        final l<SendToDestination> l2 = inputNotification.addSendToCombo(props.getProperty("DCM_REG_W_DESTINATION")).a(sendToDestination);
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DcmDeformableRegWriter.this.seriesDescription = (String)af2.b();
                DcmDeformableRegWriter.this.contentCreator = (String)af3.b();
                DcmDeformableRegWriter.this.dest = (SendToDestination)l2.b();
                ProgressQueueNotification.a(new ProgressQueueNotification.b(){

                    @Override
                    public void run(g g2) {
                        boolean bl2 = DcmDeformableRegWriter.this.writeTo(DcmDeformableRegWriter.this.dest, (Progress)g2);
                        if (dcmSaveListener != null) {
                            dcmSaveListener.saveFinished(bl2, DcmDeformableRegWriter.this.getSeriesInstanceUID());
                        }
                    }
                });
            }
        });
        return inputNotification;
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        Object object;
        Matrix4f matrix4f;
        ImageFrame imageFrame;
        ImageFrame imageFrame2;
        Object object2;
        DicomElement dicomElement;
        dicomObject.putString(524323, VR.DA, DateUtils.e());
        dicomObject.putString(524339, VR.TM, DateUtils.f());
        if (this.warpTransform.O() == null && this.warpTransform.deformableSaveInfo != null) {
            dicomElement = dicomObject.putSequence(528896);
            dicomElement.addDicomObject(this.warpTransform.deformableSaveInfo.srcSCORISSequenceItem);
            dicomElement.addDicomObject(this.warpTransform.deformableSaveInfo.destSCORISSequenceItem);
            object2 = dicomObject.putSequence(528661);
            object2.addDicomObject(this.warpTransform.deformableSaveInfo.srcReferencedImageSequenceItem);
            object2.addDicomObject(this.warpTransform.deformableSaveInfo.srcSeriesUIDItem);
            if (this.warpTransform.deformableSaveInfo.destReferencedImageSequenceItem != null) {
                object2.addDicomObject(this.warpTransform.deformableSaveInfo.destReferencedImageSequenceItem);
            }
        }
        if (this.warpTransform.O() != null) {
            this.warpTransform.O().buildReferencedSeriesSequence(dicomObject);
            this.warpTransform.O().buildScorisSequence(dicomObject);
        }
        dicomObject.putString(2097171, null, "1");
        dicomObject.putString(0x200052, VR.UI, this.info.frameOfRefUID);
        dicomObject.putString(2101312, null, "");
        dicomObject.putString(0x700080, null, "REGISTRATION");
        dicomObject.putString(7340161, null, "Fusion Registration");
        dicomObject.putString(7340164, null, this.contentCreator);
        dicomElement = dicomObject.putSequence(6553602);
        if (this.warpTransform.O() != null) {
            this.addDestRegSeq(dicomElement);
        }
        this.addRegSeq(dicomElement);
        object2 = new DcmDeformableRegQAHelper(this);
        if (((DcmDeformableRegQAHelper)object2).shouldAddQaSequence()) {
            ((DcmDeformableRegQAHelper)object2).addQASequence(dicomObject);
        }
        if (DcmDeformableRegQAHelper.shouldAddLockedAlignmentsSequence(imageFrame2 = this.warpTransform.x(), imageFrame = this.warpTransform.a())) {
            DcmDeformableRegQAHelper.createRRSequence(dicomObject, imageFrame2, imageFrame);
        }
        if ((matrix4f = this.warpTransform.D()) != null) {
            object = new float[16];
            FloatBuffer floatBuffer = FloatBuffer.wrap((float[])object);
            for (int i2 = 0; i2 < 4; ++i2) {
                for (int i3 = 0; i3 < 4; ++i3) {
                    floatBuffer.put(matrix4f.getElement(i2, i3));
                }
            }
            dicomObject.putFloats(930283824, VR.OF, (float[])object);
        }
        if (this.warpTransform.N() != null) {
            object = !cn.g(this.warpTransform.N().c) ? (Object)this.warpTransform.N().c : (Object)this.warpTransform.N().a;
            dicomObject.putString(930283828, VR.ST, (String)object);
        }
        if ((object = (Object)this.getJSONWarpProfile(this.warpTransform)) != null) {
            dicomObject.putString(930283830, VR.ST, (String)object);
        }
    }

    public String getJSONWarpProfile(WarpTransform warpTransform) {
        if (warpTransform.P() != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString((Object)warpTransform.P());
            }
            catch (JsonProcessingException jsonProcessingException) {
                ay.d((Object)"Failed to serialize Warp Profile JSON", this);
                return null;
            }
        }
        return null;
    }

    private void addDestRegSeq(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        this.warpTransform.O().buildEmbeddedDestReferencedImageSequence((DicomObject)basicDicomObject);
        String string = this.warpTransform.O().destInfo != null ? this.warpTransform.O().getDestInfo().info.frameOfRefUID : "";
        basicDicomObject.putString(6553603, VR.UI, string);
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        basicDicomObject.putNestedDicomObject(7340809, (DicomObject)basicDicomObject2);
        DicomElement dicomElement2 = basicDicomObject2.putSequence(7340813);
        this.addCodeSequence(dicomElement2, "125025", "DCM", "Visual Alignment");
        DcmRegWriter.addIdentityMatrixSeq(basicDicomObject2.putSequence(7340810));
    }

    private void addRegSeq(DicomElement dicomElement) {
        DicomElement dicomElement2;
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(6553603, VR.UI, this.info.frameOfRefUID);
        if (this.warpTransform.O() == null) {
            dicomElement2 = basicDicomObject.putSequence(528704);
            DicomElement dicomElement3 = basicDicomObject.putSequence(6553615);
            DicomElement dicomElement4 = basicDicomObject.putSequence(6553616);
            dicomElement2.addDicomObject(this.warpTransform.deformableSaveInfo.srcReferencedImageSequenceItem);
            if (this.warpTransform.deformableSaveInfo.destReferencedImageSequenceItem != null) {
                dicomElement2.addDicomObject(this.warpTransform.deformableSaveInfo.destReferencedImageSequenceItem);
            }
            this.addPreDeformationMatrixSeq(dicomElement3);
            dicomElement4.addDicomObject(this.warpTransform.deformableSaveInfo.postDeformationMatrixSeq);
        } else {
            this.warpTransform.O().buildEmbeddedSourceReferencedImageSequence((DicomObject)basicDicomObject);
            dicomElement2 = basicDicomObject.putSequence(6553615);
            this.addPreDeformationMatrixSeq(dicomElement2);
            DicomElement dicomElement5 = basicDicomObject.putSequence(6553616);
            this.warpTransform.O().addPostDeformationMatrixItem(dicomElement5);
        }
        dicomElement2 = basicDicomObject.putSequence(6553605);
        this.addMatrixGridSequence(dicomElement2);
    }

    private void addPreDeformationMatrixSeq(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        try {
            Matrix4f matrix4f = MatrixMultiplier.b();
            basicDicomObject.putFloats(805699782, null, MatrixMultiplier.l(matrix4f));
            basicDicomObject.putString(7340812, null, "RIGID");
        }
        catch (Throwable throwable) {
            ay.d((Object)"Matrix calculation error.", throwable, this);
        }
    }

    private static void addPostDeformationMatrixSeq(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        Matrix4f matrix4f = MatrixMultiplier.b();
        basicDicomObject.putFloats(805699782, null, MatrixMultiplier.l(matrix4f));
        basicDicomObject.putString(7340812, null, "RIGID");
    }

    private void addMatrixGridSequence(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        Point3f.PointVolumeInfo pointVolumeInfo = this.warpTransform.J();
        int[] nArray = this.warpTransform.y().d();
        float[] fArray = new VoxelIndexPoint3f(0.0f, 0.0f, (float)(nArray[2] - 1), pointVolumeInfo).d().d().f();
        basicDicomObject.putFloats(0x200032, VR.DS, fArray);
        float[] fArray2 = pointVolumeInfo.iop;
        basicDicomObject.putFloats(2097207, VR.DS, fArray2);
        float[] fArray3 = ab.a(fArray2, null);
        s s2 = this.warpTransform.y();
        int[] nArray2 = s2.d();
        basicDicomObject.putInts(6553607, VR.UL, nArray2);
        float[] fArray4 = s2.e();
        basicDicomObject.putDoubles(6553608, VR.FD, MathUtils.b(fArray4));
        int n2 = nArray2[0] * nArray2[1] * nArray2[2] * 3;
        FloatBuffer floatBuffer = FloatBuffer.allocate(n2);
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        DicomPoint3f dicomPoint3f = new DicomPoint3f(pointVolumeInfo);
        Point3f.PointVolumeInfo pointVolumeInfo2 = this.warpTransform.q();
        VoxelIndexPoint3f voxelIndexPoint3f = new VoxelIndexPoint3f(pointVolumeInfo2);
        MetricPoint3f metricPoint3f = new MetricPoint3f(pointVolumeInfo2);
        DicomPoint3f dicomPoint3f2 = new DicomPoint3f(pointVolumeInfo2);
        for (int i2 = nArray2[2] - 1; i2 >= 0; --i2) {
            point3d.x = fArray[0] + (float)(nArray2[2] - i2 - 1) * fArray4[2] * fArray3[0];
            point3d.y = fArray[1] + (float)(nArray2[2] - i2 - 1) * fArray4[2] * fArray3[1];
            point3d.z = fArray[2] + (float)(nArray2[2] - i2 - 1) * fArray4[2] * fArray3[2];
            float[] fArray5 = (float[])s2.a().b().get(i2);
            float[] fArray6 = (float[])s2.b().b().get(i2);
            float[] fArray7 = (float[])s2.c().b().get(i2);
            int n3 = 0;
            for (int i3 = 0; i3 < nArray2[1]; ++i3) {
                point3d2.x = point3d.x + (double)((float)i3 * fArray4[1] * fArray2[3]);
                point3d2.y = point3d.y + (double)((float)i3 * fArray4[1] * fArray2[4]);
                point3d2.z = point3d.z + (double)((float)i3 * fArray4[1] * fArray2[5]);
                int n4 = 0;
                while (n4 < nArray2[0]) {
                    dicomPoint3f.x = (float)(point3d2.x + (double)((float)n4 * fArray4[0] * fArray2[0]));
                    dicomPoint3f.y = (float)(point3d2.y + (double)((float)n4 * fArray4[0] * fArray2[1]));
                    dicomPoint3f.z = (float)(point3d2.z + (double)((float)n4 * fArray4[0] * fArray2[2]));
                    voxelIndexPoint3f.x = fArray5[n3];
                    voxelIndexPoint3f.y = fArray6[n3];
                    voxelIndexPoint3f.z = fArray7[n3];
                    voxelIndexPoint3f.a(metricPoint3f);
                    metricPoint3f.a(dicomPoint3f2);
                    floatBuffer.put(dicomPoint3f2.x - dicomPoint3f.x);
                    floatBuffer.put(dicomPoint3f2.y - dicomPoint3f.y);
                    floatBuffer.put(dicomPoint3f2.z - dicomPoint3f.z);
                    ++n4;
                    ++n3;
                }
            }
        }
        basicDicomObject.putFloats(6553609, VR.OF, floatBuffer.array());
    }

    @Deprecated
    public static class DeformableSaveInformation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public DicomObject postDeformationMatrixSeq = this.getPostDeformationMatrixSeq();
        public DicomObject srcReferencedImageSequenceItem;
        private DicomObject srcSeriesUIDItem;
        @d
        public DicomObject destReferencedImageSequenceItem;
        public DicomObject srcSCORISSequenceItem;
        public DicomObject destSCORISSequenceItem;
        public String destPatientName;
        public String destPatientID;

        public DeformableSaveInformation(ImageFrame imageFrame, ImageFrame imageFrame2) {
            this.srcReferencedImageSequenceItem = RawDicomUtils.getImageSOPInstanceMacro(imageFrame2);
            this.srcSeriesUIDItem = new BasicDicomObject();
            this.srcSeriesUIDItem.putString(0x20000E, VR.UI, imageFrame2.getUncopiedMutableInfo().ag());
            if (!f.b(imageFrame.getUncopiedMutableInfo())) {
                this.destReferencedImageSequenceItem = RawDicomUtils.getImageSOPInstanceMacro(imageFrame);
            } else {
                ay.a((Object)"Dest is neuro template, omitting dest seq.", this);
            }
            this.srcSCORISSequenceItem = RawDicomUtils.getScorisObject(imageFrame2);
            this.destSCORISSequenceItem = RawDicomUtils.getScorisObject(imageFrame);
            this.destPatientName = imageFrame.getUncopiedMutableInfo().patientName;
            this.destPatientID = imageFrame.getUncopiedMutableInfo().patientId;
        }

        public String getDestSeriesUid() {
            DicomElement dicomElement = this.destSCORISSequenceItem.get(528661);
            if (dicomElement == null) {
                return null;
            }
            DicomObject dicomObject = dicomElement.getDicomObject(0);
            if (dicomObject == null) {
                return null;
            }
            return dicomObject.getString(0x20000E, (String)null);
        }

        private DicomObject getPostDeformationMatrixSeq() {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            Matrix4f matrix4f = MatrixMultiplier.b();
            basicDicomObject.putFloats(805699782, null, MatrixMultiplier.l(matrix4f));
            basicDicomObject.putString(7340812, null, "RIGID");
            return basicDicomObject;
        }
    }

    public static class DeformableSaveHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private ConciseVolumeReferenceInfo srcInfo;
        private ConciseVolumeReferenceInfo destInfo;

        public DeformableSaveHelper(ImageFrame imageFrame, ImageFrame imageFrame2) {
            this.srcInfo = new ConciseVolumeReferenceInfo((ImageVolumeShort)imageFrame2);
            if (imageFrame != null && !f.b(imageFrame.getUncopiedMutableInfo())) {
                this.destInfo = new ConciseVolumeReferenceInfo((ImageVolumeShort)imageFrame);
            } else {
                ay.a((Object)"Dest is neuro template, omitting dest seq.", this);
            }
        }

        public DeformableSaveHelper(SeriesInfo seriesInfo, SeriesInfo seriesInfo2) {
            this.srcInfo = new ConciseVolumeReferenceInfo();
            this.srcInfo.info = seriesInfo2.m();
            this.srcInfo.sops.add(seriesInfo2.sopInstanceUID);
            this.destInfo = new ConciseVolumeReferenceInfo();
            this.destInfo.info = seriesInfo.m();
            this.destInfo.sops.add(seriesInfo.sopInstanceUID);
        }

        public ConciseVolumeReferenceInfo getSrcInfo() {
            if (this.srcInfo == null) {
                return null;
            }
            return this.srcInfo.clone();
        }

        public ConciseVolumeReferenceInfo getDestInfo() {
            if (this.destInfo == null) {
                return null;
            }
            return this.destInfo.clone();
        }

        public String getDestSeriesUid() {
            if (this.destInfo == null) {
                return null;
            }
            return this.destInfo.info.ag();
        }

        public String getDestPatientName() {
            if (this.destInfo == null) {
                return "";
            }
            return this.destInfo.getPatientName();
        }

        public String getDestPatientId() {
            if (this.destInfo == null) {
                return "";
            }
            return this.destInfo.getPatientId();
        }

        public boolean areInDifferentStudies() {
            if (this.destInfo == null || cn.g(this.srcInfo.getStudyInstanceUID())) {
                return false;
            }
            return !this.srcInfo.getStudyInstanceUID().equalsIgnoreCase(this.destInfo.getStudyInstanceUID());
        }

        public void buildReferencedSeriesSequence(DicomObject dicomObject) {
            DicomElement dicomElement = dicomObject.putSequence(528661);
            if (!this.areInDifferentStudies()) {
                for (ConciseVolumeReferenceInfo conciseVolumeReferenceInfo : Lists.newArrayList((Object[])new ConciseVolumeReferenceInfo[]{this.srcInfo, this.destInfo})) {
                    this.addRefInstanceSeqItem(dicomElement, conciseVolumeReferenceInfo);
                }
            } else {
                this.addRefInstanceSeqItem(dicomElement, this.srcInfo);
            }
        }

        public void buildEmbeddedDestReferencedImageSequence(DicomObject dicomObject) {
            if (this.destInfo == null || this.destInfo.isTemplate()) {
                return;
            }
            DicomElement dicomElement = dicomObject.putSequence(528704);
            this.addRefImageSeqItems(dicomElement, this.destInfo);
        }

        public void buildEmbeddedSourceReferencedImageSequence(DicomObject dicomObject) {
            DicomElement dicomElement = dicomObject.putSequence(528704);
            this.addRefImageSeqItems(dicomElement, this.srcInfo);
        }

        public void buildScorisSequence(DicomObject dicomObject) {
            if (this.destInfo == null || this.destInfo.isTemplate()) {
                return;
            }
            DicomElement dicomElement = dicomObject.putSequence(528896);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            DicomElement dicomElement2 = basicDicomObject.putSequence(528661);
            this.addRefInstanceSeqItem(dicomElement2, this.destInfo);
            if (this.srcInfo != null) {
                basicDicomObject.putString(0x20000D, null, this.srcInfo.getStudyInstanceUID());
            }
        }

        protected void addRefInstanceSeqItem(DicomElement dicomElement, ConciseVolumeReferenceInfo conciseVolumeReferenceInfo) {
            if (conciseVolumeReferenceInfo == null || conciseVolumeReferenceInfo.isTemplate()) {
                return;
            }
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            DicomElement dicomElement2 = basicDicomObject.putSequence(528714);
            for (String string : conciseVolumeReferenceInfo.sops) {
                if (cn.h(string)) continue;
                BasicDicomObject basicDicomObject2 = new BasicDicomObject();
                dicomElement2.addDicomObject((DicomObject)basicDicomObject2);
                basicDicomObject2.putString(528720, null, conciseVolumeReferenceInfo.info.sopClassUID);
                basicDicomObject2.putString(528725, null, string);
            }
            basicDicomObject.putString(0x20000E, null, conciseVolumeReferenceInfo.info.ag());
        }

        protected void addRefImageSeqItems(DicomElement dicomElement, ConciseVolumeReferenceInfo conciseVolumeReferenceInfo) {
            if (conciseVolumeReferenceInfo == null || conciseVolumeReferenceInfo.isTemplate()) {
                return;
            }
            for (String string : conciseVolumeReferenceInfo.sops) {
                if (cn.h(string)) continue;
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject);
                basicDicomObject.putString(528720, null, conciseVolumeReferenceInfo.info.sopClassUID);
                basicDicomObject.putString(528725, null, string);
            }
        }

        protected void addPostDeformationMatrixItem(DicomElement dicomElement) {
            DcmDeformableRegWriter.addPostDeformationMatrixSeq(dicomElement);
        }

        public void setDestInfoInternal(ConciseVolumeReferenceInfo conciseVolumeReferenceInfo) {
            this.destInfo = conciseVolumeReferenceInfo;
        }
    }

    public static class ConciseVolumeReferenceInfo
    implements Serializable {
        private static final long serialVersionUID = -7034872947420522928L;
        SeriesInfo info;
        ViewController.TemplateType templateType = ViewController.TemplateType.c;
        public List<String> sops = Lists.newArrayList();

        public ConciseVolumeReferenceInfo(ImageVolumeShort imageVolumeShort) {
            List<SliceInfo> list;
            this.info = imageVolumeShort.I();
            if (imageVolumeShort.j() != null) {
                this.templateType = imageVolumeShort.j().aB();
            }
            if ((list = imageVolumeShort.at()) == null) {
                list = imageVolumeShort.ab();
            }
            for (SliceInfo sliceInfo : Lists.newArrayList((Iterable)Iterables.filter(list, (Predicate)Predicates.notNull()))) {
                this.sops.add(sliceInfo.sopInstanceUID);
            }
        }

        public ConciseVolumeReferenceInfo() {
        }

        public ConciseVolumeReferenceInfo(ConciseVolumeReferenceInfo conciseVolumeReferenceInfo) {
            this.info = conciseVolumeReferenceInfo.info.m();
            this.sops.addAll(conciseVolumeReferenceInfo.sops);
        }

        public String getStudyInstanceUID() {
            if (this.info.studyUID == null) {
                return "";
            }
            return this.info.studyUID;
        }

        public ConciseVolumeReferenceInfo clone() {
            return new ConciseVolumeReferenceInfo(this);
        }

        public String getPatientName() {
            return this.info.patientName;
        }

        public String getPatientId() {
            return this.info.patientId;
        }

        public boolean isTemplate() {
            return this.templateType != ViewController.TemplateType.c;
        }
    }
}

