/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write.rtst;

import com.google.common.collect.Lists;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ContourSliceProvider {
    public abstract List<Pair<SliceInfo, ContourSlice>> getContourSliceIterator();

    public static ContourSliceProvider getContourSliceProvider(Contour contour, boolean bl2) {
        if (bl2 || contour.a().getUncopiedMutableInfo().modality.equalsIgnoreCase("NM") || contour.a().getUncopiedMutableInfo().mimDerivedVolume) {
            return new UniformContourSliceProvider(contour);
        }
        return new NonuniformContourSliceProvider(contour);
    }

    public static class NonuniformContourSliceProvider
    extends ContourSliceProvider {
        private Contour c;

        public NonuniformContourSliceProvider(Contour contour) {
            this.c = contour;
        }

        @Override
        public List<Pair<SliceInfo, ContourSlice>> getContourSliceIterator() {
            ArrayList arrayList = Lists.newArrayList();
            ImageVolumeShort imageVolumeShort = (ImageVolumeShort)this.c.a();
            List<SliceInfo> list = imageVolumeShort.at();
            if (list == null) {
                list = imageVolumeShort.ab();
            }
            for (SliceInfo sliceInfo : list) {
                DicomPoint3f dicomPoint3f = new DicomPoint3f(sliceInfo.sliceDicomCenter[0], sliceInfo.sliceDicomCenter[1], sliceInfo.sliceDicomCenter[2], imageVolumeShort);
                VoxelPoint3f voxelPoint3f = dicomPoint3f.b();
                float f2 = voxelPoint3f.z * (float)this.c.v()[2];
                int n2 = (int)f2;
                ContourSlice contourSlice = this.c.c(n2);
                if (contourSlice == null) continue;
                arrayList.add(Pair.get(sliceInfo, contourSlice));
            }
            return arrayList;
        }
    }

    public static class UniformContourSliceProvider
    extends ContourSliceProvider {
        private Contour c;

        public UniformContourSliceProvider(Contour contour) {
            this.c = contour;
        }

        @Override
        public List<Pair<SliceInfo, ContourSlice>> getContourSliceIterator() {
            boolean bl2 = DcmWriterFactory.isMultiframeModality(this.c.a().getUncopiedMutableInfo().modality);
            ArrayList arrayList = Lists.newArrayList();
            ImageVolumeShort imageVolumeShort = (ImageVolumeShort)this.c.a();
            List<Integer> list = this.c.u();
            Collections.sort(list);
            for (int n2 : list) {
                ContourSlice contourSlice = this.c.d(n2);
                SliceInfo sliceInfo = imageVolumeShort.c(n2).a();
                if (bl2) {
                    sliceInfo.sopInstanceUID = null;
                }
                float f2 = (float)n2 / (float)this.c.v()[2];
                VoxelPoint3f voxelPoint3f = new VoxelPoint3f(0.0f, 0.0f, f2 + 0.5f, imageVolumeShort);
                sliceInfo.sliceDicomCenter = voxelPoint3f.b().d().f();
                arrayList.add(Pair.get(sliceInfo, contourSlice));
            }
            return arrayList;
        }
    }
}

