/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write.rtst;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.d;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.AbstractRtStructLoader;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.write.rtst.ContourSliceProvider;
import com.mimvista.internals.AssistedAlignmentWrapper;
import com.mimvista.internals.Contour;
import com.mimvista.internals.ContourSlice;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleDicomContourCreator;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.o;
import com.mimvista.internals.t;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.findings.Finding;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.AbstractPeakSphereOverlay;
import com.mimvista.mui.overlays.AnnotationOverlay;
import com.mimvista.mui.overlays.ChrontourOverlay;
import com.mimvista.mui.overlays.MoveableOverlayish;
import com.mimvista.mui.overlays.Overlay;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.mui.overlays.RecistPerpOverlay;
import com.mimvista.mui.overlays.TwoDContourOverlayish;
import com.mimvista.mui.overlays.TwoDMeasureOverlay;
import com.mimvista.mui.overlays.VennContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.mui.overlays.f;
import com.mimvista.mui.overlays.findings.FindingsOverlay;
import com.mimvista.mui.overlays.m;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.Polylines;
import com.mimvista.numerics.VolumePoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.contourtools.g;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.viewer.algo.b;
import java.awt.Color;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.vecmath.Tuple3f;
import org.apache.commons.lang3.ArrayUtils;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomRtStructCreator
extends b {
    public static final String ANNOTATION_POINT_ROI_NAME = "Annotation Point";
    public static final String ANNOTATION_RECIST_PERP_NAME = "RECIST Axes";
    public static final String ANNOTATION_LINE_ROI_NAME = "Measurement Line";
    public static final String ANNOTATION_MANUAL = "MANUAL";
    private String operatorName = "";
    private String structureSetLabel = "RTstruct";
    private String structureSetName = "";
    private ImageVolumeShort volume;
    private boolean canSaveEmptyContours = false;
    private boolean saveVisibleOnly = false;
    private boolean saveSingleFrameFromDynamic = false;
    private boolean simplifyContours = false;
    private boolean saveMeasurements = ContourPrefs.dontSaveMeasurements.getValue() == false;
    private boolean updateContourSaveTime = true;
    private boolean saveFindingsOnly = false;
    private List<? extends Overlayish> overlaysToWrite;
    private static String lastOperatorName = LoginChecker.getInstance().getUserFullName();

    public static synchronized void setLastOperatorName(String string) {
        lastOperatorName = string;
    }

    public static String getLastOperatorName() {
        return lastOperatorName;
    }

    public DicomRtStructCreator(ViewController3D viewController3D) {
        this(viewController3D, viewController3D.cw());
    }

    public DicomRtStructCreator(ViewController3D viewController3D, ImageVolumeShort imageVolumeShort) {
        this(viewController3D, imageVolumeShort, null);
    }

    public DicomRtStructCreator(ViewController3D viewController3D, String string) {
        this(viewController3D, viewController3D.cw(), string);
    }

    public DicomRtStructCreator(ViewController3D viewController3D, ImageVolumeShort imageVolumeShort, String string) {
        this.viewState = viewController3D;
        this.volume = imageVolumeShort;
        this.info = imageVolumeShort.getUncopiedMutableInfo();
        this.sopInstanceUID = string;
    }

    public DicomRtStructCreator(List<? extends Overlayish> list) {
        this.volume = (ImageVolumeShort)list.get(0).ao();
        this.viewState = list.get(0).au();
        this.overlaysToWrite = list;
        this.info = this.volume.I();
    }

    @Override
    public String getProgressTitle() {
        return Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE");
    }

    @Override
    public Modality getModality() {
        return Modality.RTST;
    }

    @Override
    public UIDContainer getSopClassUID() {
        return new UIDContainer.SOPClassUID("1.2.840.10008.5.1.4.1.1.481.3");
    }

    @Override
    public String getSeriesDate() {
        return DateUtils.e();
    }

    @Override
    public String getSeriesTime() {
        return DateUtils.f();
    }

    @Override
    public String getSeriesDescription() {
        String string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String string2 = simpleDateFormat.format(Calendar.getInstance().getTime());
        StringBuilder stringBuilder = new StringBuilder();
        if (DicomPrefs.seriesDescPrependTimestamp.getValue().booleanValue()) {
            stringBuilder.append(string2);
        }
        if (DicomPrefs.seriesDescPrependOperator.getValue().booleanValue()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(this.operatorName);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(": ");
        }
        stringBuilder.append(this.seriesDescription + (this.simplifyContours ? ".simplified" : ""));
        if (this.saveSingleFrameFromDynamic && !cn.g(string = this.volume.getUncopiedMutableInfo().seriesDesc)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(string);
            FrameNumber frameNumber = this.getFrameNumber();
            if (frameNumber != null) {
                stringBuilder.append(" (frame " + frameNumber.a() + ")");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getOperatorName() {
        return this.operatorName;
    }

    public void setSaveMeasurements(boolean bl2) {
        this.saveMeasurements = bl2;
    }

    public void setUpdateContourSaveTime(boolean bl2) {
        this.updateContourSaveTime = bl2;
    }

    public void setOperatorName(String string) {
        this.operatorName = string;
    }

    private FrameNumber getFrameNumber() {
        try {
            o o2 = ((ViewController3D)this.viewState).cE();
            FrameNumber frameNumber = o2.a((SimpleImageVolume<ImageCube.ImageCubeShort>)this.volume);
            return frameNumber;
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error in getting frame number", throwable, this);
            return null;
        }
    }

    private boolean hasAllEmptyContours(List<? extends Overlayish> list) {
        for (Overlayish overlayish : list) {
            if (overlayish instanceof MoveableOverlayish && ((MoveableOverlayish)overlayish).ay_() && this.saveMeasurements) {
                return false;
            }
            if (overlayish instanceof TwoDContourOverlayish && !((TwoDContourOverlayish)overlayish).f()) {
                return false;
            }
            if (overlayish instanceof VolumetricContourOverlayish) {
                VolumetricContourOverlayish volumetricContourOverlayish = (VolumetricContourOverlayish)overlayish;
                if (volumetricContourOverlayish.K()) continue;
                if (!volumetricContourOverlayish.A_()) {
                    return false;
                }
            }
            if (!(overlayish instanceof PointContourOverlay)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        Serializable serializable;
        Object object;
        if (this.volume.ak()) {
            ay.b((Object)"Declined to create RtStruct from atlas volume.", this);
            throw new SavingAtlasContoursException();
        }
        List<? extends Overlayish> list = this.findOverlaysToWrite();
        ArrayList arrayList = Lists.newArrayList();
        if (!this.saveMeasurements) {
            object = list.listIterator();
            while (object.hasNext()) {
                serializable = object.next();
                if (!(serializable instanceof MoveableOverlayish)) continue;
                arrayList.add(serializable);
                object.remove();
            }
        }
        if (!this.canSaveEmptyContours && this.hasAllEmptyContours(list)) {
            throw new SavingEmptyContourException();
        }
        object = this.getIdListAndMap(list);
        this.buildBasicHeader(dicomObject);
        this.buildSeriesInfo(dicomObject);
        this.buildReferencedFrameOfRefSequence(dicomObject);
        this.buildStructureSetRoiSequence(dicomObject, list, (List)((Pair)object).x);
        this.buildRoiContourSequence(dicomObject, list, (List)((Pair)object).x);
        this.buildObservationSequence(dicomObject, list, (List)((Pair)object).x);
        if (!arrayList.isEmpty()) {
            serializable = this.getIdListAndMap(arrayList);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomObject.putNestedDicomObject(930295846, (DicomObject)basicDicomObject);
            this.buildStructureSetRoiSequence((DicomObject)basicDicomObject, arrayList, (List)((Pair)serializable).x);
            this.buildRoiContourSequence((DicomObject)basicDicomObject, arrayList, (List)((Pair)serializable).x);
            this.buildObservationSequence((DicomObject)basicDicomObject, arrayList, (List)((Pair)serializable).x);
        }
        this.buildMulticontourDataSequence(dicomObject, list, (Map)((Pair)object).y);
        this.buildVoxelMultipliedDataSequence(dicomObject, list, (List)((Pair)object).x);
        dicomObject.putFloats(930295820, VR.DS, this.volume.getUncopiedMutableInfo().origImageOrientation);
        long l2 = System.currentTimeMillis();
        if (this.updateContourSaveTime) {
            for (Overlayish overlayish : list) {
                if (!(overlayish instanceof AbstractContourOverlayish)) continue;
                ((AbstractContourOverlayish)overlayish).b(l2);
            }
        }
    }

    private Pair<List<Integer>, Map<Long, Long>> getIdListAndMap(List<? extends Overlayish> list) {
        ArrayList arrayList = Lists.newArrayList();
        HashMap hashMap = Maps.newHashMap();
        long l2 = 1L;
        for (Overlayish overlayish : list) {
            if (overlayish.aG() != -1L) {
                hashMap.put(overlayish.aG(), l2);
            }
            arrayList.add((int)l2);
            ++l2;
        }
        return Pair.get(arrayList, hashMap);
    }

    private List<? extends Overlayish> findOverlaysToWrite() {
        List list;
        if (this.overlaysToWrite != null) {
            return this.overlaysToWrite;
        }
        HashSet hashSet = Sets.newHashSet();
        for (Overlayish object : this.volume.n().h()) {
            this.addOverlayToListIfSavable(object, hashSet);
        }
        if (this.viewState.bl() && !this.saveSingleFrameFromDynamic) {
            list = ((ViewController3D)this.viewState).cE();
            for (ImageVolumeShort imageVolumeShort : list) {
                if (imageVolumeShort == this.volume) continue;
                for (Overlayish overlayish2 : imageVolumeShort.n().h()) {
                    this.addOverlayToListIfSavable(overlayish2, hashSet);
                }
            }
        }
        list = hashSet.stream().filter(overlayish -> !this.saveVisibleOnly || !overlayish.an()).filter(overlayish -> !this.saveFindingsOnly || overlayish.I_()).collect(Collectors.toList());
        Collections.sort(list, new Comparator<Overlayish>(){

            @Override
            public int compare(Overlayish overlayish, Overlayish overlayish2) {
                long l2 = overlayish.aG();
                long l3 = overlayish2.aG();
                l2 = l2 < 0L ? Long.MAX_VALUE : l2;
                l3 = l3 < 0L ? Long.MAX_VALUE : l3;
                return new Long(l2).compareTo(new Long(l3));
            }
        });
        return list;
    }

    protected void addOverlayToListIfSavable(Overlayish overlayish, Set<Overlayish> set) {
        if (overlayish instanceof RecistPerpOverlay && !(overlayish instanceof TwoDMeasureOverlay)) {
            set.add(((RecistPerpOverlay)overlayish).z());
            set.add(((RecistPerpOverlay)overlayish).C());
        } else if (overlayish instanceof ChrontourOverlay) {
            ChrontourOverlay chrontourOverlay = (ChrontourOverlay)overlayish;
            boolean bl2 = false;
            for (ChrontourOverlay chrontourOverlay2 : chrontourOverlay.bT_()) {
                bl2 |= set.contains(chrontourOverlay2);
            }
            if (!bl2) {
                set.add(overlayish);
            }
        } else if (!(overlayish instanceof m)) {
            set.add(overlayish);
        }
    }

    protected void buildBasicHeader(DicomObject dicomObject) {
        dicomObject.putString(805699586, VR.SH, this.structureSetLabel);
        dicomObject.putString(805699588, VR.LO, this.structureSetName);
        dicomObject.putString(805699592, VR.DA, DateUtils.e());
        dicomObject.putString(805699593, VR.TM, DateUtils.f());
        dicomObject.putString(806223874, VR.CS, "UNAPPROVED");
    }

    protected void buildSeriesInfo(DicomObject dicomObject) {
        dicomObject.putString(0x37730030, VR.LO, "MIM Software Inc.");
        if (this.viewState != null) {
            if (this.viewState.e()) {
                dicomObject.putString(930295832, VR.LO, AssistedAlignmentWrapper.StudyType.b.name());
            } else if (this.viewState.bm()) {
                dicomObject.putString(930295832, VR.LO, AssistedAlignmentWrapper.StudyType.a.name());
            } else {
                dicomObject.putString(930295832, VR.LO, AssistedAlignmentWrapper.StudyType.d.name());
            }
        } else {
            dicomObject.putString(930295832, VR.LO, AssistedAlignmentWrapper.StudyType.d.name());
        }
    }

    protected void buildReferencedFrameOfRefSequence(DicomObject dicomObject) {
        Object object;
        t t2;
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        BasicDicomObject basicDicomObject3 = new BasicDicomObject();
        basicDicomObject2.putNestedDicomObject(805699604, (DicomObject)basicDicomObject3);
        basicDicomObject.putNestedDicomObject(805699602, (DicomObject)basicDicomObject2);
        dicomObject.putNestedDicomObject(805699600, (DicomObject)basicDicomObject);
        basicDicomObject.putString(0x200052, VR.UI, this.info.frameOfRefUID);
        basicDicomObject2.putString(528720, VR.UI, "1.2.840.10008.3.1.2.3.1");
        basicDicomObject2.putString(528725, VR.UI, this.info.studyUID);
        if (this.volume.s() && this.viewState.bf()) {
            t2 = this.viewState.au();
            object = new int[t2.n()];
            for (int i2 = 0; i2 < ((int[])object).length; ++i2) {
                object[i2] = t2.b(i2).c();
            }
            dicomObject.putInts(930291984, VR.IS, (int[])object);
        }
        basicDicomObject3.putString(0x20000E, VR.UI, this.info.ah());
        t2 = basicDicomObject3.putSequence(805699606);
        object = this.volume.at();
        if (object == null) {
            object = this.volume.ab();
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            SliceInfo sliceInfo = (SliceInfo)iterator.next();
            BasicDicomObject basicDicomObject4 = new BasicDicomObject();
            t2.addDicomObject((DicomObject)basicDicomObject4);
            basicDicomObject4.putString(528720, VR.UI, this.info.sopClassUID);
            basicDicomObject4.putString(528725, VR.UI, sliceInfo.sopInstanceUID);
        }
    }

    protected void buildStructureSetRoiSequence(DicomObject dicomObject, List<? extends Overlayish> list, List<Integer> list2) {
        DicomElement dicomElement = dicomObject.putSequence(805699616);
        int n2 = 0;
        for (Overlayish overlayish : list) {
            int n3 = list2.get(n2++);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putInt(805699618, VR.IS, n3);
            basicDicomObject.putString(805699620, VR.UI, this.info.frameOfRefUID);
            this.addOverlayStructureSetROISequence(basicDicomObject, overlayish);
        }
    }

    private void addOverlayStructureSetROISequence(BasicDicomObject basicDicomObject, Overlayish overlayish) {
        String string = overlayish.getName();
        if (cn.g(string)) {
            string = MIMFormat.a(ViewController.e.getProperty("NUMBERED_OVERLAY"), ViewController.e.getProperty(overlayish.D_().a()), "");
        }
        basicDicomObject.putString(805699622, VR.LO, string);
        basicDicomObject.putString(805699624, VR.ST, overlayish.B_());
        basicDicomObject.putString(0x30060036, VR.CS, ANNOTATION_MANUAL);
    }

    protected void buildRoiContourSequence(DicomObject dicomObject, List<? extends Overlayish> list, List<Integer> list2) {
        DicomElement dicomElement = dicomObject.putSequence(805699641);
        int n2 = 0;
        for (Overlayish overlayish : list) {
            int n3 = list2.get(n2);
            ++n2;
            Color color = overlayish.bn_();
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            RawDicomUtils.addRoiDisplayColor((DicomObject)basicDicomObject, color);
            basicDicomObject.putInt(805699716, VR.IS, n3);
            this.buildContourSequence(basicDicomObject, overlayish);
        }
    }

    protected void buildMulticontourDataSequence(DicomObject dicomObject, List<? extends Overlayish> list, Map<Long, Long> map) {
        boolean bl2 = false;
        for (Overlayish object : list) {
            if (!(object instanceof VennContourOverlay)) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        DicomElement dicomElement = dicomObject.putSequence(930283792);
        for (Overlayish overlayish : list) {
            if (!(overlayish instanceof VennContourOverlay)) continue;
            VennContourOverlay vennContourOverlay = (VennContourOverlay)overlayish;
            int n2 = map.get(vennContourOverlay.aG()).intValue();
            for (Contour contour : vennContourOverlay.at()) {
                VolumetricContourOverlay volumetricContourOverlay = f.a(vennContourOverlay.au(), contour);
                volumetricContourOverlay.am().c();
                Color color = vennContourOverlay.V();
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject);
                basicDicomObject.putInts(805699626, VR.IS, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
                basicDicomObject.putInt(805699716, VR.IS, n2);
                this.buildContourSequence(basicDicomObject, volumetricContourOverlay);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void buildVoxelMultipliedDataSequence(DicomObject dicomObject, List<? extends Overlayish> list, List<Integer> list2) {
        boolean bl2 = false;
        for (Overlayish overlayish : list) {
            Object object;
            if (overlayish instanceof VolumetricContourOverlayish) {
                object = (VolumetricContourOverlayish)overlayish;
                if (object.aq().v()[2] == 1) continue;
                bl2 = true;
                break;
            }
            if (!(overlayish instanceof ChrontourOverlay) || ((ChrontourOverlay)(object = (ChrontourOverlay)overlayish)).aq().v()[2] == 1) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            return;
        }
        DicomElement dicomElement = dicomObject.putSequence(930283794);
        boolean n2 = false;
        for (Overlayish overlayish : list) {
            VolumetricContourOverlayish volumetricContourOverlayish;
            void var6_8;
            if (!(overlayish instanceof VolumetricContourOverlayish) && !(overlayish instanceof ChrontourOverlay)) continue;
            int n3 = list2.get((int)var6_8);
            ++var6_8;
            Color color = overlayish.bn_();
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putInts(805699626, VR.IS, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
            basicDicomObject.putInt(805699716, VR.IS, n3);
            DicomElement dicomElement2 = basicDicomObject.putSequence(805699648);
            if (overlayish instanceof ChrontourOverlay) {
                volumetricContourOverlayish = (ChrontourOverlay)overlayish;
                this.buildContourSeqForceMultiframe(dicomElement2, (ChrontourOverlay)volumetricContourOverlayish);
                continue;
            }
            if (!(overlayish instanceof VolumetricContourOverlayish)) continue;
            volumetricContourOverlayish = (VolumetricContourOverlayish)overlayish;
            this.buildContourSeqForceMultiframe(dicomElement2, volumetricContourOverlayish);
        }
    }

    protected void buildContourSequence(BasicDicomObject basicDicomObject, Overlayish overlayish) {
        DicomElement dicomElement = basicDicomObject.putSequence(805699648);
        if (overlayish instanceof PointContourOverlay) {
            this.buildContourSeq(dicomElement, (PointContourOverlay)overlayish);
        } else if (overlayish instanceof ChrontourOverlay) {
            this.buildContourSeq(dicomElement, (ChrontourOverlay)overlayish);
        } else if (overlayish instanceof TwoDContourOverlayish) {
            this.buildContourSeq(dicomElement, (TwoDContourOverlayish)overlayish);
        } else if (overlayish instanceof VolumetricContourOverlayish) {
            this.buildContourSeq(dicomElement, (VolumetricContourOverlayish)overlayish);
        } else if (overlayish instanceof AnnotationOverlay) {
            this.buildContourSeq(dicomElement, (AnnotationOverlay)overlayish, "POINT");
        } else if (overlayish instanceof MoveableOverlayish && ((MoveableOverlayish)overlayish).ay_()) {
            this.buildContourSeq(dicomElement, (MoveableOverlayish)overlayish, "OPEN_NONPLANAR");
        }
    }

    private void buildContourSeq(DicomElement dicomElement, TwoDContourOverlayish twoDContourOverlayish) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        float[] fArray = twoDContourOverlayish.ak();
        basicDicomObject.putString(805699650, VR.CS, "CLOSED_PLANAR");
        basicDicomObject.putInt(805699654, VR.IS, fArray.length / 3);
        this.addContourImageSequence(basicDicomObject, twoDContourOverlayish.aa());
        basicDicomObject.putFloats(805699664, VR.DS, fArray);
    }

    private void buildContourSeq(DicomElement dicomElement, MoveableOverlayish moveableOverlayish, String string) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(805699650, VR.CS, string);
        MetricPoint3f[] metricPoint3fArray = moveableOverlayish.t();
        basicDicomObject.putInt(805699654, VR.IS, metricPoint3fArray.length);
        DicomPoint3f[] dicomPoint3fArray = new DicomPoint3f[metricPoint3fArray.length];
        float[] fArray = new float[3 * metricPoint3fArray.length];
        for (int i2 = 0; i2 < metricPoint3fArray.length; ++i2) {
            dicomPoint3fArray[i2] = metricPoint3fArray[i2].d();
            for (int i3 = 0; i3 < 3; ++i3) {
                fArray[3 * i2 + i3] = dicomPoint3fArray[i2].b(i3);
            }
        }
        this.addContourImageSequenceForPointContours(basicDicomObject, this.getFrameNumberFor(moveableOverlayish), dicomPoint3fArray);
        basicDicomObject.putTruncatedFloatsToDS(805699664, fArray, 3);
    }

    private void buildContourSeq(DicomElement dicomElement, PointContourOverlay pointContourOverlay) {
        FrameNumber frameNumber = this.getFrameNumberFor(pointContourOverlay);
        int n2 = 1;
        for (DicomPoint3f dicomPoint3f : pointContourOverlay.a()) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(805699650, VR.CS, "POINT");
            basicDicomObject.putInt(805699654, VR.IS, 1);
            basicDicomObject.putInt(805699656, VR.IS, n2++);
            this.addContourImageSequenceForPointContours(basicDicomObject, frameNumber, dicomPoint3f);
            basicDicomObject.putTruncatedFloatsToDS(805699664, dicomPoint3f.f(), 3);
        }
    }

    private FrameNumber getFrameNumberFor(Overlayish overlayish) {
        if (this.viewState.bl() && overlayish.aH() != null) {
            return overlayish.aH();
        }
        return null;
    }

    private void buildContourSeqForceMultiframe(DicomElement dicomElement, VolumetricContourOverlayish volumetricContourOverlayish) {
        ContourSliceProvider contourSliceProvider = ContourSliceProvider.getContourSliceProvider(volumetricContourOverlayish.aq(), true);
        this.buildContourSeq(dicomElement, volumetricContourOverlayish.aq(), contourSliceProvider, null);
    }

    private void buildContourSeqForceMultiframe(DicomElement dicomElement, ChrontourOverlay chrontourOverlay) {
        this.buildContourSeq(dicomElement, chrontourOverlay, true);
    }

    private void buildContourSeq(DicomElement dicomElement, VolumetricContourOverlayish volumetricContourOverlayish) {
        ContourSliceProvider contourSliceProvider = ContourSliceProvider.getContourSliceProvider(volumetricContourOverlayish.aq(), false);
        this.buildContourSeq(dicomElement, volumetricContourOverlayish.aq(), contourSliceProvider, null);
    }

    private void buildContourSeq(DicomElement dicomElement, ChrontourOverlay chrontourOverlay) {
        this.buildContourSeq(dicomElement, chrontourOverlay, false);
    }

    private FrameNumber getRealFrameNumber(int n2) {
        if (this.volume.getUncopiedMutableInfo().isMultiSeries4d) {
            ViewController3D viewController3D = (ViewController3D)this.viewState;
            ImageFrame imageFrame = (ImageFrame)viewController3D.cE().c(n2);
            return imageFrame.getUncopiedMutableInfo().frameNumFromSeriesDesc;
        }
        return new FrameNumber(n2 + 1);
    }

    private void buildContourSeq(DicomElement dicomElement, ChrontourOverlay chrontourOverlay, boolean bl2) {
        Map<Contour, Set<Integer>> map = chrontourOverlay.at();
        int n2 = chrontourOverlay.bR_().a((SimpleImageVolume<ImageCube.ImageCubeShort>)this.volume).a();
        for (Map.Entry<Contour, Set<Integer>> entry : map.entrySet()) {
            Object object;
            Set<Integer> set = entry.getValue();
            Object object2 = new int[set.size()];
            int n3 = 0;
            for (Integer n4 : set) {
                int n5 = this.getRealFrameNumber(n4).a();
                if (this.saveSingleFrameFromDynamic && n5 != n2) continue;
                object2[n3++] = n5;
            }
            if (n3 < ((int[])object2).length) {
                object = new int[n3];
                System.arraycopy(object2, 0, object, 0, n3);
                object2 = object;
            }
            if (this.saveSingleFrameFromDynamic && !ArrayUtils.contains((int[])object2, (int)n2)) continue;
            object = ContourSliceProvider.getContourSliceProvider(entry.getKey(), bl2);
            if (this.saveSingleFrameFromDynamic && ((ViewController3D)this.viewState).cD() && !bl2) {
                object2 = null;
            }
            this.buildContourSeq(dicomElement, entry.getKey(), (ContourSliceProvider)object, (int[])object2);
        }
    }

    private SlicePolygonProvider getPolygonProvider(Contour contour) {
        SlicePolygonProvider slicePolygonProvider = this.simplifyContours ? new SimplifiedPolygonProvider(contour) : new NormalPolygonProvider();
        return slicePolygonProvider;
    }

    private void buildContourSeq(DicomElement dicomElement, Contour contour, ContourSliceProvider contourSliceProvider, @d int[] nArray) {
        SlicePolygonProvider slicePolygonProvider = this.getPolygonProvider(contour);
        for (Pair<SliceInfo, ContourSlice> pair : contourSliceProvider.getContourSliceIterator()) {
            SliceInfo sliceInfo = (SliceInfo)pair.x;
            ContourSlice contourSlice = (ContourSlice)pair.y;
            if (contourSlice == null) continue;
            this.buildContourSeqData(dicomElement, contour, slicePolygonProvider.getPolygonsForSlice(contourSlice, contour), sliceInfo, nArray);
        }
    }

    private void buildContourSeqData(DicomElement dicomElement, Contour contour, List<Polylines.VoxelPolyline2f> list, SliceInfo sliceInfo, @d int[] nArray) {
        if (!ContourPrefs.suppressKeyholing.getValue().booleanValue() && list.size() > 1) {
            com.mimvista.contouring.b.a(list);
        }
        for (Polylines.VoxelPolyline2f voxelPolyline2f : list) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            DicomPoint3f dicomPoint3f = new DicomPoint3f(sliceInfo.sliceDicomCenter, (SimpleImageFrame)this.volume);
            float[] fArray = this.getPolygonDicomPoints(voxelPolyline2f, dicomPoint3f);
            basicDicomObject.putString(805699650, VR.CS, "CLOSED_PLANAR");
            basicDicomObject.putInt(805699654, VR.IS, fArray.length / 3);
            this.addContourImageSequence(basicDicomObject, sliceInfo, nArray);
            basicDicomObject.putTruncatedFloatsToDS(805699664, fArray, 3);
        }
    }

    private float[] getPolygonDicomPoints(Polylines.VoxelPolyline2f voxelPolyline2f, DicomPoint3f dicomPoint3f) {
        Point3f point3f;
        VolumePoint3f volumePoint3f;
        int n2 = voxelPolyline2f.h();
        float[] fArray = new float[3 * n2];
        boolean bl2 = false;
        ArrayList<VoxelPoint3f> arrayList = new ArrayList<VoxelPoint3f>();
        MetricPoint3f metricPoint3f = dicomPoint3f.c();
        float f2 = dicomPoint3f.b().c().z;
        int n3 = 0;
        for (Object object : voxelPolyline2f) {
            VoxelPoint3f voxelPoint3f = new VoxelPoint3f(((Point2f)((Object)object)).x, ((Point2f)((Object)object)).y, f2, this.volume);
            volumePoint3f = voxelPoint3f.b();
            volumePoint3f.z = metricPoint3f.z;
            point3f = volumePoint3f.d();
            fArray[n3] = point3f.x;
            fArray[n3 + 1] = point3f.y;
            fArray[n3 + 2] = point3f.z;
            n3 += 3;
            if (!bl2) continue;
            arrayList.add(voxelPoint3f);
        }
        if (bl2) {
            Object object;
            boolean bl3 = true;
            object = SimpleDicomContourCreator.a(new AbstractRtStructLoader.PointSet(fArray), (SimpleImageFrame)this.volume);
            for (int i2 = 0; i2 < voxelPolyline2f.h(); ++i2) {
                volumePoint3f = (VoxelPoint3f)((Object)arrayList.get(i2));
                if (volumePoint3f.epsilonEquals((Tuple3f)(point3f = (Point3f)((Object)object.get(i2))), 0.001f)) continue;
                bl3 = false;
            }
            if (!bl3) {
                System.out.println("Contour point conversion not symmetric!");
            }
        }
        return fArray;
    }

    private void addContourImageSequenceForPointContours(BasicDicomObject basicDicomObject, FrameNumber frameNumber, DicomPoint3f ... dicomPoint3fArray) {
        DicomElement dicomElement = basicDicomObject.putSequence(805699606);
        HashSet hashSet = Sets.newHashSet();
        for (DicomPoint3f dicomPoint3f : dicomPoint3fArray) {
            String string;
            Pair<SliceInfo, Float> pair = SimpleImageVolume.a(this.volume, dicomPoint3f);
            if (pair == null || pair.x == null || (string = ((SliceInfo)pair.x).sopInstanceUID) == null) continue;
            hashSet.add(string);
        }
        if (hashSet.isEmpty()) {
            BasicDicomObject basicDicomObject2 = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject2);
            basicDicomObject2.putString(528725, VR.UI, null);
            basicDicomObject2.putString(528720, VR.UI, this.info.sopClassUID);
            if (frameNumber != null) {
                basicDicomObject2.putInts(528736, VR.IS, new int[]{frameNumber.a()});
            }
        } else {
            for (String string : hashSet) {
                BasicDicomObject basicDicomObject3 = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject3);
                basicDicomObject3.putString(528725, VR.UI, string);
                basicDicomObject3.putString(528720, VR.UI, this.info.sopClassUID);
                if (frameNumber == null) continue;
                basicDicomObject3.putInts(528736, VR.IS, new int[]{frameNumber.a()});
            }
        }
    }

    private void addContourImageSequence(BasicDicomObject basicDicomObject, float ... fArray) {
        DicomElement dicomElement = basicDicomObject.putSequence(805699606);
        for (float f2 : fArray) {
            BasicDicomObject basicDicomObject2 = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject2);
            SliceInfo sliceInfo = this.volume.c(Math.round(f2));
            basicDicomObject2.putString(528725, VR.UI, sliceInfo.sopInstanceUID);
            basicDicomObject2.putString(528720, VR.UI, this.info.sopClassUID);
        }
    }

    private void addContourImageSequence(BasicDicomObject basicDicomObject, SliceInfo sliceInfo, @d int[] nArray) {
        DicomElement dicomElement = basicDicomObject.putSequence(805699606);
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject2);
        String string = sliceInfo.sopInstanceUID;
        basicDicomObject2.putString(528725, VR.UI, string);
        basicDicomObject2.putString(528720, VR.UI, this.info.sopClassUID);
        if (nArray != null && nArray.length > 0) {
            basicDicomObject2.putInts(528736, VR.IS, nArray);
        }
    }

    protected void buildObservationSequence(DicomObject dicomObject, List<? extends Overlayish> list, List<Integer> list2) {
        DicomElement dicomElement = dicomObject.putSequence(805699712);
        int n2 = 0;
        for (Overlayish overlayish : list) {
            Overlay overlay;
            PresentationType presentationType;
            AbstractContourOverlayish abstractContourOverlayish;
            int n3 = list2.get(n2);
            ++n2;
            boolean bl2 = false;
            String string = "";
            if (overlayish.u()) {
                abstractContourOverlayish = (AbstractContourOverlayish)overlayish;
                bl2 = abstractContourOverlayish.z() == OverlayishBase.InterpretedType.f;
                string = abstractContourOverlayish.z().c();
                if (string.equalsIgnoreCase("NONE")) {
                    string = "";
                }
            }
            abstractContourOverlayish = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)abstractContourOverlayish);
            abstractContourOverlayish.putInt(805699714, VR.IS, n2);
            abstractContourOverlayish.putInt(805699716, VR.IS, n3);
            String string2 = overlayish.Q();
            Finding finding = overlayish.aU();
            if (finding != null) {
                string2 = string2 + ", finding:" + finding.getName();
            }
            if (overlayish instanceof FindingsOverlay && (presentationType = ((FindingsOverlay)(overlay = (FindingsOverlay)overlayish)).A()) != null) {
                string2 = string2 + ", plane:" + presentationType.name();
            }
            if (bl2 && ContourPrefs.writePatientForExternalStructureDescription.getValue().booleanValue()) {
                abstractContourOverlayish.putString(805699720, VR.ST, "patient");
            } else {
                abstractContourOverlayish.putString(805699720, VR.ST, string2);
            }
            if ((overlayish instanceof RecistPerpOverlay.RecistPerpLine || overlayish instanceof AbstractPeakSphereOverlay) && overlayish.aQ() != null) {
                ChrontourOverlay chrontourOverlay;
                int n4;
                overlay = overlayish.aQ();
                if (overlayish instanceof RecistPerpOverlay.RecistPerpLine && overlay.aQ() != null) {
                    overlay = overlay.aQ();
                }
                if ((n4 = list.indexOf(overlay)) == -1 && overlay instanceof ChrontourOverlay) {
                    chrontourOverlay = (ChrontourOverlay)overlay;
                    int n5 = chrontourOverlay.bR_().b((SimpleImageFrame)this.volume);
                    n4 = list.indexOf(chrontourOverlay.e(n5));
                }
                if (n4 != -1) {
                    chrontourOverlay = abstractContourOverlayish.putSequence(0x30060030);
                    BasicDicomObject basicDicomObject = new BasicDicomObject();
                    chrontourOverlay.addDicomObject((DicomObject)basicDicomObject);
                    basicDicomObject.putInt(805699716, VR.IS, list2.get(n4).intValue());
                    basicDicomObject.putString(0x30060033, VR.SH, "ENCLOSING");
                }
            }
            abstractContourOverlayish.putString(805699748, VR.CS, string);
            abstractContourOverlayish.putString(805699750, null, "");
            abstractContourOverlayish.putString(0x37730030, VR.LO, "MIM Software Inc.");
            try {
                abstractContourOverlayish.putBytes(930295813, VR.OB, string2.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ay.d((Object)unsupportedEncodingException, this);
                abstractContourOverlayish.putString(930295813, VR.ST, string2);
            }
        }
    }

    public void setCanSaveEmptyContours(boolean bl2) {
        this.canSaveEmptyContours = bl2;
    }

    public void setSaveVisibleContoursOnly(boolean bl2) {
        this.saveVisibleOnly = bl2;
    }

    public void setSaveFindingsOnly(boolean bl2) {
        this.saveFindingsOnly = bl2;
    }

    public void setSaveSingleFrameFromDynamic(boolean bl2) {
        this.saveSingleFrameFromDynamic = bl2;
    }

    public String getStructureSetName() {
        return this.structureSetName;
    }

    public void setStructureSetName(String string) {
        this.structureSetName = string;
    }

    public void setSimplifyContours(boolean bl2) {
        this.simplifyContours = bl2;
    }

    public static class SimplifiedPolygonProvider
    extends SlicePolygonProvider {
        Map<Integer, List<Polylines.VoxelPolyline2f>> polyMap;

        SimplifiedPolygonProvider(Contour contour) {
            ProgressPanel progressPanel = new ProgressPanel();
            progressPanel.a(false);
            progressPanel.c(true);
            progressPanel.a(Messages.a("Dicom", "DCM_RT_STRUCT_SIMPLIYING_PROG"));
            ProgressQueueNotification.a(progressPanel);
            this.polyMap = g.a(contour, progressPanel, ContourPrefs.dontSimplifyContoursWithFewerPointsThan.getValue());
            if (this.polyMap != null) {
                progressPanel.b();
            }
        }

        @Override
        public List<Polylines.VoxelPolyline2f> getPolygonsForSlice(ContourSlice contourSlice, Contour contour) {
            return this.polyMap.get(contourSlice.l());
        }
    }

    public static class NormalPolygonProvider
    extends SlicePolygonProvider {
        @Override
        public List<Polylines.VoxelPolyline2f> getPolygonsForSlice(ContourSlice contourSlice, Contour contour) {
            return contourSlice.a(contour);
        }
    }

    public static abstract class SlicePolygonProvider {
        public abstract List<Polylines.VoxelPolyline2f> getPolygonsForSlice(ContourSlice var1, Contour var2);
    }

    public static class SavingEmptyContourException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public static class SavingAtlasContoursException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }
}

