/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.bed;

import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.SimpleBEDInfo;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.dose.bed.BEDAlgorithm;
import com.mimvista.dose.bed.c;

public class BEDInfo
implements SimpleBEDInfo {
    private static final long serialVersionUID = 1L;
    public BEDAlgorithm bedModel;
    public Units bedUnit;
    public BEDAlgorithm.BEDParameterSet bedContourParams;
    public Double tcp;

    public BEDInfo(BEDAlgorithm bEDAlgorithm, Units units, BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        this.bedModel = bEDAlgorithm;
        this.bedUnit = units;
        this.bedContourParams = bEDParameterSet;
    }

    @Override
    public double calculateTCP(DoseVolumeHistogram doseVolumeHistogram) {
        if (this.tcp != null) {
            return this.tcp;
        }
        if (this.bedModel == null || this.bedContourParams == null) {
            return Double.NaN;
        }
        this.tcp = c.a(doseVolumeHistogram, this.bedUnit, this.bedModel, this.bedContourParams);
        return this.tcp;
    }

    @Override
    public Units getBEDUnit() {
        return this.bedUnit;
    }
}

