/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.bed;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.dose.bed.BEDAlgorithm;
import com.mimvista.dose.bed.BEDParameter;
import com.mimvista.dose.bed.BEDParameterFloat;
import com.mimvista.dose.bed.a;
import com.mimvista.internals.fusionmode.equation.MathEquation;
import com.mimvista.internals.fusionmode.equation.MathExpression;
import com.mimvista.internals.fusionmode.equation.MathSymbol;
import com.mimvista.util.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class LQLDRSinghModel
extends BEDAlgorithm {
    private static final long serialVersionUID = 1L;
    SinghModelParameterSet params = new SinghModelParameterSet();

    @Override
    public String a() {
        return this.g();
    }

    @Override
    public String b() {
        return "BED_SINGH_MODEL_NAME";
    }

    @Override
    public float a(BEDAlgorithm.BEDParameterSet bEDParameterSet, float f2) {
        SinghContourParameterSet singhContourParameterSet = (SinghContourParameterSet)bEDParameterSet;
        double d2 = Math.log(2.0);
        double d3 = d2 / (double)this.params.halflife.k().floatValue();
        double d4 = f2;
        double d5 = d4 * d3;
        double d6 = singhContourParameterSet.repairConstant.k().floatValue() / 24.0f;
        double d7 = d2 / d6;
        double d8 = 1.0 / d3 * Math.log(1.44 * d5 * (double)singhContourParameterSet.alpha.value * (double)singhContourParameterSet.Tp.value);
        double d9 = Math.exp(-d3 * d8);
        double d10 = Math.exp(-d7 * d8);
        double d11 = 1.0 / (1.0 - d9);
        double d12 = (1.0 - d9 * d9) / (2.0 * d3);
        double d13 = (1.0 - d9 * d10) / (d7 + d3);
        double d14 = d11 * (d12 - d13);
        double d15 = d4 * (1.0 + 2.0 * (d5 * d3) / (double)singhContourParameterSet.alphaBeta.value * (d14 / (d7 - d3)));
        return (float)(d15 -= d2 * d8 / (double)(singhContourParameterSet.alpha.value * singhContourParameterSet.Tp.value));
    }

    @Override
    public JPanel a(BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MathSymbol mathSymbol = a.a("d", "0");
        MathSymbol mathSymbol2 = a.a("\u03bb");
        MathSymbol mathSymbol3 = a.a("\u025b");
        MathSymbol mathSymbol4 = a.a("\u03bc");
        MathSymbol mathSymbol5 = a.a("k");
        MathExpression mathExpression = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.d(a.a("1"), com.mimvista.internals.fusionmode.equation.a.b(a.a("1"), mathSymbol3)));
        MathExpression mathExpression2 = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.d(com.mimvista.internals.fusionmode.equation.a.b(a.a("1"), a.b("\u025b", "2")), com.mimvista.internals.fusionmode.equation.a.c(a.a("2"), mathSymbol2)));
        MathSymbol mathSymbol6 = a.b("e", "-\u03bb*Teff");
        MathExpression mathExpression3 = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.d(com.mimvista.internals.fusionmode.equation.a.b(a.a("1"), com.mimvista.internals.fusionmode.equation.a.c(mathSymbol3, mathSymbol6)), com.mimvista.internals.fusionmode.equation.a.a((MathExpression)mathSymbol4, (MathExpression)mathSymbol2)));
        MathExpression mathExpression4 = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.d(mathSymbol5, com.mimvista.internals.fusionmode.equation.a.b(mathSymbol4, mathSymbol2)));
        MathExpression mathExpression5 = com.mimvista.internals.fusionmode.equation.a.c(a.a("D"), com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.a((MathExpression)a.a("1"), com.mimvista.internals.fusionmode.equation.a.c(a.a("2"), com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.d(com.mimvista.internals.fusionmode.equation.a.c(mathSymbol, mathSymbol2), a.f)))), mathExpression4)));
        MathExpression mathExpression6 = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.d(a.a("0.693"), a.a), com.mimvista.internals.fusionmode.equation.a.d(a.a("T"), a.a("T", "p"))));
        MathExpression mathExpression7 = com.mimvista.internals.fusionmode.equation.a.b(mathExpression5, mathExpression6);
        MathEquation mathEquation = a.a(mathExpression7);
        MathEquation mathEquation2 = com.mimvista.internals.fusionmode.equation.a.a(mathSymbol5, com.mimvista.internals.fusionmode.equation.a.c(mathExpression, com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.b(mathExpression2, mathExpression3))));
        MathExpression mathExpression8 = com.mimvista.internals.fusionmode.equation.a.d(a.a("1"), mathSymbol2);
        MathExpression mathExpression9 = com.mimvista.internals.fusionmode.equation.a.c(a.a("ln"), com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.c(a.a("1.44"), mathSymbol), com.mimvista.internals.fusionmode.equation.a.c(a.a, a.a("T", "p")))));
        MathEquation mathEquation3 = new MathEquation(a.a("T", "eff"), com.mimvista.internals.fusionmode.equation.a.c(mathExpression8, mathExpression9));
        jPanel.add(mathEquation);
        jPanel.add(mathEquation2);
        jPanel.add(mathEquation3);
        mathEquation.c();
        mathEquation2.c();
        mathEquation3.c();
        return jPanel;
    }

    public SinghModelParameterSet j() {
        return new SinghModelParameterSet();
    }

    public SinghContourParameterSet k() {
        return new SinghContourParameterSet();
    }

    @Override
    public void b(BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        this.params = (SinghModelParameterSet)bEDParameterSet;
    }

    @Override
    public BEDAlgorithm.BEDParameterSet e() {
        return this.params;
    }

    @Override
    public /* synthetic */ BEDAlgorithm.BEDParameterSet d() {
        return this.k();
    }

    @Override
    public /* synthetic */ BEDAlgorithm.BEDParameterSet c() {
        return this.j();
    }

    protected static class SinghModelParameterSet
    extends BEDAlgorithm.BEDParameterSet {
        private static final long serialVersionUID = 1L;
        BEDParameterFloat halflife = new BEDParameterFloat("HALF_LIFE", 59.4f, Units.days, new BEDParameter.StrictlyPositiveValidator());

        protected SinghModelParameterSet() {
        }

        @Override
        public List<BEDParameter> c() {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.halflife);
            return arrayList;
        }
    }

    protected static class SinghContourParameterSet
    extends BEDAlgorithm.BEDParameterSet {
        private static final long serialVersionUID = 1L;
        BEDParameterFloat alphaBeta = new BEDParameterFloat("ALPHA_BETA_RATIO", 3.0f, Units.Gy);
        BEDParameterFloat alpha = new BEDParameterFloat("ALPHA_VALUE", 0.3f, Units.none);
        BEDParameterFloat repairConstant = new BEDParameterFloat("REPAIR_CONSTANT", 1.5f, Units.hours);
        BEDParameterFloat Tp = new BEDParameterFloat("T_P_CONSTANT", 34.0f, Units.days);

        public SinghContourParameterSet() {
            this.a("Structure");
        }

        @Override
        public List<BEDParameter> c() {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.alphaBeta);
            arrayList.add(this.alpha);
            arrayList.add(this.repairConstant);
            arrayList.add(this.Tp);
            return arrayList;
        }

        @Override
        public List<BEDAlgorithm.BEDParameterSet> d() {
            ArrayList arrayList = Lists.newArrayList();
            SinghContourParameterSet singhContourParameterSet = new SinghContourParameterSet();
            singhContourParameterSet.a(Messages.a("Dose", "BED_TUMOR"));
            arrayList.add(singhContourParameterSet);
            return arrayList;
        }
    }
}

