/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.bed;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.dose.bed.BEDAlgorithm;
import com.mimvista.dose.bed.BEDParameter;
import com.mimvista.dose.bed.BEDParameterBoolean;
import com.mimvista.dose.bed.BEDParameterFloat;
import com.mimvista.dose.bed.a;
import com.mimvista.internals.fusionmode.equation.MathEquation;
import com.mimvista.internals.fusionmode.equation.MathExpression;
import com.mimvista.internals.fusionmode.equation.MathSymbol;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LQLModel
extends BEDAlgorithm {
    private static final long serialVersionUID = 1L;
    public static final String a = "USE_TANGENT";
    LQLModelParameterSet params = new LQLModelParameterSet();

    @Override
    public float a(BEDAlgorithm.BEDParameterSet bEDParameterSet, float f2) {
        LQLModelContourParameterSet lQLModelContourParameterSet = (LQLModelContourParameterSet)bEDParameterSet;
        float f3 = f2 / this.params.numFractions.value;
        if (f3 < lQLModelContourParameterSet.Dt.value) {
            float f4 = f2 * (1.0f + f3 / lQLModelContourParameterSet.alphaBeta.value);
            return f4;
        }
        float f5 = lQLModelContourParameterSet.Dt.value;
        float f6 = lQLModelContourParameterSet.gammaAlpha.value;
        if (this.params.useTangent.value) {
            f6 = 1.0f + 2.0f * f5 / lQLModelContourParameterSet.alphaBeta.value;
        }
        float f7 = f5 * (1.0f + f5 / lQLModelContourParameterSet.alphaBeta.value);
        float f8 = f6 * (f3 - f5);
        return this.params.numFractions.value * (f7 + f8);
    }

    @Override
    public JPanel a(BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        if (bEDParameterSet == null) {
            return jPanel;
        }
        MathSymbol mathSymbol = com.mimvista.dose.bed.a.a("d", "t");
        MathSymbol mathSymbol2 = com.mimvista.dose.bed.a.a("\u03b3");
        MathExpression mathExpression = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.dose.bed.a.d, mathSymbol));
        String string = Messages.a("Dose", "BED_D_CONSTANT") + " \u2264 d_t";
        jPanel.add(new JLabel(MIMFormat.a(Messages.a("Dose", "BED_PROP_COLLECTION_IF_D"), string)));
        MathEquation mathEquation = com.mimvista.dose.bed.a.a(this.a(com.mimvista.dose.bed.a.d));
        mathEquation.c();
        jPanel.add(mathEquation);
        BEDParameterBoolean bEDParameterBoolean = (BEDParameterBoolean)bEDParameterSet.b(a);
        String string2 = Messages.a("Dose", "BED_D_CONSTANT") + " > d_t";
        jPanel.add(new JLabel(MIMFormat.a(Messages.a("Dose", "BED_PROP_COLLECTION_IF_D"), string2)));
        MathEquation mathEquation2 = bEDParameterBoolean.l() ? com.mimvista.dose.bed.a.a(com.mimvista.internals.fusionmode.equation.a.a(this.a(mathSymbol), com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.dose.bed.a.c, com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.a((MathExpression)com.mimvista.dose.bed.a.a("1"), com.mimvista.internals.fusionmode.equation.a.d(com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.dose.bed.a.a("2"), mathSymbol), com.mimvista.dose.bed.a.f))), mathExpression)))) : com.mimvista.dose.bed.a.a(com.mimvista.internals.fusionmode.equation.a.a(this.a(mathSymbol), com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.dose.bed.a.c, com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.d(mathSymbol2, com.mimvista.dose.bed.a.a), mathExpression))));
        mathEquation2.c();
        jPanel.add(mathEquation2);
        return jPanel;
    }

    private MathExpression a(MathSymbol mathSymbol) {
        return com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.dose.bed.a.c, mathSymbol), com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.a((MathExpression)com.mimvista.dose.bed.a.a("1"), com.mimvista.internals.fusionmode.equation.a.d(mathSymbol, com.mimvista.dose.bed.a.f))));
    }

    @Override
    public String a() {
        return this.g();
    }

    @Override
    public String b() {
        return "BED_LQL_MODEL_NAME";
    }

    public LQLModelParameterSet j() {
        return new LQLModelParameterSet();
    }

    public LQLModelContourParameterSet k() {
        return new LQLModelContourParameterSet();
    }

    @Override
    public void b(BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        this.params = (LQLModelParameterSet)bEDParameterSet;
    }

    @Override
    public BEDAlgorithm.BEDParameterSet e() {
        return this.params;
    }

    @Override
    public /* synthetic */ BEDAlgorithm.BEDParameterSet d() {
        return this.k();
    }

    @Override
    public /* synthetic */ BEDAlgorithm.BEDParameterSet c() {
        return this.j();
    }

    protected static class LQLModelParameterSet
    extends BEDAlgorithm.BEDParameterSet {
        private static final long serialVersionUID = 1L;
        BEDParameterFloat numFractions = new BEDParameterFloat("NUM_FRACTIONS_LABEL", 20.0f, Units.none, new BEDParameter.NonNegativeValidator());
        BEDParameterBoolean useTangent = new BEDParameterBoolean("USE_TANGENT", false, Units.none);

        protected LQLModelParameterSet() {
        }

        @Override
        public List<BEDParameter> c() {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.numFractions);
            arrayList.add(this.useTangent);
            return arrayList;
        }
    }

    protected static class LQLModelContourParameterSet
    extends BEDAlgorithm.BEDParameterSet {
        private static final long serialVersionUID = 1L;
        BEDParameterFloat alphaBeta = new BEDParameterFloat("ALPHA_BETA_RATIO", 3.0f, Units.Gy);
        BEDParameterFloat Dt = new BEDParameterFloat("D_T_CONSTANT", 6.0f, Units.Gy, new BEDParameter.StrictlyPositiveValidator());
        BEDParameterFloat gammaAlpha = new BEDParameterFloat("GAMMA_ALPHA_VALUE", 5.0f, Units.none);

        public LQLModelContourParameterSet() {
            this.a("Structure");
        }

        @Override
        public List<BEDParameter> c() {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.alphaBeta);
            arrayList.add(this.Dt);
            arrayList.add(this.gammaAlpha);
            return arrayList;
        }

        @Override
        public List<BEDAlgorithm.BEDParameterSet> d() {
            ArrayList arrayList = Lists.newArrayList();
            LQLModelContourParameterSet lQLModelContourParameterSet = new LQLModelContourParameterSet();
            lQLModelContourParameterSet.alphaBeta.a(10.0f);
            lQLModelContourParameterSet.Dt.a(20.0f);
            lQLModelContourParameterSet.gammaAlpha.a(5.0f);
            lQLModelContourParameterSet.a(Messages.a("Dose", "BED_EARLY"));
            LQLModelContourParameterSet lQLModelContourParameterSet2 = new LQLModelContourParameterSet();
            lQLModelContourParameterSet2.alphaBeta.a(3.0f);
            lQLModelContourParameterSet2.Dt.a(6.0f);
            lQLModelContourParameterSet2.gammaAlpha.a(5.0f);
            lQLModelContourParameterSet2.a(Messages.a("Dose", "BED_LATE"));
            LQLModelContourParameterSet lQLModelContourParameterSet3 = new LQLModelContourParameterSet();
            lQLModelContourParameterSet3.alphaBeta.a(10.0f);
            lQLModelContourParameterSet3.Dt.a(20.0f);
            lQLModelContourParameterSet3.gammaAlpha.a(5.0f);
            lQLModelContourParameterSet3.a(Messages.a("Dose", "BED_TUMOR"));
            arrayList.add(lQLModelContourParameterSet);
            arrayList.add(lQLModelContourParameterSet2);
            return arrayList;
        }
    }
}

