/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.bed;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.dose.bed.BEDAlgorithm;
import com.mimvista.dose.bed.BEDParameter;
import com.mimvista.dose.bed.BEDParameterFloat;
import com.mimvista.dose.bed.a;
import com.mimvista.internals.fusionmode.equation.MathEquation;
import com.mimvista.internals.fusionmode.equation.MathExpression;
import com.mimvista.util.Messages;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class LQplusTModel
extends BEDAlgorithm {
    private static final long serialVersionUID = 1L;
    LQPlusTModelParameterSet params = new LQPlusTModelParameterSet();

    @Override
    public float a(BEDAlgorithm.BEDParameterSet bEDParameterSet, float f2) {
        LQPlusTModelContourParameterSet lQPlusTModelContourParameterSet = (LQPlusTModelContourParameterSet)bEDParameterSet;
        float f3 = f2 / this.params.numFractions.value;
        float f4 = f2 * (1.0f + f3 / lQPlusTModelContourParameterSet.alphaBeta.value);
        float f5 = 0.693f / lQPlusTModelContourParameterSet.alpha.value * ((this.params.T.value - lQPlusTModelContourParameterSet.Tk.value) / lQPlusTModelContourParameterSet.Teff.value);
        return f4 - f5;
    }

    @Override
    public JPanel a(BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MathExpression mathExpression = com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.c(a.c, a.d), com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.a((MathExpression)a.a("1"), com.mimvista.internals.fusionmode.equation.a.d(a.d, com.mimvista.internals.fusionmode.equation.a.d(a.a, a.b)))));
        MathExpression mathExpression2 = com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.c(com.mimvista.internals.fusionmode.equation.a.d(a.a("0.693"), a.a), com.mimvista.internals.fusionmode.equation.a.d(com.mimvista.internals.fusionmode.equation.a.b(com.mimvista.internals.fusionmode.equation.a.b(a.a("T"), a.a("T", "k"))), a.a("T", "eff"))));
        MathEquation mathEquation = a.a(com.mimvista.internals.fusionmode.equation.a.b(mathExpression, mathExpression2));
        jPanel.add(mathEquation);
        mathEquation.c();
        return jPanel;
    }

    @Override
    public String a() {
        return this.g();
    }

    @Override
    public String b() {
        return "BED_LQPLUSTMODEL_NAME";
    }

    public LQPlusTModelParameterSet j() {
        return new LQPlusTModelParameterSet();
    }

    public LQPlusTModelContourParameterSet k() {
        return new LQPlusTModelContourParameterSet();
    }

    @Override
    public void b(BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        this.params = (LQPlusTModelParameterSet)bEDParameterSet;
    }

    @Override
    public BEDAlgorithm.BEDParameterSet e() {
        return this.params;
    }

    @Override
    public /* synthetic */ BEDAlgorithm.BEDParameterSet d() {
        return this.k();
    }

    @Override
    public /* synthetic */ BEDAlgorithm.BEDParameterSet c() {
        return this.j();
    }

    protected static class LQPlusTModelParameterSet
    extends BEDAlgorithm.BEDParameterSet {
        private static final long serialVersionUID = 1L;
        BEDParameterFloat numFractions = new BEDParameterFloat("NUM_FRACTIONS_LABEL", 20.0f, Units.none, new BEDParameter.StrictlyPositiveValidator());
        BEDParameterFloat T = new BEDParameterFloat("T_CONSTANT_LABEL_UNITS", 30.0f, Units.days, new BEDParameter.StrictlyPositiveValidator());

        protected LQPlusTModelParameterSet() {
        }

        @Override
        public List<BEDParameter> c() {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.numFractions);
            arrayList.add(this.T);
            return arrayList;
        }
    }

    protected static class LQPlusTModelContourParameterSet
    extends BEDAlgorithm.BEDParameterSet {
        private static final long serialVersionUID = 1L;
        BEDParameterFloat alphaBeta = new BEDParameterFloat("ALPHA_BETA_RATIO", 3.0f, Units.Gy);
        BEDParameterFloat alpha = new BEDParameterFloat("ALPHA_VALUE", 0.3f, Units.none);
        BEDParameterFloat Teff = new BEDParameterFloat("T_EFF_CONSTANT", 5.0f, Units.days, new BEDParameter.StrictlyPositiveValidator());
        BEDParameterFloat Tk = new BEDParameterFloat("T_K_CONSTANT", 14.0f, Units.days, new BEDParameter.NonNegativeValidator());

        public LQPlusTModelContourParameterSet() {
            this.a("Structure");
        }

        @Override
        public List<BEDParameter> c() {
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(this.alphaBeta);
            arrayList.add(this.alpha);
            arrayList.add(this.Teff);
            arrayList.add(this.Tk);
            return arrayList;
        }

        @Override
        public List<BEDAlgorithm.BEDParameterSet> d() {
            ArrayList arrayList = Lists.newArrayList();
            LQPlusTModelContourParameterSet lQPlusTModelContourParameterSet = new LQPlusTModelContourParameterSet();
            lQPlusTModelContourParameterSet.alphaBeta.a(10.0f);
            lQPlusTModelContourParameterSet.a(Messages.a("Dose", "BED_TUMOR"));
            arrayList.add(lQPlusTModelContourParameterSet);
            return arrayList;
        }
    }
}

