/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.bed.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.d;
import com.mimvista.dose.bed.BEDAlgorithm;
import com.mimvista.dose.bed.BEDParameter;
import com.mimvista.dose.bed.BEDParameterFloat;
import com.mimvista.dose.bed.ui.BEDContourMatchingDialog;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.util.Messages;
import com.mimvista.util.NumberFormatFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class BEDContourMatchingTableGUI
extends Box {
    private static final long serialVersionUID = -8397208118006531692L;
    Messages props = Messages.a("Dose");
    private List<ActionListener> tableChangedListeners = Lists.newArrayList();
    private BEDContourMatchingTableModel tableModel;
    private JTable table;
    private String noneLabel;
    private BEDAlgorithm algo;
    private boolean constructed = false;

    public BEDContourMatchingTableGUI(BEDAlgorithm bEDAlgorithm, List<VolumetricContourOverlayish> list, List<BEDAlgorithm.BEDParameterSet> list2, Map<VolumetricContourOverlayish, Float> map) {
        super(3);
        this.algo = bEDAlgorithm;
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.tableModel = new BEDContourMatchingTableModel(bEDAlgorithm, list, list2, map);
        this.table = new JTable(this.tableModel);
        String[] stringArray = new String[list2.size() + 1];
        stringArray[0] = BEDContourMatchingDialog.a();
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            stringArray[i2 + 1] = list2.get(i2).b();
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setCellEditor(new ComboBoxEditor(stringArray));
        tableColumn.setCellRenderer(new ContourMatchingTableCellRenderer(stringArray));
        if (map != null) {
            this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).setCellRenderer(new DecimalFormatRenderer());
            this.table.getColumnModel().getColumn(this.table.getColumnCount() - 2).setCellRenderer(new DecimalFormatRenderer());
        }
        int n2 = this.table.getRowHeight();
        this.table.setRowHeight(n2 + 5);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.table.setRowSorter(new TableRowSorter<BEDContourMatchingTableModel>(this.tableModel));
        this.c();
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                BEDContourMatchingTableGUI.this.repaint();
                BEDContourMatchingTableGUI.this.table.repaint();
            }
        });
    }

    public void a(ActionListener actionListener) {
        this.tableChangedListeners.add(actionListener);
    }

    public Map<VolumetricContourOverlayish, BEDAlgorithm.BEDParameterSet> a() {
        return this.tableModel.paramMap;
    }

    public void a(String string, BEDAlgorithm.BEDParameterSet bEDParameterSet) {
        this.tableModel.a(string, bEDParameterSet);
    }

    public void a(String string, boolean bl2) {
        this.tableModel.a(string, bl2);
    }

    public void b() {
        this.tableModel.fireTableDataChanged();
    }

    public void c() {
        if (!this.constructed) {
            JScrollPane jScrollPane = new JScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 400));
            this.add((Component)jScrollPane, "Center");
            Iterator<ActionListener> iterator = this.tableChangedListeners.iterator();
            while (iterator.hasNext()) {
                ActionListener actionListener;
                final ActionListener actionListener2 = actionListener = iterator.next();
                this.tableModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        actionListener2.actionPerformed(null);
                    }
                });
            }
            this.constructed = true;
        }
    }

    public void a(boolean bl2) {
        this.tableModel.a(bl2);
    }

    public void a(a a2) {
        this.tableModel.a(a2);
    }

    public void a(final Map<VolumetricContourOverlayish, Float> map) {
        MIMSwingUtils.a(new Runnable(){

            @Override
            public void run() {
                BEDContourMatchingTableGUI.this.tableModel.a(map);
            }
        });
    }

    static class BEDContourMatchingTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2932462450975145021L;
        private List<BEDAlgorithm.BEDParameterSet> presets = Lists.newArrayList();
        private List<String> columnNames = Lists.newArrayList();
        private List<VolumetricContourOverlayish> contours;
        Map<VolumetricContourOverlayish, BEDAlgorithm.BEDParameterSet> paramMap = Maps.newHashMap();
        private Map<VolumetricContourOverlayish, BEDAlgorithm.BEDParameterSet> presetMap = Maps.newHashMap();
        private Map<String, BEDAlgorithm.BEDParameterSet> presetNameMap = Maps.newHashMap();
        private BEDAlgorithm algo;
        private Map<VolumetricContourOverlayish, Float> maxMap = Maps.newHashMap();
        private Map<VolumetricContourOverlayish, Float> scaledMaxMap = Maps.newHashMap();
        private boolean displayMaxColumn = false;
        private a editableFunctor = null;

        public BEDContourMatchingTableModel(BEDAlgorithm bEDAlgorithm, List<VolumetricContourOverlayish> list, List<BEDAlgorithm.BEDParameterSet> list2, @d Map<VolumetricContourOverlayish, Float> map) {
            this.presets = list2;
            this.contours = list;
            this.algo = bEDAlgorithm;
            this.maxMap = map;
            Messages messages = Messages.a("Dose");
            this.columnNames.add(messages.getProperty("BED_TABLE_CONTOUR_NAME"));
            this.columnNames.add(messages.getProperty("BED_TABLE_PRESET"));
            for (BEDAlgorithm.BEDParameterSet cloneable : list2) {
                this.presetNameMap.put(cloneable.b(), cloneable);
            }
            for (BEDParameter bEDParameter : list2.get(0).e()) {
                this.columnNames.add(messages.getProperty("BED_" + bEDParameter.a()));
            }
            if (map != null) {
                this.displayMaxColumn = true;
                this.columnNames.add(messages.getProperty("BED_CONTOUR_MAX_DOSE"));
                this.columnNames.add(messages.getProperty("BED_CONTOUR_SCALED_MAX_DOSE"));
            }
        }

        public void a(final boolean bl2) {
            this.editableFunctor = new a(){

                @Override
                public boolean a(String string) {
                    return bl2;
                }
            };
        }

        public void a(a a2) {
            this.editableFunctor = a2;
        }

        @Override
        public String getColumnName(int n2) {
            return this.columnNames.get(n2);
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.size();
        }

        @Override
        public int getRowCount() {
            return this.contours.size();
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            if (n2 == 0 || n2 == 1) {
                return String.class;
            }
            if (this.displayMaxColumn && n2 == this.columnNames.size() - 2) {
                return Float.class;
            }
            if (this.displayMaxColumn && n2 == this.columnNames.size() - 1) {
                return Float.class;
            }
            if (this.presets.isEmpty()) {
                return String.class;
            }
            BEDParameter bEDParameter = this.presets.get(0).e().get(n2 - 2);
            if (bEDParameter instanceof BEDParameterFloat) {
                return Float.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            if (n2 < 0 || n2 >= this.contours.size()) {
                return "";
            }
            VolumetricContourOverlayish volumetricContourOverlayish = this.contours.get(n2);
            if (n3 == 0) {
                return volumetricContourOverlayish.getName();
            }
            if (n3 == 1) {
                if (this.presetMap.get(volumetricContourOverlayish) != null) {
                    return this.presetMap.get(volumetricContourOverlayish).b();
                }
                return BEDContourMatchingDialog.a();
            }
            if (this.displayMaxColumn && n3 == this.columnNames.size() - 2) {
                return this.maxMap.get(volumetricContourOverlayish);
            }
            if (this.displayMaxColumn && n3 == this.columnNames.size() - 1) {
                BEDAlgorithm.BEDParameterSet bEDParameterSet = this.paramMap.get(volumetricContourOverlayish);
                Float f2 = this.maxMap.get(volumetricContourOverlayish);
                if (bEDParameterSet == null || f2 == null) {
                    return null;
                }
                return Float.valueOf(this.algo.a(bEDParameterSet, f2.floatValue()));
            }
            BEDAlgorithm.BEDParameterSet bEDParameterSet = this.paramMap.get(volumetricContourOverlayish);
            if (bEDParameterSet == null) {
                return null;
            }
            BEDParameter bEDParameter = bEDParameterSet.e().get(n3 - 2);
            if (bEDParameter instanceof BEDParameterFloat) {
                return ((BEDParameterFloat)bEDParameter).k();
            }
            return bEDParameter.f();
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            if (this.editableFunctor != null && !this.editableFunctor.a(this.columnNames.get(n3))) {
                return false;
            }
            if (n3 == 0) {
                return false;
            }
            if (n3 == 1) {
                return true;
            }
            if (this.displayMaxColumn && (n3 == this.columnNames.size() - 2 || n3 == this.columnNames.size() - 1)) {
                return false;
            }
            VolumetricContourOverlayish volumetricContourOverlayish = this.contours.get(n2);
            BEDAlgorithm.BEDParameterSet bEDParameterSet = this.paramMap.get(volumetricContourOverlayish);
            return bEDParameterSet != null;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            VolumetricContourOverlayish volumetricContourOverlayish = this.contours.get(n2);
            System.out.println("VCO: " + volumetricContourOverlayish.getName());
            System.out.println("address: " + n2 + "," + n3);
            if (n3 == 0) {
                return;
            }
            if (n3 == 1) {
                if (object.toString().equals(BEDContourMatchingDialog.a())) {
                    this.paramMap.remove(volumetricContourOverlayish);
                    this.presetMap.remove(volumetricContourOverlayish);
                } else {
                    BEDAlgorithm.BEDParameterSet bEDParameterSet = this.presetNameMap.get(object.toString());
                    BEDAlgorithm.BEDParameterSet bEDParameterSet2 = bEDParameterSet.a();
                    this.paramMap.put(volumetricContourOverlayish, bEDParameterSet2);
                    this.presetMap.put(volumetricContourOverlayish, bEDParameterSet);
                }
                this.fireTableDataChanged();
            } else {
                BEDAlgorithm.BEDParameterSet bEDParameterSet = this.paramMap.get(volumetricContourOverlayish);
                if (bEDParameterSet == null) {
                    bEDParameterSet = this.algo.d();
                    this.paramMap.put(volumetricContourOverlayish, bEDParameterSet);
                }
                bEDParameterSet.e().get(n3 - 2).b(object.toString());
                this.fireTableDataChanged();
            }
        }

        public void a(String string, boolean bl2) {
            for (VolumetricContourOverlayish volumetricContourOverlayish : this.contours) {
                if ((!bl2 || BEDContourMatchingDialog.a(volumetricContourOverlayish)) && (bl2 || !BEDContourMatchingDialog.a(volumetricContourOverlayish))) continue;
                BEDAlgorithm.BEDParameterSet bEDParameterSet = this.presetNameMap.get(string);
                BEDAlgorithm.BEDParameterSet bEDParameterSet2 = bEDParameterSet.a();
                this.paramMap.put(volumetricContourOverlayish, bEDParameterSet2);
                this.presetMap.put(volumetricContourOverlayish, bEDParameterSet);
            }
            this.fireTableDataChanged();
        }

        public void a(String string, BEDAlgorithm.BEDParameterSet bEDParameterSet) {
            for (VolumetricContourOverlayish volumetricContourOverlayish : this.contours) {
                if (!string.equalsIgnoreCase(volumetricContourOverlayish.getName())) continue;
                System.out.println(bEDParameterSet.b());
                this.paramMap.put(volumetricContourOverlayish, bEDParameterSet.a());
                BEDAlgorithm.BEDParameterSet bEDParameterSet2 = this.presetNameMap.get(bEDParameterSet.b());
                if (bEDParameterSet2 == null) {
                    this.presetMap.remove(volumetricContourOverlayish);
                    continue;
                }
                this.presetMap.put(volumetricContourOverlayish, bEDParameterSet2);
            }
        }

        public void a(Map<VolumetricContourOverlayish, Float> map) {
            this.maxMap = map;
            this.fireTableDataChanged();
        }
    }

    public static interface a {
        public boolean a(String var1);
    }

    static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -5437292482211735811L;

        public DecimalFormatRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (object instanceof Number) {
                object = NumberFormatFactory.a().format((Number)object);
            }
            return super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
        }
    }

    static class ContourMatchingTableCellRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1623843487575267145L;

        public ContourMatchingTableCellRenderer(String[] stringArray) {
            super(stringArray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelectedItem(object);
            return this;
        }
    }

    static class ComboBoxEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8745142473083904008L;

        public ComboBoxEditor(String[] stringArray) {
            super(new JComboBox<String>(stringArray));
        }
    }
}

