/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.constraints;

import com.mimvista.MimJsonSerializable;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.dose.constraints.DVConstraintState;
import com.mimvista.dose.constraints.DoseConstraint;
import com.mimvista.dose.constraints.DoseContext;
import com.mimvista.dose.constraints.DoseContourConstraintType;
import com.mimvista.dose.constraints.units.DoseUnit;
import com.mimvista.dose.constraints.units.VolumeUnit;
import com.mimvista.dose.constraints.units.a;
import com.mimvista.internals.ad;
import com.mimvista.internals.statistics.IsodoseStatistician;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.workflow.backend.t;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.Icon;

@MimJsonSerializable
public class DVConstraint
extends DoseConstraint.AbstractDoseContourConstraint {
    private static final long serialVersionUID = 127872731567366348L;
    public static Messages messages = DoseContext.a;
    public final DVConstraintState state;

    private DVConstraint() {
        this.state = null;
    }

    public DVConstraint(DVConstraintState dVConstraintState) {
        this.state = dVConstraintState.clone();
    }

    @Override
    public DoseContourConstraintType getType() {
        return this.state.dOrV == DVType.a ? DoseContourConstraintType.a : DoseContourConstraintType.b;
    }

    @Override
    public FulfilledCellObject.FulfilledState fulfilled(IsodoseOverlay isodoseOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
        DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.b(volumetricContourOverlayish);
        if (doseVolumeHistogram == null) {
            return null;
        }
        return this.fulfilled((ad)isodoseOverlay, doseVolumeHistogram);
    }

    @Override
    public FulfilledCellObject.FulfilledState fulfilled(ad ad2, DoseVolumeHistogram doseVolumeHistogram) {
        Double d2 = this.getValue(ad2, doseVolumeHistogram);
        Double d3 = this.getTargetValue();
        return this.getComparisonType().a(d2, d3, this.getPosNegFuzzyThresholds());
    }

    @Override
    public Double getValue(IsodoseOverlay isodoseOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
        DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.c(volumetricContourOverlayish);
        return this.getValue((ad)isodoseOverlay, doseVolumeHistogram);
    }

    @Override
    public Double getValueForDisplay(IsodoseOverlay isodoseOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
        DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.c(volumetricContourOverlayish);
        return this.getValueForDisplay((ad)isodoseOverlay, doseVolumeHistogram);
    }

    @Override
    public Double getValue(ad ad2, DoseVolumeHistogram doseVolumeHistogram) {
        return this.a(ad2, doseVolumeHistogram, false);
    }

    @Override
    public Double getValueForDisplay(ad ad2, DoseVolumeHistogram doseVolumeHistogram) {
        return this.a(ad2, doseVolumeHistogram, true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Double a(ad ad2, DoseVolumeHistogram doseVolumeHistogram, boolean bl2) {
        void var6_9;
        double d2;
        double d3;
        if (this.state.dOrV == DVType.b && doseVolumeHistogram.getMaxVolume() <= 0.0) {
            return null;
        }
        if (this.state.dOrV == DVType.a) {
            d3 = this.state.volUnit.a(this.state.vol, ad2, doseVolumeHistogram);
            if (!(d3 < doseVolumeHistogram.getMaxVolume())) return null;
            d2 = doseVolumeHistogram.getInterpolatedGyValue(d3);
            DoseUnit doseUnit = DoseUnit.a;
        } else {
            if (this.state.dOrV != DVType.b) throw new RuntimeException(this.state.dOrV + " was not recognized");
            d3 = this.state.doseUnit.a(this.state.dose, ad2, doseVolumeHistogram);
            d2 = doseVolumeHistogram.getInterpolatedMLValue(d3);
            VolumeUnit volumeUnit = VolumeUnit.a;
        }
        a a2 = this.getUnits();
        if (bl2) {
            a2 = this.getUnitsForDisplay();
        }
        if (a2 != null && a2.a().equals(var6_9)) return a2.b(d2, ad2, doseVolumeHistogram);
        throw new RuntimeException("Invalid unit conversion: " + String.valueOf(var6_9) + " to " + String.valueOf(a2));
    }

    @Override
    public Double getTargetValue() {
        if (this.state.dOrV == DVType.a) {
            return this.state.dose;
        }
        return this.state.vol;
    }

    @Override
    public a getUnits() {
        if (this.state.dOrV == DVType.a) {
            return this.state.doseUnit;
        }
        return this.state.volUnit;
    }

    @Override
    public a getUnitsForDisplay() {
        a a2 = this.getUnits();
        if (a2 instanceof DoseUnit) {
            Pair<Float, DoseUnit> pair = DoseUnit.a(0.0f, (DoseUnit)a2);
            a2 = (a)pair.y;
        }
        return a2;
    }

    public String toString() {
        String string = "";
        String string2 = "";
        if (this.state.dOrV == DVType.a) {
            string = string + "D";
            string = string + this.state.vol;
            string = string + " ";
            string2 = this.state.volUnit.getExternalizedString();
        } else {
            string = string + "V";
            string = string + this.state.dose;
            string = string + " ";
            string2 = this.state.doseUnit.getExternalizedString();
        }
        string = string + string2;
        return string;
    }

    public String toHeavyVerbosityString(String string, String string2) {
        String string3 = this.toString();
        if (this.state.compareType == ComparisonType.c) {
            return string3;
        }
        string3 = string3 + "\n\n";
        Messages messages = Messages.a("DoseConstraints");
        if (this.state.dOrV == DVType.a) {
            String string4 = this.state.compareType == ComparisonType.a ? messages.getProperty("CONFIG_GUI_DOSE_CONSTRAINT_INTERPOLATION_STRING_HEAVY_D_GREATER_THAN") : messages.getProperty("CONFIG_GUI_DOSE_CONSTRAINT_INTERPOLATION_STRING_HEAVY_D_LESS_THAN");
            string3 = string3 + MIMFormat.a(string4, string, string2, Float.valueOf(this.state.vol), this.state.volUnit.d(), Float.valueOf(this.state.dose), this.state.doseUnit.d());
        } else {
            String string5 = this.state.compareType == ComparisonType.a ? messages.getProperty("CONFIG_GUI_DOSE_CONSTRAINT_INTERPOLATION_STRING_HEAVY_V_GREATER_THAN") : messages.getProperty("CONFIG_GUI_DOSE_CONSTRAINT_INTERPOLATION_STRING_HEAVY_V_LESS_THAN");
            string3 = string3 + MIMFormat.a(string5, string, string2, Float.valueOf(this.state.dose), this.state.doseUnit.d(), Float.valueOf(this.state.vol), this.state.volUnit.d());
        }
        return string3;
    }

    @Override
    public ComparisonType getComparisonType() {
        return this.state.compareType;
    }

    @Override
    public String getDescription() {
        ComparisonType comparisonType = this.state.compareType;
        if (comparisonType == ComparisonType.c) {
            return this.toString();
        }
        float f2 = this.state.dose;
        DoseUnit doseUnit = this.state.doseUnit;
        Pair<Float, DoseUnit> pair = DoseUnit.a(f2, doseUnit);
        f2 = ((Float)pair.x).floatValue();
        doseUnit = (DoseUnit)pair.y;
        String string = f2 + " " + doseUnit.getExternalizedString();
        String string2 = this.state.vol + " " + this.state.volUnit.getExternalizedString();
        if (this.state.dOrV == DVType.a) {
            return MIMFormat.a(Messages.a("DoseConstraints", "CONFIG_GUI_DOSE_CONSTRAINT_INTERPOLATION_STRING_LITE_D"), comparisonType.b(), string, string2);
        }
        return MIMFormat.a(Messages.a("DoseConstraints", "CONFIG_GUI_DOSE_CONSTRAINT_INTERPOLATION_STRING_LITE_V"), string, comparisonType.b(), string2);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.state == null ? 0 : this.state.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DVConstraint dVConstraint = (DVConstraint)object;
        return !(this.state == null ? dVConstraint.state != null : !this.state.equals(dVConstraint.state));
    }

    @Override
    public Pair<Double, Double> getPosNegFuzzyThresholds() {
        if (this.state == null) {
            return Pair.get(0.0, 0.0);
        }
        return Pair.get(new Double(this.state.fuzzyThreshPositive), new Double(this.state.fuzzyThreshNegative));
    }

    @Override
    public String getPosNegThresholdString() {
        Pair<Double, Double> pair = this.getPosNegFuzzyThresholds();
        a a2 = this.getUnits();
        float f2 = (float)((Double)pair.x).doubleValue();
        float f3 = (float)((Double)pair.y).doubleValue();
        if (this.state.dOrV == DVType.a && a2 instanceof DoseUnit) {
            Pair<Float, DoseUnit> pair2 = DoseUnit.a(f2, (DoseUnit)a2);
            Pair<Float, DoseUnit> pair3 = DoseUnit.a(f3, (DoseUnit)a2);
            if (pair2.y != pair3.y) {
                throw new RuntimeException("Threshold units don't match!");
            }
            f2 = ((Float)pair2.x).floatValue();
            f3 = ((Float)pair3.x).floatValue();
            a2 = (a)pair2.y;
        }
        return "+" + f2 + "/-" + f3 + a2.getExternalizedString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(objectInputStream, (Object)this);
    }

    public static enum DVType implements t
    {
        a,
        b;


        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        @Override
        public String getExternalizedString() {
            if (this == a) {
                return DoseContourConstraintType.a.getExternalizedString();
            }
            return DoseContourConstraintType.b.getExternalizedString();
        }

        public static DVType a(DoseContourConstraintType doseContourConstraintType) {
            if (doseContourConstraintType != null) {
                switch (doseContourConstraintType) {
                    case a: {
                        return a;
                    }
                    case b: {
                        return b;
                    }
                }
            }
            return null;
        }
    }
}

