/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.constraints;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mimvista.MimJsonSerializable;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.dose.constraints.DVConstraint;
import com.mimvista.dose.constraints.units.DoseUnit;
import com.mimvista.dose.constraints.units.VolumeUnit;
import java.io.Serializable;

@MimJsonSerializable
public class DVConstraintState
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 628158842003285040L;
    @JsonProperty(value="type")
    public DVConstraint.DVType dOrV;
    public float vol;
    public VolumeUnit volUnit;
    @JsonProperty(value="comparisonType")
    public ComparisonType compareType;
    public float dose;
    @JsonProperty(value="positiveThresh")
    public float fuzzyThreshPositive;
    @JsonProperty(value="negativeThresh")
    public float fuzzyThreshNegative;
    public DoseUnit doseUnit;

    private DVConstraintState() {
    }

    public DVConstraintState(DVConstraint.DVType dVType, float f2, VolumeUnit volumeUnit, ComparisonType comparisonType, float f3, DoseUnit doseUnit) {
        this.dOrV = dVType;
        this.vol = f2;
        this.volUnit = volumeUnit;
        this.compareType = comparisonType;
        this.dose = f3;
        this.doseUnit = doseUnit;
        this.fuzzyThreshPositive = 0.0f;
        this.fuzzyThreshNegative = 0.0f;
    }

    public DVConstraintState(DVConstraint.DVType dVType, float f2, VolumeUnit volumeUnit, ComparisonType comparisonType, float f3, DoseUnit doseUnit, float f4, float f5) {
        this.dOrV = dVType;
        this.vol = f2;
        this.volUnit = volumeUnit;
        this.compareType = comparisonType;
        this.dose = f3;
        this.doseUnit = doseUnit;
        this.fuzzyThreshPositive = f4;
        this.fuzzyThreshNegative = f5;
    }

    public DVConstraintState clone() {
        try {
            return (DVConstraintState)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException();
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.compareType == null ? 0 : this.compareType.hashCode());
        n3 = 31 * n3 + (this.dOrV == null ? 0 : this.dOrV.hashCode());
        n3 = 31 * n3 + Float.floatToIntBits(this.dose);
        n3 = 31 * n3 + (this.doseUnit == null ? 0 : this.doseUnit.hashCode());
        n3 = 31 * n3 + Float.floatToIntBits(this.fuzzyThreshNegative);
        n3 = 31 * n3 + Float.floatToIntBits(this.fuzzyThreshPositive);
        n3 = 31 * n3 + Float.floatToIntBits(this.vol);
        n3 = 31 * n3 + (this.volUnit == null ? 0 : this.volUnit.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DVConstraintState dVConstraintState = (DVConstraintState)object;
        if (this.compareType != dVConstraintState.compareType) {
            return false;
        }
        if (this.dOrV != dVConstraintState.dOrV) {
            return false;
        }
        if (Float.floatToIntBits(this.dose) != Float.floatToIntBits(dVConstraintState.dose)) {
            return false;
        }
        if (this.doseUnit != dVConstraintState.doseUnit) {
            return false;
        }
        if (Float.floatToIntBits(this.fuzzyThreshNegative) != Float.floatToIntBits(dVConstraintState.fuzzyThreshNegative)) {
            return false;
        }
        if (Float.floatToIntBits(this.fuzzyThreshPositive) != Float.floatToIntBits(dVConstraintState.fuzzyThreshPositive)) {
            return false;
        }
        if (Float.floatToIntBits(this.vol) != Float.floatToIntBits(dVConstraintState.vol)) {
            return false;
        }
        return this.volUnit == dVConstraintState.volUnit;
    }
}

