/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.constraints;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.mimvista.MimJsonSerializable;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.dose.constraints.DoseContourConstraintType;
import com.mimvista.dose.constraints.units.a;
import com.mimvista.internals.ad;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.util.NumberFormatFactory;
import com.mimvista.util.Pair;
import java.io.Serializable;

@MimJsonSerializable
public interface DoseConstraint
extends Serializable {

    @MimJsonSerializable
    public static abstract class AbstractDoseContourConstraint
    implements DoseContourConstraint {
        private static final long serialVersionUID = 1L;

        @Override
        public String formatValue(Double d2) {
            FulfilledCellObject.FulfilledState fulfilledState;
            Pair<Double, Double> pair;
            Double d3;
            if (d2 == null || Double.isNaN(d2)) {
                return "-";
            }
            String string = NumberFormatFactory.a().format(d2);
            if (Double.POSITIVE_INFINITY == Math.abs(d2)) {
                return string;
            }
            ComparisonType comparisonType = this.getComparisonType();
            FulfilledCellObject.FulfilledState fulfilledState2 = comparisonType.a(d2, d3 = this.getTargetValue(), pair = this.getPosNegFuzzyThresholds());
            if (fulfilledState2 != (fulfilledState = comparisonType.a(Double.valueOf(string), d3, pair))) {
                return "" + d2;
            }
            return string;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, include=JsonTypeInfo.As.PROPERTY, property="constraintType")
    public static interface DoseContourConstraint
    extends DoseConstraint {
        public FulfilledCellObject.FulfilledState fulfilled(IsodoseOverlay var1, VolumetricContourOverlayish var2);

        public FulfilledCellObject.FulfilledState fulfilled(ad var1, DoseVolumeHistogram var2);

        public Double getValue(IsodoseOverlay var1, VolumetricContourOverlayish var2);

        public Double getValue(ad var1, DoseVolumeHistogram var2);

        public String formatValue(Double var1);

        public Double getValueForDisplay(IsodoseOverlay var1, VolumetricContourOverlayish var2);

        public Double getValueForDisplay(ad var1, DoseVolumeHistogram var2);

        public Double getTargetValue();

        public a getUnits();

        public a getUnitsForDisplay();

        public Pair<Double, Double> getPosNegFuzzyThresholds();

        public String getPosNegThresholdString();

        public DoseContourConstraintType getType();

        public ComparisonType getComparisonType();

        public String getDescription();
    }
}

