/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dose.constraints;

import com.google.common.collect.Lists;
import com.mimvista.MimJsonSerializable;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.gui.constraint.FulfilledCellObject;
import com.mimvista.dose.constraints.ComparisonType;
import com.mimvista.dose.constraints.DoseConstraint;
import com.mimvista.dose.constraints.DoseContext;
import com.mimvista.dose.constraints.DoseContourConstraintType;
import com.mimvista.dose.constraints.MinMeanMaxConstraintState;
import com.mimvista.dose.constraints.units.DoseUnit;
import com.mimvista.dose.constraints.units.a;
import com.mimvista.internals.ad;
import com.mimvista.internals.statistics.IsodoseStatistician;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.mui.overlays.VolumetricContourOverlayish;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.workflow.backend.t;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

@MimJsonSerializable
public class MinMeanMaxConstraint
extends DoseConstraint.AbstractDoseContourConstraint {
    private static final long serialVersionUID = 7416174615069719699L;
    private static Messages messages = DoseContext.a;
    private final MinMeanMaxConstraintState state;

    private MinMeanMaxConstraint() {
        this.state = null;
    }

    public MinMeanMaxConstraint(MinMeanMaxConstraintState minMeanMaxConstraintState) {
        this.state = minMeanMaxConstraintState.a();
    }

    @Override
    public DoseContourConstraintType getType() {
        return DoseContourConstraintType.c;
    }

    @Override
    public ComparisonType getComparisonType() {
        if (this.state == null) {
            return ComparisonType.c;
        }
        return this.state.comparisonType;
    }

    @Override
    public FulfilledCellObject.FulfilledState fulfilled(IsodoseOverlay isodoseOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
        DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.b(volumetricContourOverlayish);
        return this.fulfilled((ad)isodoseOverlay, doseVolumeHistogram);
    }

    @Override
    public FulfilledCellObject.FulfilledState fulfilled(ad ad2, DoseVolumeHistogram doseVolumeHistogram) {
        if (doseVolumeHistogram == null) {
            return null;
        }
        Double d2 = this.getValue(ad2, doseVolumeHistogram);
        Double d3 = this.getTargetValue();
        return this.getComparisonType().a(d2, d3, this.getPosNegFuzzyThresholds());
    }

    @Override
    public Double getValue(IsodoseOverlay isodoseOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
        DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.b(volumetricContourOverlayish);
        if (doseVolumeHistogram == null) {
            return null;
        }
        return this.getValue((ad)isodoseOverlay, doseVolumeHistogram);
    }

    @Override
    public Double getValueForDisplay(IsodoseOverlay isodoseOverlay, VolumetricContourOverlayish volumetricContourOverlayish) {
        IsodoseStatistician isodoseStatistician = isodoseOverlay.h();
        DoseVolumeHistogram doseVolumeHistogram = isodoseStatistician.b(volumetricContourOverlayish);
        if (doseVolumeHistogram == null) {
            return null;
        }
        return this.getValueForDisplay((ad)isodoseOverlay, doseVolumeHistogram);
    }

    @Override
    public Double getValue(ad ad2, DoseVolumeHistogram doseVolumeHistogram) {
        return this.a(ad2, doseVolumeHistogram, false);
    }

    @Override
    public Double getValueForDisplay(ad ad2, DoseVolumeHistogram doseVolumeHistogram) {
        return this.a(ad2, doseVolumeHistogram, true);
    }

    private Double a(ad ad2, DoseVolumeHistogram doseVolumeHistogram, boolean bl2) {
        double d2;
        if (doseVolumeHistogram == null || doseVolumeHistogram.getMaxVolume() <= 0.0) {
            return null;
        }
        switch (this.state.type) {
            case a: {
                d2 = doseVolumeHistogram.getMinDose();
                break;
            }
            case b: {
                d2 = doseVolumeHistogram.getMeanDose();
                break;
            }
            case c: {
                d2 = doseVolumeHistogram.getMaxDose();
                break;
            }
            default: {
                throw new RuntimeException("We don't know how to compute this type of MMMConstraint: " + this.state.type);
            }
        }
        a a2 = this.state.doseUnit;
        if (bl2) {
            a2 = this.getUnitsForDisplay();
        }
        if (a2 == null || !a2.a().equals(DoseUnit.a)) {
            throw new RuntimeException("Invalid unit conversion: " + String.valueOf(DoseUnit.a) + " to " + String.valueOf(a2));
        }
        return a2.b(d2, ad2, doseVolumeHistogram);
    }

    @Override
    public Double getTargetValue() {
        return this.state.dose;
    }

    @Override
    public a getUnits() {
        return this.state.doseUnit;
    }

    @Override
    public a getUnitsForDisplay() {
        a a2 = this.getUnits();
        if (a2 instanceof DoseUnit) {
            Pair<Float, DoseUnit> pair = DoseUnit.a(0.0f, (DoseUnit)a2);
            a2 = (a)pair.y;
        }
        return a2;
    }

    public MinMeanMaxConstraintState getState() {
        return this.state.a();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.state.type.getExternalizedString());
        ComparisonType comparisonType = this.state.comparisonType;
        if (comparisonType != ComparisonType.c) {
            stringBuilder.append(" ");
            stringBuilder.append(this.state.comparisonType.b());
            float f2 = this.state.dose;
            DoseUnit doseUnit = this.state.doseUnit;
            Pair<Float, DoseUnit> pair = DoseUnit.a(f2, doseUnit);
            f2 = ((Float)pair.x).floatValue();
            doseUnit = (DoseUnit)pair.y;
            stringBuilder.append(" ");
            stringBuilder.append(f2);
            stringBuilder.append(" ");
            stringBuilder.append(doseUnit.getExternalizedString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.state == null ? 0 : this.state.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MinMeanMaxConstraint minMeanMaxConstraint = (MinMeanMaxConstraint)object;
        return !(this.state == null ? minMeanMaxConstraint.state != null : !this.state.equals(minMeanMaxConstraint.state));
    }

    @Override
    public Pair<Double, Double> getPosNegFuzzyThresholds() {
        if (this.state == null) {
            return Pair.get(0.0, 0.0);
        }
        return Pair.get(new Double(this.state.fuzzyThreshPositive), new Double(this.state.fuzzyThreshNegative));
    }

    @Override
    public String getPosNegThresholdString() {
        Pair<Double, Double> pair = this.getPosNegFuzzyThresholds();
        a a2 = this.getUnits();
        float f2 = (float)((Double)pair.x).doubleValue();
        float f3 = (float)((Double)pair.y).doubleValue();
        if (a2 instanceof DoseUnit) {
            Pair<Float, DoseUnit> pair2 = DoseUnit.a(f2, (DoseUnit)a2);
            Pair<Float, DoseUnit> pair3 = DoseUnit.a(f3, (DoseUnit)a2);
            if (pair2.y != pair3.y) {
                throw new RuntimeException("Threshold units don't match!");
            }
            f2 = ((Float)pair2.x).floatValue();
            f3 = ((Float)pair3.x).floatValue();
            a2 = (a)pair2.y;
        }
        return "+" + f2 + " / -" + f3 + " " + a2.getExternalizedString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        readHelper.a(objectInputStream, (Object)this);
    }

    public static enum MinMeanMax implements t
    {
        a,
        b,
        c;


        @Override
        public Icon getIcon(int n2) {
            return null;
        }

        @Override
        public String getExternalizedString() {
            return messages.getProperty(this.a());
        }

        public String a() {
            return "MINMEANMAX_" + this.name().toUpperCase();
        }

        public static MinMeanMax a(String string) {
            for (MinMeanMax minMeanMax : MinMeanMax.values()) {
                if (!string.trim().toLowerCase().equals(minMeanMax.getExternalizedString().trim().toLowerCase())) continue;
                return minMeanMax;
            }
            throw new RuntimeException("Unable to parse MinMeanMax enum from string: \"" + string + "\"");
        }

        public static MinMeanMax b(String string) {
            for (MinMeanMax minMeanMax : MinMeanMax.values()) {
                if (!string.trim().toLowerCase().equals(minMeanMax.a().trim().toLowerCase())) continue;
                return minMeanMax;
            }
            throw new RuntimeException("Unable to parse MinMeanMax enum from externalized string: \"" + string + "\"");
        }

        public static List<String> b() {
            ArrayList arrayList = Lists.newArrayList();
            for (MinMeanMax minMeanMax : MinMeanMax.values()) {
                arrayList.add(minMeanMax.getExternalizedString());
            }
            return arrayList;
        }
    }
}

