/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.extensions.control;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.MimJsonSerializable;
import com.mimvista.commands.workflow.launch.d;
import com.mimvista.d;
import com.mimvista.extensions.util.ExtensionId;
import com.mimvista.extensions.util.ExtensionUtils;
import com.mimvista.external.contouring.XMimContour;
import com.mimvista.external.control.XMimAppInstance;
import com.mimvista.external.control.XMimSession;
import com.mimvista.external.integration.XMimLLPInboundMessage;
import com.mimvista.external.integration.XMimLLPMessageSource;
import com.mimvista.external.integration.XMimSearchFilter;
import com.mimvista.external.series.XMimDicomInfo;
import com.mimvista.external.series.XMimDicomSeries;
import com.mimvista.external.series.XMimDose;
import com.mimvista.external.series.XMimImage;
import com.mimvista.external.series.XMimSeriesView;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.file.j;
import com.mimvista.imports.ImportContainer;
import com.mimvista.mui.bm;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.a;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ax;
import com.mimvista.util.ay;
import com.mimvista.util.bd;
import com.mimvista.util.bp;
import com.mimvista.util.cm;
import com.mimvista.util.cn;
import com.mimvista.workflow.backend.Target;
import com.mimvista.workflow.backend.VariableType;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

@MimJsonSerializable
public class ExtensionWrapper
implements d.c<String>,
ImportContainer.a,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXTENSION_INFO_PROPERTIES_FILENAME = "info.properties";
    public static final String MATLAB_EXTENSION_FILENAME = "ext.m";
    public static final String JAVASCRIPT_EXTENSION_FILE_EXTENSION = ".js";
    private static final ImmutableList<String> FILE_EXTENSIONS = ImmutableList.of((Object)".zip", (Object)ImportContainer.ImportType.f.ext, (Object)ImportContainer.ImportType.f.additionalExts.get(0));
    private String name;
    private File zipFile;
    private String desc;
    private String author;
    private String category;
    private String inst;
    private String site;
    private String version;
    private String iconName;
    private String iconTip;
    private ExtensionUtils.ExtensionScope scope;
    private boolean fake = false;
    private boolean matlab = false;
    private boolean javascript = false;
    private String jsFileNameInsideZip = null;
    private String entryClassName;
    private String entryMethodName;
    private Date creationDate;
    private List<ExtensionUtils.a> inputs = Lists.newArrayList();
    private List<ExtensionUtils.a> outputs = Lists.newArrayList();
    private BufferedImage iconImage = null;

    public static ExtensionWrapper getExtensionById(ExtensionId extensionId, bp<String> bp2) {
        Map<ExtensionId, List<ExtensionWrapper>> map = ExtensionWrapper.a(new ArrayList<String>(), c.d());
        List<ExtensionWrapper> list = map.get(extensionId);
        Messages messages = Messages.a("Extensions");
        if (list == null || list.isEmpty()) {
            bp2.a = MIMFormat.a(messages.b("EXTENSION_NO_MATCH"), extensionId.getName(), extensionId.getAuthor());
            ay.d((Object)("Unknown extension: " + extensionId), ExtensionWrapper.class);
            return null;
        }
        if (list.size() > 1) {
            bp2.a = MIMFormat.a(messages.b("EXTENSION_RUN_DUPE"), extensionId.getName(), extensionId.getAuthor());
            ay.d((Object)("Failed to get extension by id due to multiple matches. Name: " + extensionId.getName() + " Auth: " + extensionId.getAuthor()), ExtensionWrapper.class);
            return null;
        }
        return list.get(0);
    }

    private static List<File> a(c c2) {
        FileFilter fileFilter = j.b(FILE_EXTENSIONS);
        List<File> list = c2.a(CascadeSubfolder.q, fileFilter);
        list.addAll(MIMFile.a(new File(Path.getExtensionPath()), fileFilter));
        return list;
    }

    private static Map<ExtensionId, List<ExtensionWrapper>> a(List<String> list, c c2) {
        return ExtensionWrapper.getExtensionMap(list, ExtensionWrapper.a(c2));
    }

    public static Map<ExtensionId, List<ExtensionWrapper>> getExtensionMapFromDirectory(List<String> list, File file) {
        return ExtensionWrapper.getExtensionMap(list, MIMFile.a(file, j.b(FILE_EXTENSIONS)));
    }

    public static Map<ExtensionId, List<ExtensionWrapper>> getExtensionMap(List<String> list, Iterable<File> iterable) {
        HashMap hashMap = Maps.newHashMap();
        for (File file : iterable) {
            Object object;
            String string = file.getName().toLowerCase();
            if (string.endsWith(".zip") || string.endsWith(ImportContainer.ImportType.f.ext)) {
                object = ExtensionWrapper.getExtensionsFromZipFile(file);
                if (object == null) {
                    list.add(file.getName());
                    continue;
                }
                for (int i2 = 0; i2 < object.size(); ++i2) {
                    ExtensionWrapper extensionWrapper = object.get(i2);
                    if (extensionWrapper == null) {
                        list.add(file.getName() + " #" + i2);
                        continue;
                    }
                    ExtensionId extensionId = extensionWrapper.getId();
                    List list2 = (List)hashMap.get(extensionId);
                    if (list2 == null) {
                        list2 = Lists.newArrayList();
                        hashMap.put(extensionId, list2);
                    }
                    list2.add(extensionWrapper);
                }
                continue;
            }
            if (!string.endsWith(ImportContainer.ImportType.f.additionalExts.get(0))) continue;
            object = ExtensionWrapper.getExtensionFromJSFile(file, null);
            if (object != null) {
                hashMap.put(((ExtensionWrapper)object).getId(), Lists.newArrayList((Object[])new ExtensionWrapper[]{object}));
                continue;
            }
            list.add(file.getName());
        }
        return hashMap;
    }

    public static ExtensionWrapper getExtensionFromJSFile(File file, @d ZipFile zipFile) {
        ZipEntry zipEntry = null;
        if (zipFile != null && (zipEntry = ExtensionWrapper.a(zipFile, JAVASCRIPT_EXTENSION_FILE_EXTENSION)) == null) {
            return null;
        }
        try {
            ExtensionWrapper extensionWrapper;
            ObjectMapper objectMapper = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            objectMapper.setVisibilityChecker(objectMapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(ExtensionUtils.a.class, (JsonDeserializer)new JsonDeserializer<ExtensionUtils.a>(){

                public ExtensionUtils.a a(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                    ExtensionUtils.a a2;
                    String string;
                    ObjectNode objectNode = (ObjectNode)jsonParser.getCodec().readTree(jsonParser);
                    String string2 = (String)objectNode.fieldNames().next();
                    switch (string = objectNode.get(string2).asText()) {
                        case "XMimSession": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimSession.class));
                            break;
                        }
                        case "XMimImage": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimImage.class));
                            break;
                        }
                        case "XMimContour": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimContour.class));
                            break;
                        }
                        case "XMimDose": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimDose.class));
                            break;
                        }
                        case "XMimAppInstance": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimAppInstance.class));
                            break;
                        }
                        case "XMimDicomSeries": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimDicomSeries.class));
                            break;
                        }
                        case "XMimSeriesView": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimSeriesView.class));
                            break;
                        }
                        case "List<XMimContour>": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)List.class));
                            break;
                        }
                        case "String": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)String.class));
                            break;
                        }
                        case "XMimSearchFilter": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimSearchFilter.class));
                            break;
                        }
                        case "XMimLLPInboundMessage": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimLLPInboundMessage.class));
                            break;
                        }
                        case "XMimLLPMessageSource": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimLLPMessageSource.class));
                            break;
                        }
                        case "XMimDicomInfo": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)XMimDicomInfo.class));
                            break;
                        }
                        case "List<XMimDicomInfo>": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)List.class));
                            break;
                        }
                        case "Map<String, Object>": {
                            a2 = new ExtensionUtils.a(string2, (Type)((Object)Map.class));
                            break;
                        }
                        default: {
                            ay.b((Object)("Unknown Extension param type " + string), (Object)this);
                            return null;
                        }
                    }
                    return a2;
                }

                public /* synthetic */ Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                    return this.a(jsonParser, deserializationContext);
                }
            });
            objectMapper.registerModule((Module)simpleModule);
            if (zipEntry != null) {
                extensionWrapper = (ExtensionWrapper)objectMapper.readValue(zipFile.getInputStream(zipEntry), ExtensionWrapper.class);
                extensionWrapper.jsFileNameInsideZip = zipEntry.getName();
            } else {
                extensionWrapper = (ExtensionWrapper)objectMapper.readValue(file, ExtensionWrapper.class);
            }
            extensionWrapper.zipFile = file;
            extensionWrapper.javascript = true;
            if (extensionWrapper.name == null) {
                String string = file.getName();
                extensionWrapper.name = string.substring(0, string.lastIndexOf(46));
            }
            if (extensionWrapper.author == null) {
                extensionWrapper.author = "";
            }
            if (extensionWrapper.category == null) {
                extensionWrapper.category = "";
            }
            if (extensionWrapper.desc == null) {
                extensionWrapper.category = "";
            }
            if (extensionWrapper.inst == null) {
                extensionWrapper.inst = "";
            }
            if (extensionWrapper.site == null) {
                extensionWrapper.site = "";
            }
            return extensionWrapper;
        }
        catch (Throwable throwable) {
            ay.b((Object)("Couldn't parse extension json from " + file), throwable, ExtensionWrapper.class);
            return null;
        }
    }

    public static Invocable loadScriptEngine(ScriptEngine scriptEngine, ExtensionWrapper extensionWrapper) throws ScriptException, IOException {
        String string;
        if (extensionWrapper.jsFileNameInsideZip == null) {
            string = FileUtils.readFileToString((File)extensionWrapper.zipFile, (String)"UTF-8");
        } else {
            try (ZipFile zipFile = new ZipFile(extensionWrapper.zipFile);){
                string = IOUtils.toString((InputStream)zipFile.getInputStream(new ZipEntry(extensionWrapper.jsFileNameInsideZip)), (String)"UTF-8");
            }
        }
        scriptEngine.eval("var ___com_mimvista_extensions_js_metadata = " + string);
        return (Invocable)((Object)scriptEngine);
    }

    public static List<ExtensionWrapper> parseSessionExtensionsFromCascade(boolean bl2, c c2) {
        List<ExtensionWrapper> list = ExtensionWrapper.parseExtensionsFromCascade(bl2, c2);
        list.removeIf(extensionWrapper -> extensionWrapper.getScope() != ExtensionUtils.ExtensionScope.SESSION);
        return list;
    }

    public static List<ExtensionWrapper> parseExtensionsFromCascade(boolean bl2, c c2) {
        return ExtensionWrapper.parseExtensions(bl2, ExtensionWrapper.a(c2));
    }

    public static List<ExtensionWrapper> parseExtensions(boolean bl2, Iterable<File> iterable) {
        List<ExtensionWrapper> list;
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        Map<ExtensionId, List<ExtensionWrapper>> map = ExtensionWrapper.getExtensionMap(arrayList2, iterable);
        HashSet hashSet = Sets.newHashSet();
        for (Map.Entry<ExtensionId, List<ExtensionWrapper>> entry : map.entrySet()) {
            list = entry.getValue();
            if (list.size() <= 1) {
                arrayList.addAll(list);
                continue;
            }
            hashSet.add(entry.getKey());
        }
        Collections.sort(arrayList, (extensionWrapper, extensionWrapper2) -> extensionWrapper.getName().compareToIgnoreCase(extensionWrapper2.getName()));
        if (bl2) {
            Object object2;
            Map.Entry<ExtensionId, List<ExtensionWrapper>> entry;
            Messages messages = Messages.a("Extensions");
            if (!arrayList2.isEmpty()) {
                entry = messages.getProperty("EXTENSION_GUI_LOAD_ERROR");
                for (Object object2 : arrayList2) {
                    entry = (String)((Object)entry) + "\n" + (String)object2;
                }
                list = new Notification.a(bm.b());
                object2 = new BasicNotification(BasicNotification.NotificationType.b, (String)((Object)entry), (Notification.a)((Object)list));
                ((a)object2).setPriority(500);
                u.b().c((Notification)object2);
            }
            if (!hashSet.isEmpty()) {
                entry = messages.getProperty("EXTENSION_LIST_DUPE");
                for (Object object2 : hashSet) {
                    entry = (String)((Object)entry) + "\n" + ((ExtensionId)object2).getName() + " - " + ((ExtensionId)object2).getAuthor();
                }
                list = new Notification.a(bm.b());
                object2 = new BasicNotification(BasicNotification.NotificationType.b, (String)((Object)entry), (Notification.a)((Object)list));
                ((a)object2).setPriority(499);
                u.b().c((Notification)object2);
            }
        }
        return arrayList;
    }

    public static List<String> getErrorMessages() {
        List<ExtensionWrapper> list;
        Map.Entry<ExtensionId, List<ExtensionWrapper>> entry2;
        ArrayList arrayList = Lists.newArrayList();
        Map<ExtensionId, List<ExtensionWrapper>> map = ExtensionWrapper.a(arrayList, c.d());
        HashSet hashSet = Sets.newHashSet();
        for (Map.Entry<ExtensionId, List<ExtensionWrapper>> entry2 : map.entrySet()) {
            list = entry2.getValue();
            if (list.size() <= 1) continue;
            hashSet.add(entry2.getKey());
        }
        ArrayList arrayList2 = new ArrayList();
        entry2 = Messages.a("Extensions");
        if (!arrayList.isEmpty()) {
            list = ((Messages)((Object)entry2)).getProperty("EXTENSION_GUI_LOAD_ERROR");
            for (Object object : arrayList) {
                list = (String)((Object)list) + "\n" + (String)object;
            }
            arrayList2.add(list);
        }
        if (!hashSet.isEmpty()) {
            list = ((Messages)((Object)entry2)).getProperty("EXTENSION_LIST_DUPE");
            for (Object object : hashSet) {
                list = (String)((Object)list) + "\n" + ((ExtensionId)object).getName() + " - " + ((ExtensionId)object).getAuthor();
            }
            arrayList2.add(list);
        }
        return arrayList2;
    }

    public static List<ExtensionWrapper> getExtensionsFromZipFile(File file) {
        if (!file.exists()) {
            ay.d((Object)"Zip file not found, cannot parse extensions.", ExtensionWrapper.class);
            return null;
        }
        ArrayList<ExtensionWrapper> arrayList = new ArrayList<ExtensionWrapper>();
        try (ZipFile zipFile = new ZipFile(file);){
            int n2 = ExtensionWrapper.a(zipFile);
            ExtensionWrapper extensionWrapper = ExtensionWrapper.a(file, zipFile);
            if (extensionWrapper != null) {
                arrayList.add(extensionWrapper);
            } else {
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        ExtensionWrapper extensionWrapper2 = new ExtensionWrapper(file, zipFile, i2);
                        arrayList.add(extensionWrapper2);
                        continue;
                    }
                    catch (Exception exception) {
                        ay.d((Object)"Error parsing extension from zip.", (Throwable)exception, ExtensionWrapper.class);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (arrayList.isEmpty()) {
            ay.d((Object)("Error unzipping " + file), ExtensionWrapper.class);
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExtensionZip(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            boolean bl2 = ExtensionWrapper.a(zipFile) > 0;
            return bl2;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static int a(ZipFile zipFile) throws IOException {
        if (ExtensionWrapper.a(zipFile, JAVASCRIPT_EXTENSION_FILE_EXTENSION) != null) {
            return 1;
        }
        InputStream inputStream = zipFile.getInputStream(new ZipEntry(EXTENSION_INFO_PROPERTIES_FILENAME));
        if (inputStream == null) {
            return 0;
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        String string = zipFile.getEntry(MATLAB_EXTENSION_FILENAME) == null ? properties.getProperty("ENTRY_COUNT", "0") : "1";
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public ExtensionWrapper(File file, ZipFile zipFile, int n2) throws Exception {
        ExtensionUtils.CachedExtInfo cachedExtInfo;
        Object object;
        Object object2;
        String string;
        int n3;
        this.zipFile = file;
        InputStream inputStream = null;
        this.matlab = zipFile.getEntry(MATLAB_EXTENSION_FILENAME) != null;
        inputStream = zipFile.getInputStream(new ZipEntry(EXTENSION_INFO_PROPERTIES_FILENAME));
        Properties properties = new Properties();
        properties.load(inputStream);
        this.name = this.matlab ? properties.getProperty("NAME") : properties.getProperty("NAME_" + n2);
        this.desc = this.matlab ? properties.getProperty("DESC") : properties.getProperty("DESC_" + n2);
        this.author = this.matlab ? properties.getProperty("AUTHOR") : properties.getProperty("AUTHOR_" + n2);
        this.category = this.matlab ? properties.getProperty("CATEGORY") : properties.getProperty("CATEGORY_" + n2);
        this.inst = this.matlab ? properties.getProperty("COMPANY") : properties.getProperty("COMPANY_" + n2);
        this.site = this.matlab ? properties.getProperty("WEBSITE") : properties.getProperty("WEBSITE_" + n2);
        this.version = this.matlab ? properties.getProperty("VERSION") : properties.getProperty("VERSION_" + n2);
        this.iconName = this.matlab ? properties.getProperty("ICON") : properties.getProperty("ICON_" + n2);
        this.iconTip = this.matlab ? properties.getProperty("ICON_TIP") : properties.getProperty("ICON_TIP_" + n2);
        String string2 = this.matlab ? properties.getProperty("SCOPE") : properties.getProperty("SCOPE_" + n2);
        this.scope = ExtensionUtils.ExtensionScope.fromUserKey(string2);
        String string3 = properties.getProperty("CREATION_DATE");
        if (string3 != null) {
            try {
                this.creationDate = DateFormat.getDateTimeInstance(0, 0).parse(string3);
            }
            catch (Exception exception) {
                ay.d((Object)"Error parsing extension date.", (Throwable)exception, ExtensionWrapper.class);
            }
        }
        this.entryClassName = properties.getProperty("CLASS_" + n2);
        this.entryMethodName = properties.getProperty("METHOD_" + n2);
        int n4 = Integer.parseInt(properties.getProperty("PARAM_COUNT_" + n2, "0"));
        for (n3 = 0; n3 < n4; ++n3) {
            String string4 = properties.getProperty("PARAM_NAME_" + n2 + "_" + n3);
            string = properties.getProperty("PARAM_TYPE_GENERIC_" + n2 + "_" + n3);
            if (string == null) {
                string = properties.getProperty("PARAM_TYPE_" + n2 + "_" + n3);
            }
            if (string == null) {
                throw new Exception("Missing input param type, fatal error.");
            }
            try {
                object2 = bd.a(string);
            }
            catch (Exception exception) {
                throw new Exception("Input param of unknown type (" + string + " " + string4 + ").  Fatal Error.");
            }
            object = new ExtensionUtils.a(string4, (Type)object2);
            this.inputs.add((ExtensionUtils.a)object);
        }
        if (this.scope == ExtensionUtils.ExtensionScope.SESSION) {
            n3 = Integer.parseInt(properties.getProperty("OUTPUT_COUNT_" + n2, "0"));
            for (int i2 = 0; i2 < n3; ++i2) {
                string = properties.getProperty("OUTPUT_TYPE_" + n2 + "_" + i2);
                object2 = properties.getProperty("OUTPUT_NAME_" + n2 + "_" + i2);
                if (string == null) {
                    ay.d((Object)"Output missing type, will ignore.", this);
                    this.outputs.add(new ExtensionUtils.a(null, null));
                    continue;
                }
                try {
                    object = Class.forName(string);
                }
                catch (Exception exception) {
                    ay.c((Object)("Output of unknown type (" + string + ").  Will ignore."), this);
                    this.outputs.add(new ExtensionUtils.a(null, null));
                    continue;
                }
                ExtensionUtils.a a2 = new ExtensionUtils.a((String)object2, (Type)object);
                this.outputs.add(a2);
            }
        } else if (this.scope == ExtensionUtils.ExtensionScope.MESSAGE) {
            // empty if block
        }
        if ((cachedExtInfo = ExtensionUtils.a(this.getId())) != null) {
            this.iconImage = cachedExtInfo.getImage();
        } else if (!cn.h(this.iconName)) {
            try {
                ZipEntry zipEntry = zipFile.getEntry(this.iconName);
                this.iconImage = ImageIO.read(zipFile.getInputStream(zipEntry));
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, this);
            }
        }
    }

    private static ExtensionWrapper a(File file, ZipFile zipFile) {
        ExtensionWrapper extensionWrapper = ExtensionWrapper.getExtensionFromJSFile(file, zipFile);
        if (extensionWrapper == null) {
            return null;
        }
        ZipEntry zipEntry = ExtensionWrapper.a(zipFile, ".png", ".jpg", ".gif");
        if (zipEntry != null) {
            try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
                extensionWrapper.iconImage = ImageIO.read(inputStream);
            }
            catch (IOException iOException) {
                ay.d((Object)("Reading image for extension " + file.getName()), (Throwable)iOException, ExtensionWrapper.class);
            }
        }
        return extensionWrapper;
    }

    private static ZipEntry a(ZipFile zipFile, String ... stringArray) {
        ArrayList<? extends ZipEntry> arrayList = Collections.list(zipFile.entries());
        Collections.sort(arrayList, (zipEntry, zipEntry2) -> zipEntry.getName().compareTo(zipEntry2.getName()));
        for (ZipEntry zipEntry3 : arrayList) {
            for (String string : stringArray) {
                if (zipEntry3.isDirectory() || !zipEntry3.getName().endsWith(string)) continue;
                return zipEntry3;
            }
        }
        return null;
    }

    public ExtensionWrapper(String string, boolean bl2) {
        this.name = string;
        this.matlab = bl2;
        this.fake = true;
    }

    public ExtensionWrapper() {
    }

    public boolean isMatlab() {
        return this.matlab;
    }

    public boolean isJavascript() {
        return this.javascript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMFile unpackJar() {
        block9: {
            MIMFile mIMFile;
            ZipFile zipFile = null;
            FileOutputStream fileOutputStream = null;
            try {
                zipFile = new ZipFile(this.zipFile);
                InputStream inputStream = zipFile.getInputStream(new ZipEntry("ext.jar"));
                MIMFile mIMFile2 = new MIMFile(PathUtils.getTempPath("extTemp", true, true));
                MIMFile mIMFile3 = new MIMFile(mIMFile2, "ext.jar");
                fileOutputStream = new FileOutputStream(mIMFile3);
                cm.a(inputStream, fileOutputStream);
                for (ZipEntry zipEntry : ax.b(zipFile.entries())) {
                    if (zipEntry.isDirectory()) continue;
                    String string = "lib/";
                    if (!zipEntry.getName().startsWith(string)) continue;
                    MIMFile mIMFile4 = new MIMFile(mIMFile2, string + zipEntry.getName().substring(string.length()));
                    mIMFile4.g().mkdirs();
                    InputStream inputStream2 = null;
                    FileOutputStream fileOutputStream2 = null;
                    try {
                        inputStream2 = zipFile.getInputStream(zipEntry);
                        fileOutputStream2 = new FileOutputStream(mIMFile4);
                        cm.a(inputStream2, fileOutputStream2);
                    }
                    finally {
                        cm.a((Closeable)inputStream2, null, null);
                        cm.a((Closeable)fileOutputStream2, null, null);
                    }
                }
                mIMFile = mIMFile2;
                cm.a(zipFile, null, null);
            }
            catch (Exception exception) {
                ay.d((Object)"Error.", (Throwable)exception, ExtensionWrapper.class);
                break block9;
            }
            finally {
                cm.a(zipFile, null, null);
                cm.a(fileOutputStream, null, null);
            }
            cm.a((Closeable)fileOutputStream, null, null);
            return mIMFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MIMFile unzip(boolean bl2) {
        ZipFile zipFile = null;
        Closeable closeable = null;
        try {
            zipFile = new ZipFile(this.zipFile);
            MIMFile mIMFile = new MIMFile(PathUtils.getTempPath("extTemp", true, true));
            for (ZipEntry zipEntry : ax.b(zipFile.entries())) {
                if (zipEntry.isDirectory()) continue;
                MIMFile mIMFile2 = new MIMFile(mIMFile, zipEntry.getName());
                if (bl2) {
                    if (zipEntry.getName().endsWith(EXTENSION_INFO_PROPERTIES_FILENAME)) continue;
                    mIMFile2 = new MIMFile(mIMFile, mIMFile2.getName());
                }
                if (mIMFile2.exists()) {
                    ay.d((Object)"Duplicate files detected in extension zip!  Failure likely.", this);
                    continue;
                }
                mIMFile2.g().mkdirs();
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    inputStream = zipFile.getInputStream(zipEntry);
                    fileOutputStream = new FileOutputStream(mIMFile2);
                    cm.a(inputStream, fileOutputStream);
                }
                finally {
                    cm.a((Closeable)inputStream, null, null);
                    cm.a((Closeable)fileOutputStream, null, null);
                }
            }
            MIMFile mIMFile3 = mIMFile;
            return mIMFile3;
        }
        catch (Exception exception) {
            ay.d((Object)"Error.", (Throwable)exception, ExtensionWrapper.class);
        }
        finally {
            cm.a(zipFile, null, null);
            cm.a(closeable, null, null);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Date getCreationDate() {
        if (this.creationDate == null) {
            return new Date(this.getZipFile().lastModified());
        }
        return this.creationDate;
    }

    public File getZipFile() {
        return this.zipFile;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCategory() {
        return this.category;
    }

    public String getEntryClassName() {
        return this.entryClassName;
    }

    public String getEntryMethodName() {
        return this.entryMethodName;
    }

    public List<ExtensionUtils.a> getInputs() {
        return this.inputs;
    }

    public String getInst() {
        return this.inst;
    }

    public String getSite() {
        return this.site;
    }

    public String getVersion() {
        return this.version;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getIconTip() {
        return this.iconTip;
    }

    public ExtensionUtils.ExtensionScope getScope() {
        return this.scope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public d.d getOutput(String string) {
        void var4_10;
        ExtensionUtils.a a2 = null;
        for (ExtensionUtils.a object2 : this.outputs) {
            if (!string.equals(object2.a())) continue;
            a2 = object2;
            break;
        }
        if (a2 == null) {
            return null;
        }
        Class<?> clazz = a2.d();
        Object var4_5 = null;
        if (XMimDose.class.isAssignableFrom(clazz)) {
            VariableType variableType = VariableType.c;
        } else if (XMimImage.class.isAssignableFrom(clazz) || XMimSeriesView.class.isAssignableFrom(clazz)) {
            VariableType variableType = VariableType.a;
        } else if (XMimContour.class.isAssignableFrom(clazz)) {
            VariableType variableType = VariableType.b;
        } else if (Float.class.isAssignableFrom(clazz)) {
            VariableType variableType = VariableType.g;
        } else {
            ay.d((Object)("Unknown return type: " + clazz), this.category);
            return null;
        }
        d.d d2 = new d.d((VariableType)var4_10, false);
        return d2;
    }

    public ExtensionId getId() {
        return new ExtensionId(this.getName(), this.getAuthor());
    }

    public List<ExtensionUtils.a> getOutputs() {
        return this.outputs;
    }

    public Class<?>[] getEntrySig() {
        Class[] classArray = new Class[this.inputs.size()];
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            classArray[i2] = this.inputs.get(i2).c();
        }
        return classArray;
    }

    public boolean isFake() {
        return this.fake;
    }

    public BufferedImage getImage() {
        return this.iconImage;
    }

    @Override
    public String getDescription() {
        return this.getDesc();
    }

    @Override
    public String getPath() {
        return this.getZipFile().getAbsolutePath();
    }

    @Override
    public String getFilename() {
        return this.getZipFile().getName();
    }

    @Override
    public long getFileLastModifiedTime() {
        return this.getZipFile().lastModified();
    }

    @Override
    public ImportContainer.ImportType getImportType() {
        return ImportContainer.ImportType.f;
    }

    @Override
    public Iterable<Target> getTargets() {
        return null;
    }
}

