/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.extensions.gui;

import com.google.common.collect.Lists;
import com.mimvista.extensions.control.ExtensionWrapper;
import com.mimvista.util.Messages;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ExtensionListJTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private Messages props = Messages.a("Extensions");
    List<ExtensionWrapper> extens;

    public ExtensionListJTable(List<ExtensionWrapper> list) {
        this.extens = list;
        DefaultTableModel defaultTableModel = new DefaultTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
        this.setModel(defaultTableModel);
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoCreateRowSorter(true);
        this.setAutoCreateRowSorter(true);
        this.setSelectionMode(0);
        String string = this.props.getProperty("EXTENSION_GUI_NAME_NO_COLON");
        defaultTableModel.addColumn(string);
        defaultTableModel.addColumn(this.props.getProperty("EXTENSION_GUI_CATEGORY_NO_COLON"));
        defaultTableModel.addColumn(this.props.getProperty("EXTENSION_GUI_AUTHOR_NO_COLON"));
        defaultTableModel.addColumn(this.props.getProperty("EXTENSION_GUI_DESCRIPTION_NO_COLON"));
        defaultTableModel.addColumn(this.props.getProperty("EXTENSION_GUI_DATE_NO_COLON"));
        int n2 = this.getColumnModel().getColumnIndex(string);
        ArrayList arrayList = Lists.newArrayList((Object[])new RowSorter.SortKey[]{new RowSorter.SortKey(n2, SortOrder.ASCENDING)});
        this.getRowSorter().setSortKeys(arrayList);
        for (int i2 = 0; i2 < this.getColumnCount(); ++i2) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i2);
            if (i2 == 0) {
                tableColumn.setPreferredWidth(150);
                continue;
            }
            if (i2 == 3) {
                tableColumn.setPreferredWidth(210);
                continue;
            }
            if (i2 == 4) {
                tableColumn.setPreferredWidth(10);
                continue;
            }
            tableColumn.setPreferredWidth(40);
        }
        for (ExtensionWrapper extensionWrapper : list) {
            Object[] objectArray = new Object[5];
            objectArray[0] = extensionWrapper.getName();
            objectArray[1] = extensionWrapper.getCategory();
            objectArray[2] = extensionWrapper.getAuthor();
            objectArray[3] = extensionWrapper.getDesc();
            Date date = extensionWrapper.getCreationDate();
            if (date == null) {
                date = new Date(extensionWrapper.getZipFile().lastModified());
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM-dd-yyyy");
            objectArray[4] = simpleDateFormat.format(date);
            defaultTableModel.addRow(objectArray);
        }
    }

    public void a(ExtensionWrapper extensionWrapper) {
        int n2 = this.extens.indexOf(extensionWrapper);
        if (n2 == -1) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n2, n2);
    }

    public ExtensionWrapper a() {
        int n2 = this.getSelectedRow();
        if (n2 == -1) {
            return null;
        }
        return this.extens.get(this.convertRowIndexToModel(n2));
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        return (String)this.getValueAt(this.rowAtPoint(point), this.columnAtPoint(point));
    }
}

