/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.extensions.shims.stats;

import com.google.common.collect.Lists;
import com.mimvista.dicom.rtdose.DoseVolumeHistogram;
import com.mimvista.dicom.rtdose.DvhInfo;
import com.mimvista.dicom.rtdose.ReferencedRoi;
import com.mimvista.external.stats.XMimDoseVolumeHistogramInfo;
import java.util.ArrayList;
import java.util.List;

public class ShimDoseVolumeHistogramInfo
implements XMimDoseVolumeHistogramInfo {
    private DvhInfo info;
    private double firstBin;
    private boolean mimgenerated;
    private Iterable<ReferencedRoi> rois;

    public ShimDoseVolumeHistogramInfo(DvhInfo dvhInfo, Iterable<ReferencedRoi> iterable, double d2, boolean bl2) {
        this.info = dvhInfo;
        this.firstBin = d2;
        this.mimgenerated = bl2;
        this.rois = iterable;
    }

    public boolean isMimGenerated() {
        return this.mimgenerated;
    }

    public List<String> getReferencedContours() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.rois == null) {
            return arrayList;
        }
        for (ReferencedRoi referencedRoi : this.rois) {
            arrayList.add(referencedRoi.toString());
        }
        return arrayList;
    }

    public XMimDoseVolumeHistogramInfo.XMimDVHDoseUnits getDoseUnit() {
        DoseVolumeHistogram.DoseUnits doseUnits = this.info.doseUnits;
        if (doseUnits == DoseVolumeHistogram.DoseUnits.GY) {
            return XMimDoseVolumeHistogramInfo.XMimDVHDoseUnits.GY;
        }
        return XMimDoseVolumeHistogramInfo.XMimDVHDoseUnits.RELATIVE;
    }

    public XMimDoseVolumeHistogramInfo.XMimDVHType getDVHType() {
        DoseVolumeHistogram.DVHType dVHType = this.info.dvhType;
        if (dVHType == DoseVolumeHistogram.DVHType.CUMULATIVE) {
            return XMimDoseVolumeHistogramInfo.XMimDVHType.CUMULATIVE;
        }
        if (dVHType == DoseVolumeHistogram.DVHType.DIFFERENTIAL) {
            return XMimDoseVolumeHistogramInfo.XMimDVHType.DIFFERENTIAL;
        }
        return XMimDoseVolumeHistogramInfo.XMimDVHType.NATURAL;
    }

    public Number getDoseOfFirstBin() {
        return this.firstBin;
    }

    public Number getDoseScaling() {
        return this.info.dvhDoseScaling;
    }

    public Number getDoseGridScaling() {
        return this.info.dvhDoseGridScaling;
    }
}

