/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.extensions.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.external.series.XMimDicomInfo;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.List;

public class DicomInfoProvider
implements XMimDicomInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private JsonDicomSeries dicom;

    public DicomInfoProvider(DicomSeries dicomSeries) {
        this.dicom = JsonDicomSeries.castOrConvert(dicomSeries);
    }

    public Object getValueByName(String string) {
        return this.getValue(TagUtils.forTagName(string));
    }

    public Object getValueArrayByName(String string) {
        return this.getValueArray(TagUtils.forTagName(string));
    }

    private static Object a(List<?> list) {
        if (list.isEmpty()) {
            return new Object[0];
        }
        int n2 = list.size();
        Object obj = list.get(0);
        if (obj instanceof Boolean) {
            boolean[] blArray = new boolean[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                blArray[i2] = (Boolean)list.get(i2);
            }
            return blArray;
        }
        if (obj instanceof Short) {
            short[] sArray = new short[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                sArray[i3] = (Short)list.get(i3);
            }
            return sArray;
        }
        if (obj instanceof Byte) {
            byte[] byArray = new byte[n2];
            for (int i4 = 0; i4 < n2; ++i4) {
                byArray[i4] = (Byte)list.get(i4);
            }
            return byArray;
        }
        if (obj instanceof Character) {
            char[] cArray = new char[n2];
            for (int i5 = 0; i5 < n2; ++i5) {
                cArray[i5] = ((Character)list.get(i5)).charValue();
            }
            return cArray;
        }
        if (obj instanceof Integer) {
            int[] nArray = new int[n2];
            for (int i6 = 0; i6 < n2; ++i6) {
                nArray[i6] = (Integer)list.get(i6);
            }
            return nArray;
        }
        if (obj instanceof Float) {
            float[] fArray = new float[n2];
            for (int i7 = 0; i7 < n2; ++i7) {
                fArray[i7] = ((Float)list.get(i7)).floatValue();
            }
            return fArray;
        }
        if (obj instanceof Double) {
            double[] dArray = new double[n2];
            for (int i8 = 0; i8 < n2; ++i8) {
                dArray[i8] = (Double)list.get(i8);
            }
            return dArray;
        }
        if (obj instanceof Long) {
            long[] lArray = new long[n2];
            for (int i9 = 0; i9 < n2; ++i9) {
                lArray[i9] = (Long)list.get(i9);
            }
            return lArray;
        }
        return list.toArray();
    }

    public Object getValue(int n2) {
        ImmutableList immutableList = this.dicom.getTagValues(n2);
        if (immutableList == null || immutableList.isEmpty()) {
            return null;
        }
        Object object = immutableList.get(0);
        if (object instanceof DicomSeries) {
            return new DicomInfoProvider((DicomSeries)object);
        }
        return object;
    }

    public Object getValueArray(int n2) {
        ImmutableList immutableList = this.dicom.getTagValues(n2);
        if (immutableList == null || immutableList.isEmpty()) {
            return new Object[0];
        }
        Object object = immutableList.get(0);
        if (object instanceof DicomSeries) {
            DicomInfoProvider[] dicomInfoProviderArray = new DicomInfoProvider[immutableList.size()];
            for (int i2 = 0; i2 < immutableList.size(); ++i2) {
                dicomInfoProviderArray[i2] = new DicomInfoProvider((DicomSeries)immutableList.get(i2));
            }
            return dicomInfoProviderArray;
        }
        if (immutableList.size() == 1) {
            return object;
        }
        return DicomInfoProvider.a(immutableList);
    }

    public Object a(Number number) {
        return this.getValue(number.intValue());
    }

    public Object getValue(String string) {
        try {
            int n2 = TagUtils.parseTagValue(string);
            return this.getValue(n2);
        }
        catch (DicomTagParseException dicomTagParseException) {
            return null;
        }
    }

    public Object getValueArray(String string) {
        try {
            int n2 = TagUtils.parseTagValue(string);
            return this.getValueArray(n2);
        }
        catch (DicomTagParseException dicomTagParseException) {
            return new Object[0];
        }
    }

    public DicomInfoProvider a(int n2, int n3) {
        try {
            ImmutableList<DicomSeries> immutableList = this.dicom.getTagSequence(n2);
            if (immutableList == null) {
                return null;
            }
            return new DicomInfoProvider((DicomSeries)Iterables.get(immutableList, (int)n3));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw indexOutOfBoundsException;
        }
        catch (Exception exception) {
            ay.d((Object)"This tag does not appear to be a sequence...", this);
            return null;
        }
    }

    public /* synthetic */ XMimDicomInfo getSubObject(int n2, int n3) {
        return this.a(n2, n3);
    }
}

