/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.file;

import com.google.common.base.Objects;
import com.mimvista.ExternallyVisible;
import com.mimvista.IndirectlyInstantiated;
import com.mimvista.archive.Parser;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.imports.b;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.CdburningPrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.user.LoginChecker;
import com.mimvista.user.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

@ExternallyVisible
@IndirectlyInstantiated
public class Path
extends PathUtils {
    static String a = "/";

    public static String getFullPath(String string, String string2) {
        return PathUtils.getFullPath(string, string2);
    }

    public static String getTempCaptureDir() {
        return Path.getMIMTempPath() + File.separator + "Captures" + File.separator;
    }

    public static String getTempMimportPodDir() {
        return com.mimvista.imports.b.a.getAbsolutePath() + File.separator;
    }

    public static String getTempQuickImageDir() {
        return Path.getTempCaptureDir() + "StraightToImage" + File.separator;
    }

    public static String getFTPFullPath(String string, String string2) {
        String string3 = "";
        int n2 = string.length() - 1;
        if (string.lastIndexOf(a) != n2) {
            string = string + a;
        }
        if (string2.indexOf(a) == 0) {
            string2 = string2.substring(1);
        }
        string3 = string + string2;
        return string3;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Config base         : " + Path.getLegacyConfigBasePath());
            System.out.println("");
            System.out.println("Config (application): " + Path.getConfigPath());
            System.out.println("Config (system)     : " + Path.getSystemConfigPath());
            System.out.println("-------------------------------------------------");
            System.out.println("Log base         : " + Path.getLogBasePath());
            System.out.println("");
            System.out.println("Log (application): " + Path.getLogPath());
            System.out.println("Log (system)     : " + Path.getServiceLogPath());
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected String a() {
        Object object;
        User user = LoginChecker.getInstance().currentUser();
        if (user == null) {
            return Path.getLegacyConfigBasePath();
        }
        String string = Path.getLegacyConfigBasePath();
        if (LoginChecker.getInstance().isEditSiteDefaults()) {
            string = string + "defaults" + b;
        } else {
            object = LoginChecker.getInstance().isUseNetworkUsers() ? "users" : "localusers";
            string = string + (String)object + b + user.getLogin() + b;
        }
        object = new MIMFile(string);
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        string = ((File)object).getAbsolutePath() + b;
        return string;
    }

    @Override
    protected String b() {
        File file = c.d().b(CascadeSubfolder.a, "");
        file.mkdirs();
        return file.getAbsolutePath();
    }

    public static String getUserDefaultsConfigPath() {
        User user = LoginChecker.getInstance().currentUser();
        if (user == null) {
            return Path.getLegacyConfigBasePath();
        }
        return new File(Path.getLegacyConfigBasePath() + "defaults" + b).getAbsolutePath() + b;
    }

    @Deprecated
    public static String getSystemConfigPath() {
        return Path.getLegacyConfigBasePath();
    }

    @Deprecated
    public static String getConfigPath() {
        return Path.getLegacyConfigBasePath();
    }

    public static String getDataPath() {
        String string = System.getProperty("data.path");
        if (string != null) {
            return string;
        }
        if (Path.shouldUseDevStylePaths() && new File(Path.getRelativePathToWorkspaceRoot() + "datafiles").exists()) {
            return new File(Path.getRelativePathToWorkspaceRoot() + "datafiles").getAbsolutePath();
        }
        return new File("data").getAbsolutePath();
    }

    public static String getClassesPath(String string) {
        String string2 = File.separator;
        MIMFile mIMFile = new MIMFile(".." + string2 + "data" + string2 + "mirror" + string2 + "java" + string2 + "classes" + string2, string);
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile("lib", string);
        }
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile(".." + string2 + ".." + string2 + "java" + string2 + "classes" + string2, string);
        }
        if (!mIMFile.exists()) {
            String string3 = System.getProperty("java.class.path");
            String[] stringArray = string3.split(File.pathSeparator);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file;
                String string4 = stringArray[i2];
                if (string4.endsWith(".jar") || string4.indexOf("objbridge") > -1 || !(file = new File(string4, string)).exists()) continue;
                mIMFile = new MIMFile(file.getAbsolutePath());
                break;
            }
        }
        try {
            return mIMFile.getCanonicalPath();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getDcmtkbinPath() {
        String string = File.separator;
        MIMFile mIMFile = new MIMFile(".." + string + "dcmtkbin" + string);
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile(".." + string + ".." + string + "bin" + string + "dcmtkbin" + string);
        }
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile("data", "config");
        }
        try {
            return mIMFile.getCanonicalPath() + string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getImagePath() {
        String string = File.separator;
        MIMFile mIMFile = new MIMFile(".." + string + "data" + string + "mirror" + string + "resource" + string + "graphics" + string + "icons" + string);
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile(".." + string + "data" + string + "mirror" + string + "resource" + string + "graphics" + string + "other" + string);
        }
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile(".." + string + ".." + string + "resource" + string + "graphics" + string + "icons" + string);
        }
        if (!mIMFile.exists()) {
            mIMFile = new MIMFile(".." + string + ".." + string + "resource" + string + "graphics" + string + "other" + string);
        }
        try {
            return mIMFile.getCanonicalPath() + string;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String getTempPath(String string) {
        return Path.getTempPath(string, true, true);
    }

    public static Comparator<File> getNewestToOldestComparator() {
        return new Comparator<File>(){

            public int a(File file, File file2) {
                long l2 = file.lastModified();
                long l3 = file2.lastModified();
                return (int)Math.signum(l3 - l2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((File)object, (File)object2);
            }
        };
    }

    public static void deleteOldest(List<File> list, int n2) {
        Collections.sort(list, Path.getNewestToOldestComparator());
        while (list.size() > n2) {
            list.get(list.size() - 1).delete();
            list.remove(list.size() - 1);
        }
    }

    public static String getEndOfPath(java.nio.file.Path path, int n2) {
        java.nio.file.Path path2;
        java.nio.file.Path path3 = path;
        while (n2 > 0 && (path2 = path3.getParent()) != null) {
            path3 = path2;
            --n2;
        }
        return path3.relativize(path).toString();
    }

    public static String getRplTempDir() {
        return GetOSPath.convertPath(Path.getTempPath("MimQuery", false, true));
    }

    public static String getCloudTempDir() {
        return GetOSPath.convertPath(Path.getTempPath("CloudQuery", false, true));
    }

    public static String getRplTransferTempPath(String string) {
        Date date = Parser.getDateFromFile(string);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM");
        String string2 = simpleDateFormat.format(date);
        String string3 = GetOSPath.convertPath(Path.getRplTempDir() + "\\" + string2 + "__Studies\\" + new File(GetOSPath.convertPath(string, false)).getName(), false);
        return string3;
    }

    public static String getCloudTransferTempPath() {
        long l2 = System.currentTimeMillis();
        String string = GetOSPath.convertPath(Path.getCloudTempDir() + "\\" + l2, false);
        return string;
    }

    public static File getCdBurningTempPath() {
        return CdburningPrefs.cdCreationPath.getValue();
    }

    public static String getCDPreBurnDataPath(MIMFile mIMFile) {
        MIMFile mIMFile2 = new MIMFile(mIMFile.g().getAbsolutePath(), "cdburningThumbs");
        if (!mIMFile2.exists()) {
            mIMFile2.mkdir();
        }
        return mIMFile2.getAbsolutePath();
    }

    public static String getWindowsDesktopPath() throws SecurityException, NoSuchMethodException, Exception {
        if (!GetOSPath.isWindows()) {
            return System.getProperty("user.home") + "/Desktop";
        }
        return Path.getPathFromRegistry(true, "Desktop");
    }

    public static String getWindowsRelativeTo(String string, String string2) {
        int n2;
        if (!GetOSPath.isWindows() || string2 == null) {
            return string;
        }
        for (n2 = 0; n2 < string.length() && n2 < string2.length() && string.charAt(n2) == string2.charAt(n2); ++n2) {
        }
        if (n2 < 3) {
            return string;
        }
        string = string.substring(n2);
        if ((string2 = string2.substring(n2)).equals("")) {
            return string;
        }
        String[] stringArray = string2.split(Pattern.quote("\\"));
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string = "..\\" + string;
        }
        return string;
    }

    public static String getWindowsRelativeDesktopPath(boolean bl2, String string) {
        if (!GetOSPath.isWindows()) {
            return string;
        }
        try {
            String string2 = Path.getPathFromRegistry(true, "Desktop");
            String string3 = Path.getPathFromRegistry(!bl2, bl2 ? "Common Desktop" : "Desktop");
            string3 = Path.getWindowsRelativeTo(string3, string2);
            if (string3 != null) {
                return string3;
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getWindowsRelativeProgramsPath(boolean bl2, String string) {
        if (!GetOSPath.isWindows()) {
            return string;
        }
        try {
            String string2 = Path.getPathFromRegistry(true, "Desktop");
            String string3 = Path.getPathFromRegistry(!bl2, bl2 ? "Common Programs" : "Programs");
            string3 = Path.getWindowsRelativeTo(string3, string2);
            if (string3 != null) {
                return string3;
            }
            return string;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String getMIMTempPath() {
        return Path.getMIMDataPath() + File.separator + "TEMP";
    }

    public static String getTempCDExportArchive() {
        MIMFile mIMFile = new MIMFile(Path.getMIMTempPath() + File.separator + "cd_archive" + File.separator);
        if (!mIMFile.exists()) {
            mIMFile.mkdirs();
        }
        return mIMFile.getAbsolutePath();
    }

    public static String getImporterTempPath() {
        File file = new File(Path.getMIMTempPath() + File.separator + "Importer");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWin32ShortPathName(String string) {
        if (!GetOSPath.isWindows() || !new File(string).exists()) {
            return string;
        }
        String string2 = "for %I in (\"" + new File(string).getAbsolutePath() + "\") do @echo %~sI";
        BufferedReader bufferedReader = null;
        try {
            Process process = new ProcessBuilder("cmd", "/c", string2).start();
            process.waitFor();
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = null;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (Objects.equal((Object)"", (Object)string3.trim()) || string3.trim().contains(" ")) continue;
                String string4 = string3.trim();
                return string4;
            }
        }
        catch (InterruptedException interruptedException) {
            String string5 = string;
            return string5;
        }
        catch (IOException iOException) {
            String string6 = string;
            return string6;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    @Deprecated
    public static File getMimpacsFolder() {
        return Path.joinFile(Path.getBasePath(), "mimpacs");
    }

    @Deprecated
    public static File getMimpacsUserConfigFolder(String string) {
        return Path.joinFile(Path.getMimpacsFolder(), "users", string);
    }

    @Deprecated
    public static File getMimpacsAdminDefaultsFolder() {
        return Path.joinFile(Path.getMimpacsFolder(), "admin-defaults");
    }

    @Deprecated
    public static File getMimpacsOverrideFolder() {
        return Path.joinFile(Path.getMimpacsFolder(), "override");
    }

    @Deprecated
    public static File getMimpacsUserOverrideFolder() {
        return Path.joinFile(Path.getMimpacsOverrideFolder(), "user");
    }

    @Deprecated
    public static File getMimpacsMachineOverrideFolder() {
        return Path.joinFile(Path.getMimpacsOverrideFolder(), "machine");
    }

    public static File getMimpacsSyncFolder() {
        return new File(Path.getMiscDataPath(), "mimpacs/synced-settings");
    }
}

