/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.file;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.AccessedViaReflection;
import com.mimvista.IndirectlyInstantiated;
import com.mimvista.file.MIMFile;
import com.mimvista.license.g;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.LoggingPrefs;
import com.mimvista.preferencesNew.MachinePrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.MIMContext;
import com.mimvista.util.ay;
import com.mimvista.util.bz;
import com.mimvista.util.cn;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.prefs.Preferences;
import org.appkit.osdependant.OSUtils;

@IndirectlyInstantiated
public class PathUtils {
    static String b = File.separator;
    public static final String LOG_PATH_CONF_KEY = "BASE_LOG_PATH";
    public static final String CURRENT_INSTALL_PATH_FILE = "mim_install_location.txt";
    private static final int a = 24;
    public static final String CASCADE_DIR_NAME = "settings";
    public static final String LEGACY_CONFIG_DIR_NAME = "config";
    public static final String NO_USERS_CONFIG_DIR = "settings/machine";
    public static final String MACHINE_CONFIG_DIR = "settings/machine";
    public static final String LOCAL_USERS_CONFIG_DIR = "settings/local-users";
    public static final String NETWORK_USERS_CONFIG_DIR = "settings/network-users";
    public static final String PACS_SERVER_SITE_DEFAULTS_CONFIG_DIR = "settings/site-defaults";
    public static final String MISC_DATA_DIR = "app-data";
    public static final String META_SETTINGS_DIR = "settings/" + CascadeSubfolder.t.a();
    private static Boolean c;
    private static Object d;
    private static PathUtils e;
    private static Set<String> f;
    private static String g;
    private static String h;
    private static Boolean i;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PathUtils c() {
        if (e != null) {
            return e;
        }
        Object object = d;
        synchronized (object) {
            if (e != null) {
                return e;
            }
            try {
                String string = System.getProperty("java.version");
                if (!string.startsWith("1.6")) {
                    Class<?> clazz = Class.forName("com.mimvista.file.Path");
                    e = (PathUtils)clazz.newInstance();
                }
            }
            catch (Throwable throwable) {
                ay.a((Object)("'Path' class not found.  Must be in simple-dicomy context. " + throwable.getMessage() + " ~ " + throwable.getClass().getName()), PathUtils.class);
            }
            finally {
                if (e == null) {
                    ay.a((Object)"Instantiating PathUtils because we couldn't load Path", PathUtils.class);
                    e = new PathUtils();
                }
            }
            return e;
        }
    }

    public static boolean shouldUseDevStylePrefsPath() {
        if (c == null) {
            c = com.mimvista.license.g.a() ? (new MIMFile("config/userealconfig").exists() ? Boolean.valueOf(false) : (new MIMFile(PathUtils.getRelativePathToMimBaseDir() + "config/userealconfig").exists() ? Boolean.valueOf(false) : Boolean.valueOf(true))) : Boolean.valueOf(false);
        }
        return c;
    }

    public static File getUniquelyNamedFile(File file, String string, String string2) {
        if (!(string2 = cn.i(string2)).isEmpty() && string2.charAt(0) != '.') {
            string2 = "." + string2;
        }
        String string3 = string + string2;
        int n2 = 1;
        while (new File(file, string3).exists()) {
            string3 = string + "(" + n2++ + ")" + string2;
        }
        return new File(file, string3);
    }

    public static String getFullPath(String string, String string2) {
        String string3 = "";
        String string4 = File.separator;
        int n2 = string.length() - 1;
        if (string.lastIndexOf(string4) != n2) {
            string = string + string4;
        }
        if (string2.indexOf(string4) == 0) {
            string2 = string2.substring(1);
        }
        string3 = string + string2;
        return string3;
    }

    public static boolean shouldAppendViewer() {
        return MIMContext.t() || MIMContext.j();
    }

    protected String a() {
        return PathUtils.getLegacyConfigBasePath();
    }

    public static String getLegacyUserConfigPath() {
        return PathUtils.c().a();
    }

    protected String b() {
        return PathUtils.getUserlessConfigDir();
    }

    public static String getUserConfigPath() {
        return PathUtils.c().b();
    }

    public static String getLegacyConfigBasePath() {
        return PathUtils.getLegacyConfigBasePath(true);
    }

    public static String getLegacyConfigBasePath(boolean bl2) {
        return PathUtils.a(LEGACY_CONFIG_DIR_NAME, bl2);
    }

    public static String getCascadeDir() {
        return PathUtils.a(CASCADE_DIR_NAME);
    }

    public static String getMachineConfigDir() {
        return PathUtils.a("settings/machine");
    }

    public static String getUserlessConfigDir() {
        return PathUtils.a("settings/machine");
    }

    public static String getServiceIniPath() {
        return PathUtils.a("service-inis");
    }

    public static String getDatabaseIndexPath() {
        return PathUtils.a("indexes");
    }

    public static String getAssistantDataPath() {
        return PathUtils.a("MIM", "app-data/assistant");
    }

    public static String getArtAssistDataPath() {
        return PathUtils.a("MIM", new File(MISC_DATA_DIR, "art-assist").getPath());
    }

    public static String getOrganizerDataPath() {
        return PathUtils.a("MIMcloud Organizer", MISC_DATA_DIR);
    }

    public static String getMCADataPath() {
        return PathUtils.a("MIMcloudAssistant", MISC_DATA_DIR);
    }

    public static String getMetaPreferencePath() {
        return PathUtils.a(META_SETTINGS_DIR);
    }

    @AccessedViaReflection
    public static String getExtensionPath() {
        return PathUtils.a("extensions");
    }

    public static File getSingleInstanceServiceDir() {
        String string = "instances/" + System.getProperty("user.name");
        File file = new File(PathUtils.a(true) + string);
        if (!file.exists() && !file.mkdirs()) {
            ay.d((Object)("Couldn't create single instance file directory in temp folder: " + file.getAbsolutePath()), PathUtils.class);
        }
        return file;
    }

    public static String getCrossProcessTempPath() {
        return PathUtils.a(true);
    }

    public static String getBasePath() {
        return PathUtils.getBasePath(MIMContext.G());
    }

    public static String getResourcePathWrapIfJunit(String string) {
        StringBuilder stringBuilder = new StringBuilder(PathUtils.getRelativePathToMimBaseDir());
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String getBasePath(String string) {
        String string2 = System.getProperty("junit.test.path");
        if (string2 != null) {
            return new File(string2).getAbsolutePath();
        }
        if (MIMContext.p()) {
            return new bz<String>().a("", "com.mimvista.oisintegration.client.PacsWebClient", "getConfigPath");
        }
        try {
            if (PathUtils.shouldUseDevStylePrefsPath()) {
                return System.getProperty("user.dir");
            }
            if (OSUtils.isLinux()) {
                return "/etc/" + string;
            }
            if (OSUtils.isMac()) {
                if (PathUtils.d()) {
                    return OSUtils.userDataFolder(string);
                }
                return "/Library/Application Support/" + string;
            }
            if (OSUtils.isWindows()) {
                if (PathUtils.d()) {
                    return OSUtils.userDataFolder(string);
                }
                return new File(System.getenv("ALLUSERSPROFILE"), string).getAbsolutePath();
            }
            throw new IllegalStateException("The current OS is not supported");
        }
        catch (Throwable throwable) {
            ay.e(throwable);
            return null;
        }
    }

    protected static String a(String string) {
        return PathUtils.a(MIMContext.G(), string);
    }

    protected static String a(String string, boolean bl2) {
        return PathUtils.a(MIMContext.G(), string, bl2);
    }

    protected static String a(String string, String string2) {
        return PathUtils.a(string, string2, true);
    }

    public static String getMiscDataPath() {
        return PathUtils.a(MISC_DATA_DIR);
    }

    public static String getMiscDataPathDontCreateYet() {
        return PathUtils.a(MISC_DATA_DIR, false);
    }

    protected static String a(String string, String string2, boolean bl2) {
        String string3 = PathUtils.getBasePath(string);
        if (string3 == null) {
            return null;
        }
        File file = new File(string3, string2);
        try {
            if (bl2) {
                file.mkdirs();
            }
            return file.getCanonicalPath() + b;
        }
        catch (IOException iOException) {
            ay.e(iOException);
            return null;
        }
    }

    private static boolean d() {
        return MIMContext.i() || MIMContext.k() || MIMContext.o() || MIMContext.p() || MIMContext.C();
    }

    public static String getPathFromRegistry(boolean bl2, String string) throws SecurityException, NoSuchMethodException, Exception {
        return PathUtils.a(bl2, string, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders");
    }

    private static String a(boolean bl2, String string, String string2) throws SecurityException, NoSuchMethodException, Exception {
        Preferences preferences = bl2 ? Preferences.userRoot() : Preferences.systemRoot();
        int n2 = 131097;
        Class<?> clazz = preferences.getClass();
        Method method = clazz.getDeclaredMethod("openKey", byte[].class, Integer.TYPE, Integer.TYPE);
        method.setAccessible(true);
        Method method2 = clazz.getDeclaredMethod("closeKey", Integer.TYPE);
        method2.setAccessible(true);
        Method method3 = clazz.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
        method3.setAccessible(true);
        Integer n3 = (Integer)method.invoke((Object)preferences, PathUtils.b(string2), 131097, 131097);
        byte[] byArray = null;
        byArray = (byte[])method3.invoke((Object)preferences, n3, PathUtils.b(string));
        method2.invoke((Object)preferences, n3);
        return byArray == null ? null : new String(byArray).trim();
    }

    private static byte[] b(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        byArray[string.length()] = 0;
        return byArray;
    }

    private static boolean e() {
        File file;
        try {
            file = new File(".").getCanonicalFile();
        }
        catch (IOException iOException) {
            return false;
        }
        if (file == null) {
            return false;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return false;
        }
        return f.contains(file2.getName());
    }

    private static boolean f() {
        return new File("./mimjava/mim/src").exists();
    }

    public static boolean shouldUseDevStylePaths() {
        if (i == null) {
            i = new MIMFile("./.project").exists() || new MIMFile("./mimjava/mim/src").exists();
        }
        return i;
    }

    public static String slowlyComputeRelativePathToWorkspaceRoot() {
        if (PathUtils.e()) {
            return "../../";
        }
        if (PathUtils.f()) {
            System.out.println("Running from workspace root, this is unusual.  (Expected for anno procs though.)");
            return "./";
        }
        return "../";
    }

    public static String getRelativePathToWorkspaceRoot() {
        if (h == null) {
            h = PathUtils.slowlyComputeRelativePathToWorkspaceRoot();
        }
        return h;
    }

    public static String getRelativePathToMimBaseDir() {
        if (g == null) {
            g = PathUtils.getRelativePathToProjectDir("mimjava/mim/");
        }
        return g;
    }

    public static String getRelativePathToProjectDir(String string) {
        if (PathUtils.shouldUseDevStylePaths()) {
            StringBuilder stringBuilder = new StringBuilder(PathUtils.getRelativePathToWorkspaceRoot());
            stringBuilder.append(string);
            if (string.charAt(string.length() - 1) != '/') {
                stringBuilder.append('/');
            }
            return stringBuilder.toString();
        }
        return "./";
    }

    public static String getRelativePathToBinaries() {
        return PathUtils.getRelativePathToMimBaseDir() + "resources/binaries/";
    }

    public static String getRelativePathToMimjavaTestProject() {
        return PathUtils.getRelativePathToProjectDir("mimjava_test/");
    }

    public static String getLogPath() {
        MIMFile mIMFile = new MIMFile(PathUtils.getLogBasePath());
        try {
            return mIMFile.getCanonicalPath() + b;
        }
        catch (Exception exception) {
            ay.e(exception);
            return "";
        }
    }

    public static List<MIMFile> getJars(MIMFile mIMFile) {
        ArrayList arrayList = Lists.newArrayList();
        for (MIMFile mIMFile2 : mIMFile.d()) {
            if (mIMFile2.isDirectory()) {
                arrayList.addAll(PathUtils.getJars(mIMFile2));
                continue;
            }
            if (!mIMFile2.getName().toLowerCase().endsWith(".jar")) continue;
            arrayList.add(mIMFile2);
        }
        return arrayList;
    }

    public static String getLogBasePath() {
        return PathUtils.getLogBasePath(true);
    }

    public static String getLogBasePath(boolean bl2) {
        String string = PathUtils.getDefaultLogBasePath();
        File file = LoggingPrefs.baseLogPath.getValue();
        boolean bl3 = MIMContext.z();
        if (bl2 && bl3) {
            String string2;
            String string3;
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = System.getProperty("user.name");
            String string5 = MIMContext.A();
            boolean bl4 = !cn.h(string5);
            String string6 = string3 = bl4 ? "cx" : "rdp";
            if (cn.h(string4)) {
                string4 = "unk";
            }
            stringBuilder.append(string3);
            stringBuilder.append("-");
            stringBuilder.append(string4);
            if (bl4) {
                stringBuilder.append("-");
                stringBuilder.append(string5);
            }
            if ((string2 = PathUtils.safeFilename(stringBuilder.toString())).length() > 24) {
                string2 = string2.substring(0, 24);
            }
            file = new File(file, string2);
            file.mkdir();
        }
        if (new MIMFile(file).canWrite()) {
            return file.getAbsolutePath();
        }
        return string;
    }

    public static String getDefaultLogBasePath() {
        return PathUtils.getDefaultLogBasePath(MIMContext.G());
    }

    public static String getDefaultLogBasePath(String string) {
        try {
            MIMFile mIMFile = new MIMFile("config/userealconfig");
            String string2 = "";
            if (com.mimvista.license.g.a() && !mIMFile.exists()) {
                string2 = PathUtils.getRelativePathToMimBaseDir() + "logs";
            } else if (GetOSPath.isMacOs()) {
                string2 = PathUtils.d(string);
            } else if (GetOSPath.isLinux()) {
                string2 = "/var/log/" + string;
            } else if (GetOSPath.isWindows()) {
                string2 = PathUtils.c(string);
            } else {
                throw new IllegalStateException("The current OS is not supported");
            }
            MIMFile mIMFile2 = new MIMFile(string2);
            if (!mIMFile2.exists()) {
                mIMFile2.mkdirs();
            }
            return mIMFile2.getCanonicalPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static String c(String string) {
        File file = null;
        boolean bl2 = PathUtils.d();
        if (!bl2 && !(file = new MIMFile(new MIMFile(System.getenv("ALLUSERSPROFILE"), string), "logs")).canWrite()) {
            bl2 = true;
        }
        if (bl2) {
            file = new MIMFile(OSUtils.userDataFolder(string), "logs");
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    private static String d(String string) {
        File file = null;
        boolean bl2 = PathUtils.d();
        if (!bl2 && !(file = new MIMFile("/Library/Logs/" + string)).canWrite()) {
            bl2 = true;
        }
        if (bl2) {
            String string2 = System.getProperty("user.home");
            if (string2 == null) {
                string2 = "~";
            }
            file = new MIMFile(string2, "/Library/Logs/" + string);
        }
        if (file != null) {
            return file.getAbsolutePath();
        }
        return "";
    }

    public static String safeFilename(String string, boolean bl2) {
        return PathUtils.safeFilename(string, bl2, false);
    }

    public static String safeFilename(String string, boolean bl2, boolean bl3) {
        if (string == null) {
            return ".";
        }
        String string2 = string;
        string = "";
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            string = c2 < ' ' ? string + "." : string + c2;
        }
        String string3 = "[\\\\/ :_*\"|?]";
        if (bl2) {
            string3 = "[\\\\/:_*\"|?]";
        }
        string = string.replaceAll(string3, ".").replaceAll("[\\[{<]", "(").replaceAll("[\\]}>]", ")");
        if (!bl3 && string.endsWith(".")) {
            string = string.substring(0, string.length() - 1) + "-";
        }
        return string;
    }

    public static String safeFilename(String string) {
        return PathUtils.safeFilename(string, false);
    }

    public static String getFilenameFromOSIndependentPath(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = string.replaceAll("\\\\", "/");
        String[] stringArray = string2.split("/");
        return stringArray[stringArray.length - 1];
    }

    private static void a(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        String[] stringArray = null;
        stringArray = MIMContext.x() ? new String[]{"admin", "mimcloud_express", "dcmstore", "MIMDB"} : new String[]{"dcmstore", "dcmquery", "license", "webadmin", "pacs", "mobile", "automator", "admin", "mimcloud_express", "MIMDB"};
        for (String string : stringArray) {
            MIMFile mIMFile;
            MIMFile mIMFile2;
            MIMFile mIMFile3 = new MIMFile(file, string);
            if (!mIMFile3.exists()) {
                mIMFile3.mkdirs();
            }
            if ((mIMFile2 = new MIMFile(mIMFile = new MIMFile(file, "audit"), string)).exists()) continue;
            mIMFile2.mkdirs();
        }
    }

    public static String getSubLogPath(String string) {
        MIMFile mIMFile = new MIMFile(PathUtils.getLogBasePath(), string);
        if (!mIMFile.exists()) {
            mIMFile.mkdirs();
        }
        try {
            return mIMFile.getCanonicalPath() + b;
        }
        catch (IOException iOException) {
            ay.c((Object)"Canon Error?", (Throwable)iOException, PathUtils.class);
            return mIMFile.getAbsolutePath() + b;
        }
    }

    public static String getServiceLogPath() {
        MIMFile mIMFile = new MIMFile(PathUtils.getLogBasePath(false), "services");
        if (!mIMFile.exists()) {
            mIMFile.mkdir();
        }
        try {
            PathUtils.a(mIMFile);
            return mIMFile.getCanonicalPath() + b;
        }
        catch (Exception exception) {
            ay.c((Object)"Canon Error? (Serv)", (Throwable)exception, PathUtils.class);
            return mIMFile.getAbsolutePath() + b;
        }
    }

    public static String getFilenameFromPath(String string) {
        if (cn.h(string)) {
            return "";
        }
        File file = new File(string);
        String string2 = "";
        String[] stringArray = file.getName().split("\\.");
        for (int i2 = 0; i2 < stringArray.length - 1; ++i2) {
            string2 = string2 + stringArray[i2] + ".";
        }
        string2 = string2.substring(0, string2.length() - 1);
        return string2;
    }

    @Deprecated
    public static String getUnitTestDataPath() {
        return PathUtils.getRelativePathToMimjavaTestProject() + "data/";
    }

    public static String getMIMDataPath() {
        File file;
        if ("true".equals(System.getProperty("junit.test")) && ((file = new File(PathUtils.getRelativePathToMimjavaTestProject() + "test_mimdata_dir")).exists() || file.mkdirs())) {
            return file.getAbsolutePath();
        }
        file = new File(MachinePrefs.mimDataPath.getValue());
        return file.getAbsolutePath();
    }

    public static String getTempPath() {
        return PathUtils.a(false);
    }

    private static String a(boolean bl2) {
        String string;
        File file;
        String string2 = "";
        if (!bl2) {
            string2 = ManagementFactory.getRuntimeMXBean().getName();
            string2 = string2.split("@")[0];
        }
        if (File.separatorChar == '\\') {
            String string3 = System.getProperty("java.io.tmpdir");
            File file2 = new File(string3, "mim" + string2);
            if (!file2.exists() && !file2.mkdirs()) {
                System.err.println("Can't create temp folder " + string3);
            }
            return PathUtils.getCanonicalOrAbsolutePath(file2) + "\\";
        }
        String string4 = System.getProperty("user.name");
        if ("root".equals(string4)) {
            string4 = "_service";
        }
        if (!(file = PathUtils.getCanonicalOrAbsoluteFile(new File(string = "/tmp/mim-" + string4, "mim" + string2))).exists()) {
            file.mkdirs();
        }
        return file.getAbsolutePath() + "/";
    }

    public static MIMFile getTempPathUnique(String string) {
        int n2;
        String string2 = PathUtils.getTempPath();
        int n3 = 1000000000;
        int n4 = n2 = (int)(Math.random() * (double)n3);
        n2 = (n2 + 1) % n3;
        do {
            MIMFile mIMFile;
            if (!(mIMFile = new MIMFile(string2, string + n2)).mkdirs()) continue;
            return mIMFile;
        } while ((n2 = (n2 + 1) % n3) != n4);
        return null;
    }

    public static String getTempPath(String string, boolean bl2, boolean bl3) {
        String string2 = PathUtils.getTempPath();
        if (bl2) {
            string = string + String.valueOf(Calendar.getInstance().getTimeInMillis());
        }
        if (bl3) {
            new File(string2, string).mkdirs();
        }
        return string2 + string;
    }

    public static String getMIMInstallPathForWindowsOrNull() {
        if (!com.mimvista.license.g.a()) {
            String string = PathUtils.e(CURRENT_INSTALL_PATH_FILE);
            if (string == null) {
                string = PathUtils.e("mim_path_5.log");
            }
            if (string == null) {
                try {
                    string = PathUtils.a(false, "Software\\MIM", "InstallPath");
                }
                catch (Throwable throwable) {
                    ay.a((Object)"Trying to read install location from registry", throwable, PathUtils.class);
                }
            }
            return string;
        }
        return System.getProperty("user.dir");
    }

    public static String getMimInstallPathForWindowsOrDefault() {
        String string = PathUtils.getMIMInstallPathForWindowsOrNull();
        if (string == null) {
            return PathUtils.getWindowsProgramFilesPath() + "\\MIM";
        }
        return string;
    }

    public static String getMimViewerInstallPathForWindows() {
        if (!com.mimvista.license.g.a()) {
            String string = PathUtils.e("mimviewer_install_location.txt");
            if (string == null) {
                string = PathUtils.e("mimviewer_2_path.log");
            }
            return string;
        }
        return System.getProperty("user.dir");
    }

    public static String getMIMInstallPathForMacOS() {
        return "/Library/Frameworks/MIM.framework/Versions/" + VersionNumber.getSimpleVersionStringWithoutBuild(false) + "/Contents";
    }

    public static String getMimCloudExpressInstallPathForWindows() {
        if (!com.mimvista.license.g.a()) {
            return PathUtils.e("mim_express_1.log");
        }
        return System.getProperty("user.dir");
    }

    public static String getMIMcloudAssistantInstallPathForMacOS() {
        return "/Library/Frameworks/MIMcloudAssistant.framework/CurrentVersion/Contents";
    }

    public static String getMIMviewerInstallPathForMacOS() {
        String[] stringArray = VersionNumber.loadVersion();
        stringArray[0] = "" + (Integer.parseInt(stringArray[0]) - 3);
        return "/Library/Frameworks/MIMviewer.framework/Versions/" + stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "/Contents";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String e(String string) {
        String string2 = PathUtils.getPathFileName(string);
        if (string2 != null) {
            File file = new File(string2);
            Scanner scanner = null;
            try {
                File file2;
                scanner = new Scanner(file);
                if (scanner.hasNext() && (file2 = new File(scanner.nextLine())).isDirectory()) {
                    String string3 = file2.getAbsolutePath();
                    return string3;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
        ay.c((Object)("can't find or read " + string), PathUtils.class);
        return null;
    }

    public static String getPathFileName(String string) {
        return new File(PathUtils.join(PathUtils.getWindowsSystemDrive(), string)).getAbsolutePath();
    }

    public static String getWindowsSystemDrive() {
        String string = System.getenv("SYSTEMDRIVE");
        if (string != null && !"".equals(string)) {
            return string;
        }
        return "C:";
    }

    public static String getWindowsInstallPath() {
        String string = System.getenv("WINDIR");
        if (string != null && !"".equals(string)) {
            return string;
        }
        String string2 = PathUtils.getWindowsSystemDrive();
        return new File(string2, "WINDOWS").getAbsolutePath();
    }

    public static String getWindowsProgramFilesPath() {
        String string = System.getenv("PROGRAMFILES");
        if (cn.g(string)) {
            string = PathUtils.getWindowsSystemDrive() + "\\Program Files";
        }
        string = string + "\\MIM Software";
        return string;
    }

    public static String getWindowsAllUsersStartMenuProgramsPath() {
        try {
            return PathUtils.getPathFromRegistry(false, "Common Programs");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getWindowsAllUsersDesktopPath() {
        try {
            return PathUtils.getPathFromRegistry(false, "Common Desktop");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getWindowsAllUsersStartupPath() {
        try {
            return PathUtils.getPathFromRegistry(false, "Common Start Menu");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getWindowsCurrentUserStartMenuProgramsPath() {
        try {
            return PathUtils.getPathFromRegistry(true, "Programs");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getWindowsCurrentUserDesktopPath() {
        try {
            return PathUtils.getPathFromRegistry(true, "Desktop");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getWindowsCurrentUserStartupPath() {
        try {
            return PathUtils.getPathFromRegistry(false, "Start Menu");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String join(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length <= 0) {
            return "";
        }
        String string = stringArray[0].trim();
        if (stringArray.length > 1 && string.endsWith(b)) {
            string = string.substring(0, string.length() - b.length());
        }
        stringBuilder.append(string);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            string = stringArray[i2].trim();
            if (i2 < stringArray.length - 1 && string.endsWith(b)) {
                string = string.substring(0, string.length() - b.length());
            }
            stringBuilder.append(b).append(string);
        }
        return stringBuilder.toString();
    }

    public static File joinFile(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            return PathUtils.joinFile(new File(stringArray[0]), Arrays.copyOfRange(stringArray, 1, stringArray.length));
        }
        return null;
    }

    public static File joinFile(File file, String ... stringArray) {
        if (file != null && stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                file = new File(file, string);
            }
        }
        return file;
    }

    public static File joinFile(File ... fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        File file = fileArray[0];
        for (int i2 = 1; i2 < fileArray.length; ++i2) {
            Preconditions.checkArgument((!fileArray[i2].isAbsolute() ? 1 : 0) != 0, (Object)"Only the first param to joinFile is allowed to be an absolute path");
            file = new File(file, fileArray[i2].getPath());
        }
        return file;
    }

    public static String stripTrailingPathSeparators(String string) {
        char c2;
        if (string == null) {
            return null;
        }
        while (!(string.isEmpty() || (c2 = string.charAt(string.length() - 1)) != '/' && c2 != '\\')) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getArchivePathFromSeriesFolder(String string) {
        MIMFile mIMFile = new MIMFile(string);
        for (int n2 = 0; n2 < 2 && mIMFile != null; mIMFile = mIMFile.g(), ++n2) {
        }
        if (mIMFile != null) {
            return mIMFile.getAbsolutePath();
        }
        return null;
    }

    public static String getCanonicalOrAbsolutePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String getCanonicalOrAbsolutePath(String string) {
        return PathUtils.getCanonicalOrAbsolutePath(new File(string));
    }

    public static File getCanonicalOrAbsoluteFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static File getCanonicalOrAbsoluteFile(String string) {
        return PathUtils.getCanonicalOrAbsoluteFile(new File(string));
    }

    public static File getInstallDirOfCurrentlyRunningMim() {
        return new File(".");
    }

    public static String getOsIndependentPath(String string) {
        if (!OSUtils.isWindows()) {
            return string;
        }
        return string.replace('\\', '/');
    }

    public static String getOsIndependentPath(File file) {
        return PathUtils.getOsIndependentPath(file.getPath());
    }

    public static String getJrePath() {
        String string;
        Object object;
        String string2 = null;
        if (GetOSPath.isWindows()) {
            object = "java.exe";
            string = PathUtils.g() + (String)object;
            File file = new File(string);
            if (file.exists()) {
                string2 = file.getAbsolutePath();
            }
        }
        if (string2 == null) {
            object = System.getProperty("java.home");
            string = "java";
            if (GetOSPath.isWindows()) {
                string = string + ".exe";
            }
            string2 = PathUtils.join(new String[]{object, "bin", string});
        }
        if (string2 != null && ((File)(object = new File(string2))).exists()) {
            return string2;
        }
        ay.d((Object)"Couldn't find java executable, trying hardcoded paths", "");
        string2 = GetOSPath.isMacOs() || GetOSPath.isLinux() ? "/usr/bin/java" : PathUtils.g() + "java.exe";
        return new File(string2).getAbsolutePath();
    }

    private static String g() {
        String string = System.getProperty("sun.arch.data.model");
        return "bin\\jre_" + string + "\\bin\\";
    }

    public static String changeFileExtension(String string, String string2) {
        String string3;
        if ((string = string.trim()).isEmpty() || string.endsWith("\\") || string.endsWith("/")) {
            return string;
        }
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(92));
        String string4 = string3 = n2 < 0 ? string : string.substring(n2 + 1);
        if (string3.equals(".") || string3.equals("..")) {
            return string;
        }
        if (cn.h(string2)) {
            string2 = "";
        } else if (!string2.startsWith(".")) {
            string2 = "." + string2;
        }
        int n3 = string.lastIndexOf(46);
        if (n3 < 0 || n3 < n2) {
            return string + string2;
        }
        return string.substring(0, n3) + string2;
    }

    public static boolean isParentOf(File file, File file2) {
        return PathUtils.isParentOf(file, file2, false);
    }

    public static boolean isParentOf(File file, File file2, boolean bl2) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file3 = file2;
        if (!bl2) {
            file3 = file3.getParentFile();
        }
        do {
            if (!file3.equals(file)) continue;
            return true;
        } while ((file3 = file3.getParentFile()) != null);
        return false;
    }

    public static boolean isArchivePathLocationValid(File file) {
        return !PathUtils.isInWorkingDirectory(file) && !PathUtils.isInMIMInstallLocation(file) && !PathUtils.isConfiggedMimDataOrMimDataTemp(file);
    }

    public static void checkArchivePath(File file) {
        Preconditions.checkArgument((!PathUtils.isInWorkingDirectory(file) ? 1 : 0) != 0, (String)"The archive path cannot be in the current working directory: %s", (Object[])new Object[]{file});
        Preconditions.checkArgument((!PathUtils.isInMIMInstallLocation(file) ? 1 : 0) != 0, (String)"The archive path cannot be in the MIM install directory: %s", (Object[])new Object[]{file});
        Preconditions.checkArgument((!PathUtils.isConfiggedMimDataOrMimDataTemp(file) ? 1 : 0) != 0, (String)"The archive path cannot be in the MIM_DATA or MIM_DATA_TEMP directory: %s", (Object[])new Object[]{file});
    }

    public static boolean isConfiggedMimDataOrMimDataTemp(File file) {
        String string = MachinePrefs.mimDataPath.getValue();
        String string2 = string + "\\TEMP";
        file = file.getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File file2 = new File(string).getAbsoluteFile();
        File file3 = new File(string2).getAbsoluteFile();
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file3 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.equals(file2) || file.equals(file3);
    }

    public static boolean isOnePathWithinTheOther(File file, File file2) {
        return PathUtils.isParentOf(file, file2, true) || PathUtils.isParentOf(file2, file, true);
    }

    public static boolean isInMIMInstallLocation(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PathUtils.getMimInstallPathForWindowsOrDefault());
        arrayList.add(PathUtils.getMIMInstallPathForMacOS());
        arrayList.add(PathUtils.getMimViewerInstallPathForWindows());
        arrayList.add(PathUtils.getMIMviewerInstallPathForMacOS());
        return PathUtils.isInAnyPath(file, arrayList);
    }

    public static boolean isInWorkingDirectory(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(PathUtils.getCanonicalOrAbsolutePath(""));
        arrayList.add(PathUtils.getCanonicalOrAbsolutePath("."));
        return PathUtils.isInAnyPath(file, arrayList);
    }

    public static boolean isInAnyPath(File file, List<String> list) {
        for (String string : list) {
            File file2;
            if (string == null || !PathUtils.isOnePathWithinTheOther(file, file2 = new File(string))) continue;
            return true;
        }
        return false;
    }

    public static File getResolvedPathWithin(String string, String string2) {
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(string2, string);
        }
        return new File(PathUtils.getCanonicalOrAbsolutePath(file));
    }

    public static File getResolvedPathWithinMimData(String string) {
        return PathUtils.getResolvedPathWithin(string, PathUtils.getMIMDataPath());
    }

    public static File relativize(File file, File file2) {
        if (file.isAbsolute() && !file2.isAbsolute()) {
            return file2;
        }
        file = file.getAbsoluteFile();
        file2 = file2.getAbsoluteFile();
        File file3 = new File(file.toURI().relativize(file2.toURI()).getPath());
        if (file3.isAbsolute()) {
            throw new IllegalArgumentException("Cannot relativize { base: \"" + file + "\", path: \"" + file2 + "\" }");
        }
        return file3;
    }

    public static String getWindowsErrorFileEnvPath() {
        return "%AllUsersProfile%/" + MIMContext.G() + "/hs_error_pid%p.log";
    }

    public static void main(String[] stringArray) {
        System.out.println("? " + PathUtils.join("C:\\Example\\", "Path\\", "  To  ", "Something\\"));
        System.out.println("= C:\\Example\\Path\\To\\Something\\");
        System.out.println("? " + PathUtils.join("  blah  ", "  diddly\\", "blah"));
        System.out.println("= blah\\diddly\\blah");
        System.out.println(PathUtils.changeFileExtension("/blah.txt", ".poo"));
        System.out.println(PathUtils.changeFileExtension("/some.dir/foo", ".bar"));
        System.out.println(PathUtils.changeFileExtension("..", ".uhoh"));
        System.out.println(PathUtils.changeFileExtension(".", "hmmm"));
        System.out.println(PathUtils.changeFileExtension("C:\\a\\b\\c\\d\\", "heh"));
        System.out.println(PathUtils.changeFileExtension("C:\\directory.A\\text.txt", "xml"));
        System.out.println(PathUtils.changeFileExtension("C:\\STUFF\\.", "xml"));
        System.out.println(PathUtils.changeFileExtension("C:\\OTHERSTUFF\\.\\..", "NUUUU"));
        System.out.println(PathUtils.changeFileExtension("./dir/to/stuff/../something.config", ".BOOM"));
        System.out.println(PathUtils.changeFileExtension("...", "..."));
        System.out.println(PathUtils.changeFileExtension("C:\\delete_my_extension.delete", null));
        System.out.println(PathUtils.changeFileExtension("bluhhh", null));
        System.out.println(PathUtils.changeFileExtension("bluhhh", ""));
        System.out.println(PathUtils.changeFileExtension("goo.booooo", ""));
        System.out.println(PathUtils.changeFileExtension("/a/b/c.d/e.f/file.xxxxx", null));
    }

    static {
        d = new Object();
        f = Sets.newHashSet((Object[])new String[]{"mim_secret", "mimjava", "sadfox", "mimcloud_accessories"});
        g = null;
        h = null;
    }
}

