/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.gui;

import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.mui.ToggleButtonWithPopupMenu;
import com.mimvista.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SplitDropDownButton
extends ToggleButtonWithPopupMenu {
    private static final long serialVersionUID = 1L;
    private JLabel dropdown = new JLabel();
    private List<JMenuItem> values = new ArrayList<JMenuItem>();
    private boolean clickedDropDown = false;
    private ActionListener listener;

    public SplitDropDownButton(ActionListener actionListener) {
        super("", null);
        this.listener = actionListener;
        this.setVerticalAlignment(0);
        this.setHorizontalAlignment(2);
        this.dropdown.setIcon(ImageManipulator.c("ui_dropdown", 14, 14));
        this.dropdown.setVerticalAlignment(0);
        this.setVerticalTextPosition(3);
        this.setHorizontalTextPosition(0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 2, -3, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.dropdown, gridBagConstraints);
    }

    @Override
    protected void a(MouseEvent mouseEvent) {
        this.clickedDropDown = false;
        if (mouseEvent.getPoint().x >= this.dropdown.getLocation().x) {
            this.clickedDropDown = true;
        }
    }

    @Override
    protected JPopupMenu a() {
        if (!this.clickedDropDown) {
            this.listener.actionPerformed(null);
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (this.values.size() != 0) {
            for (JMenuItem jMenuItem : this.values) {
                jPopupMenu.add(jMenuItem);
            }
        } else {
            JMenuItem jMenuItem = new JMenuItem(Messages.a("GUI").getProperty("SPLITDROP_EMPTY"));
            jMenuItem.setForeground(Color.WHITE);
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
        }
        return jPopupMenu;
    }

    public synchronized void a(List<JMenuItem> list) {
        this.values.clear();
        this.values.addAll(list);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += this.dropdown.getPreferredSize().width;
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }
}

