/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.gui.util;

import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class TextEditDefaultActions {
    private static Messages a = Messages.a("GUI");

    public static class SelectAllAction
    extends TextEditDefaultAction {
        private static final long serialVersionUID = 1L;

        public SelectAllAction(JTextComponent jTextComponent) {
            super(a.b("MIMSWING_SELECT_ALL"), jTextComponent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.selectAll();
                }
            });
        }

        @Override
        public boolean a() {
            return super.a() && !cn.g(this.comp.getText());
        }
    }

    public static class CopyAction
    extends TextEditDefaultAction {
        private static final long serialVersionUID = 1L;

        public CopyAction(JTextComponent jTextComponent) {
            super(a.b("MIMSWING_COPY"), jTextComponent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.copy();
                }
            });
        }

        @Override
        public boolean a() {
            return super.a() && !cn.g(this.comp.getSelectedText());
        }
    }

    public static class DeleteAction
    extends TextEditDefaultAction {
        private static final long serialVersionUID = 1L;

        public DeleteAction(JTextComponent jTextComponent) {
            super(a.b("MIMSWING_DELETE"), jTextComponent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.replaceSelection(null);
                }
            });
        }

        @Override
        public boolean a() {
            return super.a() && this.comp.isEditable() && !cn.g(this.comp.getSelectedText());
        }
    }

    public static class PasteAction
    extends TextEditDefaultAction {
        private static final long serialVersionUID = 1L;

        public PasteAction(JTextComponent jTextComponent) {
            super(a.b("MIMSWING_PASTE"), jTextComponent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.paste();
                }
            });
        }

        @Override
        public boolean a() {
            if (super.a()) {
                try {
                    return this.comp.isEditable() && Toolkit.getDefaultToolkit().getSystemClipboard().isDataFlavorAvailable(DataFlavor.stringFlavor);
                }
                catch (Throwable throwable) {
                    return false;
                }
            }
            return false;
        }
    }

    public static class CutAction
    extends TextEditDefaultAction {
        private static final long serialVersionUID = 1L;

        public CutAction(JTextComponent jTextComponent) {
            super(a.b("MIMSWING_CUT"), jTextComponent);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    comp.cut();
                }
            });
        }

        @Override
        public boolean a() {
            return super.a() && this.comp.isEditable() && !cn.g(this.comp.getSelectedText());
        }
    }

    public static abstract class TextEditDefaultAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        protected JTextComponent comp;

        public TextEditDefaultAction(String string, JTextComponent jTextComponent) {
            super(string);
            this.comp = jTextComponent;
        }

        public boolean a() {
            return this.comp.isEnabled();
        }
    }

    public static class TextEditDefaultActionMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = 1L;
        private TextEditDefaultAction editAction = null;

        public TextEditDefaultActionMenuItem(TextEditDefaultAction textEditDefaultAction) {
            this.editAction = textEditDefaultAction;
            this.setAction(textEditDefaultAction);
        }

        public boolean a() {
            return this.editAction != null && this.editAction.a();
        }
    }
}

