/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.hl7.messages;

import ca.uhn.hl7v2.model.Message;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mimvista.IndirectlyInstantiated;
import com.mimvista.MimJsonSerializable;
import com.mimvista.hl7.messages.b;
import com.mimvista.preferencesNew.LLPServicePrefs;
import com.mimvista.util.af;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.core.client.impl.ClientMessageImpl;

@MimJsonSerializable
@IndirectlyInstantiated
public abstract class HL7RelayMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final String hl7RelayMessageClassKey = "hl7relaymsg.class";
    static final String hl7RelayMessageKey = "hl7relaymsg.message";
    private Message hl7_msg;

    protected HL7RelayMessage() {
    }

    public HL7RelayMessage(Message message) {
        this.hl7_msg = message;
    }

    public Message getHL7Message() {
        return this.hl7_msg;
    }

    public ClientMessage createHornetqMessage() throws IllegalStateException {
        int n2 = LLPServicePrefs.messageTimeoutInHrs.getValue();
        long l2 = TimeUnit.HOURS.toMillis(n2);
        long l3 = System.currentTimeMillis();
        ClientMessageImpl clientMessageImpl = new ClientMessageImpl(2, true, l3 + l2, l3, 4, 1500);
        try {
            String string = this.serialize();
            String string2 = this.getClass().getName();
            clientMessageImpl.putStringProperty(hl7RelayMessageKey, string);
            clientMessageImpl.putStringProperty(hl7RelayMessageClassKey, string2);
            return clientMessageImpl;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public String serialize() throws JsonProcessingException {
        return HL7RelayMessage.a().writeValueAsString((Object)this);
    }

    public static HL7RelayMessage parseHornetqMessage(ClientMessage clientMessage) throws IllegalStateException {
        try {
            String string = clientMessage.getStringProperty(hl7RelayMessageClassKey);
            String string2 = clientMessage.getStringProperty(hl7RelayMessageKey);
            Class<?> clazz = Class.forName(string);
            return HL7RelayMessage.deserialize(string2, clazz);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    public static <T extends HL7RelayMessage> T deserialize(String string, Class<T> clazz) throws JsonParseException, JsonMappingException, IOException {
        return (T)((HL7RelayMessage)HL7RelayMessage.a().readValue(string, clazz));
    }

    static synchronized ObjectMapper a() {
        ObjectMapper objectMapper = af.a();
        objectMapper.registerModule(b.a());
        return objectMapper;
    }
}

