/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.hl7.messages;

import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Field;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.Terser;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.mimvista.util.af;
import com.mimvista.util.ay;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class a
extends Parser {
    public a(HapiContext hapiContext) {
        super(hapiContext);
    }

    public String getDefaultEncoding() {
        return "JSON";
    }

    public String getEncoding(String string) {
        try {
            return string.trim().charAt(0) == '{' && string.contains("MSH") ? "JSON" : null;
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, (Object)this);
            return null;
        }
    }

    protected Message doParse(String string, String string2) throws HL7Exception {
        Map<String, Object> map = this.a(string);
        try {
            Map map2 = (Map)map.get("MSH");
            Map map3 = (Map)map2.get("9");
            String string3 = null;
            boolean bl2 = false;
            if (map3.containsKey("3")) {
                bl2 = true;
                string3 = String.valueOf(map3.get("3"));
            } else if ("ACK".equals(map3.get("1"))) {
                string3 = "ACK";
            } else if (map3.containsKey("1") && map3.containsKey("2")) {
                string3 = String.valueOf(map3.get("1")) + "_" + String.valueOf(map3.get("2"));
            } else {
                StringBuilder stringBuilder = new StringBuilder("Can't determine message structure from MSH-9: ");
                stringBuilder.append(Arrays.toString(map3.keySet().toArray()));
                if (map3.size() < 3) {
                    stringBuilder.append(" HINT: there are only ");
                    stringBuilder.append(map3.size());
                    stringBuilder.append(" of 3 components present");
                }
                throw new HL7Exception(stringBuilder.toString(), ErrorCode.UNSUPPORTED_MESSAGE_TYPE);
            }
            Message message = this.instantiateMessage(string3, string2, bl2);
            message.setParser((Parser)this);
            message.setValidationContext(this.getValidationContext());
            this.a((Group)message, map);
            return message;
        }
        catch (HL7Exception hL7Exception) {
            throw hL7Exception;
        }
        catch (Throwable throwable) {
            throw new HL7Exception("Error parsing JSON into message", throwable);
        }
    }

    protected String doEncode(Message message, String string) throws HL7Exception {
        if (!this.getDefaultEncoding().equals(string)) {
            throw new EncodingNotSupportedException("HL7JSONParser supports only JSON encoding");
        }
        return this.encode(message);
    }

    protected String doEncode(Message message) throws HL7Exception {
        if (message instanceof GenericMessage) {
            throw new HL7Exception("Can't JSON-encode a GenericMessage.  Message must have a recognized structure.");
        }
        Map<String, Object> map = this.a(message);
        try {
            return af.a().writeValueAsString(map);
        }
        catch (Exception exception) {
            throw new HL7Exception("Exception serializing JSON map to string", (Throwable)exception);
        }
    }

    public Segment getCriticalResponseData(String string) throws HL7Exception {
        Map<String, Object> map = a.a(string, "MSH");
        try {
            Map map2 = (Map)map.get("MSH");
            String string2 = this.getVersion(string);
            Segment segment = Parser.makeControlMSH((String)string2, (ModelClassFactory)this.getFactory());
            String string3 = (String)map2.get("1");
            String string4 = (String)map2.get("2");
            String string5 = (String)map2.get("10");
            String string6 = a.a(map2, "11", "1");
            Terser.set((Segment)segment, (int)1, (int)0, (int)1, (int)1, (String)string3);
            Terser.set((Segment)segment, (int)2, (int)0, (int)1, (int)1, (String)string4);
            Terser.set((Segment)segment, (int)10, (int)0, (int)1, (int)1, (String)string5);
            Terser.set((Segment)segment, (int)11, (int)0, (int)1, (int)1, (String)string6);
            return segment;
        }
        catch (HL7Exception hL7Exception) {
            throw hL7Exception;
        }
        catch (Throwable throwable) {
            throw new HL7Exception("Critical Response Data not accessible from json message", throwable);
        }
    }

    public String getAckID(String string) {
        try {
            Map<String, Object> map = a.a(string, "MSA");
            Map map2 = (Map)map.get("MSA");
            return String.valueOf(map2.get("1"));
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, (Object)this);
            return null;
        }
    }

    public String getVersion(String string) throws HL7Exception {
        Map<String, Object> map = a.a(string, "MSH");
        Map map2 = (Map)map.get("MSH");
        String string2 = a.a(map2, "12", "1");
        return string2;
    }

    public void parse(Message message, String string) throws HL7Exception {
        Map<String, Object> map = this.a(string);
        this.a((Group)message, map);
        this.applySuperStructureName(message);
    }

    public String doEncode(Segment segment, EncodingCharacters encodingCharacters) throws HL7Exception {
        try {
            Map<String, Object> map = this.a(segment);
            return af.a().writeValueAsString(map);
        }
        catch (HL7Exception hL7Exception) {
            throw hL7Exception;
        }
        catch (Throwable throwable) {
            throw new HL7Exception(throwable);
        }
    }

    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        try {
            Object object = this.a(type);
            return af.a().writeValueAsString(object);
        }
        catch (HL7Exception hL7Exception) {
            throw hL7Exception;
        }
        catch (Throwable throwable) {
            throw new HL7Exception(throwable);
        }
    }

    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Message doParseForSpecificPackage(String string, String string2, String string3) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<String, Object> a(Message message) throws HL7Exception {
        try {
            return this.a((Group)message);
        }
        catch (HL7Exception hL7Exception) {
            throw hL7Exception;
        }
        catch (Throwable throwable) {
            throw new HL7Exception("Can't encode message as JSON", throwable);
        }
    }

    private Map<String, Object> a(Group group) throws HL7Exception {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        for (String string : group.getNames()) {
            Structure[] structureArray;
            for (Structure structure : structureArray = group.getAll(string)) {
                Map<String, Object> map;
                if (structure instanceof Group) {
                    map = this.a((Group)structure);
                    if (map == null) continue;
                    for (Map.Entry entry : map.entrySet()) {
                        this.a(linkedHashMap, (String)entry.getKey(), entry.getValue(), false);
                    }
                    continue;
                }
                if (!(structure instanceof Segment)) continue;
                map = string;
                Map<String, Object> map2 = this.a((Segment)structure);
                if (map2 == null) continue;
                this.a(linkedHashMap, (String)((Object)map), map2, group.isRepeating(structure.getName()));
            }
        }
        if (!linkedHashMap.isEmpty()) {
            return linkedHashMap;
        }
        return null;
    }

    private Map<String, Object> a(Segment segment) throws HL7Exception {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        int n2 = segment.numFields();
        for (int i2 = 1; i2 <= n2; ++i2) {
            Type[] typeArray;
            String string = String.valueOf(i2);
            for (Type type : typeArray = segment.getField(i2)) {
                Object object = this.a(type);
                if (object == null) continue;
                this.a(linkedHashMap, string, object, false);
            }
        }
        if (!linkedHashMap.isEmpty()) {
            return linkedHashMap;
        }
        return null;
    }

    private Object a(Type type) throws DataTypeException {
        if (type instanceof Varies) {
            return this.a((Varies)type);
        }
        if (type instanceof Composite) {
            return this.a((Composite)type);
        }
        if (type instanceof Primitive) {
            return this.a((Primitive)type);
        }
        return null;
    }

    private Object a(Varies varies) throws DataTypeException {
        if (varies.getData() != null) {
            return this.a(varies.getData());
        }
        return null;
    }

    private Map<String, Object> a(Composite composite) throws DataTypeException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Type[] typeArray = composite.getComponents();
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            Object object = this.a(typeArray[i2]);
            if (object == null) continue;
            linkedHashMap.put(String.valueOf(i2 + 1), object);
        }
        if (!linkedHashMap.isEmpty()) {
            return linkedHashMap;
        }
        return null;
    }

    private String a(Primitive primitive) throws DataTypeException {
        String string = primitive.getValue();
        if (string == null || string.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n2;
            EncodingCharacters encodingCharacters = EncodingCharacters.getInstance((Message)primitive.getMessage());
            char c2 = encodingCharacters.getEscapeCharacter();
            int n3 = 0;
            boolean bl2 = false;
            while ((n2 = string.indexOf(c2, n3)) >= 0) {
                String string2 = string.substring(n3, n2);
                if (!bl2) {
                    if (string2.length() > 0) {
                        stringBuilder.append(string2);
                    }
                    bl2 = true;
                } else if (string2.startsWith(".") || "H".equals(string2) || "N".equals(string2)) {
                    stringBuilder.append(string2);
                    bl2 = false;
                } else {
                    stringBuilder.append(c2);
                    stringBuilder.append(string2);
                }
                n3 = n2 + 1;
            }
            if (n3 <= string.length()) {
                if (bl2) {
                    stringBuilder.append(c2);
                }
                stringBuilder.append(string.substring(n3));
            }
        }
        catch (Exception exception) {
            throw new DataTypeException("Exception encoding Primitive: ", (Throwable)exception);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    private void a(Map<String, Object> map, String string, Object object, boolean bl2) {
        Object object2 = map.get(string);
        if (object2 instanceof List) {
            ((List)object2).add(object);
        } else if (object2 != null || bl2) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (object2 != null) {
                arrayList.add(object2);
            }
            arrayList.add(object);
            map.put(string, arrayList);
        } else {
            map.put(string, object);
        }
    }

    public Map<String, Object> a(String string) throws HL7Exception {
        try {
            MapType mapType = TypeFactory.defaultInstance().constructMapType(LinkedHashMap.class, String.class, Object.class);
            Map map = (Map)af.a().readValue(string, (JavaType)mapType);
            return map;
        }
        catch (Throwable throwable) {
            throw new HL7Exception(throwable);
        }
    }

    private void a(Group group, Map<String, Object> map) throws HL7Exception {
        Group group2 = null;
        List<String> list = Arrays.asList(group.getNames());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            Map<String, Object> map2 = a.a(object, 0);
            if (list.contains(string)) {
                if (group.isRepeating(string)) {
                    int n2 = a.a(map2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        String string2 = String.valueOf(i2 + 1);
                        Object object2 = map2.get(string2);
                        group2 = group.get(string, i2);
                        this.a((Structure)group2, object2, i2);
                    }
                    continue;
                }
                if (map2.isEmpty()) continue;
                group2 = group.get(string);
                this.a((Structure)group2, map2, 0);
                continue;
            }
            group2 = this.a(group, string, map2, object instanceof List, (Structure)group2);
        }
    }

    private Group a(Group group, String string, Map<String, Object> map, boolean bl2, Structure structure) throws HL7Exception {
        Group group2 = this.a(group, string, structure);
        if (group2 == null) {
            throw new HL7Exception("Unable to place Structure: " + string + " within Message Group: " + group.getName());
        }
        if (group2.isRepeating(string)) {
            int n2 = a.a(map);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = map.get(String.valueOf(i2 + 1));
                this.a(group2.get(string, i2), object, i2);
            }
        } else if (bl2 && group2.getParent().isRepeating(group2.getName())) {
            int n3 = a.a(map);
            for (int i3 = 0; i3 < n3; ++i3) {
                group2 = (Group)group2.getParent().get(group2.getName(), i3);
                Object object = map.get(String.valueOf(i3 + 1));
                this.a(group2.get(string), object, 0);
            }
        } else {
            this.a(group2.get(string), map, 0);
        }
        return group2;
    }

    private Group a(Group group, String string, Structure structure) throws HL7Exception {
        a a2 = new a(string, structure);
        group.accept((MessageVisitor)a2, new Location());
        if (a2.a() != null) {
            return a2.a();
        }
        group.accept((MessageVisitor)a2, new Location());
        return a2.b();
    }

    private void a(Structure structure, Object object, int n2) throws HL7Exception {
        Map<String, Object> map = a.a(object, n2);
        if (structure instanceof Group) {
            this.a((Group)structure, map);
        } else if (structure instanceof Segment) {
            this.a((Segment)structure, map);
        }
    }

    private void a(Segment segment, Map<String, Object> map) throws HL7Exception {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            int n2 = Integer.parseInt(string);
            Object object = entry.getValue();
            Map<String, Object> map2 = a.a(object, 0);
            boolean bl2 = object instanceof List;
            if (bl2) {
                int n3 = a.a(map2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object2 = map2.get(String.valueOf(i2 + 1));
                    this.a(segment.getField(n2, i2), object2, n2);
                }
                continue;
            }
            this.a(segment.getField(n2, 0), object, n2);
        }
        if (segment.getClass().getName().contains("OBX")) {
            Varies.fixOBX5((Segment)segment, (ModelClassFactory)this.getFactory(), (ParserConfiguration)this.getHapiContext().getParserConfiguration());
        }
    }

    private void a(Type type, Object object, int n2) throws HL7Exception {
        if (type instanceof Varies) {
            this.a((Varies)type, object, n2);
        } else if (type instanceof Composite) {
            this.a((Composite)type, object, n2);
        } else if (type instanceof Primitive) {
            this.a((Primitive)type, object, n2);
        }
    }

    private void a(Varies varies, Object object, int n2) throws HL7Exception {
        Map<String, Object> map = a.a(object, 0);
        if (map.size() == 1 && map.values().iterator().next() instanceof String) {
            varies.setData((Type)new GenericPrimitive(varies.getMessage()));
        } else {
            varies.setData((Type)new GenericComposite(varies.getMessage()));
        }
        this.a(varies.getData(), object, n2);
    }

    private void a(Composite composite, Object object, int n2) throws HL7Exception {
        Map<String, Object> map = a.a(object, 0);
        if (composite instanceof GenericComposite) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                int n3 = Integer.parseInt(entry.getKey());
                Type type = composite.getComponent(n3);
                this.a(type, entry.getValue(), n2);
            }
        } else {
            HashSet<String> hashSet = new HashSet<String>(map.size());
            Type[] typeArray = composite.getComponents();
            for (int i2 = 0; i2 < typeArray.length; ++i2) {
                String string = String.valueOf(i2 + 1);
                if (!map.containsKey(string)) continue;
                hashSet.add(string);
                Object object2 = map.get(string);
                this.a(typeArray[i2], object2, n2);
            }
            for (String string : map.keySet()) {
                if (hashSet.contains(string)) continue;
                int n4 = Integer.parseInt(string) - 1;
                this.a((Type)composite.getExtraComponents().getComponent(n4), map.get(string), n2);
            }
        }
    }

    private void a(Primitive primitive, Object object, int n2) throws HL7Exception {
        primitive.setValue(object == null ? null : String.valueOf(object));
    }

    private static Map<String, Object> a(Object object, int n2) {
        LinkedHashMap<String, Object> linkedHashMap;
        if (object instanceof Map) {
            linkedHashMap = (LinkedHashMap<String, Object>)object;
        } else if (object instanceof List) {
            List list = (List)object;
            linkedHashMap = new LinkedHashMap(list.size());
            for (int i2 = 0; i2 < list.size(); ++i2) {
                linkedHashMap.put(String.valueOf(i2 + 1), list.get(i2));
            }
        } else {
            linkedHashMap = new LinkedHashMap<String, Object>(1);
            linkedHashMap.put(String.valueOf(n2 + 1), object);
        }
        return linkedHashMap;
    }

    private static int a(Map<String, Object> map) {
        int n2 = 0;
        for (String string : map.keySet()) {
            int n3 = Integer.parseInt(string);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2;
    }

    private static Map<String, Object> a(String string, String string2) throws HL7Exception {
        try {
            JsonParser jsonParser = af.a().getFactory().createParser((Reader)new StringReader(string));
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken != JsonToken.START_OBJECT) {
                throw new JsonParseException("Expected start of object", jsonParser.getCurrentLocation());
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            while ((jsonToken = jsonParser.nextToken()) == JsonToken.FIELD_NAME) {
                String string3 = jsonParser.getCurrentName();
                jsonParser.nextToken();
                Object object = a.a(jsonParser);
                linkedHashMap.put(string3, object);
                if (!string2.equals(string3)) continue;
                return linkedHashMap;
            }
            throw new JsonParseException("Segment not found at the top-level of message: " + string2, jsonParser.getCurrentLocation());
        }
        catch (Throwable throwable) {
            throw new HL7Exception("Unable to create JSON Parser", throwable);
        }
    }

    private static Object a(JsonParser jsonParser) throws JsonParseException {
        try {
            Cloneable cloneable;
            switch (jsonParser.getCurrentToken()) {
                case VALUE_NULL: {
                    cloneable = null;
                    break;
                }
                case VALUE_FALSE: {
                    cloneable = Boolean.FALSE;
                    break;
                }
                case VALUE_TRUE: {
                    cloneable = Boolean.TRUE;
                    break;
                }
                case VALUE_STRING: {
                    cloneable = jsonParser.getText();
                    break;
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    cloneable = Double.parseDouble(jsonParser.getText());
                    break;
                }
                case START_ARRAY: {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        arrayList.add(a.a(jsonParser));
                    }
                    cloneable = arrayList;
                    break;
                }
                case START_OBJECT: {
                    LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
                    while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                        if (jsonParser.getCurrentToken() != JsonToken.FIELD_NAME) {
                            throw new JsonParseException("Expected field name", jsonParser.getCurrentLocation());
                        }
                        String string = jsonParser.getCurrentName();
                        jsonParser.nextToken();
                        Object object = a.a(jsonParser);
                        linkedHashMap.put(string, object);
                    }
                    cloneable = linkedHashMap;
                    break;
                }
                default: {
                    throw new JsonParseException("Unexpected embedded object", jsonParser.getCurrentLocation());
                }
            }
            return cloneable;
        }
        catch (Throwable throwable) {
            throw new JsonParseException("Error parsing JSON", jsonParser.getCurrentLocation());
        }
    }

    private static String a(Map<String, Object> map, String ... stringArray) throws HL7Exception {
        String string;
        String string2 = stringArray[0];
        Object object = map.get(string2);
        if (object instanceof Map) {
            Map map2 = (Map)object;
            stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            string = a.a(map2, stringArray);
        } else {
            string = (String)object;
        }
        return string;
    }

    private static class a
    implements MessageVisitor {
        private final String a;
        private final Structure b;
        private boolean c;
        private Group d;
        private Group e;

        public a(String string, Structure structure) {
            this.a = string;
            this.b = structure;
            this.c = false;
            this.d = null;
            this.e = null;
        }

        public Group a() {
            return this.e;
        }

        public Group b() {
            return this.d;
        }

        private void a(Group group) throws HL7Exception {
            for (String string : group.getNames()) {
                group.get(string);
            }
        }

        public boolean start(Message message) throws HL7Exception {
            this.a((Group)message);
            return true;
        }

        public boolean end(Message message) throws HL7Exception {
            return true;
        }

        public boolean start(Group group, Location location) throws HL7Exception {
            this.a(group);
            List<String> list = Arrays.asList(group.getNames());
            if (this.b != null && !this.c && list.contains(this.b.getName())) {
                for (Structure structure : group.getAll(this.b.getName())) {
                    if (structure != this.b) continue;
                    this.c = true;
                    break;
                }
            }
            if (list.contains(this.a)) {
                if (this.c) {
                    this.e = group;
                    if (this.d == null) {
                        this.d = group;
                    }
                    return false;
                }
                if (this.d == null) {
                    this.d = group;
                    if (this.b == null) {
                        return false;
                    }
                }
            }
            return true;
        }

        public boolean end(Group group, Location location) throws HL7Exception {
            return true;
        }

        public boolean start(Segment segment, Location location) throws HL7Exception {
            return true;
        }

        public boolean end(Segment segment, Location location) throws HL7Exception {
            return true;
        }

        public boolean start(Field field, Location location) throws HL7Exception {
            return true;
        }

        public boolean end(Field field, Location location) throws HL7Exception {
            return true;
        }

        public boolean start(Composite composite, Location location) throws HL7Exception {
            return true;
        }

        public boolean end(Composite composite, Location location) throws HL7Exception {
            return true;
        }

        public boolean visit(Primitive primitive, Location location) throws HL7Exception {
            return true;
        }
    }
}

