/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.install;

import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import com.mimvista.LocalLicense.Admin;
import com.mimvista.cloud.shared.common.version.VersionNumberComparator;
import com.mimvista.dicom.server.gui.ServiceControl;
import com.mimvista.dicom.server.gui.ServiceException;
import com.mimvista.dicom.server.gui.WindowsServiceControl;
import com.mimvista.exodus.MIM;
import com.mimvista.file.MIMFile;
import com.mimvista.file.Path;
import com.mimvista.file.PathUtils;
import com.mimvista.file.n;
import com.mimvista.install.FreshInstaller;
import com.mimvista.install.InstallException;
import com.mimvista.install.InstallerBackend;
import com.mimvista.install.LocalUpgradeInstaller;
import com.mimvista.install.c;
import com.mimvista.install.d;
import com.mimvista.install.f;
import com.mimvista.license.LocalLicenseDialog;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.osdep.b;
import com.mimvista.osdep.service.WindowsServiceUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.logging.MIMDiskAndConsoleAppender;
import com.mimvista.util.logging.r;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.service.SimpleServiceControl;
import com.mimvista.windows.IntegrityProcessLauncher;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

@ExternallyVisible
public abstract class MimInstaller {
    public static final String progFilesPath = PathUtils.getWindowsProgramFilesPath();
    public static final String homeDrive;
    public static final String MIMINSTALLER_LOG = "mim_install.log";
    private static String a;
    public static final String recommendedMimInstallPath;
    public static final String recommendedViewerInstallPath;
    public static final String recommendedAtlasInstallPath;
    public static final String recommendedMIMDataPath;
    public static final String recommendedSlingerPath;
    public static final String recommendedSlingerDataPath;
    public static final String licenseResource = "/eulas/license.txt";
    public static final String viewerlicenseResource = "/eulas/viewerlicense.txt";
    public static final String cdViewerLicenseResource = "/eulas/mimviewercd_license.txt";
    public static final String slingerLicenseResource = "/eulas/slinger_license.txt";
    public static final String MIM_KEY = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MIM";
    public static final String MIMVIEWER_KEY = "HKLM\\Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\MIMviewer";
    public static final String DEFAULT_DESKTOP_PATH = "..\\..\\All Users\\Desktop";
    public static final String DEFAULT_USER_PROGRAMS_PATH = "..\\Start Menu\\Programs";
    public static final String DEFAULT_ALL_PROGRAMS_PATH = "..\\..\\All Users\\Start Menu\\Programs";
    public static final Messages props;
    protected static final String j;
    protected String k = null;
    protected String l;
    protected String m = j;
    protected boolean n = false;
    protected String o = "";
    protected String p;
    protected boolean q = false;
    protected boolean r = false;
    protected InstallerBackend s = new InstallerBackend(this);
    protected c t = new c(this);
    protected boolean u = false;
    protected ActionListener v;
    protected ActionListener w;
    boolean x = false;
    private boolean b = false;
    private boolean c = true;
    protected boolean y = false;
    static String[] z;
    protected f A = new f(this);
    protected boolean B = false;

    public MimInstaller() {
        System.setProperty("miminstaller", "true");
        this.l = Path.getTempPath();
    }

    public static void main(String[] stringArray) {
        System.setProperty("sun.java2d.d3d", "false");
        System.setProperty("nodevelopment", "true");
        System.setProperty("miminstaller", "true");
        MIMDiskAndConsoleAppender mIMDiskAndConsoleAppender = com.mimvista.util.logging.r.a(false, MIMINSTALLER_LOG);
        MIMLookAndFeel.M();
        MIM.setJavaLibPath();
        System.out.println("Running updater!");
        if (MIMFile.separator.equals("/")) {
            if (stringArray.length >= 2 && "blessme".equals(stringArray[0])) {
                FakeInstaller fakeInstaller = new FakeInstaller(1);
                MimInstaller.setInstallPath(stringArray[1]);
                try {
                    fakeInstaller.s.b();
                }
                catch (InstallException installException) {
                    installException.printStackTrace();
                }
                return;
            }
            MimInstaller.c();
            return;
        }
        ay.b((Object)("Started updater! " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime())), MimInstaller.class);
        try {
            if (stringArray.length < 3) {
                MimInstaller mimInstaller;
                d d2 = new d();
                d2.c();
                if (d2.d()) {
                    mimInstaller = new LocalUpgradeInstaller();
                    a = d2.e();
                } else {
                    mimInstaller = new FreshInstaller();
                }
                com.mimvista.file.n.a();
                super.b();
                mimInstaller.init();
                mimInstaller.getWindow().d();
            } else {
                if (stringArray[0].equals("test")) {
                    MimInstaller.c();
                    return;
                }
                ay.d((Object)"Wrong args???", MimInstaller.class);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    ay.d((Object)string, MimInstaller.class);
                    System.out.println("About to System.exit");
                    System.exit(0);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            JOptionPane.showMessageDialog(null, throwable.toString(), props.getProperty("MIMINSTALL_ERROR"), 0);
            System.out.println("About to System.exit");
            System.exit(0);
        }
    }

    public boolean getShow64bitOption() {
        return this.y;
    }

    private void b() {
        if (!com.mimvista.osdep.b.a()) {
            return;
        }
        this.y = true;
        if (this.isFresh()) {
            return;
        }
        if (new MIMFile(a, "bin/jre_64").exists()) {
            this.setInstall64bit(true);
        }
    }

    private static void c() {
        FakeInstaller fakeInstaller = new FakeInstaller(1);
        super.b();
        z = new String[]{"3", "3", "0", "339"};
        fakeInstaller.m = "3.1.0.324";
        ((MimInstaller)fakeInstaller).init();
        fakeInstaller.t.d();
    }

    protected abstract void init();

    protected abstract void run() throws InstallException;

    public abstract String getDeclineLicenseText();

    public abstract String getClosedTooltipText();

    public abstract String getFinishedText();

    public abstract String getFinishedMsg();

    protected void a(Progress progress) {
        if (progress != null) {
            progress.a(true);
            progress.b_(MIMFormat.a(props.getProperty("MIMINSTALL_STOPPING_SERVICES"), this.getProductString()));
        }
        if (this.q) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.s.c();
    }

    protected void b(Progress progress) {
        if (progress != null) {
            progress.a(true);
            progress.b_(MIMFormat.a(props.getProperty("MIMINSTALL_RESTARTING_SERVICES"), this.getProductString()));
        }
        if (this.q) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.s.d();
    }

    MIMFile.a a(final long[] lArray, final long l2, final Progress progress) {
        return new MIMFile.a(){

            @Override
            public void a(int n2) {
                lArray[0] = lArray[0] + (long)n2;
                progress.b((int)(300L * lArray[0] / l2));
            }

            @Override
            public void a(String string) {
                progress.b_(props.getProperty("MIMINSTALL_COPYING") + " " + string);
            }

            @Override
            public boolean a(Exception exception, MIMFile mIMFile, MIMFile mIMFile2) {
                return MimInstaller.this.a(mIMFile2, exception);
            }
        };
    }

    protected void g() {
        MIMFile mIMFile = new MIMFile(new MIMFile(a).getAbsolutePath() + "\\");
        for (SimpleServiceControl.MimService mimService : this.a()) {
            if (mimService.b() || mimService.c()) continue;
            ServiceControl serviceControl = ServiceControl.getInstance(mimService);
            serviceControl.createRedirectInisForInstall(mIMFile);
        }
    }

    protected List<SimpleServiceControl.MimService> a() {
        return Lists.newArrayList((Object[])SimpleServiceControl.MimService.values());
    }

    protected void h() {
        block14: {
            if (!this.d()) {
                return;
            }
            InstallerBackend.a(PathUtils.getServiceIniPath());
            this.g();
            ay.b((Object)"Checking/installing MIMadmin", this);
            WindowsServiceControl windowsServiceControl = MimInstaller.getWindowsServiceControl(SimpleServiceControl.MimService.h);
            try {
                SimpleServiceControl.MimServiceState mimServiceState = windowsServiceControl.getServerStatusCodeNoXcpAndUseRegCheck();
                if (mimServiceState != SimpleServiceControl.MimServiceState.a) {
                    ay.b((Object)"MIMadmin already installed, checking version", this);
                    if (mimServiceState != SimpleServiceControl.MimServiceState.d) {
                        try {
                            FuncUtils.b(() -> {
                                windowsServiceControl.startService();
                                return true;
                            });
                        }
                        catch (Throwable throwable) {
                            ay.c((Object)"Totally failed to re-start admin service.", throwable, this);
                        }
                    }
                    Admin[] adminArray = new Admin[1];
                    FuncUtils.b(() -> {
                        adminArray[0] = LocalLicenseDialog.a(true, false);
                        return adminArray[0] != null;
                    });
                    Admin admin = adminArray[0];
                    try {
                        if (admin == null) {
                            ay.b((Object)"Could not connect to MIMadmin, forcibly uninstalling.", this);
                            windowsServiceControl.uninstallService();
                            windowsServiceControl.installService();
                            windowsServiceControl.startService();
                        } else if (admin.getServiceVersion() < 15) {
                            ay.b((Object)"Older MIMadmin found, reinstalling.", this);
                            windowsServiceControl.uninstallService();
                            windowsServiceControl.installService();
                            windowsServiceControl.startService();
                        } else {
                            ay.b((Object)"MIMadmin is current or newer, leaving alone.", this);
                        }
                    }
                    catch (RemoteException remoteException) {
                        ay.c((Object)"Unable to determine MIMadmin version...", (Throwable)remoteException, this);
                    }
                    mimServiceState = windowsServiceControl.getServerStatusCodeNoXcpAndUseRegCheck();
                    if (mimServiceState != SimpleServiceControl.MimServiceState.d) {
                        ay.b((Object)"MIMadmin is still not running, so just going to install under this app.", this);
                        windowsServiceControl.uninstallService();
                        windowsServiceControl.installService();
                        windowsServiceControl.startService();
                    }
                    break block14;
                }
                ay.b((Object)"Installing MIMadmin clean", this);
                windowsServiceControl.installService();
                windowsServiceControl.startService();
            }
            catch (Exception exception) {
                ay.d((Object)"Exception thrown installing and/or version checking MIMadmin.", (Throwable)exception, MimInstaller.class);
            }
        }
    }

    protected void i() {
        ay.b((Object)"Removing the MIMDB service if it exists...", this);
        if (!WindowsServiceUtils.a("mimpacs", WindowsServiceUtils.Config.g, "\"\"")) {
            ay.d((Object)"Unable to remove the dependencies for the MIMpacs service", this);
        }
        if (!WindowsServiceUtils.c("MIMDB") && !WindowsServiceUtils.c("MIMDB")) {
            ay.d((Object)"Unable to uninstall the MIMDB service.", this);
        }
    }

    protected void a(SimpleServiceControl.MimService mimService, boolean bl2) {
        WindowsServiceControl windowsServiceControl;
        SimpleServiceControl.MimServiceState mimServiceState;
        if (!this.d()) {
            return;
        }
        if (mimService.f().equals(SimpleServiceControl.MimService.g.f()) && (mimServiceState = (windowsServiceControl = MimInstaller.getWindowsServiceControl(SimpleServiceControl.MimService.f)).getServerStatusCodeNoXcpAndUseRegCheck()).a()) {
            ay.c((Object)"Cannot install the Assistant and MIMcloud Assistant on the same machine.", this);
            return;
        }
        windowsServiceControl = MimInstaller.getWindowsServiceControl(mimService);
        mimServiceState = windowsServiceControl.getServerStatusCodeNoXcpAndUseRegCheck();
        if (mimServiceState.a()) {
            ay.c((Object)"Went to install service, but it was already installed.  Should not happen.", this);
            return;
        }
        try {
            ay.b((Object)("Installing " + mimService.f() + " and setting as " + (bl2 ? "Automatic" : "Manual") + " start."), this);
            windowsServiceControl.installService();
            if (!bl2) {
                windowsServiceControl.setManualStart();
                windowsServiceControl.stopService();
            } else {
                windowsServiceControl.startService();
            }
        }
        catch (ServiceException serviceException) {
            ay.d((Object)"Exception installing service: ", (Throwable)serviceException, this);
        }
    }

    protected void a(SimpleServiceControl.MimService mimService) {
        this.a(mimService, true);
    }

    protected void b(SimpleServiceControl.MimService mimService) {
        this.a(mimService, false);
    }

    public void runServicesSetup() {
        this.s.h();
    }

    private boolean d() {
        if (MIMFile.separatorChar == '\\') {
            ay.b((Object)"Installing on NT", MimInstaller.class);
            return true;
        }
        ay.d((Object)"Not an NT operating system", MimInstaller.class);
        return false;
    }

    abstract String e();

    boolean a(MIMFile mIMFile, Exception exception) {
        return this.a(mIMFile, exception.getMessage());
    }

    boolean a(MIMFile mIMFile, String string) {
        ay.d((Object)("Asking user about copying error (" + string + ") on: " + mIMFile), this);
        String string2 = mIMFile.getName();
        if (string2.equalsIgnoreCase("mim.ico") || string2.equalsIgnoreCase("storescp.exe")) {
            return true;
        }
        String string3 = props.getProperty("MIMINSTALL_ERROR_COPYING") + "\n" + string + "\n" + MIMFormat.a(props.getProperty("MIMINSTALL_ERROR_COPYING_TIP"), this.getProductString());
        Object[] objectArray = new Object[]{props.getProperty("MIMINSTALL_RETRY"), props.getProperty("MIMINSTALL_ABORT")};
        int n2 = JOptionPane.showOptionDialog(this.t.a(), string3, props.getProperty("MIMINSTALL_INSTALL_ERROR"), 0, -1, null, objectArray, null);
        return n2 == 0;
    }

    protected ArrayList<String> j() throws InstallException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.q) {
            return arrayList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("mim.manifest"));
            f.a(bufferedReader, arrayList);
        }
        catch (IOException iOException) {
            ay.d((Object)"Unable to read manifest: ", (Throwable)iOException, MimInstaller.class);
            throw new InstallException(props.getProperty("MIMINSTALL_ERROR_MANIFEST") + ": " + iOException.getMessage());
        }
        arrayList = this.A.a(arrayList);
        arrayList = this.a(this.A, arrayList);
        return arrayList;
    }

    public static String getVersion() {
        return cn.a(z, ".");
    }

    public boolean askQuestion(String string, String string2) {
        return this.t.b(string, string2);
    }

    private static void a(ServiceControl serviceControl) {
        serviceControl.setForceDirectCommand(true);
        serviceControl.setStartDir(new File(a).getAbsolutePath() + "\\");
    }

    public static ServiceControl getServiceControl(SimpleServiceControl.MimService mimService) {
        ServiceControl serviceControl = ServiceControl.getInstance(mimService);
        MimInstaller.a(serviceControl);
        return serviceControl;
    }

    public static WindowsServiceControl getWindowsServiceControl(SimpleServiceControl.MimService mimService) {
        WindowsServiceControl windowsServiceControl = new WindowsServiceControl(mimService);
        MimInstaller.a((ServiceControl)windowsServiceControl);
        return windowsServiceControl;
    }

    public static String getInstallPath() {
        return a;
    }

    public static void setInstallPath(String string) {
        a = string;
    }

    public JFrame getFrame() {
        return this.t.a();
    }

    public void startMim() {
        String string = a;
        string = this.isInstall64bit() ? string + "bin\\MIM_64.exe" : string + "bin\\MIM.exe";
        IntegrityProcessLauncher integrityProcessLauncher = new IntegrityProcessLauncher(string);
        integrityProcessLauncher.a();
        this.getFrame().setVisible(false);
        System.exit(0);
    }

    public void bailOutWithError(Throwable throwable) {
        this.bailOutWithError(props.getProperty("FRESH_INSTALL_FAILED_TITLE"), props.getProperty("FRESH_INSTALL_FAILED_MESSAGE"), throwable);
    }

    public void bailOutWithError(String string, String string2, @com.mimvista.d Throwable throwable) {
        if (throwable != null) {
            ay.d((Object)throwable, this);
        } else {
            ay.d((Object)string2, this);
        }
        JOptionPane.showMessageDialog(this.getFrame(), string2, string, 0);
        this.getFrame().setVisible(false);
        System.exit(-1);
    }

    public abstract boolean isFresh();

    protected ArrayList<String> a(f f2, ArrayList<String> arrayList) {
        if (!this.isInstall64bit()) {
            if (!com.mimvista.osdep.b.a()) {
                arrayList = f2.a(arrayList, "bin/jre_64");
            }
            arrayList = f2.a(arrayList, "bin/MIM_64");
        }
        return arrayList;
    }

    public boolean isInstall64bit() {
        return this.b;
    }

    public void setInstall64bit(boolean bl2) {
        this.b = bl2;
    }

    public boolean isCreateShortcutFor64bitOnly() {
        return this.c;
    }

    public void setCreateShortcutFor64bitOnly(boolean bl2) {
        this.c = bl2;
    }

    public abstract String getProductString();

    public abstract String getRecommendedInstallPath();

    public static String getLicenseResource() {
        if (MIMContext.i()) {
            return cdViewerLicenseResource;
        }
        if (MIMContext.j()) {
            return viewerlicenseResource;
        }
        if (MIMContext.x()) {
            return slingerLicenseResource;
        }
        return licenseResource;
    }

    public c getWindow() {
        return this.t;
    }

    public boolean isCreate64BitIcon() {
        return this.B;
    }

    public void setCreate64BitIcon(boolean bl2) {
        this.B = bl2;
    }

    public boolean isFromWeb() {
        return this.n;
    }

    protected String k() {
        if (this.r) {
            int n2 = VersionNumberComparator.d.a().compare(new VersionNumber(this.m), new VersionNumber(z));
            if (n2 == 0) {
                return "It appears you already have an up-to-date version of MIM installed.\n\nClick Next to reinstall the current version.";
            }
            if (n2 == -1) {
                return "It appears you have a more current version of MIM already installed.\n\nClick Next only if you are sure you want to install an older version.";
            }
        }
        return "";
    }

    protected boolean verifyProductNotRunning() {
        int n2 = 0;
        while (this.s.i() && n2 == 0) {
            String string = props.getProperty("LOCALUP_MIM_RUNNING_TITLE");
            String string2 = props.getProperty("LOCALUP_MIM_RUNNING_MSG");
            n2 = JOptionPane.showConfirmDialog(this.getFrame(), string2, string, 2, 2);
        }
        return n2 == 0;
    }

    public static String getMIMDataPath() {
        String string = System.getProperty("mim_data_root");
        return string == null ? recommendedMIMDataPath : string;
    }

    static {
        String string = System.getenv("SYSTEMDRIVE");
        homeDrive = string != null && !"".equals(string) ? string : "C:";
        a = progFilesPath + "\\MIM";
        recommendedMimInstallPath = progFilesPath + "\\MIM";
        recommendedViewerInstallPath = progFilesPath + "\\MIMviewer";
        recommendedAtlasInstallPath = progFilesPath + "\\MIM\\data\\";
        recommendedMIMDataPath = homeDrive + "\\MIM_DATA";
        recommendedSlingerPath = progFilesPath + "\\MIMcloudAssistant";
        recommendedSlingerDataPath = recommendedMIMDataPath + "\\EXPRESS";
        props = Messages.a("MimInstaller");
        j = props.getProperty("MIMINSTALL_UNKNOWN_VERSION");
        z = VersionNumber.loadVersion();
    }

    public static final class FakeInstaller
    extends LocalUpgradeInstaller {
        private FakeInstaller(int n2) {
            this.q = true;
        }

        @Override
        protected void init() {
            super.init();
        }

        @Override
        public String getDeclineLicenseText() {
            return "asdf";
        }
    }
}

