/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.intensitybasedwarp.props;

import com.mimvista.MimJsonSerializable;
import com.mimvista.intensitybasedwarp.props.g;
import com.mimvista.intensitybasedwarp.props.h;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.f;

@MimJsonSerializable
public class AtlasPropertyDeriver
extends h {
    @Override
    public int getSuggestedIterations() {
        return (int)AtlasParameter.ITERATIONS.getRuntimeValue();
    }

    @Override
    public float[] calculateDegreesOfFreedom(int n2, float[] fArray) {
        float f2 = 1.0E8f;
        float[] fArray2 = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            fArray2[i2] = (float)((double)f2 / Math.pow(fArray[i2], 3.0));
        }
        return fArray2;
    }

    @Override
    public float[] calculateResolution(int n2) {
        float f2 = AtlasParameter.START_RESOLUTION.getRuntimeValue();
        float f3 = AtlasParameter.END_RESOLUTION.getRuntimeValue();
        return this.calculateResolution(n2, f2, f3);
    }

    public float[] calculateResolution(int n2, float f2, float f3) {
        return g.e(n2, f2, f3);
    }

    @Override
    public float[] calculateStepSize(int n2) {
        float f2 = AtlasParameter.START_RESOLUTION.getRuntimeValue();
        float f3 = AtlasParameter.STEP_SIZE.getRuntimeValue();
        return this.calculateStepSize(n2, f2, f3);
    }

    public float[] calculateStepSize(int n2, float f2, float f3) {
        return g.e(n2, f2 / 1.5f, f3);
    }

    @Override
    public float[] calculateScoreFWHM(int n2, float f2) {
        float f3 = AtlasParameter.START_SCORE_FWHM.getRuntimeValue();
        float f4 = AtlasParameter.END_SCORE_FWHM.getRuntimeValue();
        float f5 = AtlasParameter.SCORE_PERCENT_LINEAR.getRuntimeValue();
        return this.calculateScoreFWHM(n2, f3, f4, f5, f2);
    }

    public float[] calculateScoreFWHM(int n2, float f2, float f3, float f4, float f5) {
        float[] fArray = g.b(n2, f2, f3, f4);
        for (int i2 = 2; i2 < n2; ++i2) {
            int n3 = i2;
            fArray[n3] = (float)((double)fArray[n3] / Math.pow(i2, f5));
        }
        return fArray;
    }

    @Override
    public float[] calculateWarpFieldFWHM(int n2, float f2) {
        float f3 = AtlasParameter.START_FIELD_FWHM.getRuntimeValue();
        float f4 = AtlasParameter.END_FIELD_FWHM.getRuntimeValue();
        return this.calculateWarpFieldFWHM(n2, f3, f4, f2);
    }

    public float[] calculateWarpFieldFWHM(int n2, float f2, float f3, float f4) {
        float[] fArray = g.e(n2, f2, f3);
        for (int i2 = 2; i2 < n2; ++i2) {
            int n3 = i2;
            fArray[n3] = (float)((double)fArray[n3] * Math.pow(i2, f4));
        }
        return fArray;
    }

    @Override
    public float[] calculateDataFWHM(int n2) {
        float f2 = AtlasParameter.START_DATA_FWHM.getRuntimeValue();
        float f3 = AtlasParameter.END_DATA_FWHM.getRuntimeValue();
        return this.calculateDataFWHM(n2, f2, f3);
    }

    public float[] calculateDataFWHM(int n2, float f2, float f3) {
        return g.e(n2, f2, f3);
    }

    @Override
    public boolean forceSmoothAfterTransfer() {
        return true;
    }

    @Override
    public float calculateSmoothStrength() {
        float f2 = AtlasParameter.SMOOTH_STRENGTH.getRuntimeValue();
        return f2;
    }

    @Override
    public float[] calculateWeightRampFactor(int n2) {
        return MathUtils.a(0.0f, n2);
    }

    @Override
    public float[] calculatePrevWeightFactor(int n2) {
        return MathUtils.a(0.0f, n2);
    }

    @Override
    public float calculateScoreFWHMIterationExponent() {
        return 0.0f;
    }

    @Override
    public float calculateFieldFWHMIterationExponent() {
        return 0.0f;
    }

    @MimJsonSerializable
    public static enum AtlasParameter implements f
    {
        ITERATIONS(50.0f, 250.0f, 150.0f),
        START_RESOLUTION(5.0f, 20.0f, 8.0f),
        END_RESOLUTION(2.0f, 4.0f, 3.0f),
        START_SCORE_FWHM(50.0f, 100.0f, 70.0f),
        END_SCORE_FWHM(2.0f, 16.0f, 3.0f),
        SCORE_PERCENT_LINEAR(0.25f, 1.0f, 0.4f),
        START_FIELD_FWHM(50.0f, 100.0f, 80.0f),
        END_FIELD_FWHM(2.5f, 12.0f, 2.6f),
        STEP_SIZE(0.3f, 1.5f, 0.5f),
        START_DATA_FWHM(3.0f, 20.0f, 8.0f),
        END_DATA_FWHM(0.0f, 5.0f, 2.0f),
        SCORE_EXPONENT(1.0f, 3.0f, 2.0f),
        SMOOTH_STRENGTH(0.0f, 1.0f, 0.25f);

        private float upperBound;
        private float lowerBound;
        private float runtimeValue;

        private AtlasParameter(float f2, float f3, float f4) {
            this.upperBound = f3;
            this.lowerBound = f2;
            this.runtimeValue = f4;
        }

        @Override
        public float getLowerBound() {
            return this.lowerBound;
        }

        @Override
        public float getUpperBound() {
            return this.upperBound;
        }

        @Override
        public float getRuntimeValue() {
            return this.runtimeValue;
        }
    }
}

