/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.mimvista.dicom.read.DicomRTplanReader;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.mui.Session;
import com.mimvista.mui.SessionKey;
import com.mimvista.mui.bm;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.state.f;
import com.mimvista.util.ay;
import com.mimvista.util.work.m;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.SwingUtilities;

public class CollimatorState
implements Serializable {
    private static final long serialVersionUID = 5955051525869557682L;
    private final DicomBeamRecord beam;
    public final String rtPlanSop;
    private SessionKey sessKey;
    private int currentPosition;
    private int cachedPosition;
    public final int numTimePoints;
    private boolean playing = false;
    private transient Timer a;

    public CollimatorState(DicomBeamRecord dicomBeamRecord, String string, Session session) {
        this.beam = dicomBeamRecord;
        this.rtPlanSop = string;
        this.sessKey = session.H();
        this.currentPosition = 0;
        this.cachedPosition = 0;
        int n2 = Math.max(dicomBeamRecord.getXJaws().getTimePoints().size(), dicomBeamRecord.getYJaws().getTimePoints().size());
        if (DicomRTplanReader.getBeamsEyeMLCPoints((ReportableRtplanState.BeamRecord)dicomBeamRecord, 0) != null) {
            n2 = Math.max(n2, dicomBeamRecord.getFirstMLC().getTimePoints().size());
        }
        this.numTimePoints = n2;
    }

    public void a() {
        this.a.schedule(new TimerTask(){

            @Override
            public void run() {
                CollimatorState.this.a();
            }
        }, com.mimvista.internals.CollimatorState$a.a(this, (this.cachedPosition + 1) % this.numTimePoints));
        SwingUtilities.invokeLater(() -> {
            try {
                RtplanStateManager rtplanStateManager = RtplanStateManager.getForSession(bm.b());
                if (rtplanStateManager == null || rtplanStateManager.getState(this.beam.getRtplanSOPUID()) == null || !rtplanStateManager.getState(this.beam.getRtplanSOPUID()).getDRR(this.beam).b().bu()) {
                    this.a.cancel();
                    return;
                }
                this.b();
            }
            catch (NullPointerException nullPointerException) {
                ay.d((Object)"Error caught while playing through collimator positions: ", (Throwable)nullPointerException, this);
                this.a.cancel();
            }
        });
    }

    public void b() {
        this.a(CollimatorStep.c);
    }

    public void c() {
        this.a(CollimatorStep.a);
    }

    public void d() {
        this.a(CollimatorStep.b);
    }

    public void e() {
        this.a(CollimatorStep.d);
    }

    public void f() {
        this.a(CollimatorStep.e);
    }

    public boolean g() {
        return this.currentPosition < 0;
    }

    public void h() {
        if (this.m()) {
            return;
        }
        this.playing = true;
        this.a = new Timer();
        this.a.schedule(new TimerTask(){

            @Override
            public void run() {
                CollimatorState.this.a();
            }
        }, 0L);
    }

    public void i() {
        if (!this.m()) {
            return;
        }
        this.playing = false;
        this.a.cancel();
    }

    public void j() {
        com.mimvista.internals.CollimatorState$a.a();
    }

    public void k() {
        com.mimvista.internals.CollimatorState$a.b();
    }

    public void a(CollimatorStep collimatorStep) {
        switch (collimatorStep) {
            case c: {
                this.cachedPosition = this.currentPosition = (this.cachedPosition + 1) % this.numTimePoints;
                break;
            }
            case a: {
                this.cachedPosition = this.currentPosition = (this.cachedPosition + this.numTimePoints - 1) % this.numTimePoints;
                break;
            }
            case b: {
                if (this.currentPosition == -1) {
                    this.currentPosition = this.cachedPosition;
                    break;
                }
                this.cachedPosition = this.currentPosition;
                this.currentPosition = -1;
                break;
            }
            case d: {
                this.cachedPosition = this.currentPosition = this.beam.getMaxMUSegment();
                break;
            }
        }
        RtplanStateManager.getForSession(this.sessKey.b()).getState(this.rtPlanSop).fireOverlayChangedListeners(this.beam);
    }

    public int l() {
        return this.currentPosition;
    }

    public boolean m() {
        return this.playing;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.sessKey == null) {
            this.sessKey = f.a().g();
        }
    }

    private static class a {
        private static long d = 5000L;
        public static final long a = 20000L;
        public static final long b = 500L;
        public static final float c = 1.5f;
        private static Map<CollimatorState, long[]> e = new ConcurrentHashMap<CollimatorState, long[]>();

        private a() {
        }

        public static void a() {
            d = Math.max(500L, (long)((float)d / 1.5f));
            e.clear();
        }

        public static void b() {
            d = Math.min(20000L, (long)((float)d * 1.5f));
            e.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static long a(CollimatorState collimatorState, int n2) {
            long[] lArray = e.get(collimatorState);
            if (lArray == null) {
                Map<CollimatorState, long[]> map = e;
                synchronized (map) {
                    DicomBeamRecord dicomBeamRecord = collimatorState.beam;
                    lArray = dicomBeamRecord.getPrimaryDosimeterUnit() == DicomBeamRecord.DosimeterUnit.MINUTE && dicomBeamRecord.getDoseRate() != null ? com.mimvista.internals.CollimatorState$a.b(collimatorState) : com.mimvista.internals.CollimatorState$a.a(collimatorState);
                }
            }
            return lArray[n2];
        }

        private static long[] a(CollimatorState collimatorState) {
            final DicomBeamRecord dicomBeamRecord = collimatorState.beam;
            final float[] fArray = dicomBeamRecord.getCumulativeMetersets();
            final long[] lArray = new long[collimatorState.numTimePoints];
            FuncUtils.a((ThreadPoolExecutor)m.b, collimatorState.numTimePoints, new FuncUtils.e(){

                @Override
                public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                    for (int i2 = n2; i2 < n3; ++i2) {
                        float f2 = i2 + 1 < fArray.length ? fArray[i2 + 1] : dicomBeamRecord.getFinalCumulativeMeterset();
                        float f3 = i2 - 1 >= 0 ? fArray[i2 - 1] : 0.0f;
                        lArray[i2] = (long)((f2 - f3) / dicomBeamRecord.getFinalCumulativeMeterset() * (float)d / 2.0f);
                    }
                }
            });
            e.put(collimatorState, lArray);
            return lArray;
        }

        private static long[] b(CollimatorState collimatorState) {
            final DicomBeamRecord dicomBeamRecord = collimatorState.beam;
            final float[] fArray = dicomBeamRecord.getCumulativeMetersets();
            final float[] fArray2 = new float[collimatorState.numTimePoints];
            final long[] lArray = new long[collimatorState.numTimePoints];
            final float[] fArray3 = new float[m.c.getCorePoolSize()];
            FuncUtils.a((ThreadPoolExecutor)m.b, collimatorState.numTimePoints, new FuncUtils.e(){

                @Override
                public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    for (int i2 = n2; i2 < n3; ++i2) {
                        f3 = dicomBeamRecord.getDoseRate(i2).getValue();
                        float f5 = fArray[i2];
                        float f6 = i2 + 1 < fArray.length ? fArray[i2 + 1] : dicomBeamRecord.getFinalCumulativeMeterset();
                        float f7 = i2 - 1 >= 0 ? fArray[i2 - 1] : 0.0f;
                        float f8 = (f6 - f5) * f3;
                        f2 += f8;
                        fArray2[i2] = ((f5 - f7) * f4 + f8) / 2.0f;
                        f4 = f3;
                    }
                    fArray3[n4] = f2;
                }
            });
            float f2 = 0.0f;
            for (float f3 : fArray3) {
                f2 += f3;
            }
            final float f4 = f2;
            FuncUtils.a((ThreadPoolExecutor)m.b, collimatorState.numTimePoints, new FuncUtils.e(){

                @Override
                public void f(int n2, int n3, int n4) throws FuncUtils.MIMInterruptedException {
                    for (int i2 = n2; i2 < n3; ++i2) {
                        lArray[i2] = (long)(fArray2[i2] / dicomBeamRecord.getFinalCumulativeMeterset() / f4 * (float)d);
                    }
                }
            });
            e.put(collimatorState, lArray);
            return lArray;
        }
    }

    protected static enum CollimatorStep {
        a,
        b,
        c,
        d,
        e;

    }
}

