/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.google.common.collect.ImmutableList;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.util.HUEDConverter;
import com.mimvista.dicom.util.HUEDProfile;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.PresetWindowLevel;
import com.mimvista.internals.ReadOnlyContrast;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.Point2f;
import com.mimvista.preferencesNew.ContrastPresetsPrefs;
import com.mimvista.state.ReadHelper;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.algo.BestContrastor;
import com.mimvista.viewer.algo.c;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import javax.vecmath.Tuple2f;

public class ContrastState
implements ReadOnlyContrast,
Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    protected PresetWindowLevel presetAsLoaded = null;
    protected ImmutableList<PresetWindowLevel> windowLevelPresetList;
    protected int[] currentLookupTable = null;
    protected boolean useCTPresets = false;
    protected PresetWindowLevel lastSelectedContrastPreset;
    protected float widthFromBestContrastor;
    protected float centerFromBestContrastor;
    protected int deactualizedMaxValue;
    protected int deactualizedMinValue;
    protected final String units;
    protected RescaleConverter rescale;
    protected float currentWindowCenter;
    protected float currentWindowWidth;
    protected boolean useGamma = true;
    protected float currentGamma = 1.0f;
    protected float currentLog = 1.0f;
    protected ContrastLockMode lockMode = ContrastLockMode.a;
    protected boolean keepUpperContrastInRange = true;
    protected boolean keepLowerContrastInRange = true;
    protected HUEDConverter edConverter = null;
    protected Modality modality;

    public ContrastState(BestContrastor bestContrastor, float f2, float f3, float f4, String string, Modality modality) {
        this.a(bestContrastor, f2, f3, f4);
        this.units = string;
        this.modality = modality;
    }

    public ContrastState(BestContrastor bestContrastor, RescaleConverter rescaleConverter, String string, Modality modality) {
        this.a(bestContrastor, rescaleConverter);
        this.units = string;
        this.modality = modality;
    }

    public void a(BestContrastor bestContrastor, float f2, float f3, float f4) {
        this.deactualizedMaxValue = bestContrastor.h();
        this.deactualizedMinValue = bestContrastor.i();
        this.widthFromBestContrastor = bestContrastor.b();
        this.centerFromBestContrastor = bestContrastor.c();
        RescaleConverter rescaleConverter = new RescaleConverter(f2, f3, f4);
        if (this.rescale != null && !this.rescale.equals(rescaleConverter)) {
            float f5 = this.h();
            float f6 = this.c();
            this.rescale = rescaleConverter;
            this.a(f5, f6);
        } else if (this.rescale == null) {
            this.rescale = rescaleConverter;
        }
    }

    public void a(BestContrastor bestContrastor, RescaleConverter rescaleConverter) {
        this.a(bestContrastor, rescaleConverter.slope, rescaleConverter.intercept, rescaleConverter.unitScale);
    }

    public void a(HUEDProfile hUEDProfile) {
        try {
            this.edConverter = new HUEDConverter(hUEDProfile);
        }
        catch (Exception exception) {
            this.edConverter = null;
            ay.d((Object)("HUEDConverter couldn't be set up:\n" + exception.getMessage()), this);
        }
    }

    public boolean a() {
        return this.edConverter != null;
    }

    public HUEDConverter b() {
        return this.edConverter;
    }

    @Override
    public float a(int n2) {
        return this.rescale.apply(n2);
    }

    @Override
    public float a(float f2) {
        return this.rescale.apply(f2);
    }

    @Override
    public int b(float f2) {
        return this.rescale.removeWithBounds(f2);
    }

    @Override
    public float c(float f2) {
        return this.rescale.removeRaw(f2);
    }

    @Override
    public float c() {
        return this.rescale.apply(this.l());
    }

    @Override
    public float d() {
        float f2 = this.l() - this.m() / 2.0f;
        if ((double)f2 < 0.001 && (double)f2 > -0.001) {
            f2 = 0.0f;
        }
        return f2;
    }

    @Override
    public float e() {
        return this.l() + this.m() / 2.0f;
    }

    public void d(float f2) {
        float f3 = this.d();
        float f4 = f2 - f3;
        float f5 = (f2 + f3) / 2.0f;
        this.c(f4, f5);
    }

    public void e(float f2) {
        float f3 = this.c(f2);
        float f4 = this.d();
        float f5 = f3 - f4;
        float f6 = (f3 + f4) / 2.0f;
        this.c(f5, f6);
    }

    @Override
    public float f() {
        float f2 = this.c() - this.h() / 2.0f;
        if (f2 < 0.0f && (double)f2 > -0.001) {
            f2 = 0.0f;
        }
        return f2;
    }

    @Override
    public float g() {
        return this.c() + this.h() / 2.0f;
    }

    @Override
    public float h() {
        return Math.abs(this.rescale.applyContrastWidth(this.m()));
    }

    @Override
    public float i() {
        return this.widthFromBestContrastor;
    }

    @Override
    public float j() {
        return this.centerFromBestContrastor;
    }

    public void b(int n2) {
        this.widthFromBestContrastor = n2;
    }

    public void c(int n2) {
        this.centerFromBestContrastor = n2;
    }

    @Override
    public float k() {
        float f2 = this.l() - this.m() / 2.0f;
        return (int)f2;
    }

    @Override
    public float l() {
        return this.currentWindowCenter;
    }

    @Override
    public float m() {
        return this.currentWindowWidth;
    }

    @Override
    public float n() {
        return this.currentGamma;
    }

    @Override
    public float o() {
        return this.currentLog;
    }

    @Override
    public int[] p() {
        if (this.R() == null) {
            this.a(c.a(this.A(), (int)this.k(), this.q(), this.L()));
        }
        return this.R();
    }

    public float q() {
        boolean bl2 = this.L();
        float f2 = this.n();
        if (!bl2) {
            f2 = this.o();
        }
        return f2;
    }

    public int[] r() {
        int n2 = c.a(this.A(), (int)this.k());
        int n3 = c.b(this.A(), (int)this.k());
        int n4 = n3 - n2 + 1;
        int[] nArray = new int[n4];
        try {
            System.arraycopy(this.p(), n2, nArray, 0, n4);
        }
        catch (Exception exception) {
            ay.d((Object)"LUT Error", (Throwable)exception, this);
        }
        return nArray;
    }

    public float s() {
        return 0.0f;
    }

    public float t() {
        return 0.0f;
    }

    @Override
    public String u() {
        boolean bl2 = this.U();
        if (bl2) {
            return this.lastSelectedContrastPreset.getName();
        }
        return "";
    }

    public String v() {
        boolean bl2 = this.U();
        if (bl2) {
            return this.lastSelectedContrastPreset.getUniqueId();
        }
        return "";
    }

    public String w() {
        return "\u03b3=" + String.format("%1$3.1f", Float.valueOf(this.n()));
    }

    public String x() {
        return "ln=" + String.format("%1$3.2f", Float.valueOf(this.o()));
    }

    @Override
    public float y() {
        return this.rescale.intercept;
    }

    @Override
    public float z() {
        return this.rescale.slope;
    }

    @Override
    public float A() {
        return 255.0f / this.m();
    }

    @Override
    public String B() {
        return this.units;
    }

    @Override
    public float C() {
        return this.rescale.unitScale;
    }

    public ImmutableList<PresetWindowLevel> D() {
        return this.a(true);
    }

    public ImmutableList<PresetWindowLevel> a(boolean bl2) {
        if (this.useCTPresets) {
            return ContrastPresetsPrefs.getCTPresets();
        }
        if (this.units != null && this.units.startsWith("SUV")) {
            return ContrastPresetsPrefs.getPETPresets();
        }
        if (this.modality == Modality.MR) {
            return ContrastPresetsPrefs.getMRPresets();
        }
        if (this.modality == Modality.US) {
            return ContrastPresetsPrefs.getUSPresets();
        }
        if (bl2) {
            return this.E();
        }
        return ImmutableList.of();
    }

    public ImmutableList<PresetWindowLevel> E() {
        return this.windowLevelPresetList;
    }

    public void a(ContrastState contrastState) {
        RescaleConverter rescaleConverter = contrastState.rescale;
        float f2 = this.h();
        float f3 = this.c();
        this.rescale = new RescaleConverter(rescaleConverter.slope, rescaleConverter.intercept, this.rescale.unitScale);
        this.a(f2, f3);
    }

    public void a(SeriesInfo seriesInfo, BestContrastor bestContrastor) {
        Object object;
        boolean bl2 = false;
        if (SeriesIdentifier.shouldUseDicomContrast(seriesInfo.modality)) {
            bl2 = true;
        } else if (SeriesIdentifier.isFunctionalModality(seriesInfo.modality) && !cn.h((String)(object = seriesInfo.w()))) {
            bl2 = (Boolean)ContrastPresetsPrefs.loadDcmContrast.b(object).getValue();
        }
        object = null;
        if ("CT".equalsIgnoreCase(seriesInfo.modality) && this.units.toUpperCase().startsWith("HU")) {
            this.d(true);
            object = PresetWindowLevel.getDefaultCTPreset();
            ImmutableList<PresetWindowLevel> immutableList = this.D();
            if (object == null && immutableList.size() > 0 && immutableList.get(0) != null) {
                object = (PresetWindowLevel)immutableList.get(0);
            }
            if (object != null && !this.a((PresetWindowLevel)object, seriesInfo.modality, bestContrastor)) {
                object = null;
            }
        } else if ("PT".equalsIgnoreCase(seriesInfo.modality) && this.units.toUpperCase().startsWith("SUV")) {
            object = PresetWindowLevel.getDefaultPETPreset();
        } else if ("MR".equalsIgnoreCase(seriesInfo.modality)) {
            object = PresetWindowLevel.getDefaultMRPreset();
        } else if ("US".equalsIgnoreCase(seriesInfo.modality)) {
            object = PresetWindowLevel.getDefaultUSPreset();
            bl2 = true;
        } else if (!SeriesIdentifier.isFunctionalModality(seriesInfo.modality)) {
            bl2 = true;
        }
        this.a((PresetWindowLevel)object, seriesInfo, bl2);
    }

    private void a(PresetWindowLevel presetWindowLevel, SeriesInfo seriesInfo, boolean bl2) {
        if (presetWindowLevel != null) {
            this.presetAsLoaded = presetWindowLevel;
            this.a(presetWindowLevel);
            return;
        }
        if (bl2) {
            this.a(seriesInfo);
        } else {
            this.O();
        }
    }

    private void a(SeriesInfo seriesInfo) {
        PresetWindowLevel[] presetWindowLevelArray = seriesInfo.presetsFromDICOM;
        if (presetWindowLevelArray != null) {
            PresetWindowLevel[] presetWindowLevelArray2 = new PresetWindowLevel[presetWindowLevelArray.length];
            for (int i2 = 0; i2 < presetWindowLevelArray.length; ++i2) {
                PresetWindowLevel presetWindowLevel = presetWindowLevelArray[i2];
                float f2 = seriesInfo.u().m().unitScale;
                presetWindowLevelArray2[i2] = new PresetWindowLevel(presetWindowLevel.name, presetWindowLevel.windowCenter * f2, presetWindowLevel.windowWidth * f2, presetWindowLevel.gamma);
            }
            this.d(false);
            this.a(presetWindowLevelArray2);
            PresetWindowLevel presetWindowLevel = presetWindowLevelArray2[0];
            this.a(presetWindowLevel);
            this.presetAsLoaded = presetWindowLevel;
        } else {
            this.O();
        }
    }

    public boolean F() {
        return this.keepUpperContrastInRange;
    }

    public boolean G() {
        return this.lockMode == ContrastLockMode.c;
    }

    public boolean H() {
        return this.lockMode == ContrastLockMode.b;
    }

    public boolean I() {
        return this.lockMode == ContrastLockMode.d;
    }

    public boolean J() {
        return this.useCTPresets;
    }

    public void K() {
        this.a((int[])null);
    }

    public void a(float f2, float f3) {
        this.c(this.rescale.removeContrastWidth(f2), this.rescale.removeRaw(f3));
    }

    public void a(float f2, float f3, float f4) {
        this.b(this.rescale.removeContrastWidth(f2), this.rescale.removeRaw(f3), f4);
    }

    public void a(float f2, float f3, float f4, float f5, boolean bl2) {
        this.b(this.rescale.removeContrastWidth(f2), this.rescale.removeRaw(f3), f4, f5, bl2);
    }

    public void b(float f2, float f3) {
        float f4 = f3 - f2;
        this.c(f4, f2 + f4 / 2.0f);
    }

    public synchronized void a(int[] nArray) {
        this.currentLookupTable = nArray;
    }

    private void d(float f2, float f3) {
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        this.currentWindowWidth = f2;
        this.currentWindowCenter = f3;
    }

    public void c(float f2, float f3) {
        this.d(f2, f3);
        this.K();
    }

    public void b(float f2, float f3, float f4) {
        this.d(f2, f3);
        this.f(f4);
        this.K();
    }

    public void b(float f2, float f3, float f4, float f5, boolean bl2) {
        this.d(f2, f3);
        this.f(f4);
        this.a(Float.valueOf(f5));
        this.useGamma = bl2;
        this.K();
    }

    public void a(ReadOnlyContrast readOnlyContrast) {
        this.a(readOnlyContrast.h(), readOnlyContrast.c(), readOnlyContrast.n(), readOnlyContrast.o(), readOnlyContrast.L());
    }

    public void b(ContrastState contrastState) {
        this.b(contrastState.currentWindowWidth, contrastState.currentWindowCenter, contrastState.currentGamma, contrastState.currentLog, contrastState.useGamma);
        this.d(contrastState);
    }

    public void c(ContrastState contrastState) {
        if (contrastState.rescale.equals(this.rescale)) {
            this.b(contrastState);
            return;
        }
        this.a(contrastState.h(), contrastState.c(), contrastState.n(), contrastState.o(), contrastState.L());
        this.d(contrastState);
    }

    public void d(ContrastState contrastState) {
        this.lockMode = contrastState.lockMode;
        this.keepUpperContrastInRange = contrastState.keepUpperContrastInRange;
        this.keepLowerContrastInRange = contrastState.keepLowerContrastInRange;
        this.edConverter = contrastState.b();
    }

    public void a(Float f2) {
        if (f2 == null) {
            f2 = Float.valueOf(1.0f);
            this.useGamma = true;
        } else {
            this.useGamma = false;
        }
        if (this.o() != f2.floatValue()) {
            this.currentLog = f2.floatValue();
            this.a((int[])null);
        }
    }

    public void f(float f2) {
        if (this.n() != f2) {
            this.currentGamma = f2;
            this.a((int[])null);
            this.useGamma = true;
        }
    }

    @Override
    public boolean L() {
        return this.useGamma;
    }

    public void b(boolean bl2) {
        this.keepUpperContrastInRange = bl2;
    }

    public ContrastLockMode M() {
        return this.lockMode;
    }

    public void a(ContrastLockMode contrastLockMode) {
        this.lockMode = contrastLockMode;
    }

    public void c(boolean bl2) {
        this.keepLowerContrastInRange = bl2;
    }

    public boolean N() {
        return this.keepLowerContrastInRange;
    }

    public void g(float f2) {
        this.rescale.unitScale = f2;
    }

    public void d(boolean bl2) {
        this.useCTPresets = bl2;
    }

    public void O() {
        this.b(this.widthFromBestContrastor, this.centerFromBestContrastor, 1.0f);
        this.K();
    }

    public void a(PresetWindowLevel presetWindowLevel) {
        if (presetWindowLevel == null || Float.isNaN(presetWindowLevel.windowCenter) || Float.isNaN(presetWindowLevel.windowWidth)) {
            return;
        }
        Tuple2f tuple2f = this.c(presetWindowLevel);
        float f2 = tuple2f.x;
        float f3 = tuple2f.y;
        float f4 = presetWindowLevel.gamma;
        if (Float.isNaN(f4)) {
            f4 = 1.0f;
        }
        this.b(f3, f2, f4);
        if (this.e() > (float)this.deactualizedMaxValue) {
            this.keepUpperContrastInRange = false;
        }
        if (this.d() < (float)this.deactualizedMinValue) {
            this.keepLowerContrastInRange = false;
        }
        this.b(presetWindowLevel);
        this.K();
    }

    private Tuple2f c(PresetWindowLevel presetWindowLevel) {
        float f2;
        float f3;
        float f4 = presetWindowLevel.windowCenter;
        float f5 = presetWindowLevel.windowWidth;
        if (presetWindowLevel.windowWidth != 0.0f) {
            if (presetWindowLevel.useDefaultLower || presetWindowLevel.useDefaultUpper) {
                f3 = f4 - f5 / 2.0f;
                f2 = f4 + f5 / 2.0f;
                if (presetWindowLevel.useDefaultLower) {
                    f3 = this.rescale.apply(this.centerFromBestContrastor - this.widthFromBestContrastor / 2.0f);
                }
                if (presetWindowLevel.useDefaultUpper) {
                    f2 = this.rescale.apply(this.centerFromBestContrastor + this.widthFromBestContrastor / 2.0f);
                }
                f4 = (f2 + f3) / 2.0f;
                f5 = f2 - f3;
            }
        } else {
            return new Point2f(this.centerFromBestContrastor, this.widthFromBestContrastor);
        }
        f3 = this.rescale.removeRaw(f4);
        f2 = Math.abs(this.rescale.removeContrastWidth(f5));
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        return new Point2f(f3, f2);
    }

    public void a(PresetWindowLevel[] presetWindowLevelArray) {
        this.windowLevelPresetList = ImmutableList.copyOf((Object[])presetWindowLevelArray);
    }

    public void P() {
        if (this.presetAsLoaded == null) {
            this.O();
        } else {
            this.a(this.presetAsLoaded);
        }
    }

    protected PresetWindowLevel Q() {
        return this.presetAsLoaded;
    }

    protected int[] R() {
        return this.currentLookupTable;
    }

    protected boolean S() {
        return true;
    }

    protected boolean T() {
        return false;
    }

    protected boolean U() {
        PresetWindowLevel presetWindowLevel = this.lastSelectedContrastPreset;
        if (presetWindowLevel == null) {
            return false;
        }
        Tuple2f tuple2f = this.c(presetWindowLevel);
        float f2 = tuple2f.x;
        float f3 = tuple2f.y;
        return MathUtils.a(this.l(), f2, 0.001f) && MathUtils.a(this.m(), f3, 0.001f);
    }

    protected boolean a(PresetWindowLevel presetWindowLevel, String string, BestContrastor bestContrastor) {
        boolean bl2;
        float f2;
        if (Float.isNaN(presetWindowLevel.windowCenter) || Float.isNaN(presetWindowLevel.windowWidth)) {
            return false;
        }
        float f3 = this.rescale.apply(this.j() - this.i() / 2.0f);
        float f4 = this.rescale.apply(this.j() + this.i() / 2.0f);
        float f5 = presetWindowLevel.windowCenter - presetWindowLevel.windowWidth / 2.0f;
        float f6 = presetWindowLevel.windowCenter + presetWindowLevel.windowWidth / 2.0f;
        float f7 = Math.max(f3, f5);
        if (f7 > (f2 = Math.min(f4, f6))) {
            return false;
        }
        float f8 = (f2 - f7) / (f6 - f5);
        float f9 = (f2 - f7) / (f4 - f3);
        float f10 = Modality.CT.isSameModality(string) ? 0.5f : 0.75f;
        boolean bl3 = bl2 = f8 > f10 && f9 > 0.07f;
        if (bl2 && Modality.CT.isSameModality(string) && bestContrastor != null) {
            float f11;
            long l2 = this.a(Math.round(this.rescale.removeRaw(f5)), Math.round(this.rescale.removeRaw(f6)), bestContrastor);
            int n2 = bestContrastor.h();
            long l3 = -1L;
            float f12 = f6;
            do {
                f11 = f12 + presetWindowLevel.windowWidth;
                long l4 = this.a(Math.round(this.rescale.removeRaw(f12)), Math.round(this.rescale.removeRaw(f11)), bestContrastor);
                if (l3 >= l4) continue;
                l3 = l4;
            } while (this.rescale.removeRaw(f12 = f11) < (float)n2);
            double d2 = (double)l3 / (double)l2;
            float f13 = this.rescale.apply(bestContrastor.i()) + presetWindowLevel.windowWidth;
            l3 = -1L;
            for (f12 = f5 - presetWindowLevel.windowWidth; f12 >= f13; f12 -= presetWindowLevel.windowWidth) {
                f11 = f12 + presetWindowLevel.windowWidth;
                long l5 = this.a(Math.round(this.rescale.removeRaw(f12)), Math.round(this.rescale.removeRaw(f11)), bestContrastor);
                if (l3 >= l5) continue;
                l3 = l5;
            }
            double d3 = (double)l3 / (double)l2;
            if (d2 > (double)0.3f || d3 > 11.0) {
                return false;
            }
        }
        return bl2;
    }

    private long a(int n2, int n3, BestContrastor bestContrastor) {
        int[] nArray = bestContrastor.f();
        int n4 = bestContrastor.g();
        long l2 = 0L;
        for (int i2 = n2; i2 <= n3; ++i2) {
            int n5 = i2 - n4;
            if (n5 < 0 || n5 >= nArray.length) continue;
            l2 += (long)nArray[n5];
        }
        return l2;
    }

    void b(PresetWindowLevel presetWindowLevel) {
        this.lastSelectedContrastPreset = presetWindowLevel;
    }

    @Override
    public ContrastState V() {
        try {
            ContrastState contrastState = (ContrastState)super.clone();
            if (this.windowLevelPresetList != null) {
                contrastState.windowLevelPresetList = this.windowLevelPresetList;
            }
            return contrastState;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)cloneNotSupportedException, this);
            return null;
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.centerFromBestContrastor);
        n3 = 31 * n3 + (this.lastSelectedContrastPreset == null ? 0 : this.lastSelectedContrastPreset.hashCode());
        n3 = 31 * n3 + Float.floatToIntBits(this.currentGamma);
        n3 = 31 * n3 + Float.floatToIntBits(this.currentLog);
        n3 = 31 * n3 + Arrays.hashCode(this.currentLookupTable);
        n3 = 31 * n3 + Float.floatToIntBits(this.currentWindowCenter);
        n3 = 31 * n3 + Float.floatToIntBits(this.currentWindowWidth);
        n3 = 31 * n3 + this.deactualizedMaxValue;
        n3 = 31 * n3 + this.deactualizedMinValue;
        n3 = 31 * n3 + (this.edConverter == null ? 0 : this.edConverter.hashCode());
        n3 = 31 * n3 + (this.keepUpperContrastInRange ? 1231 : 1237);
        n3 = 31 * n3 + (this.keepLowerContrastInRange ? 1231 : 1237);
        n3 = 31 * n3 + (this.lockMode == null ? 0 : this.lockMode.hashCode());
        n3 = 31 * n3 + (this.modality == null ? 0 : this.modality.hashCode());
        n3 = 31 * n3 + (this.presetAsLoaded == null ? 0 : this.presetAsLoaded.hashCode());
        n3 = 31 * n3 + (this.rescale == null ? 0 : this.rescale.hashCode());
        n3 = 31 * n3 + (this.units == null ? 0 : this.units.hashCode());
        n3 = 31 * n3 + (this.useCTPresets ? 1231 : 1237);
        n3 = 31 * n3 + (this.useGamma ? 1231 : 1237);
        n3 = 31 * n3 + Float.floatToIntBits(this.widthFromBestContrastor);
        n3 = 31 * n3 + (this.windowLevelPresetList == null ? 0 : this.windowLevelPresetList.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ContrastState contrastState = (ContrastState)object;
        if (Float.floatToIntBits(this.centerFromBestContrastor) != Float.floatToIntBits(contrastState.centerFromBestContrastor)) {
            return false;
        }
        if (this.lastSelectedContrastPreset == null ? contrastState.lastSelectedContrastPreset != null : !this.lastSelectedContrastPreset.equals(contrastState.lastSelectedContrastPreset)) {
            return false;
        }
        if (Float.floatToIntBits(this.currentGamma) != Float.floatToIntBits(contrastState.currentGamma)) {
            return false;
        }
        if (Float.floatToIntBits(this.currentLog) != Float.floatToIntBits(contrastState.currentLog)) {
            return false;
        }
        if (!Arrays.equals(this.currentLookupTable, contrastState.currentLookupTable)) {
            return false;
        }
        if (Float.floatToIntBits(this.currentWindowCenter) != Float.floatToIntBits(contrastState.currentWindowCenter)) {
            return false;
        }
        if (Float.floatToIntBits(this.currentWindowWidth) != Float.floatToIntBits(contrastState.currentWindowWidth)) {
            return false;
        }
        if (this.deactualizedMaxValue != contrastState.deactualizedMaxValue) {
            return false;
        }
        if (this.deactualizedMinValue != contrastState.deactualizedMinValue) {
            return false;
        }
        if (this.edConverter == null ? contrastState.edConverter != null : !this.edConverter.equals(contrastState.edConverter)) {
            return false;
        }
        if (this.keepUpperContrastInRange != contrastState.keepUpperContrastInRange) {
            return false;
        }
        if (this.keepLowerContrastInRange != contrastState.keepLowerContrastInRange) {
            return false;
        }
        if (this.lockMode != contrastState.lockMode) {
            return false;
        }
        if (this.modality != contrastState.modality) {
            return false;
        }
        if (this.presetAsLoaded == null ? contrastState.presetAsLoaded != null : !this.presetAsLoaded.equals(contrastState.presetAsLoaded)) {
            return false;
        }
        if (this.rescale == null ? contrastState.rescale != null : !this.rescale.equals(contrastState.rescale)) {
            return false;
        }
        if (this.units == null ? contrastState.units != null : !this.units.equals(contrastState.units)) {
            return false;
        }
        if (this.useCTPresets != contrastState.useCTPresets) {
            return false;
        }
        if (this.useGamma != contrastState.useGamma) {
            return false;
        }
        if (Float.floatToIntBits(this.widthFromBestContrastor) != Float.floatToIntBits(contrastState.widthFromBestContrastor)) {
            return false;
        }
        return !(this.windowLevelPresetList == null ? contrastState.windowLevelPresetList != null : !this.windowLevelPresetList.equals(contrastState.windowLevelPresetList));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{AL:");
        stringBuilder.append(this.f());
        stringBuilder.append(",AU:");
        stringBuilder.append(this.g());
        stringBuilder.append(",RL:");
        stringBuilder.append(this.d());
        stringBuilder.append(",RU:");
        stringBuilder.append(this.e());
        stringBuilder.append(",Scale:");
        stringBuilder.append(this.rescale);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        ReadHelper readHelper = new ReadHelper();
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        readHelper.a(getField, (Object)this);
        if (ReadHelper.b(getField, "oldDefaultWidth")) {
            this.widthFromBestContrastor = getField.get("oldDefaultWidth", 0);
        }
        if (ReadHelper.b(getField, "oldDefaultCenter")) {
            this.centerFromBestContrastor = getField.get("oldDefaultCenter", 0);
        }
        if (ReadHelper.b(getField, "defaultWidth")) {
            this.widthFromBestContrastor = getField.get("defaultWidth", 0);
        }
        if (ReadHelper.b(getField, "defaultCenter")) {
            this.centerFromBestContrastor = getField.get("defaultCenter", 0);
        }
        if (ReadHelper.b(getField, "windowLevelPresets") && (object = getField.get("windowLevelPresets", null)) instanceof PresetWindowLevel[]) {
            Object[] objectArray = (PresetWindowLevel[])object;
            this.windowLevelPresetList = ImmutableList.copyOf((Object[])objectArray);
        }
        if (ReadHelper.b(getField, "lockedUpperContrast") && getField.get("lockedUpperContrast", false)) {
            this.lockMode = ContrastLockMode.d;
        }
        if (ReadHelper.b(getField, "lockedCenter") && getField.get("lockedCenter", false)) {
            this.lockMode = ContrastLockMode.c;
        }
        if (ReadHelper.b(getField, "lockedLowerContrast") && getField.get("lockedLowerContrast", false)) {
            this.lockMode = ContrastLockMode.b;
        }
        if (!ReadHelper.b(getField, "keepLowerContrastInRange")) {
            this.keepLowerContrastInRange = true;
        }
        if (this.lockMode == null) {
            this.lockMode = ContrastLockMode.a;
        }
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.V();
    }

    public static enum ContrastLockMode {
        a,
        b,
        c,
        d;

    }
}

