/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.commands.keyboard.ax;
import com.mimvista.commands.keyboard.bc;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.linking.SimpleLinkManager;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.mui.GridPresentation;
import com.mimvista.mui.Session;
import com.mimvista.mui.bg;
import com.mimvista.mui.bm;
import com.mimvista.mui.presenters.ViewPort;
import com.mimvista.mui.presenters.protocol.a;
import com.mimvista.preferencesNew.ConfigPrefs;
import com.mimvista.state.ReadHelper;
import com.mimvista.state.SerializedSessionStateObject;
import com.mimvista.state.SessionStateObject;
import com.mimvista.util.ay;
import com.mimvista.util.u;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Timer;

public class DynamicSeriesManager
implements SessionStateObject<DynamicSeriesManager> {
    private static final ax nextCommand = new ax();
    private static final bc prevCommand = new bc();
    private static final int MAX_DELAY = 1000;
    private static final int MIN_DELAY = 33;
    private static final float CHANGE_FACTOR = 1.5f;
    public static final int MIN_FPS = 1;
    public static final int MAX_FPS = 30;
    private static float dynaRate = ConfigPrefs.dynaframerate.getValue().floatValue();
    private static Timer timer = new Timer(DynamicSeriesManager.getFrameDelay(), new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                bm.b().a(DynamicSeriesManager.class).timerTick();
            }
            catch (Throwable throwable) {
                ay.d((Object)"Exception in auto-playing dynamic frames.", throwable, DynamicSeriesManager.class);
            }
        }
    });
    private Set<ViewController> playingVCs = Collections.newSetFromMap(new WeakHashMap());
    private Set<Long> rootsAdvanced = Sets.newHashSet();
    private Set<Object> animationPreventors = Sets.newHashSet();
    private u animationRestorer = new u(300000L, new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set set = DynamicSeriesManager.this.animationPreventors;
            synchronized (set) {
                DynamicSeriesManager.this.animationPreventors.clear();
            }
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerTick() {
        if (!this.animationPreventors.isEmpty()) {
            return;
        }
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            this.rootsAdvanced.clear();
            for (ViewController viewController : this.playingVCs) {
                long l2;
                if (!viewController.bu() || this.rootsAdvanced.contains(l2 = (viewController = this.getRootLinkedVc(viewController)).aV())) continue;
                this.rootsAdvanced.add(l2);
                viewController = DynamicSeriesManager.getBestAutoPlayTarget(viewController);
                if (viewController.bg()) {
                    DynamicSeriesManager.advanceFrame(viewController, true);
                    continue;
                }
                nextCommand.execute(viewController);
            }
        }
    }

    public DynamicSeriesManager(Session session) {
    }

    private static ViewController getBestAutoPlayTarget(ViewController viewController) {
        List<ViewController> list = DynamicSeriesManager.getVcsToLinkFrameTo(viewController);
        list.add(viewController);
        Session session = viewController.g();
        if (session == null) {
            return viewController;
        }
        a a2 = session.ac();
        if (a2 == null) {
            return viewController;
        }
        List<ViewController> list2 = a2.e();
        ArrayList arrayList = Lists.newArrayList();
        for (ViewController viewController2 : list) {
            if (!list2.contains(viewController2)) continue;
            arrayList.add(viewController2);
        }
        for (ViewController viewController2 : arrayList) {
            for (ViewPort viewPort : viewController2.aZ()) {
                if (!viewPort.L().r()) continue;
                return viewController2;
            }
        }
        if (!arrayList.isEmpty()) {
            return (ViewController)arrayList.get(0);
        }
        return viewController;
    }

    private static void advanceFrame(ViewController viewController, boolean bl2) {
        int n2;
        boolean bl3 = GridPresentation.a(viewController);
        int n3 = viewController.cl();
        if (bl3) {
            n3 = viewController.cm();
        }
        if ((n2 = ax.a(viewController, n3, bl2 ? 1 : -1)) == -1) {
            int n4 = n2 = bl2 ? 0 : viewController.au().n() - 1;
        }
        if (bl3) {
            viewController.d(n2);
        } else {
            int n5 = viewController.cl();
            bg.a(viewController, n2 - n5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimationSuspender(Object object) {
        Set<Object> set = this.animationPreventors;
        synchronized (set) {
            this.animationPreventors.add(object);
        }
        this.animationRestorer.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnimationSuspender(Object object) {
        Set<Object> set = this.animationPreventors;
        synchronized (set) {
            this.animationPreventors.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void togglePlaying(ViewController viewController) {
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            if (this.isPlaying(viewController)) {
                this.stopPlaying(viewController, true);
            } else {
                this.startPlaying(viewController);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ViewController> getPlayingVcs() {
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            ArrayList<ViewController> arrayList = new ArrayList<ViewController>(this.playingVCs.size());
            Iterator<ViewController> iterator = this.playingVCs.iterator();
            while (iterator.hasNext()) {
                ViewController viewController = iterator.next();
                if (!viewController.bu()) {
                    iterator.remove();
                    continue;
                }
                arrayList.add(viewController);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlaying(ViewController viewController) {
        viewController = this.getRootLinkedVc(viewController);
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            this.playingVCs.add(viewController);
            DynamicSeriesManager.firePlayStarted(viewController);
            if (!timer.isRunning()) {
                timer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlaying(ViewController viewController, boolean bl2) {
        viewController = this.getRootLinkedVc(viewController);
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            for (ViewController viewController2 : this.getPlayingVcs()) {
                if (this.getRootLinkedVc(viewController2) != viewController) continue;
                this.playingVCs.remove(viewController2);
            }
            if (bl2) {
                DynamicSeriesManager.firePlayStopped(viewController);
            }
        }
    }

    private static void firePlayStarted(ViewController viewController) {
        if (viewController.bi()) {
            viewController.bh().cE().j();
        }
        for (ViewController viewController2 : DynamicSeriesManager.getVcsToLinkFrameTo(viewController)) {
            if (!viewController2.bi() || !viewController2.bl()) continue;
            viewController2.bh().cE().j();
        }
    }

    private static void firePlayStopped(ViewController viewController) {
        if (viewController.bi()) {
            viewController.bh().cE().i();
        }
        for (ViewController viewController2 : DynamicSeriesManager.getVcsToLinkFrameTo(viewController)) {
            if (!viewController2.bi() || !viewController2.bl()) continue;
            viewController2.bh().cE().i();
        }
    }

    private static List<ViewController> getVcsToLinkFrameTo(ViewController viewController) {
        List<ViewController> list = viewController.bO().a(ViewLink.ViewEvent.a);
        SimpleLinkManager simpleLinkManager = viewController.bO();
        for (ViewController viewController2 : Lists.newArrayList(list)) {
            ViewLink viewLink = simpleLinkManager.a(viewController2);
            if (viewLink.b(ViewLink.ViewEvent.a) && viewController2.au().n() == viewController.au().n()) continue;
            list.remove(viewController2);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            List<ViewController> list = this.getPlayingVcs();
            this.playingVCs.clear();
            for (ViewController viewController : list) {
                DynamicSeriesManager.firePlayStopped(viewController);
            }
        }
    }

    public ViewController getRootLinkedVc(ViewController viewController) {
        if (viewController.U() && viewController.bj().cE().n() < 2 && viewController.bj().n().n() > 1) {
            viewController = viewController.bj().W();
        }
        List<ViewController> list = DynamicSeriesManager.getVcsToLinkFrameTo(viewController);
        ViewController viewController2 = viewController;
        long l2 = viewController.aV();
        for (ViewController viewController3 : list) {
            long l3 = viewController3.aV();
            if (l3 >= l2) continue;
            l2 = l3;
            viewController2 = viewController3;
        }
        return viewController2;
    }

    public boolean isPlaying(ViewController viewController) {
        viewController = this.getRootLinkedVc(viewController);
        for (ViewController viewController2 : this.getPlayingVcs()) {
            if (this.getRootLinkedVc(viewController2) != viewController) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberPlaying() {
        Set<ViewController> set = this.playingVCs;
        synchronized (set) {
            return this.getPlayingVcs().size();
        }
    }

    public static void increaseRate() {
        int n2 = DynamicSeriesManager.getFrameDelay();
        n2 = Math.max((int)((float)n2 / 1.5f), 33);
        DynamicSeriesManager.setFrameDelay(n2);
    }

    public static void decreaseRate() {
        int n2 = DynamicSeriesManager.getFrameDelay();
        n2 = Math.min((int)((float)n2 * 1.5f), 1000);
        DynamicSeriesManager.setFrameDelay(n2);
    }

    public static int getFrameDelay() {
        return (int)(1000.0f / dynaRate);
    }

    private static void setFrameDelay(int n2) {
        if (n2 < 33) {
            n2 = 33;
        } else if (n2 > 1000) {
            n2 = 1000;
        }
        dynaRate = 1000.0f / (float)n2;
        timer.setDelay(n2);
    }

    public static void setFPS(int n2) {
        DynamicSeriesManager.setFrameDelay((int)(1000.0f / (float)n2));
    }

    public static float getFPS() {
        return dynaRate;
    }

    public static void nextFrame(ViewController viewController) {
        nextCommand.execute(viewController);
    }

    public static void prevFrame(ViewController viewController) {
        prevCommand.execute(viewController);
    }

    public static void bumpFrame(ViewController viewController) {
        nextCommand.a(viewController, 0);
    }

    @Override
    public SerializedSessionStateObject<DynamicSeriesManager> serialize() {
        return new SerializedDynamicSeriesManager(this);
    }

    public static class SerializedDynamicSeriesManager
    implements SerializedSessionStateObject<DynamicSeriesManager> {
        private static final long serialVersionUID = 1L;
        private final Set<Long> playingVCs = Sets.newHashSet();

        public SerializedDynamicSeriesManager(DynamicSeriesManager dynamicSeriesManager) {
            for (ViewController viewController : dynamicSeriesManager.getPlayingVcs()) {
                this.playingVCs.add(viewController.aV());
            }
        }

        public DynamicSeriesManager a(Session session) {
            DynamicSeriesManager dynamicSeriesManager = new DynamicSeriesManager(session);
            for (long l2 : this.playingVCs) {
                ViewController viewController = session.b(l2);
                if (viewController == null) continue;
                dynamicSeriesManager.playingVCs.add(viewController);
            }
            return dynamicSeriesManager;
        }

        @Override
        public void preventLambdas() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ReadHelper readHelper = new ReadHelper();
            readHelper.a(objectInputStream, (Object)this);
        }

        @Override
        public /* synthetic */ Object deserialize(Session session) {
            return this.a(session);
        }
    }
}

