/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DicomSeriesStatic;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.AtomicLoadUnit;
import com.mimvista.internals.SeriesSmasher;
import com.mimvista.util.ay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class GroupingSmasher
implements SeriesSmasher {
    @Override
    public List<Integer> getTagsNeeded() {
        return Collections.emptyList();
    }

    @Override
    public List<AtomicLoadUnit> smash(DcmSeries dcmSeries) {
        List<UIDContainer.SOPInstanceUID> list = dcmSeries.getAllSopInstanceUids();
        if (list == null) {
            ay.c((Object)("We don't have SOPInstanceUIDs for this series so we can't split it: " + dcmSeries), this);
            return null;
        }
        if (DicomSeriesStatic.isProjectionImage(dcmSeries)) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (UIDContainer.SOPInstanceUID sOPInstanceUID : list) {
            DcmSeries dcmSeries2 = dcmSeries.getSopInstance(sOPInstanceUID.uid);
            arrayListMultimap.put(this.a(dcmSeries2), (Object)dcmSeries2);
        }
        if (arrayListMultimap.keySet().size() == 1) {
            Collection collection = arrayListMultimap.get(Iterables.get((Iterable)arrayListMultimap.keySet(), (int)0));
            if (list.size() == collection.size()) {
                return Collections.singletonList(new AtomicLoadUnit(dcmSeries));
            }
        }
        for (UIDContainer.SOPInstanceUID sOPInstanceUID : arrayListMultimap.keySet()) {
            this.a(arrayList, arrayListMultimap.get((Object)sOPInstanceUID));
        }
        return arrayList;
    }

    protected abstract Object a(DcmSeries var1);

    protected void a(List<AtomicLoadUnit> list, Collection<DcmSeries> collection) {
        DcmSeries dcmSeries = (DcmSeries)Iterables.get(collection, (int)0);
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)collection.size());
        for (DcmSeries dcmSeries2 : collection) {
            arrayList.addAll(dcmSeries2.getAllSopInstanceUids());
        }
        AtomicLoadUnit atomicLoadUnit = new AtomicLoadUnit(dcmSeries);
        atomicLoadUnit.setSopsToLoad(arrayList);
        list.add(atomicLoadUnit);
    }
}

