/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.google.common.collect.Lists;
import com.mimvista.d;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.an;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.util.ay;
import com.mimvista.util.b;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.Iterator;
import javax.vecmath.Matrix4f;

public class PlanarImage
implements SimpleImageFrame,
Iterable<Short> {
    private static final long serialVersionUID = 6950182605345229027L;
    protected SeriesInfo seriesInfo = new SeriesInfo();
    protected Dimension dimension;
    protected float[] voxelSize;
    protected float[] dicomCenter;
    protected boolean dicomCenterFromImagePositionPatient = false;
    protected ByteBuffer rgbData;
    protected ShortBuffer shortData;
    protected transient BufferedImage a;
    protected float[] originOffset;
    protected float dataMin = Float.NaN;
    protected float dataMax = Float.NaN;
    protected boolean isMultiframe = false;
    protected int dynamicIdx = -1;
    protected an dynamicInfo;
    protected int multiframeIndex;

    public ByteBuffer g() {
        if (!this.D()) {
            throw new IllegalStateException("This is a grayscale 2D, don't ask for my datas as a bytebuffer.");
        }
        return this.rgbData;
    }

    public ShortBuffer al_() {
        if (this.D()) {
            throw new IllegalStateException("This is a color 2D, don't ask for my datas as a shortbuffer.");
        }
        return this.shortData;
    }

    public void a(ByteBuffer byteBuffer) {
        if (!this.D()) {
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            ShortBuffer shortBuffer2 = ShortBuffer.allocate(shortBuffer.capacity());
            shortBuffer2.put(shortBuffer);
            this.shortData = shortBuffer2;
        } else {
            this.rgbData = byteBuffer;
        }
    }

    @Override
    public int am_() {
        return this.dynamicIdx;
    }

    @Override
    public void a(an an2, int n2) {
        this.dynamicInfo = an2;
        this.dynamicIdx = n2;
    }

    @Override
    public an A() {
        return this.dynamicInfo;
    }

    public ImageCube.ImageCubeShort z() {
        ImageCube.ImageCubeShort imageCubeShort = ImageCube.ImageCubeShort.a(this.a(), 0);
        imageCubeShort.a(this.al_().array());
        return imageCubeShort;
    }

    public BufferedImage f() {
        BufferedImage bufferedImage = null;
        if (this.seriesInfo.samplesPerPix == 3 && this.seriesInfo.bitsAlloc == 8) {
            bufferedImage = new BufferedImage(this.dimension.width, this.dimension.height, 5);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            byte[] byArray = dataBufferByte.getData();
            this.rgbData.rewind();
            System.arraycopy(this.rgbData.array(), 0, byArray, 0, byArray.length);
        } else if (this.seriesInfo.samplesPerPix == 1) {
            this.shortData.rewind();
            bufferedImage = new BufferedImage(this.dimension.width, this.dimension.height, 11);
            WritableRaster writableRaster = bufferedImage.getRaster();
            DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
            int[] nArray = this.F();
            float f2 = nArray[1] - nArray[0];
            int n2 = 65535;
            short[] sArray = dataBufferUShort.getData();
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                int n3 = (int)((float)(this.shortData.get() - nArray[0]) / f2 * 65535.0f);
                sArray[i2] = (short)n3;
            }
        }
        return bufferedImage;
    }

    public boolean D() {
        return this.seriesInfo.samplesPerPix == 3;
    }

    public void E() {
        this.dataMin = Float.NaN;
        this.dataMax = Float.NaN;
    }

    public int[] F() {
        if (Float.isNaN(this.dataMin) || Float.isNaN(this.dataMax)) {
            this.dataMin = 32767.0f;
            this.dataMax = -32768.0f;
            this.shortData.rewind();
            for (int i2 = 0; i2 < this.shortData.capacity(); ++i2) {
                short s2 = this.shortData.get();
                if ((float)s2 > this.dataMax) {
                    this.dataMax = s2;
                }
                if (!((float)s2 < this.dataMin)) continue;
                this.dataMin = s2;
            }
            this.shortData.rewind();
        }
        return new int[]{(int)this.dataMin, (int)this.dataMax};
    }

    @Override
    public float[] G() {
        if (this.dicomCenter != null) {
            return (float[])this.dicomCenter.clone();
        }
        return null;
    }

    @Override
    public int[] a() {
        return new int[]{this.dimension.width, this.dimension.height, 1};
    }

    @Override
    public long H() {
        int[] nArray = this.a();
        return nArray[0] * nArray[1] * nArray[2];
    }

    @Override
    public SeriesInfo getUncopiedMutableInfo() {
        return this.seriesInfo;
    }

    @Override
    public SeriesInfo I() {
        SeriesInfo seriesInfo = this.getUncopiedMutableInfo();
        if (b.b()) {
            return seriesInfo.n();
        }
        return seriesInfo.m();
    }

    @Override
    public Iterator<Short> iterator() {
        if (this.D()) {
            return Lists.newArrayList((Object[])new Short[]{(short)0}).iterator();
        }
        final ShortBuffer shortBuffer = this.al_().duplicate();
        shortBuffer.rewind();
        return new Iterator<Short>(){

            public Short a() {
                return shortBuffer.get();
            }

            @Override
            public boolean hasNext() {
                return shortBuffer.hasRemaining();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public /* synthetic */ Object next() {
                return this.a();
            }
        };
    }

    @Override
    public float[] J() {
        if (this.originOffset == null) {
            this.originOffset = new float[3];
            for (int i2 = 0; i2 < this.originOffset.length; ++i2) {
                this.originOffset[i2] = (float)this.a()[i2] * this.voxelSize[i2] / 2.0f;
            }
        }
        return (float[])this.originOffset.clone();
    }

    @Override
    public float[] b() {
        if (this.voxelSize != null) {
            return (float[])this.voxelSize.clone();
        }
        return null;
    }

    @Override
    public void b(float[] fArray) {
        this.dicomCenter = fArray;
    }

    public void K() {
        this.dicomCenterFromImagePositionPatient = true;
    }

    public boolean L() {
        return this.dicomCenterFromImagePositionPatient;
    }

    @Override
    public void a(int[] nArray) {
        if (this.dimension == null) {
            this.dimension = new Dimension();
        }
        this.dimension.width = nArray[0];
        this.dimension.height = nArray[1];
    }

    @Override
    public void b(SeriesInfo seriesInfo) {
        this.seriesInfo = seriesInfo;
        this.a(seriesInfo);
    }

    protected void a(SeriesInfo seriesInfo) {
    }

    @Override
    public void a(float[] fArray) {
        if (this.voxelSize == null) {
            this.voxelSize = new float[]{1.0f, 1.0f, 1.0f};
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            this.voxelSize[i2] = fArray[i2];
        }
        this.originOffset = null;
        this.J();
    }

    public int a(int n2, int n3) {
        if (n2 >= 0 && n2 < this.dimension.width && n3 >= 0 && n3 < this.dimension.height) {
            return this.shortData.get(n3 * this.dimension.width + n2);
        }
        return 0;
    }

    public void a(boolean bl2) {
        this.isMultiframe = bl2;
    }

    public boolean s() {
        return this.isMultiframe;
    }

    @Override
    public void a(int n2) {
        this.multiframeIndex = n2;
    }

    @Override
    public int c() {
        return this.multiframeIndex;
    }

    @Override
    public Matrix4f M() {
        return MatrixMultiplier.b();
    }

    @Override
    public Matrix4f N() {
        return MatrixMultiplier.b();
    }

    public a O() {
        return new a(this);
    }

    public void a(BufferedImage bufferedImage) {
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        if (dataBuffer.getDataType() != 0) {
            ay.c((Object)"Special hardware image caching only supported for byte-based images.", this);
            return;
        }
        DataBufferByte dataBufferByte = (DataBufferByte)dataBuffer;
        this.a = bufferedImage;
        this.rgbData = ByteBuffer.wrap(dataBufferByte.getData());
    }

    public BufferedImage P() {
        return this.a;
    }

    protected void a(PlanarImage planarImage, boolean bl2) {
        int n2;
        this.seriesInfo = planarImage.seriesInfo == null ? null : planarImage.seriesInfo.m();
        Dimension dimension = this.dimension = planarImage.dimension == null ? null : (Dimension)planarImage.dimension.clone();
        if (planarImage.voxelSize != null) {
            this.voxelSize = new float[planarImage.voxelSize.length];
            for (n2 = 0; n2 < planarImage.voxelSize.length; ++n2) {
                this.voxelSize[n2] = planarImage.voxelSize[n2];
            }
        } else {
            this.voxelSize = null;
        }
        if (planarImage.dicomCenter != null) {
            this.dicomCenter = new float[planarImage.dicomCenter.length];
            for (n2 = 0; n2 < planarImage.dicomCenter.length; ++n2) {
                this.dicomCenter[n2] = planarImage.dicomCenter[n2];
            }
        } else {
            this.dicomCenter = null;
        }
        if (bl2) {
            if (planarImage.rgbData != null) {
                this.rgbData = planarImage.rgbData.duplicate();
            } else {
                this.shortData = planarImage.shortData.duplicate();
            }
        } else if (planarImage.rgbData != null) {
            this.rgbData = planarImage.rgbData;
        } else {
            this.shortData = planarImage.shortData;
        }
        if (planarImage.originOffset != null) {
            this.originOffset = new float[planarImage.originOffset.length];
            for (n2 = 0; n2 < planarImage.originOffset.length; ++n2) {
                this.originOffset[n2] = planarImage.originOffset[n2];
            }
        } else {
            this.originOffset = null;
        }
        this.isMultiframe = planarImage.isMultiframe;
        this.multiframeIndex = planarImage.multiframeIndex;
    }

    public PlanarImage i() {
        PlanarImage planarImage = new PlanarImage();
        planarImage.a(this, true);
        return planarImage;
    }

    @Override
    public int[] C() {
        return new int[]{1, 1, 1};
    }

    @Override
    public boolean Q() {
        return true;
    }

    public static class a {
        public final FrameNumber a;
        public final UIDContainer.SOPInstanceUID b;
        public final UIDContainer.SeriesUID c;

        private a(PlanarImage planarImage) {
            this.a = !planarImage.isMultiframe ? null : new FrameNumber(planarImage.multiframeIndex);
            this.b = new UIDContainer.SOPInstanceUID(planarImage.seriesInfo.sopInstanceUID);
            this.c = new UIDContainer.SeriesUID(planarImage.seriesInfo.ag());
        }

        public a(UIDContainer.SeriesUID seriesUID, UIDContainer.SOPInstanceUID sOPInstanceUID, @d FrameNumber frameNumber) {
            this.c = seriesUID;
            this.b = sOPInstanceUID;
            this.a = frameNumber;
        }

        public String toString() {
            return "~(SOP: " + this.b + " SUID: " + this.c + " Frm: " + this.a + ")~";
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
            n3 = 31 * n3 + (this.c == null ? 0 : this.c.hashCode());
            n3 = 31 * n3 + (this.b == null ? 0 : this.b.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            a a2 = (a)object;
            if (this.a == null ? a2.a != null : !this.a.equals(a2.a)) {
                return false;
            }
            if (this.c == null ? a2.c != null : !this.c.equals(a2.c)) {
                return false;
            }
            return !(this.b == null ? a2.b != null : !this.b.equals(a2.b));
        }
    }
}

