/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.mimvista.MimJsonSerializable;
import com.mimvista.numerics.MathUtils;
import com.mimvista.preferencesNew.ContrastPresetsPrefs;
import com.mimvista.preferencesNew.InterfacePrefs;
import com.mimvista.preferencesNew.e;
import com.mimvista.util.Messages;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@MimJsonSerializable
public class PresetWindowLevel
implements e,
Serializable {
    private static final long serialVersionUID = 1L;
    public final String name;
    public final String id;
    public final float windowCenter;
    public final float windowWidth;
    public final float gamma;
    public final boolean useDefaultLower;
    public final boolean useDefaultUpper;
    public final boolean nameIsMessagesKey;
    public static final PresetWindowLevel[] cspHistoricalDefaults = new PresetWindowLevel[]{new PresetWindowLevel("DEFAULT", 40.0f, 400.0f, 1.0f, true), new PresetWindowLevel("MEDIASTINUM", 39.0f, 500.0f, 1.0f, true), new PresetWindowLevel("BONE", 500.0f, 2500.0f, 1.0f, true), new PresetWindowLevel("LUNG", -362.0f, 1324.0f, 1.0f, true), new PresetWindowLevel("TISSUE", 40.0f, 400.0f, 1.0f, true), new PresetWindowLevel("LIVER", 40.0f, 160.0f, 1.0f, true), new PresetWindowLevel("BRAIN", 40.0f, 80.0f, 1.0f, true), new PresetWindowLevel("SEED", 450.0f, 200.0f, 1.0f, true)};
    public static String[] cspHistoricalNameKeys = new String[]{"DEFAULT", "MEDIASTINUM", "BONE", "LUNG", "TISSUE", "LIVER", "BRAIN", "SEED"};
    public static Map<String, String> PresetHistoricalNames = new HashMap<String, String>();

    public static PresetWindowLevel getSeedPreset() {
        return new PresetWindowLevel("SEED", 450.0f, 200.0f, 1.0f, true);
    }

    public static List<PresetWindowLevel> getDefaultCTPresets() {
        return ContrastPresetsPrefs.ctPresets.getDefaultValue();
    }

    public static List<PresetWindowLevel> getDefaultPETPresets() {
        return ContrastPresetsPrefs.petPresets.getDefaultValue();
    }

    public static List<PresetWindowLevel> getDefaultMRPresets() {
        return ContrastPresetsPrefs.mrPresets.getDefaultValue();
    }

    public static List<PresetWindowLevel> getDefaultUSPresets() {
        return ContrastPresetsPrefs.usPresets.getDefaultValue();
    }

    public static PresetWindowLevel getDefaultCTPreset() {
        return (PresetWindowLevel)ContrastPresetsPrefs.defaultCTpreset.getValue();
    }

    public static String getDefaultCTPresetName() {
        if (PresetWindowLevel.getDefaultCTPreset() != null) {
            return PresetWindowLevel.getDefaultCTPreset().getName();
        }
        return Messages.a("General", "DEFAULT");
    }

    public static PresetWindowLevel getDefaultPETPreset() {
        return (PresetWindowLevel)ContrastPresetsPrefs.defaultPTpreset.getValue();
    }

    public static String getDefaultPETPresetName() {
        if (PresetWindowLevel.getDefaultPETPreset() != null) {
            return PresetWindowLevel.getDefaultPETPreset().getName();
        }
        float f2 = InterfacePrefs.ptSuvUpperContrast.getValue().floatValue();
        if (Float.isNaN(f2) || MathUtils.a(f2, 0.0f, 0.001f)) {
            return Messages.a("mui").getProperty("CTPRESET_AUTONORMALIZE_NAME");
        }
        return Messages.a("General", "DEFAULT");
    }

    public static String getDefaultMRPresetName() {
        if (PresetWindowLevel.getDefaultMRPreset() != null) {
            return PresetWindowLevel.getDefaultMRPreset().getName();
        }
        return Messages.a("mui").getProperty("CTPRESET_AUTONORMALIZE_NAME");
    }

    public static PresetWindowLevel getDefaultMRPreset() {
        return (PresetWindowLevel)ContrastPresetsPrefs.defaultMRpreset.getValue();
    }

    public static PresetWindowLevel getDefaultUSPreset() {
        return (PresetWindowLevel)ContrastPresetsPrefs.defaultUSpreset.getValue();
    }

    public PresetWindowLevel(String string, float f2, float f3, float f4) {
        this(string, f2, f3, f4, false);
    }

    public PresetWindowLevel(String string, float f2, float f3, float f4, boolean bl2) {
        this(string, f2, f3, f4, bl2, null);
    }

    public PresetWindowLevel(String string, float f2, float f3, float f4, boolean bl2, String string2) {
        this(string, f2, f3, f4, bl2, string2, false, false);
    }

    @JsonCreator
    public PresetWindowLevel(@JsonProperty(value="name") String string, @JsonProperty(value="windowCenter") float f2, @JsonProperty(value="windowWidth") float f3, @JsonProperty(value="gamma") float f4, @JsonProperty(value="nameIsMessagesKey") boolean bl2, @JsonProperty(value="id") String string2, @JsonProperty(value="defaultLower") boolean bl3, @JsonProperty(value="defaultUpper") boolean bl4) {
        this.nameIsMessagesKey = bl2;
        this.name = string;
        this.windowCenter = f2;
        this.windowWidth = f3;
        this.gamma = f4;
        this.useDefaultLower = bl3;
        this.useDefaultUpper = bl4;
        this.id = !cn.h(string2) ? string2 : string;
    }

    public String getName() {
        if (this.nameIsMessagesKey) {
            return Messages.a("General", this.name.toUpperCase());
        }
        return this.name;
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    public String getNameDontTranslate() {
        return this.name;
    }

    public boolean isLicensed() {
        return true;
    }

    public boolean isAvailable() {
        return !Float.isNaN(this.windowCenter) && !Float.isNaN(this.windowWidth);
    }

    public String getIconName() {
        if ("CARDIAC".equalsIgnoreCase(this.name) || "MEDIASTINUM".equalsIgnoreCase(this.name)) {
            return "cardiac";
        }
        return "contrast_" + this.name.toLowerCase();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + Float.floatToIntBits(this.gamma);
        n3 = 31 * n3 + (this.name == null ? 0 : this.name.hashCode());
        n3 = 31 * n3 + Float.floatToIntBits(this.windowCenter);
        n3 = 31 * n3 + Float.floatToIntBits(this.windowWidth);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PresetWindowLevel presetWindowLevel = (PresetWindowLevel)object;
        if (Float.floatToIntBits(this.gamma) != Float.floatToIntBits(presetWindowLevel.gamma)) {
            return false;
        }
        if (this.name == null ? presetWindowLevel.name != null : !this.name.equals(presetWindowLevel.name)) {
            return false;
        }
        if (Float.floatToIntBits(this.windowCenter) != Float.floatToIntBits(presetWindowLevel.windowCenter)) {
            return false;
        }
        return Float.floatToIntBits(this.windowWidth) == Float.floatToIntBits(presetWindowLevel.windowWidth);
    }

    static {
        PresetHistoricalNames.put("T1", "PRESET_T1");
        PresetHistoricalNames.put("T2", "PRESET_T2");
        PresetHistoricalNames.put("FLAIR", "PRESET_FLAIR");
        PresetHistoricalNames.put("Default", "DEFAULT");
        PresetHistoricalNames.put("Mediastinum", "MEDIASTINUM");
        PresetHistoricalNames.put("Bone", "BONE");
        PresetHistoricalNames.put("Lung", "LUNG");
        PresetHistoricalNames.put("Soft Tissue", "TISSUE");
        PresetHistoricalNames.put("Brain", "BRAIN");
        PresetHistoricalNames.put("Liver", "LIVER");
        PresetHistoricalNames.put("Standard", "DEFAULT");
        PresetHistoricalNames.put("Mediastinum", "MEDIASTINUM");
        PresetHistoricalNames.put("Knogle", "BONE");
        PresetHistoricalNames.put("Lunge", "LUNG");
        PresetHistoricalNames.put("Bl\u00f8dt v\u00e6v", "TISSUE");
        PresetHistoricalNames.put("Hjerne", "BRAIN");
        PresetHistoricalNames.put("Lever", "LIVER");
        PresetHistoricalNames.put("Kerne", "SEED");
        PresetHistoricalNames.put("Standard", "DEFAULT");
        PresetHistoricalNames.put("Mediastinum", "MEDIASTINUM");
        PresetHistoricalNames.put("Knochen", "BONE");
        PresetHistoricalNames.put("Lunge", "LUNG");
        PresetHistoricalNames.put("Weichgewebe", "TISSUE");
        PresetHistoricalNames.put("Gehirn", "BRAIN");
        PresetHistoricalNames.put("Leber", "LIVER");
        PresetHistoricalNames.put("Seed", "SEED");
        PresetHistoricalNames.put("Predeterminado", "DEFAULT");
        PresetHistoricalNames.put("Mediastino", "MEDIASTINUM");
        PresetHistoricalNames.put("Hueso", "BONE");
        PresetHistoricalNames.put("Pulm\u00f3n", "LUNG");
        PresetHistoricalNames.put("Tejido blando", "TISSUE");
        PresetHistoricalNames.put("Cerebro", "BRAIN");
        PresetHistoricalNames.put("H\u00edgado", "LIVER");
        PresetHistoricalNames.put("Semilla", "SEED");
        PresetHistoricalNames.put("Par d\u00e9faut", "DEFAULT");
        PresetHistoricalNames.put("M\u00e9diastin", "MEDIASTINUM");
        PresetHistoricalNames.put("Os", "BONE");
        PresetHistoricalNames.put("Poumon", "LUNG");
        PresetHistoricalNames.put("Tissue mou", "TISSUE");
        PresetHistoricalNames.put("Cerveau", "BRAIN");
        PresetHistoricalNames.put("Foie", "LIVER");
        PresetHistoricalNames.put("Grain\u00a0", "SEED");
        PresetHistoricalNames.put("Valore predefinito", "DEFAULT");
        PresetHistoricalNames.put("Mediastino", "MEDIASTINUM");
        PresetHistoricalNames.put("Osso", "BONE");
        PresetHistoricalNames.put("Polmone", "LUNG");
        PresetHistoricalNames.put("Tessuto molle", "TISSUE");
        PresetHistoricalNames.put("Cervello", "BRAIN");
        PresetHistoricalNames.put("Fegato", "LIVER");
        PresetHistoricalNames.put("Sorgente", "SEED");
        PresetHistoricalNames.put("\u30c7\u30d5\u30a9\u30eb\u30c8", "DEFAULT");
        PresetHistoricalNames.put("\u7e26\u9694", "MEDIASTINUM");
        PresetHistoricalNames.put("\u9aa8", "BONE");
        PresetHistoricalNames.put("\u80ba", "LUNG");
        PresetHistoricalNames.put("\u8edf\u7d44\u7e54", "TISSUE");
        PresetHistoricalNames.put("\u8133", "BRAIN");
        PresetHistoricalNames.put("\u809d\u81d3", "LIVER");
        PresetHistoricalNames.put("\u30b7\u30fc\u30c9", "SEED");
        PresetHistoricalNames.put("Standaard", "DEFAULT");
        PresetHistoricalNames.put("Mediastinum", "MEDIASTINUM");
        PresetHistoricalNames.put("Bot", "BONE");
        PresetHistoricalNames.put("Long", "LUNG");
        PresetHistoricalNames.put("Zacht weefsel", "TISSUE");
        PresetHistoricalNames.put("Hersenen", "BRAIN");
        PresetHistoricalNames.put("Lever", "LIVER");
        PresetHistoricalNames.put("Zaad", "SEED");
        PresetHistoricalNames.put("Standard", "DEFAULT");
        PresetHistoricalNames.put("Mediastinum", "MEDIASTINUM");
        PresetHistoricalNames.put("Ben", "BONE");
        PresetHistoricalNames.put("Lunga", "LUNG");
        PresetHistoricalNames.put("Mjuk v\u00e4vnad", "TISSUE");
        PresetHistoricalNames.put("Hj\u00e4rna", "BRAIN");
        PresetHistoricalNames.put("Lever", "LIVER");
        PresetHistoricalNames.put("K\u00e4rna", "SEED");
        PresetHistoricalNames.put("Standard", "DEFAULT");
        PresetHistoricalNames.put("Mellomhinne", "MEDIASTINUM");
        PresetHistoricalNames.put("Ben", "BONE");
        PresetHistoricalNames.put("Lunge", "LUNG");
        PresetHistoricalNames.put("Mykt vev", "TISSUE");
        PresetHistoricalNames.put("Hjerne", "BRAIN");
        PresetHistoricalNames.put("Lever", "LIVER");
        PresetHistoricalNames.put("Seed", "SEED");
        PresetHistoricalNames.put("\u9810\u8a2d\u8a2d\u5b9a", "DEFAULT");
        PresetHistoricalNames.put("\u7e31\u9694", "MEDIASTINUM");
        PresetHistoricalNames.put("\u9aa8\u9abc", "BONE");
        PresetHistoricalNames.put("\u80ba", "LUNG");
        PresetHistoricalNames.put("\u8edf\u7d44\u7e54", "TISSUE");
        PresetHistoricalNames.put("\u5927\u8166", "BRAIN");
        PresetHistoricalNames.put("\u809d\u81df", "LIVER");
        PresetHistoricalNames.put("\u6838\u7a2e", "SEED");
        PresetHistoricalNames.put("\u9ed8\u8ba4\u8bbe\u7f6e", "DEFAULT");
        PresetHistoricalNames.put("\u7eb5\u8188\u819c", "MEDIASTINUM");
        PresetHistoricalNames.put("\u9aa8\u9abc", "BONE");
        PresetHistoricalNames.put("\u80ba", "LUNG");
        PresetHistoricalNames.put("\u8f6f\u7ec4\u7ec7", "TISSUE");
        PresetHistoricalNames.put("\u5927\u8111", "BRAIN");
        PresetHistoricalNames.put("\u809d\u810f", "LIVER");
        PresetHistoricalNames.put("\u7c92\u5b50", "SEED");
    }
}

