/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.util.DicomRegUtils;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.mui.PresentationType;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.IECFixedPoint3f;
import com.mimvista.numerics.IECFixedVector;
import com.mimvista.numerics.IOP;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.numerics.Vector3fPro;
import java.util.Arrays;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.SingularMatrixException;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.DicomObject;

public class SimpleOrientationHelper {
    public static final float b = 15.0f;
    public static final double c = Math.toRadians(1.0);
    public static final float d = 0.005f;

    public static Vector3f a(Vector3f vector3f, Vector3f vector3f2, float f2) {
        Matrix3f matrix3f = new Matrix3f();
        matrix3f.setIdentity();
        Matrix3f matrix3f2 = new Matrix3f();
        matrix3f2.m00 = 0.0f;
        matrix3f2.m01 = vector3f.z;
        matrix3f2.m02 = -vector3f.y;
        matrix3f2.m10 = -vector3f.z;
        matrix3f2.m11 = 0.0f;
        matrix3f2.m12 = vector3f.x;
        matrix3f2.m20 = vector3f.y;
        matrix3f2.m21 = -vector3f.x;
        matrix3f2.m22 = 0.0f;
        double d2 = Math.toRadians(f2);
        float f3 = vector3f.length();
        Matrix3f matrix3f3 = new Matrix3f();
        matrix3f3.set(matrix3f2);
        matrix3f3.mul((float)Math.sin(d2) / f3);
        Matrix3f matrix3f4 = new Matrix3f();
        matrix3f4.set(matrix3f2);
        matrix3f4.mul(matrix3f2);
        matrix3f4.mul((float)((1.0 - Math.cos(d2)) / (double)(f3 * f3)));
        matrix3f.add(matrix3f3);
        matrix3f.add(matrix3f4);
        Vector3f vector3f3 = new Vector3f(vector3f2);
        matrix3f.transform((Tuple3f)vector3f3);
        return vector3f3;
    }

    public static float[] a(float[] fArray, Float f2) {
        if (fArray == null || fArray.length != 6) {
            return null;
        }
        Vector3f vector3f = new Vector3f(fArray[0], fArray[1], fArray[2]);
        Vector3f vector3f2 = new Vector3f(fArray[3], fArray[4], fArray[5]);
        if (f2 != null) {
            vector3f2 = SimpleOrientationHelper.a(vector3f, vector3f2, f2.floatValue());
        }
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f, vector3f2);
        float f3 = vector3f3.length();
        if (f3 != 0.0f) {
            vector3f3.scale(1.0f / f3);
        }
        return new float[]{vector3f3.x, vector3f3.y, vector3f3.z};
    }

    public static Matrix4f a(float[] fArray, Float f2, Float f3) {
        return SimpleOrientationHelper.a(fArray, f2, SimpleOrientationHelper.a(), f3);
    }

    public static Matrix4f a(float[] fArray, Float f2, float[] fArray2, Float f3) {
        float[] fArray3 = SimpleOrientationHelper.a(fArray, f2);
        if (fArray3 == null) {
            return null;
        }
        float[][] fArrayArray = new float[][]{{fArray[0], fArray[3], -fArray3[0], 0.0f}, {fArray[1], fArray[4], -fArray3[1], 0.0f}, {-fArray[2], -fArray[5], fArray3[2], 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        float[] fArray4 = SimpleOrientationHelper.a(fArray2, f3);
        float[][] fArrayArray2 = new float[][]{{fArray2[0], fArray2[3], -fArray4[0], 0.0f}, {fArray2[1], fArray2[4], -fArray4[1], 0.0f}, {-fArray2[2], -fArray2[5], fArray4[2], 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}};
        Matrix4f matrix4f = MatrixMultiplier.a(fArrayArray);
        try {
            matrix4f.invert();
        }
        catch (SingularMatrixException singularMatrixException) {
            return null;
        }
        Matrix4f matrix4f2 = MatrixMultiplier.a(fArrayArray2);
        matrix4f.mul(matrix4f2);
        return matrix4f;
    }

    public static Matrix4f a(float[] fArray, float[] fArray2) {
        Matrix4f matrix4f = SimpleOrientationHelper.g(fArray);
        Matrix4f matrix4f2 = SimpleOrientationHelper.g(fArray2);
        matrix4f2.invert();
        Matrix4f matrix4f3 = new Matrix4f();
        matrix4f3.mul(matrix4f, matrix4f2);
        return matrix4f3;
    }

    private static Matrix4f g(float[] fArray) {
        float[] fArray2 = SimpleOrientationHelper.a(fArray, null);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        matrix4f.m00 = fArray[0];
        matrix4f.m10 = fArray[3];
        matrix4f.m20 = fArray2[0];
        matrix4f.m01 = fArray[1];
        matrix4f.m11 = fArray[4];
        matrix4f.m21 = fArray2[1];
        matrix4f.m02 = fArray[2];
        matrix4f.m12 = fArray[5];
        matrix4f.m22 = fArray2[2];
        return matrix4f;
    }

    public static float[] b(float[] fArray, Float f2) {
        if (fArray != null && f2 != null) {
            Vector3f vector3f = new Vector3f(fArray[0], fArray[1], fArray[2]);
            Vector3f vector3f2 = new Vector3f(fArray[3], fArray[4], fArray[5]);
            vector3f2 = SimpleOrientationHelper.a(vector3f, vector3f2, f2.floatValue());
            fArray = new float[]{vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z};
        }
        return fArray;
    }

    protected static int a(float[] fArray) {
        int n2 = -1;
        if (fArray == null) {
            return -1;
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            if (Math.abs(fArray[i2]) != 1.0f) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private static boolean a(Vector3fPro vector3fPro) {
        return SimpleOrientationHelper.a(vector3fPro, 15.0f);
    }

    private static boolean a(Vector3fPro vector3fPro, float f2) {
        Vector3fPro vector3fPro2 = new Vector3fPro(vector3fPro);
        for (int i2 = 0; i2 < 3; ++i2) {
            vector3fPro2.a(i2, Math.round(vector3fPro2.a(i2)));
        }
        double d2 = Math.toDegrees(Math.acos(vector3fPro2.dot(vector3fPro)));
        if (d2 < (double)f2) {
            vector3fPro.set((Tuple3f)vector3fPro2);
            return true;
        }
        return false;
    }

    public static float[] a(float[] fArray, boolean bl2) {
        IOP iOP = SimpleOrientationHelper.a(IOP.a(fArray), bl2);
        return IOP.b(iOP);
    }

    public static IOP a(IOP iOP, boolean bl2) {
        if (iOP == null) {
            return null;
        }
        Vector3fPro vector3fPro = iOP.a();
        Vector3fPro vector3fPro2 = iOP.b();
        boolean bl3 = true;
        bl3 &= SimpleOrientationHelper.a(vector3fPro);
        if ((bl3 &= SimpleOrientationHelper.a(vector3fPro2)) || !bl2) {
            return new IOP(vector3fPro, vector3fPro2);
        }
        return iOP;
    }

    public static float[] b(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        float[] fArray2 = new float[fArray.length];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray2[i2] = Math.round(fArray[i2]);
        }
        if ((double)MathUtils.l(fArray, fArray2) < 0.06) {
            return fArray2;
        }
        return fArray;
    }

    public static float[] c(float[] fArray) {
        float f2;
        if (fArray == null || fArray.length != 6) {
            return null;
        }
        Vector3f vector3f = new Vector3f(fArray[0], fArray[1], fArray[2]);
        Vector3f vector3f2 = new Vector3f(fArray[3], fArray[4], fArray[5]);
        float f3 = vector3f.length();
        if (f3 != 0.0f && f3 != 1.0f) {
            vector3f.scale(1.0f / f3);
        }
        if ((f2 = vector3f2.length()) != 0.0f && f2 != 1.0f) {
            vector3f2.scale(1.0f / f2);
        }
        return new float[]{vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z};
    }

    public static boolean a(float[] fArray, float[] fArray2, float f2) {
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (!(Math.abs(fArray[i2] - fArray2[i2]) > f2)) continue;
            return false;
        }
        return true;
    }

    public static boolean b(float[] fArray, float[] fArray2) {
        return SimpleOrientationHelper.a(fArray, fArray2, 0.005f);
    }

    public static boolean b(float[] fArray, float[] fArray2, float f2) {
        IOP iOP = IOP.a(fArray);
        IOP iOP2 = IOP.a(fArray2);
        return SimpleOrientationHelper.a(iOP, iOP2, f2);
    }

    public static boolean a(IOP iOP, IOP iOP2, float f2) {
        double d2 = Math.toDegrees(iOP.c().angle(iOP2.c()));
        return d2 <= (double)f2;
    }

    public static PresentationType c(float[] fArray, Float f2) {
        fArray = SimpleOrientationHelper.b(fArray, f2);
        float[] fArray2 = SimpleOrientationHelper.a(fArray, true);
        float[] fArray3 = SimpleOrientationHelper.b(SimpleOrientationHelper.a(fArray2, null));
        return SimpleOrientationHelper.a(SimpleOrientationHelper.a(fArray3));
    }

    protected static PresentationType a(int n2) {
        if (n2 == 2) {
            return PresentationType.a;
        }
        if (n2 == 1) {
            return PresentationType.c;
        }
        if (n2 == 0) {
            return PresentationType.b;
        }
        return null;
    }

    public static float[] a(float[] fArray, Float f2, Matrix4f matrix4f) {
        Matrix4f matrix4f2 = SimpleOrientationHelper.b(fArray, f2, matrix4f);
        if (matrix4f2 == null) {
            return null;
        }
        float[] fArray2 = new float[]{matrix4f2.m00, matrix4f2.m10, matrix4f2.m20 == 0.0f ? 0.0f : -matrix4f2.m20, matrix4f2.m01, matrix4f2.m11, matrix4f2.m21 == 0.0f ? 0.0f : -matrix4f2.m21};
        return SimpleOrientationHelper.c(fArray2);
    }

    public static Matrix4f b(float[] fArray, Float f2, Matrix4f matrix4f) {
        if (fArray == null || fArray.length != 6) {
            return null;
        }
        if (matrix4f == null) {
            return null;
        }
        float[] fArray2 = SimpleOrientationHelper.a(fArray, f2);
        Matrix4f matrix4f2 = MatrixMultiplier.a(new float[][]{{fArray[0], fArray[3], -fArray2[0], 0.0f}, {fArray[1], fArray[4], -fArray2[1], 0.0f}, {-fArray[2], -fArray[5], fArray2[2], 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}});
        Matrix4f matrix4f3 = (Matrix4f)matrix4f2.clone();
        matrix4f3.mul(matrix4f);
        return matrix4f3;
    }

    public static PresentationType d(float[] fArray, Float f2) {
        return SimpleOrientationHelper.a(fArray, f2, true);
    }

    public static PresentationType a(float[] fArray, Float f2, boolean bl2) {
        if (fArray == null) {
            return null;
        }
        Vector3f vector3f = new Vector3f(SimpleOrientationHelper.a(fArray, f2));
        Vector3f vector3f2 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f3 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 1.0f, 0.0f);
        float[] fArray2 = new float[]{vector3f.dot(vector3f3), vector3f.dot(vector3f4), vector3f.dot(vector3f2)};
        int n2 = -1;
        float f3 = 0.0f;
        for (int i2 = 0; i2 < 3; ++i2) {
            float f4 = Math.abs(fArray2[i2]);
            if (!(f4 >= f3)) continue;
            f3 = f4;
            n2 = i2;
        }
        if (bl2 && Math.abs((double)f3 - 1.0 / Math.sqrt(2.0)) < 0.001) {
            return null;
        }
        return SimpleOrientationHelper.a(n2);
    }

    public static float[] a(float[] fArray, PresentationType presentationType) {
        return SimpleOrientationHelper.a(fArray, null, presentationType);
    }

    public static float[] a(float[] fArray, Float f2, PresentationType presentationType) {
        if (fArray == null) {
            return null;
        }
        if (presentationType != PresentationType.a) {
            float[] fArray2 = SimpleOrientationHelper.a(fArray, f2);
            if (presentationType == PresentationType.c || presentationType == PresentationType.q) {
                return new float[]{fArray[0], fArray[1], fArray[2], -fArray2[0], -fArray2[1], -fArray2[2]};
            }
            if (presentationType == PresentationType.b || presentationType == PresentationType.r) {
                return new float[]{fArray[3], fArray[4], fArray[5], -fArray2[0], -fArray2[1], -fArray2[2]};
            }
        }
        return (float[])fArray.clone();
    }

    public static boolean e(float[] fArray, Float f2) {
        int n2;
        float[] fArray2 = SimpleOrientationHelper.a(SimpleOrientationHelper.b(fArray, f2), true);
        float[] fArray3 = SimpleOrientationHelper.b(SimpleOrientationHelper.a(fArray2, null));
        if (fArray3 == null) {
            return false;
        }
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < 3; ++n2) {
            if (Math.abs(fArray2[n2]) != 1.0f) continue;
            n3 = n2;
            break;
        }
        for (n2 = 3; n2 < 6; ++n2) {
            if (Math.abs(fArray2[n2]) != 1.0f) continue;
            n4 = n2;
            break;
        }
        if ((n2 = SimpleOrientationHelper.a(fArray3)) == -1) {
            return false;
        }
        return n2 == 2 ? n3 == 1 && n4 == 3 : (n2 == 0 ? n3 == 2 && n4 == 4 : n2 == 1 && n3 == 2 && n4 == 3);
    }

    public static IOP a(DicomObject dicomObject) {
        return SimpleOrientationHelper.a(new JsonDicomSeries(dicomObject));
    }

    public static IOP a(DicomSeries dicomSeries) {
        Float f2;
        Double d2 = (Double)dicomSeries.getTagValue(1578256);
        Float f3 = d2 == null || Double.isNaN(d2) ? null : Float.valueOf(d2.floatValue());
        Double d3 = (Double)dicomSeries.getTagValue(0x181511);
        Float f4 = f2 = d3 == null || Double.isNaN(d3) ? null : Float.valueOf(d3.floatValue());
        if (dicomSeries.exists(1578272) || dicomSeries.exists(1578273)) {
            return null;
        }
        return SimpleOrientationHelper.a(f3, f2);
    }

    public static IOP a(Float f2, Float f3) {
        if (f2 == null && f3 == null) {
            return null;
        }
        if (f2 == null) {
            f2 = Float.valueOf(0.0f);
        }
        if (f3 == null) {
            f3 = Float.valueOf(0.0f);
        }
        return SimpleOrientationHelper.a(f2.floatValue(), f3.floatValue());
    }

    public static IOP a(float f2, float f3) {
        Vector3fPro vector3fPro = new Vector3fPro(1.0f, 0.0f, 0.0f);
        Vector3fPro vector3fPro2 = new Vector3fPro(0.0f, 0.0f, -1.0f);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        Matrix4f matrix4f2 = new Matrix4f(matrix4f);
        matrix4f.rotZ((float)((double)(f2 / 180.0f) * Math.PI));
        matrix4f2.rotX((float)((double)(f3 / 180.0f) * Math.PI));
        matrix4f.transform((Vector3f)vector3fPro);
        matrix4f.transform((Vector3f)vector3fPro2);
        matrix4f2.transform((Vector3f)vector3fPro);
        matrix4f2.transform((Vector3f)vector3fPro2);
        return new IOP(vector3fPro, vector3fPro2);
    }

    public static boolean f(float[] fArray, Float f2) {
        boolean bl2 = true;
        float[] fArray2 = SimpleOrientationHelper.a(fArray, f2);
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            if (!((double)Math.abs(fArray2[i2]) > 1.0E-4) || !((double)Math.abs(Math.abs(fArray2[i2]) - 1.0f) > 1.0E-4)) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    public static float[] a() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    }

    public static boolean d(float[] fArray) {
        return MathUtils.b((double)(fArray[0] * fArray[0]), 1.0, 0.001) && MathUtils.b((double)(fArray[4] * fArray[4]), 1.0, 0.001);
    }

    public static boolean e(float[] fArray) {
        if (fArray == null) {
            return false;
        }
        return MathUtils.b((double)fArray[0], -1.0, 0.001);
    }

    public static boolean f(float[] fArray) {
        if (fArray == null) {
            return false;
        }
        return MathUtils.b((double)fArray[4], -1.0, 0.001);
    }

    public static Matrix4f b() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m00 = 1.0f;
        matrix4f.m21 = -1.0f;
        matrix4f.m12 = 1.0f;
        matrix4f.m33 = 1.0f;
        return matrix4f;
    }

    public static TypedMatrix<IECFixedPoint3f, IECFixedPoint3f.IECPatientPoint3f> a(PatientPosition patientPosition) {
        float[] fArray = IECFixedPoint3f.a.get((Object)patientPosition);
        float[] fArray2 = IECFixedPoint3f.a.get((Object)PatientPosition.a);
        Matrix4f matrix4f = SimpleOrientationHelper.a(fArray, fArray2);
        return new TypedMatrix<IECFixedPoint3f, IECFixedPoint3f.IECPatientPoint3f>(matrix4f);
    }

    public static TypedMatrix<IECFixedPoint3f.IECPatientPoint3f, DicomPoint3f> c() {
        return new TypedMatrix<IECFixedPoint3f.IECPatientPoint3f, DicomPoint3f>(SimpleOrientationHelper.b());
    }

    public static TypedMatrix<DicomPoint3f, IECFixedPoint3f.IECPatientPoint3f> d() {
        return new TypedMatrix<DicomPoint3f, IECFixedPoint3f.IECPatientPoint3f>(SimpleOrientationHelper.e());
    }

    public static TypedMatrix<MetricPoint3f, MetricPoint3f> a(Point3f.PointVolumeInfo pointVolumeInfo, PatientPosition patientPosition, TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        TypedMatrix<DicomPoint3f, DicomPoint3f> typedMatrix2 = SimpleOrientationHelper.a(typedMatrix, patientPosition);
        TypedMatrix<MetricPoint3f, MetricPoint3f> typedMatrix3 = SimpleOrientationHelper.a(pointVolumeInfo, pointVolumeInfo, typedMatrix2);
        return typedMatrix3;
    }

    public static TypedMatrix<DicomPoint3f, DicomPoint3f> a(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix, PatientPosition patientPosition) {
        TypedMatrix<IECFixedPoint3f, IECFixedPoint3f.IECPatientPoint3f> typedMatrix2 = SimpleOrientationHelper.a(patientPosition);
        TypedMatrix<IECFixedPoint3f.IECPatientPoint3f, DicomPoint3f> typedMatrix3 = SimpleOrientationHelper.c();
        TypedMatrix<IECFixedPoint3f, DicomPoint3f> typedMatrix4 = typedMatrix3.a(typedMatrix2);
        TypedMatrix<DicomPoint3f, IECFixedPoint3f> typedMatrix5 = typedMatrix4.c();
        return typedMatrix4.a(typedMatrix.a(typedMatrix5));
    }

    public static TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> b(TypedMatrix<DicomPoint3f, DicomPoint3f> typedMatrix, PatientPosition patientPosition) {
        TypedMatrix<IECFixedPoint3f, IECFixedPoint3f.IECPatientPoint3f> typedMatrix2 = SimpleOrientationHelper.a(patientPosition);
        TypedMatrix<IECFixedPoint3f.IECPatientPoint3f, DicomPoint3f> typedMatrix3 = SimpleOrientationHelper.c();
        TypedMatrix<IECFixedPoint3f, DicomPoint3f> typedMatrix4 = typedMatrix3.a(typedMatrix2);
        TypedMatrix<DicomPoint3f, IECFixedPoint3f> typedMatrix5 = typedMatrix4.c();
        return typedMatrix5.a(typedMatrix).a(typedMatrix4);
    }

    public static TypedMatrix<MetricPoint3f, MetricPoint3f> a(SimpleImageFrame simpleImageFrame, SimpleImageFrame simpleImageFrame2, TypedMatrix<DicomPoint3f, DicomPoint3f> typedMatrix) {
        TypedMatrix<DicomPoint3f, MetricPoint3f> typedMatrix2 = DicomRegUtils.generate_DICOM_M_METRIC(simpleImageFrame2);
        TypedMatrix<MetricPoint3f, DicomPoint3f> typedMatrix3 = DicomRegUtils.generate_METRIC_M_DICOM(simpleImageFrame);
        TypedMatrix<MetricPoint3f, MetricPoint3f> typedMatrix4 = typedMatrix2.a(typedMatrix).a(typedMatrix3);
        return typedMatrix4;
    }

    public static TypedMatrix<MetricPoint3f, MetricPoint3f> a(Point3f.PointVolumeInfo pointVolumeInfo, Point3f.PointVolumeInfo pointVolumeInfo2, TypedMatrix<DicomPoint3f, DicomPoint3f> typedMatrix) {
        TypedMatrix<DicomPoint3f, MetricPoint3f> typedMatrix2 = DicomRegUtils.generate_DICOM_M_METRIC(pointVolumeInfo2);
        TypedMatrix<MetricPoint3f, DicomPoint3f> typedMatrix3 = DicomRegUtils.generate_METRIC_M_DICOM(pointVolumeInfo);
        TypedMatrix<MetricPoint3f, MetricPoint3f> typedMatrix4 = typedMatrix2.a(typedMatrix).a(typedMatrix3);
        return typedMatrix4;
    }

    public static TypedMatrix<DicomPoint3f, DicomPoint3f> b(Point3f.PointVolumeInfo pointVolumeInfo, Point3f.PointVolumeInfo pointVolumeInfo2, TypedMatrix<MetricPoint3f, MetricPoint3f> typedMatrix) {
        TypedMatrix<DicomPoint3f, MetricPoint3f> typedMatrix2 = DicomRegUtils.generate_DICOM_M_METRIC(pointVolumeInfo);
        TypedMatrix<MetricPoint3f, DicomPoint3f> typedMatrix3 = DicomRegUtils.generate_METRIC_M_DICOM(pointVolumeInfo2, pointVolumeInfo2.iop, pointVolumeInfo2.dicomCenter);
        TypedMatrix<DicomPoint3f, DicomPoint3f> typedMatrix4 = typedMatrix3.a(typedMatrix).a(typedMatrix2);
        return typedMatrix4;
    }

    public static Matrix4f e() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.m00 = 1.0f;
        matrix4f.m21 = 1.0f;
        matrix4f.m12 = -1.0f;
        matrix4f.m33 = 1.0f;
        return matrix4f;
    }

    public static IECFixedVector a(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        float[] fArray = new float[3];
        Matrix4f matrix4f = typedMatrix.b();
        fArray[0] = matrix4f.m03;
        fArray[1] = matrix4f.m13;
        fArray[2] = matrix4f.m23;
        return new IECFixedVector(fArray);
    }

    public static IECFixedVector b(TypedMatrix<IECFixedPoint3f, IECFixedPoint3f> typedMatrix) {
        float[] fArray = new float[3];
        double[] dArray = MatrixMultiplier.f(typedMatrix.b());
        fArray[0] = (float)dArray[0];
        fArray[1] = (float)dArray[1];
        fArray[2] = (float)dArray[2];
        return new IECFixedVector(fArray);
    }

    public static enum PatientPosition {
        a(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}),
        b(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f}),
        c(new float[]{1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f}),
        d(new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f}),
        e(new float[]{0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f}),
        f(new float[]{0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f}),
        g(new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f}),
        h(new float[]{0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f}),
        i(null);

        private final float[] axialIop;
        private final Vector3f iecFixedXAxisInDicomSpace;
        private final Vector3f iecFixedYAxisInDicomSpace;

        private PatientPosition(float[] fArray) {
            this.axialIop = fArray;
            if (fArray != null) {
                this.iecFixedXAxisInDicomSpace = new Vector3f(fArray[0], fArray[1], fArray[2]);
                Vector3f vector3f = new Vector3f();
                vector3f.cross(this.iecFixedXAxisInDicomSpace, new Vector3f(fArray[3], fArray[4], fArray[5]));
                this.iecFixedYAxisInDicomSpace = vector3f;
            } else {
                this.iecFixedXAxisInDicomSpace = null;
                this.iecFixedYAxisInDicomSpace = null;
            }
        }

        public float[] a() {
            if (this.axialIop == null) {
                return null;
            }
            return Arrays.copyOf(this.axialIop, this.axialIop.length);
        }

        public Vector3f b() {
            return new Vector3f(this.iecFixedXAxisInDicomSpace);
        }

        public Vector3f c() {
            return new Vector3f(this.iecFixedYAxisInDicomSpace);
        }

        public Vector3f d() {
            Vector3f vector3f = new Vector3f();
            vector3f.cross(this.iecFixedXAxisInDicomSpace, this.iecFixedYAxisInDicomSpace);
            return vector3f;
        }

        public static PatientPosition a(String string) {
            for (PatientPosition patientPosition : PatientPosition.values()) {
                if (!patientPosition.toString().equalsIgnoreCase(string)) continue;
                return patientPosition;
            }
            return null;
        }
    }
}

