/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.internals.volumes.a;
import com.mimvista.internals.x;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.util.ay;
import com.mimvista.viewer.SeriesInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.vecmath.Vector3f;

public class SliceInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public String fileName;
    public int sliceNumber = -1;
    public float slicePosition = Float.MIN_VALUE;
    public String sopInstanceUID;
    public String seriesInstanceUID;
    public float rescaleSlope;
    public float rescaleIntercept;
    public float origRescaleSlope;
    public float origRescaleIntercept;
    public float[] sliceDicomCenter;
    public Point3f voxel;
    public float[] ipp;
    public float[] iop;
    public float[] pixelSpacing;
    public int width;
    public int height;
    public Integer pixelPaddingValue;
    public Date acquisitionTime;
    public Float frameTime;
    public Float triggerTime;
    public Float frameReferenceTime;
    public Integer temporalPositionID;
    public Float echoTime;
    public String imageComments;
    public String scanOptions;
    public Integer philipsPrivatePhaseNumber;
    public Integer gePrivateReconstructionMatrix;
    public Integer gePrivatePctRpeakDelay;
    public Integer imageIndex;
    public String seriesNumber;
    public String acquisitionNumber;
    public int binNumber = -1;
    public String sequenceName;
    public String contentTime;
    public FrameNumber explicitFrame;
    public Integer explicitMaxFrames;
    public String explicitFrameDesc;
    public boolean explicitMultiSeries4D;
    public Float decayFactor;
    public Integer actualFrameDuration;
    public SliceInfo derivedFrom = null;
    public boolean sliceIsLoaded = true;

    public String toString() {
        return "Num: " + this.sliceNumber + " Pos: " + this.slicePosition;
    }

    public SliceInfo a() {
        SliceInfo sliceInfo;
        try {
            sliceInfo = (SliceInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)cloneNotSupportedException, this);
            return null;
        }
        sliceInfo.fileName = this.fileName;
        sliceInfo.sliceNumber = this.sliceNumber;
        sliceInfo.slicePosition = this.slicePosition;
        sliceInfo.sopInstanceUID = this.sopInstanceUID;
        sliceInfo.rescaleSlope = this.rescaleSlope;
        sliceInfo.rescaleIntercept = this.rescaleIntercept;
        sliceInfo.frameTime = this.frameTime;
        if (this.sliceDicomCenter != null) {
            sliceInfo.sliceDicomCenter = (float[])this.sliceDicomCenter.clone();
        }
        if (this.voxel != null) {
            sliceInfo.voxel = this.voxel.e();
        }
        if (this.ipp != null) {
            sliceInfo.ipp = (float[])this.ipp.clone();
        }
        if (this.iop != null) {
            sliceInfo.iop = (float[])this.iop.clone();
        }
        sliceInfo.width = this.width;
        sliceInfo.height = this.height;
        if (this.derivedFrom != null) {
            sliceInfo.derivedFrom = this.derivedFrom.a();
        }
        if (this.contentTime != null) {
            sliceInfo.contentTime = this.contentTime;
        }
        if (this.explicitFrame != null) {
            sliceInfo.explicitFrame = new FrameNumber(this.explicitFrame.a());
        }
        sliceInfo.explicitMaxFrames = this.explicitMaxFrames;
        sliceInfo.explicitFrameDesc = this.explicitFrameDesc;
        sliceInfo.explicitMultiSeries4D = this.explicitMultiSeries4D;
        sliceInfo.decayFactor = this.decayFactor;
        sliceInfo.actualFrameDuration = this.actualFrameDuration;
        return sliceInfo;
    }

    public static float[] a(SeriesInfo seriesInfo, List<SliceInfo> list) {
        return SliceInfo.a(seriesInfo, list, new x());
    }

    public static float[] a(SeriesInfo seriesInfo, List<SliceInfo> list, x x2) {
        float[] fArray = new float[list.size() - 1];
        Vector3f vector3f = new Vector3f(SimpleOrientationHelper.a(seriesInfo.imageOrientation, seriesInfo.a(x2)));
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            fArray[i2] = a.a(vector3f, list.get((int)(i2 + 1)).sliceDicomCenter, list.get((int)i2).sliceDicomCenter);
        }
        return fArray;
    }

    public static boolean a(List<SliceInfo> list, SeriesInfo seriesInfo) {
        if (list == null || list.size() < 3) {
            return true;
        }
        for (SliceInfo sliceInfo : list) {
            if (sliceInfo.sliceDicomCenter != null) continue;
            return true;
        }
        float[] fArray = SliceInfo.a(seriesInfo, list);
        double d2 = 0.0;
        for (float f2 : fArray) {
            d2 += (double)f2;
        }
        d2 /= (double)fArray.length;
        double d3 = 0.0;
        for (float f3 : fArray) {
            d3 += Math.pow((double)f3 - d2, 2.0);
        }
        return (d3 = Math.sqrt(d3 / (double)fArray.length)) / d2 < 0.005;
    }

    public static void a(List<SliceInfo> list, float[] fArray, SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume) {
        float[] fArray2 = new float[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            fArray2[i2] = list.get((int)i2).voxel.z;
        }
        if (Float.isNaN(fArray2[0])) {
            return;
        }
        Arrays.sort(fArray);
        Arrays.sort(fArray2);
        if (fArray2[0] > fArray[fArray.length - 1] || fArray2[fArray2.length - 1] < fArray[0]) {
            ay.b((Object)"Slice thicknesses are not sane. Resetting them all to NaN.", SliceInfo.class);
            for (SliceInfo sliceInfo : list) {
                sliceInfo.voxel.z = Float.NaN;
            }
            Object object = simpleImageVolume.b();
            object[2] = fArray[0];
            simpleImageVolume.a((float[])object);
        }
    }

    public static List<SliceInfo> a(List<SliceInfo> list) {
        return SliceInfo.a(list, true);
    }

    public static List<SliceInfo> a(List<SliceInfo> list, boolean bl2) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        for (SliceInfo sliceInfo : list) {
            SliceInfo sliceInfo2 = sliceInfo.a();
            if (bl2) {
                sliceInfo2.sopInstanceUID = UIDGenerator.generateSopInstanceUID();
            }
            arrayList.add(sliceInfo2);
        }
        return arrayList;
    }

    public static void a(SimpleImageVolume<?> simpleImageVolume, List<SliceInfo> list) {
        VoxelPoint3f voxelPoint3f = new VoxelPoint3f((float)simpleImageVolume.a()[0] / 2.0f, (float)simpleImageVolume.a()[1] / 2.0f, 0.0f, simpleImageVolume);
        for (int i2 = 0; i2 < simpleImageVolume.a()[2]; ++i2) {
            SliceInfo sliceInfo = new SliceInfo();
            sliceInfo.sliceNumber = i2 + 1;
            voxelPoint3f.z = (float)i2 + 0.5f;
            sliceInfo.sliceDicomCenter = voxelPoint3f.b().d().f();
            sliceInfo.sopInstanceUID = UIDGenerator.generateSopInstanceUID();
            list.add(sliceInfo);
        }
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.a();
    }
}

