/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.dose;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.dicom.rtdose.Units;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.casting.q;
import com.mimvista.internals.dose.IsodoseSettingContext;
import com.mimvista.internals.dose.IsodoseSettingData;
import com.mimvista.internals.dose.a;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.Session;
import com.mimvista.mui.overlays.DoseSidePanel;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.numerics.MathUtils;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.state.ReadHelper;
import com.mimvista.viewer.RTDoseSeriesInfo;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IsodoseSetting
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static final String a = "isodose.xml";
    private List<IsodoseSettingData.SingleCurveSetting> curves;
    private IsodoseSettingData.SingleCurveSetting quickIsoCurve;
    private boolean isPercent;
    private IsodoseSettingContext context;
    private boolean showLabels = true;
    private String seriesUID;
    private Map<Long, Boolean> visMap = new HashMap<Long, Boolean>();
    private boolean showIsodose = true;
    private boolean showColorwash = false;
    private boolean showColorLabels = DosePrefs.renderColorLabels.getValue();
    private boolean showConstraint = false;
    private int transparency = 100;
    private String customName = "";
    private String workflowName = "";
    private String isdName = "";
    public static Font b = new Font("Arial Unicode MS", 0, 1);
    public static Font c = new Font("Arial Unicode MS", 0, 10);
    private transient WeakReference<Session> d;

    public static IsodoseSettingData a(IsodoseSettingContext isodoseSettingContext) {
        a a2;
        IsodoseSettingData isodoseSettingData = DoseSidePanel.b(isodoseSettingContext);
        if (isodoseSettingData != null) {
            return isodoseSettingData;
        }
        File file = com.mimvista.preferencesNew.cascade.c.d().a(CascadeSubfolder.a, a);
        if (file == null) {
            file = com.mimvista.preferencesNew.cascade.c.d().b(CascadeSubfolder.a, a);
        }
        if ((a2 = IsodoseSettingData.a(file)) != null) {
            if (a2.c()) {
                IsodoseSettingData.a(file, a2.a());
            }
            if ((isodoseSettingData = a2.a(isodoseSettingContext)) != null) {
                return isodoseSettingData;
            }
        }
        return IsodoseSettingData.b(isodoseSettingContext);
    }

    public IsodoseSetting(IsodoseSettingData isodoseSettingData, IsodoseOverlay isodoseOverlay) {
        this.d = new WeakReference<Session>(isodoseOverlay.aD());
        this.seriesUID = isodoseOverlay.ao().getUncopiedMutableInfo().ag();
        this.context = isodoseSettingData.h();
        this.curves = Lists.newArrayList();
        this.isdName = isodoseSettingData.name;
        List<IsodoseSettingData.SingleCurveSetting> list = isodoseSettingData.a();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.curves.add(new IsodoseSettingData.SingleCurveSetting(list.get(i2)));
        }
        if (isodoseSettingData.e() != null) {
            this.quickIsoCurve = new IsodoseSettingData.SingleCurveSetting(isodoseSettingData.e());
        }
        this.isPercent = isodoseSettingData.view == IsodoseSettingData.IsodoseView.a || isodoseSettingData.view == IsodoseSettingData.IsodoseView.c;
        DoseSidePanel doseSidePanel = DoseSidePanel.l();
        if (doseSidePanel != null) {
            this.showIsodose = doseSidePanel.i();
            this.showColorwash = doseSidePanel.h();
            this.transparency = doseSidePanel.j();
        }
        if (isodoseOverlay.i()) {
            IsodoseSetting isodoseSetting = isodoseOverlay.q();
            this.showLabels = isodoseSetting.showLabels;
            this.visMap = Maps.newHashMap(isodoseSetting.visMap);
            this.showIsodose = isodoseSetting.showIsodose;
            this.showColorwash = isodoseSetting.showColorwash;
            this.showColorLabels = isodoseSetting.showColorLabels;
            this.showConstraint = isodoseSetting.showConstraint;
            this.transparency = isodoseSetting.transparency;
            this.customName = isodoseSetting.customName;
            this.workflowName = isodoseSetting.workflowName;
        }
    }

    public void a(Session session) {
        this.d = new WeakReference<Session>(session);
    }

    public List<IsodoseSettingData.SingleCurveSetting> a(IsodoseOverlay isodoseOverlay) {
        ArrayList arrayList = Lists.newArrayList();
        for (IsodoseSettingData.SingleCurveSetting singleCurveSetting : this.b()) {
            arrayList.add(new IsodoseSettingData.SingleCurveSetting(singleCurveSetting));
        }
        if (!this.c()) {
            ImageVolumeShort imageVolumeShort = isodoseOverlay.C();
            int n2 = imageVolumeShort.a(0.0f);
            float f2 = ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).curDose.c().getValueInGy();
            int n3 = Math.round(imageVolumeShort.getUncopiedMutableInfo().rescale.removeRaw(f2));
            for (IsodoseSettingData.SingleCurveSetting singleCurveSetting : arrayList) {
                DoseValue doseValue = new DoseValue(singleCurveSetting.value);
                float f3 = imageVolumeShort.a(doseValue.getValueInGy());
                singleCurveSetting.value = IsodoseSetting.a(n2, n3, f3);
            }
        }
        return arrayList;
    }

    public static float a(float f2, IsodoseOverlay isodoseOverlay) {
        ImageVolumeShort imageVolumeShort = isodoseOverlay.C();
        float f3 = imageVolumeShort.a(0.0f);
        float f4 = ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).curDose.c().getValueInGy();
        float f5 = imageVolumeShort.getUncopiedMutableInfo().rescale.removeRaw(f4);
        if (DoseValue.doseUnit == Units.cGy) {
            f2 /= 100.0f;
        }
        float f6 = imageVolumeShort.a(f2);
        return IsodoseSetting.a(f3, f5, f6);
    }

    private static float a(float f2, float f3, float f4) {
        float f5 = 0.0f;
        f5 = f3 - f2 != 0.0f ? (f4 - f2) * 100.0f / (f3 - f2) : 0.0f;
        if (f5 > 100.0f) {
            f5 = 100.0f;
        }
        return f5;
    }

    public static float b(float f2, IsodoseOverlay isodoseOverlay) {
        ImageVolumeShort imageVolumeShort = isodoseOverlay.C();
        float f3 = ((RTDoseSeriesInfo)imageVolumeShort.getUncopiedMutableInfo().modInfo).curDose.c().getValueInCurrentUnit();
        return f3 * f2;
    }

    public IsodoseSettingData.SingleCurveSetting a() {
        return this.quickIsoCurve;
    }

    public List<IsodoseSettingData.SingleCurveSetting> b() {
        return this.a(false);
    }

    public List<IsodoseSettingData.SingleCurveSetting> a(boolean bl2) {
        if (this.curves == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList(this.curves);
        if (bl2 && this.quickIsoCurve != null) {
            arrayList.add(this.quickIsoCurve);
        }
        return arrayList;
    }

    public List<IsodoseSettingData.SingleCurveSetting> b(IsodoseOverlay isodoseOverlay) {
        ArrayList arrayList = Lists.newArrayList();
        for (IsodoseSettingData.SingleCurveSetting serializable2 : this.a(true)) {
            arrayList.add(new IsodoseSettingData.SingleCurveSetting(serializable2));
        }
        ImageVolumeShort imageVolumeShort = isodoseOverlay.C();
        RescaleConverter rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale;
        if (this.c()) {
            int n2 = imageVolumeShort.a(0.0f);
            RTDoseSeriesInfo singleCurveSetting = isodoseOverlay.G();
            float doseValue = imageVolumeShort.ai();
            float f2 = rescaleConverter.apply(doseValue);
            if (singleCurveSetting != null) {
                f2 = singleCurveSetting.curDose.c().getValueInGy();
            }
            int n3 = (int)rescaleConverter.removeRaw(f2);
            for (IsodoseSettingData.SingleCurveSetting singleCurveSetting2 : arrayList) {
                singleCurveSetting2.value = (float)n2 + (float)(n3 - n2) / 100.0f * singleCurveSetting2.value;
            }
        } else {
            for (IsodoseSettingData.SingleCurveSetting singleCurveSetting : arrayList) {
                DoseValue doseValue = new DoseValue(singleCurveSetting.value);
                singleCurveSetting.value = rescaleConverter.removeRaw(doseValue.getValueInGy());
            }
        }
        return arrayList;
    }

    public IsodoseSettingData.SingleCurveSetting a(int n2) {
        return this.b().get(n2);
    }

    public boolean c() {
        return this.isPercent;
    }

    public IsodoseSettingContext d() {
        return this.context;
    }

    public int e() {
        return this.transparency;
    }

    public boolean f() {
        return this.showIsodose;
    }

    public boolean g() {
        return this.showColorwash;
    }

    public boolean h() {
        return this.showColorLabels;
    }

    public boolean i() {
        return this.showConstraint;
    }

    public boolean j() {
        return this.showLabels;
    }

    public void b(boolean bl2) {
        this.showLabels = bl2;
    }

    public void b(int n2) {
        this.transparency = MathUtils.b(n2, 0, 255);
    }

    public void c(boolean bl2) {
        this.showIsodose = bl2;
    }

    public void d(boolean bl2) {
        this.showColorwash = bl2;
    }

    public void e(boolean bl2) {
        this.showColorLabels = bl2;
    }

    public void f(boolean bl2) {
        this.showConstraint = bl2;
    }

    public String k() {
        return this.customName;
    }

    public void a(String string) {
        this.customName = string;
    }

    public String l() {
        return this.workflowName;
    }

    public void b(String string) {
        this.workflowName = string;
    }

    public Boolean a(ViewController viewController) {
        return this.visMap.get(viewController.aV());
    }

    public String m() {
        return this.isdName;
    }

    public boolean b(ViewController viewController) {
        if (!this.visMap.containsKey(viewController.aV())) {
            Object object;
            boolean bl2 = false;
            if (viewController.bl()) {
                ImageVolumeShort imageVolumeShort;
                object = viewController.bh().cE().l().iterator();
                while (object.hasNext() && !(bl2 = this.seriesUID.equals((imageVolumeShort = object.next()).getUncopiedMutableInfo().ag()))) {
                }
            } else {
                bl2 = this.seriesUID.equals(viewController.getUncopiedMutableInfo().ag());
            }
            if (bl2) {
                object = viewController.aw().n().L();
                boolean bl3 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    IsodoseOverlay isodoseOverlay = (IsodoseOverlay)iterator.next();
                    IsodoseSetting isodoseSetting = isodoseOverlay.q();
                    if (this == isodoseSetting || !isodoseSetting.visMap.containsKey(viewController.aV()) || !isodoseSetting.b(viewController) || viewController.aT().aV() == isodoseOverlay.y_().aI() && !this.seriesUID.equals(isodoseSetting.seriesUID)) continue;
                    bl3 = true;
                    break;
                }
                this.visMap.put(viewController.aV(), !bl3);
            } else {
                this.visMap.put(viewController.aV(), false);
            }
        }
        return this.visMap.get(viewController.aV());
    }

    public void a(ViewController viewController, boolean bl2) {
        long l2 = viewController.aV();
        this.visMap.put(l2, bl2);
        if (bl2) {
            List<IsodoseOverlay> list = viewController.ba().L();
            for (IsodoseOverlay isodoseOverlay : list) {
                q q2;
                ViewController3D viewController3D;
                IsodoseSetting isodoseSetting = isodoseOverlay.q();
                if (this != isodoseSetting) {
                    boolean bl3;
                    viewController3D = isodoseOverlay.t();
                    if (viewController3D == null) continue;
                    boolean bl4 = false;
                    if (!this.seriesUID.equals(isodoseSetting.seriesUID) && viewController3D.bl()) {
                        for (ImageVolumeShort imageVolumeShort : viewController3D.cE()) {
                            if (!this.seriesUID.equals(imageVolumeShort.getUncopiedMutableInfo().ag())) continue;
                            bl4 = true;
                            break;
                        }
                    }
                    if (bl4) continue;
                    boolean bl5 = isodoseSetting.visMap.containsKey(l2);
                    boolean bl6 = bl3 = isodoseSetting.d != null && isodoseSetting.d.get() == this.d.get();
                    if (!bl5 || !bl3) continue;
                    isodoseSetting.a(viewController, false);
                    continue;
                }
                if (!(viewController instanceof ViewController3D) || (q2 = (viewController3D = (ViewController3D)viewController).cJ()) == null) continue;
                q2.a(isodoseOverlay);
                viewController.bB();
            }
        }
    }

    public List<ViewController> n() {
        ArrayList arrayList = Lists.newArrayList();
        ViewController viewController = null;
        ArrayList arrayList2 = Lists.newArrayList();
        if (this.d.get() != null) {
            for (Long object : this.visMap.keySet()) {
                ViewController viewController2;
                if (!((Session)this.d.get()).e(object) || (viewController2 = ((Session)this.d.get()).b(object)) == null) continue;
                arrayList2.add(viewController2);
                if (!this.seriesUID.equals(viewController2.getUncopiedMutableInfo().ag())) continue;
                viewController = viewController2;
            }
            if (viewController != null) {
                for (ViewController viewController3 : arrayList2) {
                    if (!viewController.aG().i(viewController3.aw(), viewController.aw())) continue;
                    arrayList.add(viewController3);
                }
            }
        }
        return arrayList;
    }

    public void g(boolean bl2) {
        List<ViewController> list = this.n();
        for (ViewController viewController : list) {
            this.a(viewController, bl2);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof IsodoseSetting) {
            IsodoseSetting isodoseSetting = (IsodoseSetting)object;
            return IsodoseSetting.a(this.d == null ? null : this.d.get(), isodoseSetting.d == null ? null : isodoseSetting.d.get()) && IsodoseSetting.a(this.seriesUID, isodoseSetting.seriesUID) && this.isPercent == isodoseSetting.isPercent && this.showLabels == isodoseSetting.showLabels && this.showIsodose == isodoseSetting.showIsodose && this.showColorwash == isodoseSetting.showColorwash && this.showColorLabels == isodoseSetting.showColorLabels && this.showConstraint == isodoseSetting.showConstraint && this.transparency == isodoseSetting.transparency && IsodoseSetting.a(this.curves, isodoseSetting.curves) && IsodoseSetting.a(this.quickIsoCurve, isodoseSetting.quickIsoCurve) && this.visMap.equals(isodoseSetting.visMap);
        }
        return false;
    }

    public static boolean a(List<IsodoseSettingData.SingleCurveSetting> list, List<IsodoseSettingData.SingleCurveSetting> list2, boolean bl2, boolean bl3, boolean bl4) {
        if (list == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (bl3 && list.get((int)i2).value != list2.get((int)i2).value) {
                return false;
            }
            if (bl2 && !list.get((int)i2).color.equals(list2.get((int)i2).color)) {
                return false;
            }
            if (!bl4 || list.get((int)i2).hidden == list2.get((int)i2).hidden) continue;
            return false;
        }
        return true;
    }

    public static boolean a(List<IsodoseSettingData.SingleCurveSetting> list, List<IsodoseSettingData.SingleCurveSetting> list2) {
        return IsodoseSetting.a(list, list2, false, true, false);
    }

    public static boolean a(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public int hashCode() {
        Object[] objectArray;
        int n2 = 0;
        for (Object object : objectArray = new Object[]{this.d.get(), this.seriesUID, this.isPercent, this.showLabels, this.showIsodose, this.showColorwash, this.showColorLabels, this.showConstraint, this.transparency, this.visMap}) {
            if (object != null) {
                n2 += object.hashCode();
            }
            n2 *= 13;
        }
        n2 += this.curves.hashCode();
        return n2 *= 13;
    }

    public static boolean a(IsodoseSetting isodoseSetting, IsodoseSetting isodoseSetting2) {
        if (isodoseSetting == null || isodoseSetting2 == null) {
            return false;
        }
        if (isodoseSetting.equals(isodoseSetting2)) {
            return true;
        }
        return IsodoseSetting.a(isodoseSetting.seriesUID, isodoseSetting2.seriesUID) && isodoseSetting.isPercent == isodoseSetting2.isPercent && isodoseSetting.showLabels == isodoseSetting2.showLabels && isodoseSetting.showIsodose == isodoseSetting2.showIsodose && isodoseSetting.showColorwash == isodoseSetting2.showColorwash && isodoseSetting.showColorLabels == isodoseSetting2.showColorLabels && isodoseSetting.showConstraint == isodoseSetting2.showConstraint && isodoseSetting.transparency == isodoseSetting2.transparency && IsodoseSetting.a(isodoseSetting.curves, isodoseSetting2.curves);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ReadHelper readHelper = new ReadHelper();
        readHelper.a("transparency", (Object)100);
        readHelper.a(objectInputStream, (Object)this);
    }

    public void a(IsodoseSetting isodoseSetting) {
        this.visMap.clear();
        this.visMap.putAll(isodoseSetting.visMap);
        this.curves = Lists.newArrayList();
        if (isodoseSetting.curves != null) {
            for (IsodoseSettingData.SingleCurveSetting singleCurveSetting : isodoseSetting.curves) {
                this.curves.add(new IsodoseSettingData.SingleCurveSetting(singleCurveSetting));
            }
        }
        this.isPercent = isodoseSetting.isPercent;
        this.showIsodose = isodoseSetting.showIsodose;
        this.showColorwash = isodoseSetting.showColorwash;
        this.showColorLabels = isodoseSetting.showColorLabels;
        this.showConstraint = isodoseSetting.showConstraint;
        this.transparency = isodoseSetting.transparency;
        this.showLabels = isodoseSetting.showLabels;
        this.workflowName = isodoseSetting.workflowName;
        this.seriesUID = isodoseSetting.seriesUID;
        this.d = isodoseSetting.d;
    }
}

