/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.dose;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.brachytherapy.mui.sidepanel.BrachySidePanel;
import com.mimvista.commands.workflow.dose.IsodoseSettingCommand;
import com.mimvista.dicom.rtdose.DoseValue;
import com.mimvista.internals.dose.IsodoseSetting;
import com.mimvista.internals.dose.IsodoseSettingContext;
import com.mimvista.mui.ColorTable;
import com.mimvista.mui.overlays.DoseSidePanel;
import com.mimvista.mui.overlays.IsodoseOverlay;
import com.mimvista.numerics.MathUtils;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.state.ReadHelper;
import com.mimvista.user.e;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.ColorTableFactory;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IsodoseSettingData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SingleCurveSetting> curves;
    public IsodoseView view;
    private boolean isDefault;
    public String name;
    private IsodoseSettingContext context = IsodoseSettingContext.a;
    private String colorTableType;
    private String colorTableName;
    private transient ColorTable a;
    private transient boolean b = false;
    private transient SingleCurveSetting c;
    public boolean ascending = false;
    private static Object d = new Object();

    public IsodoseSettingData() {
        this.curves = Lists.newArrayList();
        this.view = IsodoseView.a;
        this.isDefault = false;
        this.name = "";
        this.colorTableType = "Functional";
        this.colorTableName = "Rainbow 20";
    }

    public IsodoseSettingData(IsodoseSettingData isodoseSettingData) {
        this.curves = Lists.newArrayList();
        for (SingleCurveSetting singleCurveSetting : isodoseSettingData.curves) {
            this.curves.add(new SingleCurveSetting(singleCurveSetting));
        }
        this.view = isodoseSettingData.view;
        this.isDefault = isodoseSettingData.isDefault;
        this.context = isodoseSettingData.context;
        this.name = isodoseSettingData.name;
        this.ascending = isodoseSettingData.ascending;
        this.colorTableType = isodoseSettingData.colorTableType;
        this.colorTableName = isodoseSettingData.colorTableName;
        this.b = isodoseSettingData.b;
        this.f();
    }

    public boolean a(IsodoseSettingData isodoseSettingData) {
        if (this.ascending != isodoseSettingData.ascending) {
            return false;
        }
        if (!this.curves.equals(isodoseSettingData.curves)) {
            return false;
        }
        return this.view == isodoseSettingData.view;
    }

    public SingleCurveSetting a(int n2) {
        return this.curves.get(n2);
    }

    public List<SingleCurveSetting> a() {
        return this.curves;
    }

    public int b() {
        return this.curves.size();
    }

    public void b(int n2) {
        this.curves.remove(n2);
    }

    public int a(SingleCurveSetting singleCurveSetting) {
        return this.curves.indexOf(singleCurveSetting);
    }

    public String c() {
        return this.name;
    }

    public boolean d() {
        return this.b;
    }

    public void a(boolean bl2) {
        this.b = bl2;
    }

    public SingleCurveSetting a(float f2, Color color) {
        int n2 = DosePrefs.defaultIsodoseLineWidth.getValue();
        SingleCurveSetting singleCurveSetting = new SingleCurveSetting(color, f2, false, n2);
        this.curves.add(singleCurveSetting);
        return singleCurveSetting;
    }

    public void b(SingleCurveSetting singleCurveSetting) {
        this.curves.add(singleCurveSetting);
    }

    public void c(SingleCurveSetting singleCurveSetting) {
        this.c = singleCurveSetting;
    }

    public SingleCurveSetting e() {
        return this.c;
    }

    public void f() {
        Collections.sort(this.curves, new a(this.ascending));
    }

    public boolean g() {
        return this.isDefault;
    }

    public void b(boolean bl2) {
        this.isDefault = bl2;
    }

    public IsodoseSettingContext h() {
        return this.context;
    }

    public void a(IsodoseSettingContext isodoseSettingContext) {
        this.context = isodoseSettingContext;
    }

    public String toString() {
        return this.name;
    }

    public void a(ColorTable colorTable) {
        if (colorTable == null) {
            this.colorTableType = "";
            this.colorTableName = "";
        } else {
            this.colorTableType = colorTable.set;
            this.colorTableName = colorTable.name;
        }
        this.a = colorTable;
    }

    public ColorTable i() {
        if (this.a == null && !this.colorTableType.isEmpty() && !this.colorTableName.isEmpty()) {
            this.a = ColorTableFactory.b(this.colorTableType, this.colorTableName);
        }
        return this.a;
    }

    public void a(Object object, IsodoseView isodoseView, IsodoseView isodoseView2) {
        if (isodoseView == isodoseView2) {
            return;
        }
        if (object != null && object instanceof IsodoseOverlay) {
            IsodoseOverlay isodoseOverlay = (IsodoseOverlay)object;
            for (SingleCurveSetting singleCurveSetting : this.curves) {
                if (isodoseView2 == IsodoseView.b) {
                    singleCurveSetting.value = IsodoseSetting.b(singleCurveSetting.value / 100.0f, isodoseOverlay);
                    continue;
                }
                if (isodoseView2 != IsodoseView.a) continue;
                singleCurveSetting.value = IsodoseSetting.a(singleCurveSetting.value, isodoseOverlay);
            }
        }
    }

    void a(Document document, Node node) {
        Element element = (Element)node.appendChild(document.createElement("setting"));
        element.setAttribute("name", this.name);
        element.setAttribute("context", IsodoseSettingContext.a(this.context));
        element.setAttribute("view", this.view.name());
        element.setAttribute("default", String.valueOf(this.isDefault));
        element.setAttribute("colorType", this.colorTableType);
        element.setAttribute("colorName", this.colorTableName);
        for (int i2 = 0; i2 < this.curves.size(); ++i2) {
            SingleCurveSetting singleCurveSetting = this.curves.get(i2);
            Element element2 = (Element)element.appendChild(document.createElement("level"));
            element2.setAttribute("red", String.valueOf(singleCurveSetting.color.getRed()));
            element2.setAttribute("green", String.valueOf(singleCurveSetting.color.getGreen()));
            element2.setAttribute("blue", String.valueOf(singleCurveSetting.color.getBlue()));
            element2.setAttribute("alpha", String.valueOf(singleCurveSetting.color.getAlpha()));
            element2.setAttribute("number", Float.toString(singleCurveSetting.value));
            element2.setAttribute("thickness", String.valueOf(singleCurveSetting.thickness));
        }
    }

    static IsodoseSettingData a(Node node) {
        Node node2;
        IsodoseSettingData isodoseSettingData = new IsodoseSettingData();
        isodoseSettingData.name = node.getAttributes().getNamedItem("name").getNodeValue();
        Node node3 = node.getAttributes().getNamedItem("is_percent");
        if (node3 != null) {
            boolean bl2 = Boolean.parseBoolean(node3.getNodeValue());
            isodoseSettingData.view = bl2 ? IsodoseView.a : IsodoseView.b;
        } else {
            Node node4 = node.getAttributes().getNamedItem("view");
            if (node4 != null) {
                isodoseSettingData.view = IsodoseView.valueOf(node4.getNodeValue());
            }
        }
        isodoseSettingData.isDefault = Boolean.parseBoolean(node.getAttributes().getNamedItem("default").getNodeValue());
        isodoseSettingData.context = IsodoseSettingContext.a(node.getAttributes().getNamedItem("context"));
        Node node5 = node.getAttributes().getNamedItem("colorType");
        if (node5 != null) {
            isodoseSettingData.colorTableType = node5.getNodeValue();
        }
        if ((node2 = node.getAttributes().getNamedItem("colorName")) != null) {
            isodoseSettingData.colorTableName = node2.getNodeValue();
        }
        boolean bl3 = true;
        NodeList nodeList = ((Element)node).getElementsByTagName("level");
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Object object;
            NamedNodeMap namedNodeMap = nodeList.item(i2).getAttributes();
            int n2 = 255;
            Node node6 = namedNodeMap.getNamedItem("alpha");
            if (node6 != null) {
                n2 = Integer.parseInt(node6.getNodeValue());
            }
            Color color = new Color(Integer.parseInt(namedNodeMap.getNamedItem("red").getNodeValue()), Integer.parseInt(namedNodeMap.getNamedItem("green").getNodeValue()), Integer.parseInt(namedNodeMap.getNamedItem("blue").getNodeValue()), n2);
            float f2 = Float.parseFloat(namedNodeMap.getNamedItem("number").getNodeValue());
            int n3 = 1;
            Node node7 = namedNodeMap.getNamedItem("thickness");
            if (node7 != null && !cn.h((String)(object = node7.getNodeValue()))) {
                n3 = Integer.parseInt((String)object);
            }
            object = new SingleCurveSetting(color, f2, false, n3);
            isodoseSettingData.curves.add((SingleCurveSetting)object);
        }
        return isodoseSettingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static com.mimvista.internals.dose.a a(File file) {
        com.mimvista.internals.dose.a a2 = new com.mimvista.internals.dose.a();
        if (file == null || !file.exists()) {
            return a2;
        }
        try {
            Object object = d;
            synchronized (object) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile("//all_settings/setting");
                NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
                for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                    a2.c(IsodoseSettingData.a(nodeList.item(i2)));
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)("Error reading isodose settings file: " + file.getAbsolutePath()), throwable, IsodoseSettingData.class);
        }
        return a2;
    }

    private static boolean a(List<IsodoseSettingData> list) {
        if (e.a(CascadeSubfolder.a, "isodose.xml")) {
            return false;
        }
        List<IsodoseSettingData> list2 = IsodoseSettingCommand.getIsodoseSettings().a();
        if (list2.size() != list.size()) {
            return true;
        }
        for (int i2 = 0; i2 < list2.size(); ++i2) {
            if (IsodoseSettingData.a(list.get(i2), list2.get(i2))) continue;
            return true;
        }
        return false;
    }

    private static boolean a(IsodoseSettingData isodoseSettingData, IsodoseSettingData isodoseSettingData2) {
        if (!isodoseSettingData.name.equals(isodoseSettingData2.name)) {
            return false;
        }
        if (isodoseSettingData.context != isodoseSettingData2.context) {
            return false;
        }
        if (isodoseSettingData.view != isodoseSettingData2.view) {
            return false;
        }
        if (isodoseSettingData.isDefault != isodoseSettingData2.isDefault) {
            return false;
        }
        if (!isodoseSettingData.colorTableType.equals(isodoseSettingData2.colorTableType)) {
            return false;
        }
        if (!isodoseSettingData.colorTableName.equals(isodoseSettingData2.colorTableName)) {
            return false;
        }
        if (isodoseSettingData.curves.size() != isodoseSettingData2.curves.size()) {
            return false;
        }
        for (int i2 = 0; i2 < isodoseSettingData.curves.size(); ++i2) {
            if (IsodoseSettingData.a(isodoseSettingData.curves.get(i2), isodoseSettingData2.curves.get(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean a(SingleCurveSetting singleCurveSetting, SingleCurveSetting singleCurveSetting2) {
        if (!singleCurveSetting.color.equals(singleCurveSetting2.color)) {
            return false;
        }
        if (Float.floatToIntBits(singleCurveSetting.value) != Float.floatToIntBits(singleCurveSetting2.value)) {
            return false;
        }
        return singleCurveSetting.thickness == singleCurveSetting2.thickness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void a(File file, List<IsodoseSettingData> list) {
        if (!IsodoseSettingData.a(list)) {
            return;
        }
        try {
            Object object = d;
            synchronized (object) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.newDocument();
                Node node = document.appendChild(document.createElement("all_settings"));
                for (IsodoseSettingData object22 : list) {
                    object22.a(document, node);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("omit-xml-declaration", "no");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                file.getParentFile().mkdirs();
                DOMSource dOMSource = new DOMSource(document);
                try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                    StreamResult streamResult = new StreamResult(fileOutputStream);
                    transformer.transform(dOMSource, streamResult);
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, IsodoseSettingData.class);
        }
    }

    public static IsodoseSettingData b(IsodoseSettingContext isodoseSettingContext) {
        if (isodoseSettingContext == IsodoseSettingContext.b) {
            return IsodoseSettingData.k();
        }
        return IsodoseSettingData.j();
    }

    private static IsodoseSettingData j() {
        Color[] colorArray;
        IsodoseSettingData isodoseSettingData = new IsodoseSettingData();
        float[] fArray = new float[]{20.0f, 50.0f, 65.0f, 80.0f, 90.0f, 95.0f};
        ColorTable colorTable = ColorTableFactory.b("Functional", "Rainbow");
        if (colorTable != null) {
            ImmutableList<ColorTable.RGB> immutableList = colorTable.palette.f();
            colorArray = new Color[fArray.length];
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                int n2 = Math.round(fArray[i2] / 100.0f * 255.0f);
                n2 = MathUtils.b(n2, 0, 255);
                colorArray[i2] = ((ColorTable.RGB)immutableList.get(n2)).a();
            }
        } else {
            colorArray = new Color[]{Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW};
        }
        for (int i3 = 0; i3 < fArray.length; ++i3) {
            SingleCurveSetting singleCurveSetting = new SingleCurveSetting(colorArray[i3], fArray[i3], false, 1);
            isodoseSettingData.curves.add(singleCurveSetting);
        }
        isodoseSettingData.name = DoseSidePanel.a.getProperty("DOSE_PANEL_DEFAULT");
        isodoseSettingData.view = IsodoseView.a;
        isodoseSettingData.isDefault = true;
        isodoseSettingData.a((ColorTable)null);
        isodoseSettingData.context = IsodoseSettingContext.a;
        return isodoseSettingData;
    }

    private static IsodoseSettingData k() {
        IsodoseSettingData isodoseSettingData = new IsodoseSettingData();
        float[] fArray = new float[]{90.0f, 100.0f, 150.0f, 200.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 0), new Color(128, 255, 0), new Color(255, 128, 0), new Color(255, 0, 0)};
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            SingleCurveSetting singleCurveSetting = new SingleCurveSetting(colorArray[i2], fArray[i2], false, 1);
            isodoseSettingData.curves.add(singleCurveSetting);
        }
        isodoseSettingData.name = BrachySidePanel.a.b("DOSE_PANEL_DEFAULT_BRACHY");
        isodoseSettingData.view = IsodoseView.a;
        isodoseSettingData.isDefault = true;
        isodoseSettingData.context = IsodoseSettingContext.b;
        isodoseSettingData.a((ColorTable)null);
        return isodoseSettingData;
    }

    public static class a
    implements Comparator<SingleCurveSetting> {
        private boolean a;

        public a(boolean bl2) {
            this.a = bl2;
        }

        public int a(SingleCurveSetting singleCurveSetting, SingleCurveSetting singleCurveSetting2) {
            int n2 = Float.compare(singleCurveSetting.value, singleCurveSetting2.value);
            if (!this.a) {
                n2 *= -1;
            }
            return n2;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((SingleCurveSetting)object, (SingleCurveSetting)object2);
        }
    }

    public static enum IsodoseView {
        a,
        b,
        c;


        public String a() {
            switch (this) {
                case a: 
                case c: {
                    return Messages.a("Dose").getProperty("SETTING_DIALOG_RADIO_PERCENT");
                }
                case b: {
                    return DoseValue.doseUnit.name();
                }
            }
            return this.toString();
        }
    }

    public static class SingleCurveSetting
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final Integer[] a = new Integer[]{1, 2, 3, 4, 5};
        public Color color;
        public float value;
        public boolean hidden;
        public int thickness;

        public static Integer[] a() {
            return (Integer[])a.clone();
        }

        public SingleCurveSetting(Color color, float f2, boolean bl2, int n2) {
            this.color = color;
            this.value = f2;
            this.hidden = bl2;
            this.thickness = n2;
        }

        public SingleCurveSetting(SingleCurveSetting singleCurveSetting) {
            this.color = singleCurveSetting.color;
            this.value = singleCurveSetting.value;
            this.hidden = singleCurveSetting.hidden;
            this.thickness = singleCurveSetting.thickness;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.color == null ? 0 : this.color.hashCode());
            n3 = 31 * n3 + (this.hidden ? 1231 : 1237);
            n3 = 31 * n3 + this.thickness;
            n3 = 31 * n3 + Float.floatToIntBits(this.value);
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SingleCurveSetting singleCurveSetting = (SingleCurveSetting)object;
            if (this.color == null ? singleCurveSetting.color != null : !this.color.equals(singleCurveSetting.color)) {
                return false;
            }
            if (this.hidden != singleCurveSetting.hidden) {
                return false;
            }
            if (this.thickness != singleCurveSetting.thickness) {
                return false;
            }
            return Float.floatToIntBits(this.value) == Float.floatToIntBits(singleCurveSetting.value);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            ReadHelper readHelper = new ReadHelper();
            readHelper.a("thickness", (Object)DosePrefs.defaultIsodoseLineWidth.getValue());
            readHelper.a(objectInputStream, (Object)this);
        }
    }
}

