/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.internals.fusionmode.equation;

import com.mimvista.internals.fusionmode.equation.AbsoluteValue;
import com.mimvista.internals.fusionmode.equation.AbstractExpressionComponent;
import com.mimvista.internals.fusionmode.equation.BracketedOperator;
import com.mimvista.internals.fusionmode.equation.MathEquation;
import com.mimvista.internals.fusionmode.equation.MathExpression;
import com.mimvista.internals.fusionmode.equation.MathSymbol;
import com.mimvista.internals.fusionmode.equation.MultiplicationOperator;
import com.mimvista.internals.fusionmode.equation.SubtractionOperator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DivisionOperator
extends AbstractExpressionComponent {
    private static final long serialVersionUID = -4913585621784181190L;
    static final float a = 0.8f;
    final MathExpression numerator;
    final MathExpression denominator;

    public DivisionOperator(MathExpression mathExpression, MathExpression mathExpression2) {
        this.numerator = mathExpression;
        this.denominator = mathExpression2;
    }

    @Override
    public Dimension a(MathExpression.RenderMode renderMode, float f2) {
        renderMode = this.a(renderMode);
        Dimension dimension = new Dimension();
        Dimension dimension2 = this.numerator.a(renderMode, f2 * 0.8f);
        Dimension dimension3 = this.denominator.a(renderMode, f2 * 0.8f);
        dimension.height = dimension2.height + 3 + dimension3.height;
        dimension.width = Math.max(dimension2.width, dimension3.width);
        return dimension;
    }

    @Override
    public void a(Graphics2D graphics2D, int n2, int n3, MathExpression.RenderMode renderMode, float f2) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Dimension dimension = this.a(renderMode, f2);
        Dimension dimension2 = this.numerator.a(renderMode, f2 * 0.8f);
        Point point = new Point(n2 + dimension.width / 2, n3 + dimension2.height + 2);
        this.numerator.a(graphics2D2, point.x - dimension2.width / 2, n3, renderMode, f2 * 0.8f);
        graphics2D2.drawLine(n2, point.y, n2 + dimension.width, point.y);
        Dimension dimension3 = this.denominator.a(renderMode, f2 * 0.8f);
        this.denominator.a(graphics2D2, point.x - dimension3.width / 2, point.y + 2, renderMode, f2 * 0.8f);
        graphics2D2.dispose();
    }

    @Override
    public Set<MathSymbol> b() {
        Set<MathSymbol> set = this.numerator.b();
        set.addAll(this.denominator.b());
        return set;
    }

    @Override
    public float a() {
        float f2 = this.denominator.a();
        if ((double)f2 == 0.0) {
            return Float.NaN;
        }
        float f3 = this.numerator.a();
        return f3 / f2;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setSize(600, 600);
        jFrame.setContentPane(new JPanel(null));
        MathSymbol mathSymbol = new MathSymbol("", "F", "", "", "(x,y,z)", null);
        MathSymbol mathSymbol2 = new MathSymbol("", "P", "", "NN", "(x,y,z)", null);
        MathSymbol mathSymbol3 = new MathSymbol("", "U", "", "P", "", null);
        MathSymbol mathSymbol4 = new MathSymbol("", "S", "", "", "(x,y,z)", null);
        MathSymbol mathSymbol5 = new MathSymbol("", "U", "", "S", "", null);
        BracketedOperator bracketedOperator = new BracketedOperator("(", new DivisionOperator(mathSymbol5, mathSymbol3), ")");
        MultiplicationOperator multiplicationOperator = new MultiplicationOperator(bracketedOperator, mathSymbol2);
        SubtractionOperator subtractionOperator = new SubtractionOperator(multiplicationOperator, mathSymbol4);
        AbsoluteValue absoluteValue = new AbsoluteValue(mathSymbol4);
        DivisionOperator divisionOperator = new DivisionOperator(subtractionOperator, absoluteValue);
        MathEquation mathEquation = new MathEquation(mathSymbol, divisionOperator);
        mathEquation.setLocation(20, 20);
        mathEquation.setBackground(Color.RED);
        mathEquation.setSize(mathEquation.getPreferredSize());
        jFrame.getContentPane().add(mathEquation);
        jFrame.setVisible(true);
    }
}

